/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLConfigUtil {
    public static DocumentBuilder getDocumentBuilder() throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder;
    }

    public static void getXmlHead(StringBuffer stringBuffer, Element element) {
        stringBuffer.append("<");
        stringBuffer.append(element.getTagName());
        stringBuffer.append(" ");
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Node node = namedNodeMap.item(n);
            stringBuffer.append(node.getNodeName());
            stringBuffer.append("=\"");
            stringBuffer.append(node.getNodeValue());
            stringBuffer.append("\" ");
            ++n;
        }
        stringBuffer.append(">\n");
    }

    public static void getXmlTail(StringBuffer stringBuffer, Element element) {
        stringBuffer.append("</");
        stringBuffer.append(element.getTagName());
        stringBuffer.append(">\n");
    }

    public static String toXML(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        XMLConfigUtil.toXML(stringBuffer, element);
        return stringBuffer.toString();
    }

    private static void toXML(StringBuffer stringBuffer, Element element) {
        Object object;
        stringBuffer.append("<");
        stringBuffer.append(element.getTagName());
        stringBuffer.append(" ");
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            object = namedNodeMap.item(n);
            stringBuffer.append(object.getNodeName());
            stringBuffer.append("=\"");
            stringBuffer.append(object.getNodeValue());
            stringBuffer.append("\" ");
            ++n;
        }
        stringBuffer.append(">\n");
        object = XMLConfigUtil.getAllElements(element.getChildNodes(), null);
        int n2 = 0;
        while (n2 < ((ArrayList)object).size()) {
            Element element2 = (Element)((ArrayList)object).get(n2);
            XMLConfigUtil.toXML(stringBuffer, element2);
            ++n2;
        }
        stringBuffer.append("</");
        stringBuffer.append(element.getTagName());
        stringBuffer.append(">\n");
    }

    public static Element getFirstElement(NodeList nodeList, String string) {
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                Element element = (Element)node;
                if (string != null) {
                    if (element.getTagName().equals(string)) {
                        return element;
                    }
                } else {
                    return element;
                }
            }
            ++n;
        }
        return null;
    }

    public static ArrayList getAllElements(NodeList nodeList, String string) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                Element element = (Element)node;
                if (string != null) {
                    if (element.getTagName().equals(string)) {
                        arrayList.add(node);
                    }
                } else {
                    arrayList.add(node);
                }
            }
            ++n;
        }
        return arrayList;
    }

    public static double parseDouble(String string, double d) {
        try {
            return Double.parseDouble(string);
        }
        catch (Exception exception) {
            return d;
        }
    }

    public static boolean parseBoolean(String string, boolean bl) {
        if (string.equals("true")) {
            return true;
        }
        if (string.equals("false")) {
            return false;
        }
        return bl;
    }

    public static int parseLineStyle(String string, int n) {
        if (string.equals("SOLID")) {
            return 1;
        }
        if (string.equals("DOT")) {
            return 3;
        }
        if (string.equals("DASH")) {
            return 2;
        }
        if (string.equals("DASHDOT")) {
            return 4;
        }
        if (string.equals("DASHDOTDOT")) {
            return 5;
        }
        return n;
    }

    public static RGB parseColor(String string, RGB rGB) {
        try {
            if (!string.startsWith("#")) {
                throw new Exception();
            }
            if (string.length() != 7) {
                throw new Exception();
            }
            String string2 = string.substring(1, 3);
            String string3 = string.substring(3, 5);
            String string4 = string.substring(5, 7);
            int n = Integer.parseInt(string2, 16);
            int n2 = Integer.parseInt(string3, 16);
            int n3 = Integer.parseInt(string4, 16);
            return new RGB(n, n2, n3);
        }
        catch (Exception exception) {
            return rGB;
        }
    }

    public static String colorToString(Color color) {
        RGB rGB = color.getRGB();
        String string = "#";
        if (rGB.red < 16) {
            string = string + "0";
        }
        string = string + Integer.toString(rGB.red, 16);
        if (rGB.green < 16) {
            string = string + "0";
        }
        string = string + Integer.toString(rGB.green, 16);
        if (rGB.blue < 16) {
            string = string + "0";
        }
        string = string + Integer.toString(rGB.blue, 16);
        return string;
    }

    public static String lineStyleToString(int n) {
        if (n == 1) {
            return "SOLID";
        }
        if (n == 3) {
            return "DOT";
        }
        if (n == 2) {
            return "DASH";
        }
        if (n == 4) {
            return "DASHDOT";
        }
        if (n == 5) {
            return "DASHDOTDOT";
        }
        return "SOLID";
    }
}

