/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ZipStringBuffer {
    int complen = 0;
    private int CHUNK_SIZE = 10240;
    ArrayList chunks = new ArrayList();
    Chunk openChunk = new Chunk(null);
    StringBuffer tail = new StringBuffer();

    public ZipStringBuffer() {
    }

    public ZipStringBuffer(String string) {
        this.append(string);
    }

    public ZipStringBuffer(boolean bl) {
        if (!bl) {
            this.CHUNK_SIZE = Integer.MAX_VALUE;
        }
    }

    public ZipStringBuffer(int n) {
        this.CHUNK_SIZE = n;
        if (this.CHUNK_SIZE < 1024) {
            this.CHUNK_SIZE = 1024;
        }
    }

    public int compressedLength() {
        return this.complen + this.tail.length();
    }

    public int length() {
        return this.chunks.size() * this.CHUNK_SIZE + this.tail.length();
    }

    private void updateChunks() {
        while (this.tail.length() > this.CHUNK_SIZE) {
            String string = this.tail.substring(0, this.CHUNK_SIZE);
            this.tail.delete(0, this.CHUNK_SIZE);
            this.addChunk(new StringBuffer(string));
        }
    }

    private void addChunk(StringBuffer stringBuffer) {
        Chunk chunk = new Chunk(stringBuffer);
        chunk.shrink();
        this.chunks.add(chunk);
        this.complen += chunk.dat.length;
    }

    public ZipStringBuffer append(Object object) {
        this.tail.append(object);
        this.updateChunks();
        return this;
    }

    public ZipStringBuffer append(String string) {
        this.tail.append(string);
        this.updateChunks();
        return this;
    }

    public ZipStringBuffer append(int n) {
        this.tail.append(n);
        this.updateChunks();
        return this;
    }

    public ZipStringBuffer append(double d) {
        this.tail.append(d);
        this.updateChunks();
        return this;
    }

    public ZipStringBuffer append(float f) {
        this.tail.append(f);
        this.updateChunks();
        return this;
    }

    public ZipStringBuffer append(long l) {
        this.tail.append(l);
        this.updateChunks();
        return this;
    }

    public ZipStringBuffer append(byte by) {
        this.tail.append(by);
        this.updateChunks();
        return this;
    }

    public ZipStringBuffer append(boolean bl) {
        this.tail.append(bl);
        this.updateChunks();
        return this;
    }

    public ZipStringBuffer append(char c) {
        this.tail.append(c);
        this.updateChunks();
        return this;
    }

    public ZipStringBuffer append(char[] cArray) {
        this.tail.append(cArray);
        this.updateChunks();
        return this;
    }

    public ZipStringBuffer append(char[] cArray, int n, int n2) {
        this.tail.append(cArray, n, n2);
        this.updateChunks();
        return this;
    }

    public char charAt(int n) {
        int n2 = n / this.CHUNK_SIZE;
        int n3 = n % this.CHUNK_SIZE;
        if (n2 >= this.chunks.size()) {
            return this.tail.charAt(n3);
        }
        Chunk chunk = (Chunk)this.chunks.get(n2);
        if (chunk != this.openChunk) {
            this.openChunk.shrink();
            this.openChunk = chunk;
        }
        chunk.grow();
        return chunk.sb.charAt(n3);
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        String string = this.substring(n, n2);
        string.getChars(0, string.length(), cArray, n3);
    }

    public String substring(int n) {
        return this.substring(n, this.length());
    }

    public String substring(int n, int n2) {
        if (n == n2) {
            return "";
        }
        int n3 = n / this.CHUNK_SIZE;
        int n4 = n % this.CHUNK_SIZE;
        int n5 = (n2 - 1) / this.CHUNK_SIZE;
        int n6 = (n2 - 1) % this.CHUNK_SIZE;
        if (n3 >= this.chunks.size()) {
            return this.tail.substring(n4, n6);
        }
        StringBuffer stringBuffer = new StringBuffer();
        Chunk chunk = (Chunk)this.chunks.get(n3);
        chunk.grow();
        stringBuffer.append(chunk.sb.substring(n4));
        chunk.shrink();
        int n7 = n3 + 1;
        while (n7 < n5) {
            chunk = (Chunk)this.chunks.get(n7);
            chunk.grow();
            stringBuffer.append(chunk.sb.toString());
            chunk.shrink();
            ++n7;
        }
        if (n5 >= this.chunks.size()) {
            stringBuffer.append(this.tail.substring(0, n6 + 1));
        } else {
            chunk = (Chunk)this.chunks.get(n5);
            chunk.grow();
            stringBuffer.append(chunk.sb.substring(0, n6 + 1));
            chunk.shrink();
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.chunks.size()) {
            Chunk chunk = (Chunk)this.chunks.get(n);
            chunk.grow();
            stringBuffer.append(chunk.sb.toString());
            ++n;
        }
        stringBuffer.append(this.tail.toString());
        return stringBuffer.toString();
    }

    public void toStream(OutputStream outputStream) throws IOException {
        int n = 0;
        while (n < this.chunks.size()) {
            Chunk chunk = (Chunk)this.chunks.get(n);
            chunk.grow();
            outputStream.write(chunk.sb.toString().getBytes());
            ++n;
        }
        outputStream.write(this.tail.toString().getBytes());
    }

    public int indexOf(char c, int n) {
        while (n < this.length()) {
            if (this.charAt(n) == c) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int lastIndexOf(char c) {
        int n = this.length() - 1;
        while (n > 0) {
            if (this.charAt(n) == c) {
                return n;
            }
            --n;
        }
        return -1;
    }

    private byte[] compress(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gZIPOutputStream.write(byArray, 0, byArray.length);
        gZIPOutputStream.finish();
        gZIPOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] decompress(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray2 = new byte[1024];
        int n = 0;
        while (n != -1) {
            n = gZIPInputStream.read(byArray2, 0, 1024);
            if (n <= 0) continue;
            byteArrayOutputStream.write(byArray2, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    class Chunk {
        boolean compressed = true;
        StringBuffer sb;
        byte[] dat;

        public Chunk(StringBuffer stringBuffer) {
            this.sb = stringBuffer;
        }

        void shrink() {
            if (this.sb == null) {
                return;
            }
            try {
                this.dat = ZipStringBuffer.this.compress(this.sb.toString().getBytes());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.sb = null;
        }

        void grow() {
            if (this.dat == null) {
                return;
            }
            try {
                this.sb = new StringBuffer(new String(ZipStringBuffer.this.decompress(this.dat)));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.dat = null;
        }
    }
}

