/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal;

import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.TimeZoomSliderTick;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomControlBar;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSliderUtilities;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class TimeZoomSlider
extends ZoomSlider {
    private static final double[] LINEAR_PROGRESSION = new double[]{1.0, 2.0, 5.0};
    private static final double[] OOM4 = new double[]{1.0, 2.0, 3.0, 6.0};
    private static final double[] OOM5 = new double[]{1.2, 3.0, 6.0};
    private static final double[] OOM6 = new double[]{1.2, 1.8, 3.6, 7.2};
    private static final double[] OOM7 = new double[]{1.8, 3.6, 7.2, 8.64};
    ZoomControlBar bar;
    double start;
    double reconfigurePeriod = 10.0;
    double length;
    public GregorianCalendar calendar = new GregorianCalendar();
    public long startTime = System.currentTimeMillis() / 1000L;
    boolean wallTime = true;

    public TimeZoomSlider(Composite composite) {
        super(composite);
    }

    protected void createTicks() {
        this.calculateIncrement();
        this.tickVector.removeAllElements();
        double d = ZoomSliderUtilities.round(this.visible[0] - this.increment, this.increment);
        while (d <= this.visible[1] + this.increment) {
            this.tickVector.addElement(new TimeZoomSliderTick(this, d));
            d += this.increment;
            d = ZoomSliderUtilities.round(d, this.increment);
        }
        int n = 10;
        int n2 = (int)((double)this.getPixelRange() / (this.getVisibleValueRange() / this.increment));
        if (n2 < 20) {
            n = 5;
        }
        this.unitIncrement = this.increment / (double)n;
        if (this.unitIncrement < this.resolution) {
            this.unitIncrement = this.resolution;
        }
    }

    public void setWallTime(boolean bl) {
        this.wallTime = bl;
    }

    public boolean isWallTime() {
        return this.wallTime;
    }

    public void findDecimalPointPosition() {
        GC gC = new GC((Drawable)this);
        int n = gC.stringExtent((String)".000").x;
        this.decimalPointPosition = this.getBounds().width - 10;
        gC.dispose();
    }

    public Point computeSize(int n, int n2, boolean bl) {
        Point point = super.computeSize(n, n2, bl);
        Point point2 = new Point(point.x, point.y);
        if (this.orientation == 0) {
            if (n == -1) {
                GC gC = new GC((Drawable)this);
                point2.x = gC.stringExtent((String)"99:99:99").x + 20;
                gC.dispose();
            } else {
                point2.x = n;
            }
            if (n2 != -1) {
                point2.y = n2;
            }
        } else {
            point2.y = n2 == -1 ? this.getFontHeight() + 20 : n2;
            if (n != -1) {
                point2.x = n;
            }
        }
        return point2;
    }

    protected void calculateIncrement() {
        ZoomSlider.TickValueRange tickValueRange = new ZoomSlider.TickValueRange(this);
        if (tickValueRange.outside()) {
            int n = this.getPixelRange() / 10;
            this.increment = this.getVisibleValueRange() / (double)n;
            int n2 = ZoomSliderUtilities.calculateOOM(this.increment);
            double[] dArray = this.getProgression(n2);
            this.increment = dArray[0] * Math.pow(10.0, n2);
            while (this.increment < tickValueRange.min) {
                int n3 = 0;
                while (n3 < dArray.length) {
                    this.increment = dArray[n3] * Math.pow(10.0, n2);
                    if (this.increment >= tickValueRange.min) {
                        this.increment = (long)this.increment;
                        break;
                    }
                    ++n3;
                }
                dArray = this.getProgression(++n2);
            }
            this.incrementOOM = ZoomSliderUtilities.calculateOOM(this.increment);
        }
    }

    public double[] getProgression(int n) {
        switch (n) {
            case 4: {
                return OOM4;
            }
            case 5: {
                return OOM5;
            }
            case 6: {
                return OOM6;
            }
            case 7: {
                return OOM7;
            }
        }
        return LINEAR_PROGRESSION;
    }

    public double getZero() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(new Date());
        double d = 1.0 + (double)gregorianCalendar.get(11);
        double d2 = gregorianCalendar.get(12);
        double d3 = gregorianCalendar.get(13);
        return d * 60.0 * 60.0 + d2 * 60.0 + d3;
    }
}

