/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.security.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.execution.security.ISecureClientParameters;
import org.eclipse.hyades.execution.security.KeystoreHelper;
import org.eclipse.hyades.internal.execution.local.control.AgentControllerUnavailableException;
import org.eclipse.hyades.internal.execution.local.control.Application;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.internal.execution.security.DuplicateUserException;
import org.eclipse.hyades.internal.execution.security.LoginFailedException;
import org.eclipse.hyades.internal.execution.security.SecureConnectionRequiredException;
import org.eclipse.hyades.internal.execution.security.UntrustedAgentControllerException;
import org.eclipse.hyades.internal.execution.security.User;
import org.eclipse.hyades.internal.execution.security.UserFactory;
import org.eclipse.hyades.security.SecurityPlugin;
import org.eclipse.hyades.security.util.ConnectivityDialog;
import org.eclipse.hyades.security.util.TString;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class ConnectUtil {
    public static final int CONNECTION_SUCCESS = 0;
    public static final int CONNECTION_CONTROLLER_ERROR = 1;
    public static final int CONNECTION_HOST_ERROR = 2;
    public static final int CONNECTION_PORT_ERROR = 3;
    public static final int CONNECTION_SECURITY_NOT_SUPPORTED = 4;
    private Application _app;
    private String _port;
    private String _hostName;
    private InetAddress _hostAddr;
    private String _userId;
    private Node _node;
    private ISecureClientParameters _parameters;
    private boolean okPressed = false;

    public ConnectUtil(String string, String string2, Application application) {
        this(string, string2, null, application);
    }

    public ConnectUtil(String string, String string2, String string3, Application application) {
        this._hostName = string;
        this._port = string2;
        this._userId = string3;
        this._app = application;
    }

    public ConnectUtil(InetAddress inetAddress, String string, Application application) {
        this(inetAddress, string, null, application);
    }

    public ConnectUtil(InetAddress inetAddress, String string, String string2, Application application) {
        this._hostAddr = inetAddress;
        this._hostName = this._hostAddr.getHostName();
        this._port = string;
        this._userId = string2;
        this._app = application;
    }

    private ISecureClientParameters getClientParms() {
        IPluginRegistry iPluginRegistry = Platform.getPluginRegistry();
        IConfigurationElement[] iConfigurationElementArray = Platform.getPluginRegistry().getConfigurationElementsFor(SecurityPlugin.getPluginId(), "JSSESecurityProviders");
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            String string = iConfigurationElement.getAttribute("name");
            String string2 = iConfigurationElement.getAttribute("class");
            if (string2 != null) {
                try {
                    Object object = iConfigurationElement.createExecutableExtension("class");
                    if (object instanceof ISecureClientParameters) {
                        ISecureClientParameters iSecureClientParameters = (ISecureClientParameters)object;
                        Security.addProvider(iSecureClientParameters.getSecurityProvider());
                        iSecureClientParameters.getKeystoreManager().setProvider(iSecureClientParameters.getSecurityProvider());
                        return (ISecureClientParameters)object;
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            ++n;
        }
        return null;
    }

    public final int connect() {
        try {
            if (this._hostAddr == null) {
                this._hostAddr = InetAddress.getByName(this._hostName);
            }
        }
        catch (UnknownHostException unknownHostException) {
            this.resetConnection();
            String string = SecurityPlugin.getResourceString("TIMEOUT_NODE_ERROR_");
            string = TString.change(string, "%1", this._hostName);
            String string2 = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
            string2 = TString.change(string2, "%1", this._hostName);
            Status status = new Status(2, "org.eclipse.core.resources", 2, string, (Throwable)unknownHostException);
            this.openErrorDialog(ConnectUtil.getValidShell(), SecurityPlugin.getResourceString("SEC_MSG"), string2, status);
            return 2;
        }
        try {
            if (this.checkConnectionExists()) {
                return 0;
            }
            if (this._node == null) {
                this._node = NodeFactory.createNode((InetAddress)this._hostAddr, (Principal)this._app);
            }
            this._node.connect(Integer.parseInt(this._port));
        }
        catch (UnknownHostException unknownHostException) {
            this.resetConnection();
            String string = SecurityPlugin.getResourceString("TIMEOUT_NODE_ERROR_");
            string = TString.change(string, "%1", this._hostName);
            String string3 = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
            string3 = TString.change(string3, "%1", this._hostName);
            Status status = new Status(2, "org.eclipse.core.resources", 2, string, (Throwable)unknownHostException);
            this.openErrorDialog(ConnectUtil.getValidShell(), SecurityPlugin.getResourceString("SEC_MSG"), string3, status);
            return 2;
        }
        catch (SecureConnectionRequiredException secureConnectionRequiredException) {
            return this.connectUnderException((AgentControllerUnavailableException)((Object)secureConnectionRequiredException));
        }
        catch (LoginFailedException loginFailedException) {
            return this.connectUnderException((AgentControllerUnavailableException)((Object)loginFailedException));
        }
        catch (UntrustedAgentControllerException untrustedAgentControllerException) {
            String string = SecurityPlugin.getResourceString("STR_CERTIF_UNAV_ERROR_");
            string = TString.change(string, "%1", this._hostName);
            String string4 = TString.change(SecurityPlugin.getResourceString("STR_UNTRUSTED_AGENT_CONTROLLER"), "%1", this._hostName);
            boolean bl = this.openQuestionDialog(ConnectUtil.getValidShell(), SecurityPlugin.getResourceString("SEC_MSG"), string4);
            if (!bl) {
                this.resetConnection();
                String string5 = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
                string5 = TString.change(string5, "%1", this._hostName);
                Status status = new Status(2, "org.eclipse.core.resources", 2, string, (Throwable)untrustedAgentControllerException);
                this.openErrorDialog(ConnectUtil.getValidShell(), SecurityPlugin.getResourceString("SEC_MSG"), string5, status);
                return 1;
            }
            ISecureClientParameters iSecureClientParameters = this._node.getSecurityParameters();
            if (iSecureClientParameters != null) {
                iSecureClientParameters.disableServerAuthentication();
            }
            return this.connect();
        }
        catch (AgentControllerUnavailableException agentControllerUnavailableException) {
            String string = SecurityPlugin.getResourceString("STR_AGENT_CONTROLLER_UNAV_ERROR_");
            string = TString.change(string, "%1", this._hostName);
            this.resetConnection();
            String string6 = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
            string6 = TString.change(string6, "%1", this._hostName);
            Status status = new Status(2, "org.eclipse.core.resources", 2, string, (Throwable)agentControllerUnavailableException);
            this.openErrorDialog(ConnectUtil.getValidShell(), SecurityPlugin.getResourceString("SEC_MSG"), string6, status);
            return 1;
        }
        catch (NumberFormatException numberFormatException) {
            this.resetConnection();
            String string = SecurityPlugin.getResourceString("INVALID_PORT_ERROR_");
            string = TString.change(string, "%1", String.valueOf(this._port));
            String string7 = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
            string7 = TString.change(string7, "%1", this._hostName);
            Status status = new Status(2, "org.eclipse.core.resources", 2, string, (Throwable)numberFormatException);
            this.openErrorDialog(ConnectUtil.getValidShell(), SecurityPlugin.getResourceString("SEC_MSG"), string7, status);
            return 3;
        }
        return 0;
    }

    public String getUserId() {
        return this._userId;
    }

    public Node getNode() {
        return this._node;
    }

    private void resetConnection() {
        if (this._userId != null) {
            UserFactory.removeUser((Application)this._app, (String)this._userId);
        }
        if (this._node != null) {
            this._node.setSecurityParameters(null);
        }
    }

    private int connectUnderException(AgentControllerUnavailableException agentControllerUnavailableException) {
        try {
            Object object;
            Shell shell;
            User user = null;
            if (this._userId != null && !this._userId.equals("")) {
                user = UserFactory.getUser((Application)this._app, (String)this._userId);
            }
            if (user == null) {
                if (agentControllerUnavailableException instanceof SecureConnectionRequiredException && ((SecureConnectionRequiredException)((Object)agentControllerUnavailableException)).isPasswordProtected()) {
                    shell = ConnectUtil.getValidShell();
                    object = new ConnectivityDialog(shell, this._hostName, this._userId, this._userId == null || this._userId.equals(""));
                    ((ConnectivityDialog)((Object)object)).setDescription(SecurityPlugin.getResourceString("STR_PWD_REQ_INFO_"));
                    this.openDialog(shell, (Dialog)object);
                    if (object.getReturnCode() != 0) {
                        this.resetConnection();
                        String string = SecurityPlugin.getResourceString("STR_PWD_REQ_INFO_");
                        String string2 = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
                        string2 = TString.change(string2, "%1", this._hostName);
                        Status status = new Status(2, "org.eclipse.core.resources", 2, string, null);
                        this.openErrorDialog(ConnectUtil.getValidShell(), SecurityPlugin.getResourceString("SEC_MSG"), string2, status);
                        return 2;
                    }
                    this._userId = ((ConnectivityDialog)((Object)object)).getUserId();
                    if (UserFactory.getUser((Application)this._app, (String)this._userId) != null) {
                        UserFactory.removeUser((Application)this._app, (String)this._userId);
                    }
                    user = UserFactory.createUser((Application)this._app, (String)this._userId, (String)((ConnectivityDialog)((Object)object)).getPassword());
                } else {
                    this._userId = "ignoredUserId";
                    user = UserFactory.createUser((Application)this._app, (String)this._userId, (String)"dummyPass");
                }
            } else if (agentControllerUnavailableException instanceof LoginFailedException) {
                shell = ConnectUtil.getValidShell();
                object = new ConnectivityDialog(shell, this._hostName, this._userId);
                ((ConnectivityDialog)((Object)object)).setDescription(SecurityPlugin.getResourceString("STR_LOGIN_FAILED_INFO_"));
                this.openDialog(shell, (Dialog)object);
                if (object.getReturnCode() != 0) {
                    this.resetConnection();
                    String string = SecurityPlugin.getResourceString("STR_PWD_REQ_INFO_");
                    String string3 = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
                    string3 = TString.change(string3, "%1", this._hostName);
                    Status status = new Status(2, "org.eclipse.core.resources", 2, string, null);
                    this.openErrorDialog(ConnectUtil.getValidShell(), SecurityPlugin.getResourceString("SEC_MSG"), string3, status);
                    return 2;
                }
                this._userId = ((ConnectivityDialog)((Object)object)).getUserId();
                user = UserFactory.getUser((Application)this._app, (String)this._userId);
                if (user != null) {
                    user.setPassword(((ConnectivityDialog)((Object)object)).getPassword());
                } else {
                    try {
                        user = UserFactory.createUser((Application)this._app, (String)this._userId, (String)((ConnectivityDialog)((Object)object)).getPassword());
                    }
                    catch (DuplicateUserException duplicateUserException) {
                        // empty catch block
                    }
                }
            }
            if (agentControllerUnavailableException instanceof SecureConnectionRequiredException) {
                this._port = new Long(((SecureConnectionRequiredException)((Object)agentControllerUnavailableException)).getSecurePort()).toString();
            } else if (agentControllerUnavailableException instanceof LoginFailedException) {
                this._port = new Long(((LoginFailedException)((Object)agentControllerUnavailableException)).getSecurePort()).toString();
            }
            if (this._node.getSecurityParameters() == null) {
                shell = this.getClientParms();
                if (shell == null) {
                    this.resetConnection();
                    object = SecurityPlugin.getResourceString("STR_CLIENT_CANNOT_USE_SECURITY_ERROR_");
                    object = TString.change((String)object, "%1", this._hostName);
                    String string = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
                    string = TString.change(string, "%1", this._hostName);
                    Status status = new Status(2, "org.eclipse.core.resources", 2, (String)object, null);
                    this.openErrorDialog(ConnectUtil.getValidShell(), SecurityPlugin.getResourceString("SEC_MSG"), string, status);
                    return 4;
                }
                this._node.setSecurityParameters(this.getClientParms());
                this._node.getSecurityParameters().getKeystoreManager().loadKeystore(this._node.getSecurityParameters().getKeystoreFileName(), this._node.getSecurityParameters().getKeystoreFilepassword());
            }
            this._node.setUser(user);
            return this.connect();
        }
        catch (DuplicateUserException duplicateUserException) {
            this.resetConnection();
        }
        catch (IOException iOException) {
            try {
                if (this._node.getSecurityParameters() == null) {
                    this.resetConnection();
                    String string = SecurityPlugin.getResourceString("STR_CLIENT_CANNOT_USE_SECURITY_ERROR_");
                    string = TString.change(string, "%1", this._hostName);
                    String string4 = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
                    string4 = TString.change(string4, "%1", this._hostName);
                    Status status = new Status(2, "org.eclipse.core.resources", 2, string, (Throwable)iOException);
                    this.openErrorDialog(ConnectUtil.getValidShell(), SecurityPlugin.getResourceString("SEC_MSG"), string4, status);
                    return 4;
                }
                KeystoreHelper.createKeyStore((String)SecurityPlugin.getKeyStoreLocation(), (String)SecurityPlugin.getWorkspaceName());
                this._node.setSecurityParameters(this.getClientParms());
                this._node.getSecurityParameters().getKeystoreManager().loadKeystore(this._node.getSecurityParameters().getKeystoreFileName(), this._node.getSecurityParameters().getKeystoreFilepassword());
                this._node.setUser(UserFactory.getUser((Application)this._app, (String)this._userId));
                return this.connect();
            }
            catch (Exception exception) {
                this.resetConnection();
                String string = SecurityPlugin.getResourceString("STR_KEY_NOT_FOUND_ERROR_");
                string = TString.change(string, "%1", SecurityPlugin.getKeyStoreLocation());
                String string5 = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
                string5 = TString.change(string5, "%1", this._hostName);
                Status status = new Status(2, "org.eclipse.core.resources", 2, string, (Throwable)iOException);
                this.openErrorDialog(ConnectUtil.getValidShell(), SecurityPlugin.getResourceString("SEC_MSG"), string5, status);
                return 2;
            }
        }
        catch (CertificateException certificateException) {
            this.resetConnection();
            String string = SecurityPlugin.getResourceString("STR_KEY_LOAD_ERROR_");
            string = TString.change(string, "%1", SecurityPlugin.getKeyStoreLocation());
            String string6 = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
            string6 = TString.change(string6, "%1", this._hostName);
            Status status = new Status(2, "org.eclipse.core.resources", 2, string, (Throwable)certificateException);
            this.openErrorDialog(ConnectUtil.getValidShell(), SecurityPlugin.getResourceString("SEC_MSG"), string6, status);
            return 2;
        }
        catch (KeyManagementException keyManagementException) {
            this.resetConnection();
            String string = SecurityPlugin.getResourceString("STR_KEY_MANAG_ERROR_");
            string = TString.change(string, "%1", SecurityPlugin.getKeyStoreLocation());
            String string7 = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
            string7 = TString.change(string7, "%1", this._hostName);
            Status status = new Status(2, "org.eclipse.core.resources", 2, string, (Throwable)keyManagementException);
            this.openErrorDialog(ConnectUtil.getValidShell(), SecurityPlugin.getResourceString("SEC_MSG"), string7, status);
            return 2;
        }
        catch (KeyStoreException keyStoreException) {
            this.resetConnection();
            String string = SecurityPlugin.getResourceString("STR_KEY_STORE_ERROR_");
            string = TString.change(string, "%1", SecurityPlugin.getKeyStoreLocation());
            String string8 = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
            string8 = TString.change(string8, "%1", this._hostName);
            Status status = new Status(2, "org.eclipse.core.resources", 2, string, (Throwable)keyStoreException);
            this.openErrorDialog(ConnectUtil.getValidShell(), SecurityPlugin.getResourceString("SEC_MSG"), string8, status);
            return 2;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.resetConnection();
            String string = SecurityPlugin.getResourceString("STR_ALGORITHM_ERROR_");
            string = TString.change(string, "%1", SecurityPlugin.getKeyStoreLocation());
            String string9 = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
            string9 = TString.change(string9, "%1", this._hostName);
            Status status = new Status(2, "org.eclipse.core.resources", 2, string, (Throwable)noSuchAlgorithmException);
            this.openErrorDialog(ConnectUtil.getValidShell(), SecurityPlugin.getResourceString("SEC_MSG"), string9, status);
            return 2;
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            this.resetConnection();
            String string = SecurityPlugin.getResourceString("STR_UNREC_KEY_ERROR_");
            string = TString.change(string, "%1", SecurityPlugin.getKeyStoreLocation());
            String string10 = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
            string10 = TString.change(string10, "%1", this._hostName);
            Status status = new Status(2, "org.eclipse.core.resources", 2, string, (Throwable)unrecoverableKeyException);
            this.openErrorDialog(ConnectUtil.getValidShell(), SecurityPlugin.getResourceString("SEC_MSG"), string10, status);
            return 2;
        }
        return 0;
    }

    private boolean checkConnectionExists() {
        Node node = NodeFactory.getNode((InetAddress)this._hostAddr, (Principal)this._app);
        if (node != null && node.isConnected()) {
            this._node = node;
            return true;
        }
        return false;
    }

    private void openErrorDialog(final Shell shell, final String string, final String string2, final Status status) {
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError((Shell)shell, (String)string, (String)string2, (IStatus)status);
            }
        });
    }

    private void openDialog(Shell shell, final Dialog dialog) {
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
    }

    private static Shell getValidShell() {
        Shell shell = null;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        if (iWorkbench != null) {
            if (iWorkbench.getActiveWorkbenchWindow() != null && (shell = iWorkbench.getActiveWorkbenchWindow().getShell()) != null && !shell.isDisposed()) {
                return shell;
            }
            if (iWorkbench.getWorkbenchWindows().length > 0 && (shell = iWorkbench.getWorkbenchWindows()[0].getShell()) != null && !shell.isDisposed()) {
                return shell;
            }
        }
        if (Display.getCurrent() != null && (shell = new Shell(Display.getCurrent())) != null && !shell.isDisposed()) {
            return shell;
        }
        if (Display.getDefault() != null && (shell = new Shell(Display.getDefault())) != null && !shell.isDisposed()) {
            return shell;
        }
        return null;
    }

    private boolean openQuestionDialog(final Shell shell, final String string, final String string2) {
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                ConnectUtil.this.okPressed = MessageDialog.openQuestion((Shell)shell, (String)string, (String)string2);
            }
        });
        return this.okPressed;
    }
}

