/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.security.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.execution.security.KeystoreHelper;
import org.eclipse.hyades.security.SecurityImages;
import org.eclipse.hyades.security.SecurityPlugin;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.security.util.SecurityUI;
import org.eclipse.hyades.security.util.TString;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;

public class ImportSecurityCertificatePage
extends WizardPage
implements Listener {
    private SecurityUI _securityUI;

    public ImportSecurityCertificatePage(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        super(SecurityPlugin.getResourceString("STR_IMPORT_SECURITY_WIZARD_PTITLE"));
        this.setTitle(SecurityPlugin.getResourceString("STR_IMPORT_SECURITY_WIZARD_PTITLE"));
        this.setDescription(SecurityPlugin.getResourceString("STR_IMPORT_SECURITY_WIZARD_PDESC"));
        this.setImageDescriptor(SecurityImages.getImageDescriptor("import_cert_wiz.gif"));
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        GridData gridData = GridUtil.createFill();
        gridData.widthHint = 300;
        composite2.setLayoutData((Object)gridData);
        composite2.setLayoutData((Object)gridData);
        Shell shell = this.getShell();
        this._securityUI = new SecurityUI(shell);
        this._securityUI.createContents(composite2);
        this._securityUI.registerListener(this);
        this.setControl((Control)composite2);
        this.setPageComplete(false);
    }

    protected boolean determinePageCompletion() {
        boolean bl = this._securityUI.validateDialog();
        if (bl) {
            this.setErrorMessage(null);
        }
        return bl;
    }

    public boolean finish() {
        KeyStore keyStore;
        String string = this._securityUI.getPath();
        String string2 = SecurityPlugin.getKeyStoreLocation();
        String string3 = SecurityPlugin.getWorkspaceName();
        String string4 = "";
        try {
            keyStore = this.getKeyStore();
            this._securityUI.loadCertificate(keyStore);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string5 = SecurityPlugin.getResourceString("STR_KEY_IO_ERROR_");
            string5 = TString.change(string5, "%1", this._securityUI.getPath());
            String string6 = SecurityPlugin.getResourceString("STR_CERTIFICATE_LOAD_EXC_");
            Status status = new Status(4, "org.eclipse.core.resources", 4, string5, (Throwable)fileNotFoundException);
            ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)string6, (IStatus)status);
            return false;
        }
        catch (IOException iOException) {
            String string7 = SecurityPlugin.getResourceString("STR_LOAD_IO_EXC_");
            string7 = TString.change(string7, "%1", this._securityUI.getPath());
            string7 = TString.change(string7, "%1", SecurityPlugin.getKeyStoreLocation());
            String string8 = SecurityPlugin.getResourceString("STR_CERTIFICATE_LOAD_EXC_");
            Status status = new Status(4, "org.eclipse.core.resources", 4, string7, (Throwable)iOException);
            ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)string8, (IStatus)status);
            return false;
        }
        catch (CertificateException certificateException) {
            String string9 = SecurityPlugin.getResourceString("STR_CERTIFICATE_EXC_");
            string9 = TString.change(string9, "%1", this._securityUI.getPath());
            String string10 = SecurityPlugin.getResourceString("STR_CERTIFICATE_LOAD_EXC_");
            Status status = new Status(4, "org.eclipse.core.resources", 4, string9, (Throwable)certificateException);
            ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)string10, (IStatus)status);
            return false;
        }
        catch (KeyStoreException keyStoreException) {
            String string11 = SecurityPlugin.getResourceString("STR_KEY_STORE_ERROR_");
            string11 = TString.change(string11, "%1", SecurityPlugin.getKeyStoreLocation());
            String string12 = SecurityPlugin.getResourceString("STR_CERTIFICATE_LOAD_EXC_");
            Status status = new Status(4, "org.eclipse.core.resources", 4, string11, (Throwable)keyStoreException);
            ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)string12, (IStatus)status);
            return false;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            String string13 = SecurityPlugin.getResourceString("STR_SECURITY_PROVIDER_ERROR_");
            string13 = TString.change(string13, "%1", SecurityPlugin.getKeyStoreLocation());
            String string14 = SecurityPlugin.getResourceString("STR_INITIALIZE_ERROR_");
            string14 = TString.change(string14, "%1", SecurityPlugin.getKeyStoreLocation());
            Status status = new Status(4, "org.eclipse.core.resources", 4, string13, (Throwable)noSuchProviderException);
            ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)string14, (IStatus)status);
            return false;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            String string15 = SecurityPlugin.getResourceString("STR_ALGORITHM_ERROR_");
            string15 = TString.change(string15, "%1", SecurityPlugin.getKeyStoreLocation());
            String string16 = SecurityPlugin.getResourceString("STR_CERTIFICATE_LOAD_EXC_");
            Status status = new Status(4, "org.eclipse.core.resources", 4, string15, (Throwable)noSuchAlgorithmException);
            ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)string16, (IStatus)status);
            return false;
        }
        try {
            KeystoreHelper.persistKeyStore((KeyStore)keyStore, (String)string2, (String)string3);
        }
        catch (IOException iOException) {
            String string17 = SecurityPlugin.getResourceString("STR_IO_SAVE_ERROR_");
            string17 = TString.change(string17, "%1", string2);
            String string18 = SecurityPlugin.getResourceString("STR_KEYSTORE_SAVE_ERROR_");
            Status status = new Status(4, "org.eclipse.core.resources", 4, string17, (Throwable)iOException);
            ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)string18, (IStatus)status);
            return false;
        }
        catch (CertificateException certificateException) {
            String string19 = SecurityPlugin.getResourceString("STR_CERTIFICATE_STORE_ERROR_");
            string19 = TString.change(string19, "%1", string2);
            String string20 = SecurityPlugin.getResourceString("STR_KEYSTORE_SAVE_ERROR_");
            Status status = new Status(4, "org.eclipse.core.resources", 4, string19, (Throwable)certificateException);
            ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)string20, (IStatus)status);
            return false;
        }
        catch (KeyStoreException keyStoreException) {
            String string21 = SecurityPlugin.getResourceString("STR_UNINIT_KEYSTORE_ERROR_");
            string21 = TString.change(string21, "%1", SecurityPlugin.getKeyStoreLocation());
            String string22 = SecurityPlugin.getResourceString("STR_KEYSTORE_SAVE_ERROR_");
            Status status = new Status(4, "org.eclipse.core.resources", 4, string21, (Throwable)keyStoreException);
            ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)string22, (IStatus)status);
            return false;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            String string23 = SecurityPlugin.getResourceString("STR_ALGORITHM_ERROR_");
            string23 = TString.change(string23, "%1", SecurityPlugin.getKeyStoreLocation());
            String string24 = SecurityPlugin.getResourceString("STR_KEYSTORE_SAVE_ERROR_");
            Status status = new Status(4, "org.eclipse.core.resources", 4, string23, (Throwable)noSuchAlgorithmException);
            ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)string24, (IStatus)status);
            return false;
        }
        return true;
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.determinePageCompletion());
    }

    private KeyStore getKeyStore() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException {
        return KeystoreHelper.createKeyStore((String)SecurityPlugin.getKeyStoreLocation(), (String)SecurityPlugin.getWorkspaceName());
    }
}

