/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.trace.views.util.internal.Coverage;
import org.eclipse.hyades.trace.views.util.internal.CoverageAnalysis;
import org.eclipse.hyades.trace.views.util.internal.CoverageLeaf;

public class CoverageFolder
extends Coverage {
    private int methods;
    private int methodsHit;
    private ArrayList childs;

    public CoverageFolder(CoverageAnalysis coverageAnalysis, Coverage coverage) {
        super(coverageAnalysis, coverage);
        this.childs = new ArrayList();
    }

    public CoverageFolder(CoverageAnalysis coverageAnalysis, Coverage coverage, CoverageFolder coverageFolder) {
        super(coverageAnalysis, coverage);
        this.methods = coverageFolder.getMethods();
        this.methodsHit = coverageFolder.getMethodsHit();
        this.setCalls(coverageFolder.getCalls());
        this.childs = null;
    }

    public void parse(EList eList) {
        int n = 0;
        while (n < eList.size()) {
            CoverageLeaf coverageLeaf;
            EObject eObject = (EObject)eList.get(n);
            if (eObject instanceof TRCMethod) {
                coverageLeaf = this.analysis.FindCoverageLeaf(this, eObject);
                coverageLeaf.parse(eObject);
            } else {
                coverageLeaf = null;
                if (eObject instanceof TRCClass && !this.analysis.isFiltered((TRCClass)eObject)) {
                    coverageLeaf = ((TRCClass)eObject).getMethods();
                } else if (eObject instanceof TRCPackage) {
                    coverageLeaf = ((TRCPackage)eObject).getClasses();
                }
                if (coverageLeaf != null) {
                    CoverageFolder coverageFolder = this.analysis.FindCoverageFolder(this, eObject);
                    coverageFolder.parse((EList)coverageLeaf);
                }
            }
            ++n;
        }
    }

    public void compute() {
        this.methods = 0;
        this.methodsHit = 0;
        int n = 0;
        while (n < this.getChilds().size()) {
            Coverage coverage = (Coverage)this.childs.get(n);
            if (coverage instanceof CoverageFolder) {
                ((CoverageFolder)coverage).compute();
                this.methods += coverage.getMethods();
                this.methodsHit += coverage.getMethodsHit();
                this.setCalls(this.getCalls() + coverage.getCalls());
            } else {
                ++this.methods;
                if (coverage.getCalls() > 0) {
                    ++this.methodsHit;
                    this.setCalls(this.getCalls() + coverage.getCalls());
                }
            }
            ++n;
        }
    }

    public int getMethods() {
        return this.methods;
    }

    public int getMethodsHit() {
        return this.methodsHit;
    }

    public int getMethodsMissed() {
        return this.methods - this.methodsHit;
    }

    public ArrayList getChilds() {
        return this.childs;
    }

    public void setChilds(ArrayList arrayList) {
        this.childs = arrayList;
    }

    public double getPercentage() {
        if (this.getMethods() == 0) {
            return 0.0;
        }
        return (double)this.getMethodsHit() / (double)this.getMethods();
    }
}

