/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.hyades.logging.events.ICommonBaseEvent;
import org.eclipse.hyades.logging.events.IComponentIdentification;
import org.eclipse.hyades.logging.events.IReportSituation;
import org.eclipse.hyades.logging.events.ISituation;
import org.eclipse.hyades.logging.events.ISituationType;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.Parser;
import org.eclipse.hyades.logging.parsers.ParserUtilities;

public abstract class AbstractAccessLogParser
extends Parser {
    protected String clientIP = null;
    protected String method = null;
    protected String fileName = null;
    protected String returnCode = null;
    protected String fileSize = null;
    protected String userID = null;
    protected String message = null;
    protected StringBuffer currentTimeStamp = null;
    protected String productVersion = null;
    protected String sourceID = null;
    private String previousTimeStamp = "";
    private long duplicateTimeStampCounter = 0L;
    private IComponentIdentification sourceComponentID = Parser.eventFactory.createComponentIdentification();

    public void preParse() throws LogParserException {
        super.preParse();
    }

    public ICommonBaseEvent[] parseNext() throws LogParserException {
        ICommonBaseEvent[] iCommonBaseEventArray = null;
        this.curLine = this.readLine();
        this.arrayIndex = 0;
        try {
            while (this.curLine != null) {
                this.curLine = this.curLine.trim();
                if (this.curLine.length() > 0) {
                    if (this.parseLogRecord()) {
                        this.reinitializeCBE();
                        if (this.previousTimeStamp.equals(this.currentTimeStamp.toString())) {
                            this.messages[this.arrayIndex].setSequenceNumber(++this.duplicateTimeStampCounter);
                        } else {
                            this.previousTimeStamp = this.currentTimeStamp.toString();
                            this.duplicateTimeStampCounter = 0L;
                        }
                        this.messages[this.arrayIndex].setCreationTime(this.currentTimeStamp.toString());
                        this.messages[this.arrayIndex].setMsg(this.message);
                        this.messages[this.arrayIndex].setSeverity((short)10);
                        if (this.method != null) {
                            this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("method", this.method));
                        }
                        if (this.clientIP != null) {
                            this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("client", this.clientIP));
                        }
                        if (this.fileName != null) {
                            this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("file", this.fileName));
                        }
                        if (this.returnCode != null) {
                            this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("return_code", this.returnCode));
                        }
                        if (this.fileSize != null) {
                            this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("file_size", this.fileSize));
                        }
                        if (this.userID != null) {
                            this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("userid", this.userID));
                        }
                        ++this.arrayIndex;
                        if (this.arrayIndex == this.MessageArraySize) {
                            this.arrayIndex = 0;
                            ++this.recordCount;
                            this.reset();
                            return this.messages;
                        }
                        ++this.recordCount;
                        this.reset();
                    } else {
                        throw new LogParserException(ParserUtilities.getResourceString("INVALID_ACCESS_LOG_ERROR_", this.file_path));
                    }
                }
                this.curLine = this.readLine();
            }
            if (this.arrayIndex == 0) {
                iCommonBaseEventArray = null;
            } else {
                int n = this.arrayIndex;
                while (n < this.MessageArraySize) {
                    this.messages[n] = null;
                    ++n;
                }
                iCommonBaseEventArray = this.messages;
            }
            if (this.recordCount == 0) {
                throw new LogParserException(ParserUtilities.getResourceString("NO_LOG_RECORDS_ERROR_", this.file_path));
            }
        }
        catch (LogParserException logParserException) {
            throw logParserException;
        }
        catch (Throwable throwable) {
            ParserUtilities.exceptionHandler(throwable, this.curLineNumber, this.curLine, ParserUtilities.getResourceString("ACCESS_LOG_PARSER_ERROR_"));
        }
        return iCommonBaseEventArray;
    }

    private void reinitializeCBE() {
        this.messages[this.arrayIndex].init();
        this.sourceComponentID.init();
        this.sourceComponentID.setLocation(this.localHostId);
        this.sourceComponentID.setLocationType(this.localHostIdFormat);
        this.sourceComponentID.setComponent(this.sourceID);
        this.sourceComponentID.setSubComponent("Unknown");
        this.sourceComponentID.setComponentType("ApacheHTTPServer");
        this.sourceComponentID.setComponentIdType("ProductName");
        this.messages[this.arrayIndex].setSourceComponentId(this.sourceComponentID);
        this.messages[this.arrayIndex].setSituation(this.createSituation());
    }

    private ISituation createSituation() {
        ISituation iSituation = Parser.eventFactory.createSituation();
        IReportSituation iReportSituation = Parser.eventFactory.createReportSituation();
        iReportSituation.setReasoningScope("INTERNAL");
        iReportSituation.setReportCategory("LOG");
        iSituation.setCategoryName("ReportSituation");
        iSituation.setSituationType((ISituationType)iReportSituation);
        return iSituation;
    }

    protected boolean parseDate(int n, int n2) {
        if (this.curLine.charAt(n) == '[' && this.curLine.charAt(n2) == ']') {
            int n3 = this.curLine.indexOf(45, n);
            if (n3 == -1 && (n3 = this.curLine.indexOf(43, n)) == -1) {
                return false;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss", Locale.US);
            Date date = simpleDateFormat.parse(this.curLine.substring(n + 1, n3).trim(), new ParsePosition(0));
            if (date != null) {
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                this.currentTimeStamp = new StringBuffer(simpleDateFormat.format(date).trim());
                this.currentTimeStamp.replace(10, 11, "T");
                this.currentTimeStamp.append(".000000");
                this.currentTimeStamp.append(this.curLine.charAt(n3));
                this.currentTimeStamp.append(this.curLine.substring(n3 + 1, n3 + 3));
                this.currentTimeStamp.append(":");
                this.currentTimeStamp.append(this.curLine.substring(n3 + 3, n3 + 5));
                return true;
            }
        }
        return false;
    }

    protected boolean parseLogRecord() {
        int n = 0;
        int n2 = this.curLine.indexOf(" ");
        if (n2 == -1) {
            return false;
        }
        this.clientIP = this.curLine.substring(n, n2).trim();
        if (!ParserUtilities.isValidIPAddress(this.clientIP)) {
            return false;
        }
        n = n2;
        if ((n2 = this.curLine.indexOf(" ", n + 1)) == -1) {
            return false;
        }
        n = n2;
        if ((n2 = this.curLine.indexOf(" ", n + 1)) == -1) {
            return false;
        }
        this.userID = this.curLine.substring(n, n2).trim();
        if (this.userID.equals("-")) {
            this.userID = null;
        }
        if ((n2 = this.curLine.indexOf("[", n = n2)) == -1) {
            return false;
        }
        n = n2;
        if ((n2 = this.curLine.indexOf("]", n)) == -1) {
            return false;
        }
        if (!this.parseDate(n, n2)) {
            return false;
        }
        n = n2;
        if ((n2 = this.curLine.indexOf("\"", n)) == -1) {
            return false;
        }
        n = n2;
        if ((n2 = this.curLine.indexOf(" ", n)) == -1) {
            return false;
        }
        this.method = this.curLine.substring(n + 1, n2).trim();
        this.message = this.curLine.substring(n).trim();
        int n3 = this.curLine.lastIndexOf("\"");
        if (n3 == -1 || n3 == n) {
            return false;
        }
        n = n2;
        n2 = this.curLine.lastIndexOf(" ", n3);
        if (n2 == n) {
            return false;
        }
        this.fileName = this.curLine.substring(n, n2).trim();
        n = n2;
        if ((n2 = this.curLine.indexOf(" ", n + 1)) == -1) {
            return false;
        }
        n = n2;
        if ((n2 = this.curLine.indexOf(" ", n + 1)) == -1) {
            return false;
        }
        this.returnCode = this.curLine.substring(n, n2).trim();
        this.fileSize = this.curLine.substring(n2).trim();
        return true;
    }

    protected void reset() {
        this.userID = null;
        this.method = null;
        this.returnCode = null;
        this.clientIP = null;
        this.fileName = null;
        this.fileSize = null;
        this.message = null;
        this.currentTimeStamp = null;
    }
}

