/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.navigator;

import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.navigator.LogContentProvider;
import org.eclipse.hyades.log.ui.internal.navigator.LogLabelProvider;
import org.eclipse.hyades.log.ui.internal.navigator.LogNavigatorActionGroup;
import org.eclipse.hyades.log.ui.internal.navigator.LogNavigatorSynchronizer;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.ui.internal.navigator.TreeNavigator;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup;
import org.eclipse.hyades.ui.internal.provider.ResourceChangeUpdaterProvider;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class LogNavigator
extends TreeNavigator
implements IProfileEventListener {
    private final String LOG_SECTION = "LogNavigator";
    private LogContentProvider contentProvider;
    private ResourceChangeUpdaterProvider resourceChangeUpdaterProvider;
    private LogNavigatorSynchronizer synchronizer;
    private int fFilterProperties;

    public void createPartControl(Composite composite) {
        super.createPartControl(composite);
        UIPlugin.getDefault().addSelectionProvider((ISelectionProvider)this.getViewer(), (IWorkbenchPart)this);
        UIPlugin.getDefault().addProfileEventListener((IProfileEventListener)this);
    }

    public void dispose() {
        UIPlugin.getDefault().removeSelectionProvider((ISelectionProvider)this.getViewer(), (IWorkbenchPart)this);
        UIPlugin.getDefault().removeProfileEventListener((IProfileEventListener)this);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceChangeUpdaterProvider);
        this.resourceChangeUpdaterProvider.dispose();
        this.resourceChangeUpdaterProvider = null;
        this.contentProvider.getResourceSet().eAdapters().remove((Object)this.synchronizer);
        this.synchronizer.dispose();
        this.synchronizer = null;
        this.contentProvider.dispose();
        this.contentProvider = null;
        HyadesUtil.cleanupResources((String)"org.eclipse.hyades.log.ui.internal.navigator.LogNavigator");
        super.dispose();
    }

    public AbstractUIPlugin getPlugin() {
        return LogUIPlugin.getDefault();
    }

    public boolean isShowingFolders() {
        return false;
    }

    public void handleProfileEvent(ProfileEvent profileEvent) {
        if (profileEvent.getSource() != null && (profileEvent.getSource() instanceof TRCAgentProxy && ((TRCAgentProxy)profileEvent.getSource()).getType().equals("Logging") || profileEvent.getSource() instanceof IWorkspaceRoot)) {
            switch (profileEvent.getType()) {
                case 1: {
                    this.getViewer().setSelection((ISelection)new StructuredSelection(profileEvent.getSource()));
                    break;
                }
                case 4: {
                    this.getViewer().setSelection((ISelection)new StructuredSelection(profileEvent.getSource()));
                    break;
                }
                case 4096: {
                    break;
                }
                case 4608: {
                    this.getContentProvider().refreshFromLocal();
                    break;
                }
                case 5120: {
                    break;
                }
                default: {
                    this.getViewer().refresh(profileEvent.getSource());
                }
            }
        }
    }

    protected void createActions() {
        this.setActionGroup((NavigatorActionGroup)new LogNavigatorActionGroup(this));
    }

    protected Object createViewerInput() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected boolean editorActivated(IEditorPart iEditorPart) {
        return false;
    }

    public String getStoreSection() {
        return "LogNavigator";
    }

    protected void linkToEditor(IStructuredSelection iStructuredSelection) {
    }

    public void doubleClick(DoubleClickEvent doubleClickEvent) {
        if (doubleClickEvent.getViewer() == this.getTreeViewer()) {
            ((LogNavigatorActionGroup)this.getActionGroup()).handleDoubleClick(doubleClickEvent);
        }
    }

    public LogContentProvider getContentProvider() {
        return this.contentProvider;
    }

    protected void adjustTreeViewer(TreeViewer treeViewer) {
        this.contentProvider = new LogContentProvider(this);
        treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        treeViewer.setLabelProvider((IBaseLabelProvider)new LogLabelProvider(this));
        this.resourceChangeUpdaterProvider = new ResourceChangeUpdaterProvider.UIUpdaterProvider();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceChangeUpdaterProvider, 1);
        this.synchronizer = new LogNavigatorSynchronizer(this);
        this.synchronizer.register(this.resourceChangeUpdaterProvider, this.contentProvider.getResourceSet());
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
    }

    public void setLinkingEnabled(boolean bl) {
        super.setLinkingEnabled(bl);
        if (bl && this.getViewer() != null) {
            this.getViewer().setSelection(this.getViewer().getSelection());
        }
    }

    protected void initContextMenu() {
        MenuManager menuManager = new MenuManager("#LogNavigatorPopupMenu#");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        Menu menu = menuManager.createContextMenu(this.getViewer().getControl());
        this.getViewer().getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.getViewer());
    }

    public void partActivated(IWorkbenchPart iWorkbenchPart) {
        super.partActivated(iWorkbenchPart);
        if (iWorkbenchPart == this) {
            this.getViewer().setSelection((ISelection)((LogNavigator)iWorkbenchPart).getStructuredSelection());
        }
    }

    public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
        super.partBroughtToTop(iWorkbenchPart);
        if (iWorkbenchPart == this) {
            this.getViewer().setSelection((ISelection)((LogNavigator)iWorkbenchPart).getStructuredSelection());
        }
    }

    protected String getHelpContextId() {
        return ContextIds.LOG_NAVIGATOR_VIEW;
    }

    public final void addFilter(int n) {
        this.fFilterProperties |= n;
    }

    public final boolean hasFilter(int n) {
        return (this.fFilterProperties & n) != 0;
    }

    public final void removeFilter(int n) {
        this.fFilterProperties &= 0xFFFFFFFF ^ n;
    }

    public IDialogSettings getSettings() {
        return super.getSettings();
    }
}

