/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.log.ui.internal.navigator.LogNavigator;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.hyades.ui.internal.provider.IResourceChangeUpdater;
import org.eclipse.hyades.ui.internal.provider.ResourceChangeUpdaterProvider;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.swt.widgets.Display;

public class LogNavigatorSynchronizer
extends AdapterImpl
implements IDisposable,
IResourceChangeUpdater {
    private LogNavigator navigator;
    private boolean active;
    private Collection addedResources;
    private Collection removedResources;
    private Collection changedResources;
    private Collection adaptedObjects = new ArrayList();

    public LogNavigatorSynchronizer(LogNavigator logNavigator) {
        this.navigator = logNavigator;
        this.active = true;
    }

    public void dispose() {
        Iterator iterator = this.adaptedObjects.iterator();
        while (iterator.hasNext()) {
            Notifier notifier = (Notifier)iterator.next();
            notifier.eAdapters().remove((Object)this);
        }
        this.adaptedObjects.clear();
        this.navigator = null;
    }

    public void register(ResourceChangeUpdaterProvider resourceChangeUpdaterProvider, ResourceSet resourceSet) {
        if (resourceChangeUpdaterProvider != null) {
            resourceChangeUpdaterProvider.setResourceChangeUpdater((IResourceChangeUpdater)this);
        }
        if (resourceSet != null && resourceSet.eAdapters().add(this)) {
            Iterator iterator = resourceSet.getResources().iterator();
            while (iterator.hasNext()) {
                this.handleAdd((Resource)iterator.next());
            }
        }
    }

    public void notifyChanged(Notification notification) {
        if (!this.isActive()) {
            return;
        }
        switch (notification.getEventType()) {
            case 3: {
                Object object = notification.getNewValue();
                if (object instanceof Resource) {
                    this.handleAdd((Resource)object);
                    break;
                }
                if (object instanceof TRCProcessProxy) {
                    this.handleAdd((TRCProcessProxy)object);
                    break;
                }
                if (object instanceof TRCAgentProxy) {
                    this.handleAdd((TRCAgentProxy)object);
                    break;
                }
                if (object instanceof TRCMonitor) {
                    this.handleAdd((TRCMonitor)object);
                    break;
                }
                if (!(object instanceof CorrelationContainerProxy)) break;
                this.handleAdd((CorrelationContainerProxy)object);
                break;
            }
            case 5: {
                Collection collection = (Collection)notification.getNewValue();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (e instanceof Resource) {
                        this.handleAdd((Resource)e);
                        continue;
                    }
                    if (e instanceof TRCProcessProxy) {
                        this.handleAdd((TRCProcessProxy)e);
                        continue;
                    }
                    if (e instanceof TRCAgentProxy) {
                        this.handleAdd((TRCAgentProxy)e);
                        continue;
                    }
                    if (e instanceof TRCMonitor) {
                        this.handleAdd((TRCMonitor)e);
                        continue;
                    }
                    if (!(e instanceof CorrelationContainerProxy)) continue;
                    this.handleAdd((CorrelationContainerProxy)e);
                }
                break;
            }
            case 4: {
                Object object = notification.getOldValue();
                if (object instanceof Resource) {
                    this.handleRemove((Resource)object);
                } else if (object instanceof TRCProcessProxy) {
                    this.handleRemove((TRCProcessProxy)object);
                } else if (object instanceof TRCAgentProxy) {
                    this.handleRemove((TRCAgentProxy)object);
                } else if (object instanceof TRCMonitor) {
                    this.handleRemove((TRCMonitor)object);
                } else if (object instanceof CorrelationContainerProxy) {
                    this.handleRemove((CorrelationContainerProxy)object);
                }
                if (!(notification.getNotifier() instanceof CorrelationContainerProxy) || notification.getFeature() != HierarchyPackage.eINSTANCE.getCorrelationContainerProxy_CorrelatedAgents()) break;
                CorrelationContainerProxy correlationContainerProxy = (CorrelationContainerProxy)notification.getNotifier();
                if (correlationContainerProxy.getCorrelatedAgents().size() == 0) {
                    correlationContainerProxy.setMonitor(null);
                }
                this.getNavigator().getViewer().refresh(notification.getNotifier());
                break;
            }
            case 6: {
                Collection collection = (Collection)notification.getOldValue();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (e instanceof Resource) {
                        this.handleRemove((Resource)e);
                        continue;
                    }
                    if (e instanceof TRCProcessProxy) {
                        this.handleRemove((TRCProcessProxy)e);
                        continue;
                    }
                    if (e instanceof TRCAgentProxy) {
                        this.handleRemove((TRCAgentProxy)e);
                        continue;
                    }
                    if (e instanceof TRCMonitor) {
                        this.handleRemove((TRCMonitor)e);
                        continue;
                    }
                    if (!(e instanceof CorrelationContainerProxy)) continue;
                    this.handleRemove((CorrelationContainerProxy)e);
                }
                break;
            }
            case 1: {
                if (!(notification.getNotifier() instanceof TRCAgentProxy)) break;
                this.handleSet((TRCAgentProxy)notification.getNotifier());
            }
        }
    }

    protected void handleRemove(TRCMonitor tRCMonitor) {
        tRCMonitor.eAdapters().remove((Object)this);
        this.adaptedObjects.remove(tRCMonitor);
        Iterator iterator = tRCMonitor.getCorrelationContainerProxies().iterator();
        while (iterator.hasNext()) {
            this.handleRemove((CorrelationContainerProxy)iterator.next());
        }
    }

    protected void handleRemove(CorrelationContainerProxy correlationContainerProxy) {
        LogicalFolder logicalFolder = this.navigator.getContentProvider().getCorrelationFolder();
        correlationContainerProxy.eAdapters().remove((Object)this);
        this.adaptedObjects.remove(correlationContainerProxy);
        if (logicalFolder.getChildren().remove(correlationContainerProxy)) {
            this.removeFromTree(correlationContainerProxy);
        }
    }

    protected void handleAdd(Resource resource) {
        block4: {
            block3: {
                if (!"trcpxmi".equals(resource.getURI().fileExtension())) break block3;
                if (!resource.eAdapters().add(this)) break block4;
                this.adaptedObjects.add(resource);
                Iterator iterator = resource.getContents().iterator();
                while (iterator.hasNext()) {
                    EObject eObject = (EObject)iterator.next();
                    if (!(eObject instanceof TRCProcessProxy)) continue;
                    this.handleAdd((TRCProcessProxy)eObject);
                }
                break block4;
            }
            if ("trcmxmi".equals(resource.getURI().fileExtension()) && resource.eAdapters().add(this)) {
                this.adaptedObjects.add(resource);
                Iterator iterator = resource.getContents().iterator();
                while (iterator.hasNext()) {
                    EObject eObject = (EObject)iterator.next();
                    if (!(eObject instanceof TRCMonitor)) continue;
                    this.handleAdd((TRCMonitor)eObject);
                }
            }
        }
    }

    private void handleAdd(TRCMonitor tRCMonitor) {
        if (tRCMonitor.eAdapters().add(this)) {
            this.adaptedObjects.add(tRCMonitor);
            Iterator iterator = tRCMonitor.getCorrelationContainerProxies().iterator();
            while (iterator.hasNext()) {
                this.handleAdd((CorrelationContainerProxy)iterator.next());
            }
        }
    }

    private void handleAdd(CorrelationContainerProxy correlationContainerProxy) {
        LogicalFolder logicalFolder = this.navigator.getContentProvider().getCorrelationFolder();
        if (correlationContainerProxy.eAdapters().add(this)) {
            this.adaptedObjects.add(correlationContainerProxy);
            if (!logicalFolder.getChildren().contains(correlationContainerProxy)) {
                logicalFolder.getChildren().add(correlationContainerProxy);
                this.addToTree((Object)this.navigator.getContentProvider().getCorrelationFolder(), correlationContainerProxy);
            }
        }
    }

    protected void handleAdd(TRCProcessProxy tRCProcessProxy) {
        if (tRCProcessProxy.eAdapters().add(this)) {
            this.adaptedObjects.add(tRCProcessProxy);
            Iterator iterator = tRCProcessProxy.getAgentProxies().iterator();
            while (iterator.hasNext()) {
                this.handleAdd((TRCAgentProxy)iterator.next());
            }
        }
    }

    protected void handleAdd(TRCAgentProxy tRCAgentProxy) {
        if ("Logging".equals(tRCAgentProxy.getType())) {
            LogicalFolder logicalFolder = this.navigator.getContentProvider().getLogFolder();
            if (this.navigator.hasFilter(2)) {
                this.addToTree((Object)logicalFolder, tRCAgentProxy);
            } else if (!this.navigator.hasFilter(2)) {
                this.refreshTree(logicalFolder);
            }
        }
    }

    protected void handleRemove(Resource resource) {
        block4: {
            block5: {
                block3: {
                    if (!"trcpxmi".equals(resource.getURI().fileExtension())) break block3;
                    resource.eAdapters().remove((Object)this);
                    this.adaptedObjects.remove(resource);
                    Iterator iterator = resource.getContents().iterator();
                    while (iterator.hasNext()) {
                        EObject eObject = (EObject)iterator.next();
                        if (!(eObject instanceof TRCProcessProxy)) continue;
                        this.handleRemove((TRCProcessProxy)eObject);
                    }
                    break block4;
                }
                if (!"trcmxmi".equals(resource.getURI().fileExtension())) break block5;
                this.adaptedObjects.remove(resource);
                Iterator iterator = resource.getContents().iterator();
                while (iterator.hasNext()) {
                    EObject eObject = (EObject)iterator.next();
                    if (!(eObject instanceof TRCMonitor)) continue;
                    this.handleRemove((TRCMonitor)eObject);
                }
                break block4;
            }
            if (!"trcaxmi".equals(resource.getURI().fileExtension())) break block4;
            resource.eAdapters().remove((Object)this);
            this.adaptedObjects.remove(resource);
            Iterator iterator = resource.getContents().iterator();
            while (iterator.hasNext()) {
                EObject eObject = (EObject)iterator.next();
                if (!(eObject instanceof TRCAgentProxy)) continue;
                this.handleRemove((TRCAgentProxy)eObject);
            }
        }
    }

    protected void handleRemove(TRCProcessProxy tRCProcessProxy) {
        tRCProcessProxy.eAdapters().remove((Object)this);
        this.adaptedObjects.remove(tRCProcessProxy);
        Iterator iterator = tRCProcessProxy.getAgentProxies().iterator();
        while (iterator.hasNext()) {
            this.handleRemove((TRCAgentProxy)iterator.next());
        }
    }

    protected void handleRemove(TRCAgentProxy tRCAgentProxy) {
        if ("Logging".equals(tRCAgentProxy.getType())) {
            LogicalFolder logicalFolder = this.navigator.getContentProvider().getLogFolder();
            if (this.navigator.hasFilter(2)) {
                this.removeFromTree(tRCAgentProxy);
            } else if (!this.navigator.hasFilter(2)) {
                this.refreshTree(logicalFolder);
            }
        }
    }

    protected void handleSet(TRCAgentProxy tRCAgentProxy) {
        if ("Logging".equals(tRCAgentProxy.getType())) {
            this.refreshTree(tRCAgentProxy);
        }
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public boolean isActive() {
        return this.active;
    }

    public void started() {
        this.addedResources = new ArrayList();
        this.removedResources = new ArrayList();
        this.changedResources = new ArrayList();
    }

    public void ended() {
        LogicalFolder logicalFolder = this.navigator.getContentProvider().getSDFolder();
        boolean bl = false;
        if (!this.removedResources.isEmpty()) {
            int n = logicalFolder.getChildren().size();
            Iterator iterator = this.removedResources.iterator();
            while (iterator.hasNext()) {
                IResource iResource = (IResource)iterator.next();
                if (iResource.getType() == 1) continue;
                IPath iPath = iResource.getFullPath();
                IResource[] iResourceArray = logicalFolder.getChildren().toArray(new IResource[logicalFolder.getChildren().size()]);
                int n2 = 0;
                int n3 = iResourceArray.length;
                while (n2 < n3) {
                    if (iPath.isPrefixOf(iResourceArray[n2].getFullPath())) {
                        logicalFolder.getChildren().remove(n2);
                    }
                    ++n2;
                }
            }
            logicalFolder.getChildren().removeAll(this.removedResources);
            boolean bl2 = bl = n != logicalFolder.getChildren().size();
        }
        if (!this.addedResources.isEmpty()) {
            logicalFolder.getChildren().addAll(this.addedResources);
            if (!bl) {
                this.addToTree((Object)logicalFolder, this.addedResources.toArray());
            }
        }
        if (!this.changedResources.isEmpty() && !bl) {
            this.refreshTree(this.changedResources.toArray());
        }
        if (bl) {
            this.refreshTree(logicalFolder);
        }
        this.addedResources.clear();
        this.addedResources = null;
        this.removedResources.clear();
        this.removedResources = null;
        this.changedResources.clear();
        this.changedResources = null;
    }

    public boolean add(IResource iResource, IResource[] iResourceArray) {
        int n = 0;
        int n2 = iResourceArray.length;
        while (n < n2) {
            if ("trcdbxmi".equals(iResourceArray[n].getFileExtension()) && this.navigator.getContentProvider().getSDFolder().getChildren().add(iResourceArray[n])) {
                this.addedResources.add(iResourceArray[n]);
            }
            ++n;
        }
        return false;
    }

    public boolean remove(IResource iResource, IResource[] iResourceArray) {
        int n = 0;
        int n2 = iResourceArray.length;
        while (n < n2) {
            if (iResourceArray[n].getType() != 1) {
                this.removedResources.add(iResourceArray[n]);
            } else if ("trcdbxmi".equals(iResourceArray[n].getFileExtension())) {
                this.removedResources.add(iResourceArray[n]);
            }
            ++n;
        }
        return false;
    }

    public boolean replaced(IResource iResource) {
        return false;
    }

    public boolean updateChildrenType(IResource iResource) {
        return false;
    }

    public boolean updateContent(IResource iResource, IResource iResource2) {
        return false;
    }

    public boolean updateProperties(IResource iResource) {
        if ("trcdbxmi".equals(iResource.getFileExtension())) {
            this.changedResources.add(iResource);
        }
        return false;
    }

    protected void addToTree(final Object object, final Object object2) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                LogNavigatorSynchronizer.this.getNavigator().getTreeViewer().add(object, object2);
            }
        });
    }

    protected void addToTree(final Object object, final Object[] objectArray) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                LogNavigator logNavigator = LogNavigatorSynchronizer.this.getNavigator();
                if (logNavigator != null) {
                    logNavigator.getTreeViewer().add(object, objectArray);
                }
            }
        });
    }

    protected void removeFromTree(final Object object) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (LogNavigatorSynchronizer.this.navigator != null && LogNavigatorSynchronizer.this.navigator.getTreeViewer() != null && !LogNavigatorSynchronizer.this.navigator.getTreeViewer().getControl().isDisposed()) {
                    LogNavigatorSynchronizer.this.navigator.getTreeViewer().remove(object);
                }
            }
        });
    }

    protected void removeFromTree(final Object[] objectArray) {
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                if (LogNavigatorSynchronizer.this.navigator != null && LogNavigatorSynchronizer.this.navigator.getTreeViewer() != null && !LogNavigatorSynchronizer.this.navigator.getTreeViewer().getControl().isDisposed()) {
                    LogNavigatorSynchronizer.this.navigator.getTreeViewer().remove(objectArray);
                }
            }
        });
    }

    protected void refreshTree(final Object object) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (LogNavigatorSynchronizer.this.navigator != null && LogNavigatorSynchronizer.this.navigator.getTreeViewer() != null && !LogNavigatorSynchronizer.this.navigator.getTreeViewer().getControl().isDisposed()) {
                    LogNavigatorSynchronizer.this.navigator.getTreeViewer().refresh(object, true);
                }
            }
        });
    }

    protected void refreshTree(final Object[] objectArray) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                int n = 0;
                int n2 = objectArray.length;
                while (n < n2) {
                    LogNavigatorSynchronizer.this.getNavigator().getTreeViewer().refresh(objectArray[n], true);
                    ++n;
                }
            }
        });
    }

    protected LogNavigator getNavigator() {
        return this.navigator;
    }
}

