/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import java.util.ArrayList;
import org.eclipse.hyades.log.ui.internal.util.CBEAdvFilterUI;
import org.eclipse.hyades.log.ui.internal.util.FilterList;
import org.eclipse.jface.preference.IPreferenceStore;

public class FilterTableElement {
    public static final String P_OPERATOR = "operator_combo";
    public static final String P_ATTRIBUTE = "attribute_combo";
    public static final String P_VALUE = "value_string";
    private String fAttribute;
    private String fOperator;
    private String fValue;
    private FilterList fParent;

    public FilterTableElement(String string, String string2, String string3) {
        this.fAttribute = string;
        this.fOperator = string2;
        this.fValue = string3;
    }

    public void setParent(FilterList filterList) {
        this.fParent = filterList;
    }

    public String getAtrribute() {
        return this.fAttribute;
    }

    public String getOperator() {
        return this.fOperator;
    }

    public String getValue() {
        return this.fValue;
    }

    public int getAttributeState() {
        int n = 0;
        while (n < CBEAdvFilterUI.fAttributeValues.length) {
            if (CBEAdvFilterUI.fAttributeValues[n].equals(this.fAttribute)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getOperatorState() {
        int n = 0;
        while (n < CBEAdvFilterUI.fOperatorValues.length) {
            if (CBEAdvFilterUI.fOperatorValues[n].equals(this.fOperator)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void setValue(String string) {
        this.fValue = string;
        this.fParent.fireElementChanged(this, P_VALUE);
    }

    public void setOperator(String string) {
        this.fOperator = string;
        this.fParent.fireElementChanged(this, P_OPERATOR);
    }

    public void setOperator(int n) {
        this.fOperator = CBEAdvFilterUI.fOperatorValues[n];
        this.fParent.fireElementChanged(this, P_OPERATOR);
    }

    public void setAttribute(String string) {
        this.fAttribute = string;
        this.fParent.fireElementChanged(this, P_ATTRIBUTE);
    }

    public void setAttribute(int n) {
        this.fAttribute = CBEAdvFilterUI.fAttributeValues[n];
        this.fParent.fireElementChanged(this, P_ATTRIBUTE);
    }

    public String toString() {
        return this.fAttribute + "," + this.fOperator + "," + this.fValue;
    }

    public static ArrayList createFilterTableElementFromString(String string) {
        ArrayList arrayList = null;
        if (string != null && !string.equals("")) {
            int n = 0;
            int n2 = string.indexOf("!");
            while (n2 != -1) {
                ++n;
                n2 = string.indexOf("!", n2 + 1);
            }
            arrayList = new ArrayList(n);
            int n3 = 0;
            while (n3 != -1) {
                n3 = string.indexOf("!");
                if (n3 == -1) continue;
                String string2 = string.substring(0, n3);
                string = string.substring(n3 + 1);
                FilterTableElement.addFilterData(string2, arrayList);
            }
        }
        return arrayList;
    }

    private static void addFilterData(String string, ArrayList arrayList) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        int n = string.indexOf(";");
        if (n != -1) {
            string2 = string.substring(0, n);
            if ((n = (string = string.substring(n + 1)).indexOf(";")) != -1) {
                string3 = string.substring(0, n);
                string4 = string.substring(n + 1);
            }
        }
        arrayList.add(new FilterTableElement(string2, string3, string4));
    }

    public static void saveFilters(ArrayList arrayList, String string, IPreferenceStore iPreferenceStore) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        int n = 0;
        while (n < arrayList.size()) {
            FilterTableElement filterTableElement = (FilterTableElement)arrayList.get(n);
            string2 = filterTableElement.getAtrribute();
            string3 = filterTableElement.getOperator();
            string4 = filterTableElement.getValue();
            string5 = string5 + string2 + ";" + string3 + ";" + string4 + "!";
            ++n;
        }
        if (string5 != "") {
            string5.substring(0, string5.length() - 1);
        }
        iPreferenceStore.setValue(string, string5);
    }
}

