/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.CBESortUI;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.log.ui.internal.util.RecordChangeEvent;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class SortDialog
extends Dialog
implements SelectionListener {
    private CBESortUI _options;
    private static final int _restoreDefaultsButtonId = 1025;
    private String _title;
    private boolean sortHasChanged = false;

    public SortDialog(Shell shell, String string, Image image) {
        super(shell);
        this._title = string;
        Window.setDefaultImage((Image)image);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this._title);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 15;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = GridUtil.createFill();
        gridData.heightHint = 400;
        gridData.widthHint = 450;
        composite2.setLayoutData((Object)gridData);
        this._options = new CBESortUI();
        this._options.createControl(composite2);
        this._options.initializeValues(false);
        this._options.addListener(this);
        WorkbenchHelp.setHelp((Control)composite2, (String)ContextIds.ACTLOG_VIEW_DIALOG_SORT);
        return composite2;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 1025, LogUIPlugin.getResourceString("STR_COL_DLG_RESTORE_DEFAULTS"), false);
        super.createButtonsForButtonBar(composite);
    }

    protected void buttonPressed(int n) {
        if (n == 1025) {
            this._options.initializeValues(true);
        } else {
            this._options.removeListener(this);
            super.buttonPressed(n);
        }
    }

    protected void okPressed() {
        this._options.storeValues(LogUIPlugin.getDefault().getPreferenceStore());
        this._options.removeListener(this);
        if (this.sortHasChanged) {
            LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(4, (Object)this));
        }
        super.okPressed();
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.data != null && selectionEvent.data instanceof Integer && (Integer)selectionEvent.data == 4) {
            this.sortHasChanged = true;
        }
    }
}

