/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.LogUIPluginImages;
import org.eclipse.hyades.log.ui.internal.util.ColumnsDialog;
import org.eclipse.hyades.log.ui.internal.util.FiltersDialog;
import org.eclipse.hyades.log.ui.internal.util.SearchRecordDialog;
import org.eclipse.hyades.log.ui.internal.util.SortDialog;
import org.eclipse.hyades.log.ui.internal.views.LogContentProvider;
import org.eclipse.hyades.log.ui.internal.views.LogPage;
import org.eclipse.hyades.log.ui.internal.views.LogViewerUI;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.ui.part.IPage;

public class LogViewer
extends TraceViewer {
    protected final String _title = LogUIPlugin.getResourceString("STR_WAS_VIEW_TITLE");
    private LogPage logPage;
    private Action pageDown;
    private Action pageUp;
    private Action goToPage;
    public boolean handleRefreshEvent = false;

    public TraceViewerPage createPage(EObject eObject) {
        this.logPage = new LogPage(eObject, this);
        return this.logPage;
    }

    public void handleProfileEvent(ProfileEvent profileEvent) {
        if ((profileEvent.getType() == 64 || profileEvent.getType() == 32 || profileEvent.getType() == 2048) && profileEvent.getSource() instanceof EObject) {
            if (!this.fPartVisible) {
                this.fRefreshView = true;
                return;
            }
            this.handleRefreshEvent = true;
            this.refreshPage(this.getObjectToView((EObject)profileEvent.getSource()));
            this.handleRefreshEvent = false;
        }
    }

    public void dispose() {
        super.dispose();
    }

    public void makeActions() {
        if (this.isInitializedMenu()) {
            return;
        }
        this.initializedMenu(true);
        String string = LogUIPlugin.getResourceBundle().getString("STR_SORT");
        Action action = new Action(string){

            public void run() {
                IPage iPage;
                SortDialog sortDialog = new SortDialog(LogViewer.this.getViewSite().getShell(), LogUIPlugin.getResourceString("STR_ST_SORT_COL_SETTINGS"), null);
                sortDialog.open();
                if (sortDialog.getReturnCode() == 0 && (iPage = LogViewer.this.getCurrentPage()) != null && iPage instanceof LogPage) {
                    BusyIndicator.showWhile(null, (Runnable)new Runnable(this, iPage){
                        private final /* synthetic */ IPage val$page;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$page = iPage;
                        }

                        public void run() {
                            ((LogPage)this.val$page).getView().update();
                        }
                    });
                }
            }
        };
        action.setText(string);
        LogUIPluginImages.setImageDescriptors((IAction)action, "lcl16", "sortrecords_co.gif");
        action.setDescription(string);
        action.setToolTipText(string);
        String string2 = LogUIPlugin.getResourceBundle().getString("STR_FILTER");
        Action action2 = new Action(string2){

            public void run() {
                ColumnsDialog columnsDialog = new ColumnsDialog(LogViewer.this.getViewSite().getShell(), LogUIPlugin.getResourceString("STR_ST_COL_SETTINGS"), null);
                columnsDialog.open();
            }
        };
        action2.setText(string2);
        LogUIPluginImages.setImageDescriptors((IAction)action2, "lcl16", "filter_ps.gif");
        action2.setDescription(string2);
        action2.setToolTipText(string2);
        String string3 = LogUIPlugin.getResourceBundle().getString("STR_ADV_FILTER");
        Action action3 = new Action(string3){

            public void run() {
                FiltersDialog filtersDialog = new FiltersDialog(LogViewer.this.getViewSite().getShell(), LogUIPlugin.getResourceString("STR_ST_FILTER_SETTINGS"), null);
                filtersDialog.open();
            }
        };
        action3.setText(string3);
        LogUIPluginImages.setImageDescriptors((IAction)action3, "lcl16", "adv_filter_co.gif");
        action3.setDescription(string3);
        action3.setToolTipText(string3);
        Action action4 = this.createSearchButton();
        this.createPageUpButton();
        this.createPageDownButton();
        this.createGoToPageButton();
        IToolBarManager iToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        iToolBarManager.add((IAction)action);
        iToolBarManager.add((IAction)action2);
        iToolBarManager.add((IAction)action3);
        iToolBarManager.add((IAction)action4);
        iToolBarManager.add((IAction)this.pageUp);
        iToolBarManager.add((IAction)this.pageDown);
        iToolBarManager.add((IAction)this.goToPage);
        this.getViewSite().getActionBars().updateActionBars();
    }

    private Action createSearchButton() {
        String string = LogUIPlugin.getResourceBundle().getString("STR_SEARCH_RECORD");
        Action action = new Action(string){

            public void run() {
                SearchRecordDialog searchRecordDialog = new SearchRecordDialog(LogViewer.this.getViewSite().getShell(), LogUIPlugin.getResourceString("STR_ST_SEARCH_SETTINGS"), null, LogViewer.this.logPage);
                searchRecordDialog.open();
            }
        };
        action.setText(string);
        LogUIPluginImages.setImageDescriptors((IAction)action, "lcl16", "searchrecord.gif");
        action.setDescription(string);
        action.setToolTipText(string);
        return action;
    }

    private Action createPageUpButton() {
        String string = LogUIPlugin.getResourceBundle().getString("STR_PAGE_UP");
        this.pageUp = new Action(string){

            public void run() {
                IPage iPage = LogViewer.this.getCurrentPage();
                if (iPage != null && iPage instanceof LogPage) {
                    BusyIndicator.showWhile(null, (Runnable)new Runnable(this, iPage){
                        private final /* synthetic */ IPage val$page;
                        private final /* synthetic */ 6 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$page = iPage;
                        }

                        public void run() {
                            LogContentProvider logContentProvider = (LogContentProvider)((LogPage)this.val$page).getView().getViewer().getContentProvider();
                            LogViewer.access$200(6.access$100(this.this$1)).setEnabled(logContentProvider.pageUp());
                            ((LogPage)this.val$page).getView().update();
                        }
                    });
                }
            }

            static /* synthetic */ LogViewer access$100(6 var0) {
                return var0.LogViewer.this;
            }
        };
        this.getViewSite().getActionBars().setGlobalActionHandler("previous", (IAction)this.pageUp);
        this.pageUp.setText(string);
        LogUIPluginImages.setImageDescriptors((IAction)this.pageUp, "lcl16", "pageup.gif");
        this.pageUp.setDescription(string);
        this.pageUp.setToolTipText(string);
        return this.pageUp;
    }

    private Action createGoToPageButton() {
        String string = LogUIPlugin.getResourceString("STR_GO_TO_PAGE");
        this.goToPage = new Action(string){

            public void run() {
                IPage iPage = LogViewer.this.getCurrentPage();
                LogContentProvider logContentProvider = (LogContentProvider)((LogPage)iPage).getView().getViewer().getContentProvider();
                int n = logContentProvider.getTotalPages();
                if (n < 2) {
                    LogViewer.this.goToPage.setEnabled(false);
                    return;
                }
                String[] stringArray = new String[]{"1", "" + n};
                String string = LogUIPlugin.getResourceString("GO_TO_PAGE_DIALOG_TITLE");
                String string2 = LogUIPlugin.getResourceString("GO_TO_PAGE_DIALOG_MESSAGE", stringArray);
                InputDialog inputDialog = new InputDialog(LogViewer.this.getSite().getShell(), string, string2, null, new IInputValidator(this, n){
                    private final /* synthetic */ int val$totalPages;
                    private final /* synthetic */ 8 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$totalPages = n;
                    }

                    public String isValid(String string) {
                        if (string == null || string.length() == 0) {
                            return "";
                        }
                        try {
                            int n = Integer.parseInt(string);
                            if (n < 1 || n > this.val$totalPages) {
                                return LogUIPlugin.getResourceString("GO_TO_PAGE_VNIR");
                            }
                        }
                        catch (Exception exception) {
                            return LogUIPlugin.getResourceString("GO_TO_PAGE_VNAN");
                        }
                        return null;
                    }
                });
                inputDialog.open();
                if (inputDialog.getReturnCode() != 0) {
                    return;
                }
                int n2 = Integer.parseInt(inputDialog.getValue());
                if (iPage != null && iPage instanceof LogPage) {
                    BusyIndicator.showWhile(null, (Runnable)new Runnable(this, logContentProvider, n2, iPage){
                        private final /* synthetic */ LogContentProvider val$logContentProvider;
                        private final /* synthetic */ int val$pageNr;
                        private final /* synthetic */ IPage val$page;
                        private final /* synthetic */ 8 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$logContentProvider = logContentProvider;
                            this.val$pageNr = n;
                            this.val$page = iPage;
                        }

                        public void run() {
                            boolean bl = this.val$logContentProvider.goToPage(this.val$pageNr);
                            if (this.val$pageNr == 1) {
                                LogViewer.access$200(8.access$400(this.this$1)).setEnabled(false);
                            }
                            LogViewer.access$300(8.access$400(this.this$1)).setEnabled(bl);
                            ((LogPage)this.val$page).getView().update();
                        }
                    });
                }
            }

            static /* synthetic */ LogViewer access$400(8 var0) {
                return var0.LogViewer.this;
            }
        };
        this.goToPage.setText(string);
        this.getViewSite().getActionBars().setGlobalActionHandler("navigate/goToPage", (IAction)this.goToPage);
        LogUIPluginImages.setImageDescriptors((IAction)this.goToPage, "lcl16", "gotopage.gif");
        this.goToPage.setDescription(string);
        this.goToPage.setToolTipText(string);
        return this.goToPage;
    }

    private Action createPageDownButton() {
        String string = LogUIPlugin.getResourceBundle().getString("STR_PAGE_DOWN");
        this.pageDown = new Action(string){

            public void run() {
                IPage iPage = LogViewer.this.getCurrentPage();
                if (iPage != null && iPage instanceof LogPage) {
                    BusyIndicator.showWhile(null, (Runnable)new Runnable(this, iPage){
                        private final /* synthetic */ IPage val$page;
                        private final /* synthetic */ 11 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$page = iPage;
                        }

                        public void run() {
                            LogContentProvider logContentProvider = (LogContentProvider)((LogPage)this.val$page).getView().getViewer().getContentProvider();
                            LogViewer.access$600(11.access$500(this.this$1)).setEnabled(logContentProvider.pageDown());
                            ((LogPage)this.val$page).getView().update();
                        }
                    });
                }
            }

            static /* synthetic */ LogViewer access$500(11 var0) {
                return var0.LogViewer.this;
            }
        };
        this.getViewSite().getActionBars().setGlobalActionHandler("next", (IAction)this.pageDown);
        this.pageDown.setText(string);
        LogUIPluginImages.setImageDescriptors((IAction)this.pageDown, "lcl16", "pagedown.gif");
        this.pageDown.setDescription(string);
        this.pageDown.setToolTipText(string);
        return this.pageDown;
    }

    public void setFocus() {
        if (this.getCurrentPage() != null) {
            this.getCurrentPage().setFocus();
        }
    }

    public boolean isValidObject(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof TRCAgent && ((TRCAgent)object).getType().equals("Logging")) {
            return true;
        }
        if (object instanceof TRCProcessProxy) {
            return this.hasProcessLogAgents((TRCProcessProxy)object);
        }
        if (object instanceof TRCNode) {
            return this.hasNodeLogAgents((TRCNode)object);
        }
        if (object instanceof TRCMonitor) {
            return this.hasMonitorLogAgents((TRCMonitor)object);
        }
        return true;
    }

    public EObject getObjectToView(EObject eObject) {
        if (eObject == null) {
            return eObject;
        }
        List list = null;
        if (eObject instanceof TRCMonitor) {
            return eObject;
        }
        if (eObject instanceof TRCNode) {
            return eObject;
        }
        if (eObject instanceof TRCProcessProxy) {
            list = this.getLogAgentInProcess((EObject)((TRCProcessProxy)eObject));
        }
        if (list != null && list.size() == 1) {
            return (EObject)list.get(0);
        }
        return eObject;
    }

    private List getLogObjectInMonitor(EObject eObject) {
        List list;
        EList eList = ((TRCMonitor)eObject).getNodes();
        TRCNode tRCNode = null;
        int n = eList.size();
        int n2 = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n3 = 0;
        while (n3 < n && n2 < 2) {
            tRCNode = (TRCNode)eList.get(n3);
            if (tRCNode != null && (list = this.getLogObjectInNode((EObject)tRCNode)).size() >= 1) {
                ++n2;
                arrayList.add(tRCNode);
            }
            ++n3;
        }
        if (arrayList.size() == 1 && (list = this.getLogObjectInNode((EObject)((TRCNode)arrayList.get(0)))).size() == 1) {
            arrayList.clear();
            arrayList.add(list.get(0));
        }
        return arrayList;
    }

    private List getLogObjectInNode(EObject eObject) {
        List list;
        EList eList = ((TRCNode)eObject).getProcessProxies();
        TRCProcessProxy tRCProcessProxy = null;
        int n = 0;
        int n2 = eList.size();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n3 = 0;
        while (n3 < n2 && n < 2) {
            tRCProcessProxy = (TRCProcessProxy)eList.get(n3);
            if (tRCProcessProxy != null && (list = this.getLogAgentInProcess((EObject)tRCProcessProxy)).size() >= 1) {
                ++n;
                arrayList.add(tRCProcessProxy);
            }
            ++n3;
        }
        if (arrayList.size() == 1 && (list = this.getLogAgentInProcess((EObject)((TRCProcessProxy)arrayList.get(0)))).size() == 1) {
            arrayList.clear();
            arrayList.add(list.get(0));
        }
        return arrayList;
    }

    private List getLogAgentInProcess(EObject eObject) {
        int n = 0;
        EList eList = ((TRCProcessProxy)eObject).getAgentProxies();
        int n2 = eList.size();
        TRCAgentProxy tRCAgentProxy = null;
        ArrayList<TRCAgentProxy> arrayList = new ArrayList<TRCAgentProxy>();
        int n3 = 0;
        while (n3 < n2 && n < 2) {
            tRCAgentProxy = (TRCAgentProxy)eList.get(n3);
            if (tRCAgentProxy != null && !tRCAgentProxy.eIsProxy() && tRCAgentProxy.getType().equals("Logging")) {
                ++n;
                arrayList.add(tRCAgentProxy);
            }
            ++n3;
        }
        return arrayList;
    }

    private boolean hasMonitorLogAgents(TRCMonitor tRCMonitor) {
        EList eList = tRCMonitor.getNodes();
        TRCNode tRCNode = null;
        int n = eList.size();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n && !bl) {
            tRCNode = (TRCNode)eList.get(n2);
            if (tRCNode != null) {
                bl = this.hasNodeLogAgents(tRCNode);
            }
            ++n2;
        }
        return bl;
    }

    private boolean hasNodeLogAgents(TRCNode tRCNode) {
        EList eList = tRCNode.getProcessProxies();
        TRCProcessProxy tRCProcessProxy = null;
        boolean bl = false;
        int n = eList.size();
        int n2 = 0;
        while (n2 < n && !bl) {
            tRCProcessProxy = (TRCProcessProxy)eList.get(n2);
            if (tRCProcessProxy != null) {
                bl = this.hasProcessLogAgents(tRCProcessProxy);
            }
            ++n2;
        }
        return bl;
    }

    private boolean hasProcessLogAgents(TRCProcessProxy tRCProcessProxy) {
        EList eList = tRCProcessProxy.getAgentProxies();
        int n = eList.size();
        TRCAgentProxy tRCAgentProxy = null;
        int n2 = 0;
        while (n2 < n) {
            tRCAgentProxy = (TRCAgentProxy)eList.get(n2);
            if (tRCAgentProxy != null && !tRCAgentProxy.eIsProxy() && tRCAgentProxy.getType().equals("Logging")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getViewTitle() {
        return this._title;
    }

    public void setRecordSelection(EObject eObject, EObject eObject2) {
        if (this.getPage(eObject2) == null) {
            return;
        }
        LogViewerUI logViewerUI = ((LogPage)this.getPage(eObject2)).getView();
        if (logViewerUI != null && logViewerUI.getViewer() != null) {
            LogContentProvider logContentProvider = (LogContentProvider)logViewerUI.getViewer().getContentProvider();
            if (logContentProvider.revealObject(eObject)) {
                logViewerUI.update();
            }
            logViewerUI.getViewer().setSelection((ISelection)new StructuredSelection((Object)eObject), true);
        }
    }

    protected void setViewTitle(Object object) {
        if (object != null && object instanceof TRCAgentProxy) {
            TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)object;
            String string = HyadesUtil.getAgentLabel((TRCAgentProxy)tRCAgentProxy);
            if (tRCAgentProxy.getProcessProxy() != null) {
                this.setTitle(this._title + " - " + tRCAgentProxy.getName() + " " + tRCAgentProxy.getProcessProxy().getName());
            }
            return;
        }
        this.setTitle(this.getViewTitle());
    }

    public Action getPageDownAction() {
        return this.pageDown;
    }

    public Action getPageUpAction() {
        return this.pageUp;
    }

    public Action getGotPageAction() {
        return this.goToPage;
    }

    static /* synthetic */ Action access$200(LogViewer logViewer) {
        return logViewer.pageUp;
    }

    static /* synthetic */ Action access$600(LogViewer logViewer) {
        return logViewer.pageDown;
    }
}

