/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.cbe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.XMLFragmentLoader;

public class XMLCollector
implements XMLFragmentLoader {
    private Element currentElement;
    private Element rootElement;
    private int level;

    public String getTargetFeatureName() {
        return this.rootElement.getName();
    }

    public String getTargetFeatureValue() {
        return this.printContent();
    }

    public void addAttribute(String string, String string2) {
        this.currentElement.addAttribute(string, string2);
    }

    public void addCharacters(char[] cArray, int n, int n2) {
        this.currentElement.addCharacters(cArray, n, n2);
    }

    public void addYourselfInContext() {
    }

    public void cleanUp() {
    }

    public boolean done() {
        return this.level == 0;
    }

    public void endChild(String string) {
        this.currentElement = this.currentElement.getParent();
        --this.level;
    }

    public void initialize(HierarchyContext hierarchyContext, String string) {
        this.currentElement = this.rootElement = new Element(string, null);
        this.level = 0;
    }

    public void startChild(String string) {
        this.addChild(string);
        ++this.level;
    }

    private void addChild(String string) {
        List list = this.currentElement.getChildren();
        this.currentElement = new Element(string, this.currentElement);
        list.add(this.currentElement);
    }

    private void printAttributes(Attributes attributes, StringBuffer stringBuffer) {
        if (attributes == null) {
            return;
        }
        Iterator iterator = attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringBuffer.append(' ');
            stringBuffer.append(entry.getKey());
            stringBuffer.append('=');
            stringBuffer.append('\"');
            stringBuffer.append(entry.getValue());
            stringBuffer.append('\"');
        }
    }

    private String printContent() {
        if (this.rootElement == null || this.rootElement.getChildren() == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.rootElement.getChildren().iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            this.printElement(element, stringBuffer);
        }
        return stringBuffer.toString();
    }

    private void printElement(Element element, StringBuffer stringBuffer) {
        stringBuffer.append('<');
        stringBuffer.append(element.getName());
        this.printAttributes(element.getAttributes(), stringBuffer);
        if (element.getChildren() != null) {
            stringBuffer.append(">\n");
            Iterator iterator = element.getChildren().iterator();
            while (iterator.hasNext()) {
                Element element2 = (Element)iterator.next();
                this.printElement(element2, stringBuffer);
            }
            if (element.getCdata() != null) {
                stringBuffer.append(element.getCdata().toString());
            }
            stringBuffer.append("</");
            stringBuffer.append(element.getName());
            stringBuffer.append(">\n");
        } else if (element.getCdata() != null) {
            stringBuffer.append(element.getCdata().toString());
            stringBuffer.append("</");
            stringBuffer.append(element.getName());
            stringBuffer.append(">\n");
        } else {
            stringBuffer.append("/>\n");
        }
    }

    public class Element
    extends ArrayList {
        private Attributes attributes;
        private Element parent;
        private String name;
        private StringBuffer cdata;

        public Element(String string, Element element) {
            this.name = string;
            this.parent = element;
        }

        public Attributes getAttributes() {
            return this.attributes;
        }

        public StringBuffer getCdata() {
            return this.cdata;
        }

        public List getChildren() {
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Element getParent() {
            return this.parent;
        }

        public void addAttribute(String string, String string2) {
            if (this.attributes == null) {
                this.attributes = new Attributes(this);
            }
            this.attributes.append(string, string2);
        }

        public void addCharacters(char[] cArray, int n, int n2) {
            if (this.cdata == null) {
                this.cdata = new StringBuffer();
            }
            this.cdata.append(cArray, n, n2);
        }
    }

    public class Attributes
    extends HashMap {
        private Element parent;

        public Attributes(Element element) {
            this.parent = element;
        }

        public void append(String string, String string2) {
            String string3 = (String)this.get(string);
            string3 = string3 != null ? string3 + string2 : string2;
            this.put(string, string3);
        }
    }
}

