/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.context.Context;
import org.eclipse.hyades.logging.adapter.model.internal.context.ContextType;
import org.eclipse.hyades.logging.adapter.model.internal.context.RoleNames;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.Extractor;
import org.eclipse.hyades.logging.adapter.model.internal.formatter.FormatterType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.ProcessUnitType;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.context.ContextItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.context.ContextTypeItemProvider;
import org.eclipse.hyades.logging.adapter.ui.internal.util.GridUtil;
import org.eclipse.hyades.logging.adapter.ui.internal.util.IDetails;
import org.eclipse.hyades.logging.adapter.ui.internal.util.ResourceSelectionDialog;
import org.eclipse.hyades.logging.adapter.ui.internal.util.RuleBuilderWidgetFactory;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ContextSection
extends Composite
implements IDetails,
ModifyListener,
SelectionListener,
INotifyChangedListener {
    protected Text descriptionText;
    protected Text execClassText;
    protected Text uniqueIDText;
    protected Text impDateText;
    protected Text impVersionText;
    protected Text impVDescrText;
    protected Text logLevelText;
    protected Text nameText;
    protected CCombo roleCombo;
    protected Text roleDateText;
    protected Text roleVersionText;
    protected Text roleVDescrText;
    protected Button browseRef;
    protected EditingDomain editingDomain;
    protected boolean isDisplaying;
    protected ContextType currentSelection;
    protected ContextTypeItemProvider itemProvider;
    protected ContextItemProviderAdapterFactory itemFactory = new ContextItemProviderAdapterFactory();

    public ContextSection(RuleBuilderWidgetFactory ruleBuilderWidgetFactory, EditingDomain editingDomain, Composite composite, int n) {
        super(composite, n);
        this.editingDomain = editingDomain;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 5;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(GridUtil.createFill());
        Label label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_NAME"), 0);
        this.nameText = ruleBuilderWidgetFactory.createText(this, "", 0);
        this.nameText.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_DESCR"), 0);
        this.descriptionText = ruleBuilderWidgetFactory.createText(this, "", 0);
        this.descriptionText.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, "", 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_EXECC"), 0);
        this.execClassText = ruleBuilderWidgetFactory.createText(this, "", 2);
        this.execClassText.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_IMPLCD"), 0);
        this.impDateText = ruleBuilderWidgetFactory.createText(this, "", 0);
        this.impDateText.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_IMPLV"), 0);
        this.impVersionText = ruleBuilderWidgetFactory.createText(this, "", 0);
        this.impVersionText.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_IMPLVD"), 0);
        this.impVDescrText = ruleBuilderWidgetFactory.createText(this, "", 0);
        this.impVDescrText.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, "", 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_LOGL"), 0);
        this.logLevelText = ruleBuilderWidgetFactory.createText(this, "", 0);
        this.logLevelText.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, "", 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_ROLE"), 0);
        this.roleCombo = ruleBuilderWidgetFactory.createCombo(this, 8);
        this.roleCombo.setLayoutData((Object)new GridData(768));
        this.initializeRoleCombo();
        label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_ROLECD"), 0);
        this.roleDateText = ruleBuilderWidgetFactory.createText(this, "", 0);
        this.roleDateText.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_ROLEV"), 0);
        this.roleVersionText = ruleBuilderWidgetFactory.createText(this, "", 0);
        this.roleVersionText.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_ROLEVD"), 0);
        this.roleVDescrText = ruleBuilderWidgetFactory.createText(this, "", 0);
        this.roleVDescrText.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, "", 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        Composite composite2 = ruleBuilderWidgetFactory.createComposite(this);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 5;
        gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 2;
        composite2.setLayoutData((Object)gridData);
        composite2.setLayout((Layout)gridLayout);
        label = ruleBuilderWidgetFactory.createLabel(composite2, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_ID"), 0);
        this.uniqueIDText = ruleBuilderWidgetFactory.createText(composite2, "", 0);
        this.uniqueIDText.setLayoutData((Object)new GridData(768));
        this.uniqueIDText.setEditable(false);
        this.browseRef = ruleBuilderWidgetFactory.createButton(composite2, AcadEditorPlugin.getPlugin().getString("BROWSE"), 8);
        this.descriptionText.addModifyListener((ModifyListener)this);
        this.nameText.addModifyListener((ModifyListener)this);
        this.execClassText.addModifyListener((ModifyListener)this);
        this.uniqueIDText.addModifyListener((ModifyListener)this);
        this.impDateText.addModifyListener((ModifyListener)this);
        this.impVDescrText.addModifyListener((ModifyListener)this);
        this.impVersionText.addModifyListener((ModifyListener)this);
        this.logLevelText.addModifyListener((ModifyListener)this);
        this.roleDateText.addModifyListener((ModifyListener)this);
        this.roleCombo.addSelectionListener((SelectionListener)this);
        this.roleVDescrText.addModifyListener((ModifyListener)this);
        this.roleVersionText.addModifyListener((ModifyListener)this);
        this.browseRef.addSelectionListener((SelectionListener)this);
        this.itemProvider = (ContextTypeItemProvider)this.itemFactory.createContextTypeAdapter();
        this.itemProvider.addListener(this);
    }

    protected void initializeRoleCombo() {
        this.roleCombo.add("Sensor");
        this.roleCombo.add("Extractor");
        this.roleCombo.add("Parser");
        this.roleCombo.add("Formatter");
        this.roleCombo.add("Message Filter");
        this.roleCombo.add("CBE Filter");
        this.roleCombo.add("Outputter");
        this.roleCombo.add("Context");
        this.roleCombo.add("undeclared");
    }

    public void display(EObject eObject) {
        if (this.currentSelection == eObject) {
            return;
        }
        if (this.descriptionText.isFocusControl() || this.execClassText.isFocusControl() || this.uniqueIDText.isFocusControl() || this.logLevelText.isFocusControl() || this.impDateText.isFocusControl() || this.impVDescrText.isFocusControl() || this.impVersionText.isFocusControl() || this.nameText.isFocusControl() || this.roleDateText.isFocusControl() || this.roleCombo.isFocusControl() || this.roleVDescrText.isFocusControl() || this.roleVersionText.isFocusControl()) {
            return;
        }
        this.currentSelection = (ContextType)eObject;
        this.isDisplaying = true;
        this.descriptionText.setText(this.currentSelection.getDescription() == null ? "" : this.currentSelection.getDescription());
        this.execClassText.setText(this.currentSelection.getExecutableClass() == null ? "" : this.currentSelection.getExecutableClass());
        this.uniqueIDText.setText(this.currentSelection.getUniqueID() == null ? "" : this.currentSelection.getUniqueID());
        this.nameText.setText(this.currentSelection.getName() == null ? "" : this.currentSelection.getName());
        this.logLevelText.setText(this.currentSelection.getLoggingLevel() == null ? "" : this.currentSelection.getLoggingLevel());
        this.impDateText.setText(this.currentSelection.getImplementationCreationDate() == null ? "" : this.currentSelection.getImplementationCreationDate());
        this.impVDescrText.setText(this.currentSelection.getImplementationVersionDescription() == null ? "" : this.currentSelection.getImplementationVersionDescription());
        this.impVersionText.setText(this.currentSelection.getImplementationVersion() == null ? "" : this.currentSelection.getImplementationVersion());
        this.roleDateText.setText(this.currentSelection.getRoleCreationDate() == null ? "" : this.currentSelection.getRoleCreationDate());
        this.roleVDescrText.setText(this.currentSelection.getRoleVersionDescription() == null ? "" : this.currentSelection.getRoleVersionDescription());
        this.roleVersionText.setText(this.currentSelection.getRoleVersion() == null ? "" : this.currentSelection.getRoleVersion());
        this.roleCombo.select(this.currentSelection.getRole().getValue());
        this.isDisplaying = false;
    }

    public boolean updateCurrentSelection(EObject eObject) {
        this.currentSelection = (Context)eObject;
        this.currentSelection.setDescription(this.descriptionText.getText());
        this.currentSelection.setExecutableClass(this.execClassText.getText());
        this.currentSelection.setUniqueID(this.uniqueIDText.getText());
        this.currentSelection.setName(this.nameText.getText());
        this.currentSelection.setLoggingLevel(this.logLevelText.getText());
        this.currentSelection.setImplementationCreationDate(this.impDateText.getText());
        this.currentSelection.setImplementationVersion(this.impVersionText.getText());
        this.currentSelection.setImplementationVersionDescription(this.impVDescrText.getText());
        this.currentSelection.setRoleCreationDate(this.roleDateText.getText());
        this.currentSelection.setRoleVersion(this.roleVersionText.getText());
        this.currentSelection.setRoleVersionDescription(this.roleVDescrText.getText());
        this.currentSelection.setRole(RoleNames.get((int)this.roleCombo.getSelectionIndex()));
        return false;
    }

    public void setFocusToText() {
        this.nameText.setFocus();
        this.nameText.selectAll();
    }

    public void modifyText(ModifyEvent modifyEvent) {
        String string;
        if (this.isDisplaying || this.currentSelection == null) {
            return;
        }
        if (modifyEvent.getSource() == this.descriptionText) {
            String string2 = this.descriptionText.getText();
            if (!string2.equals(this.currentSelection.getDescription())) {
                if (string2.length() == 0 && this.currentSelection.getDescription() == null) {
                    return;
                }
                IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ContextTypeItemProvider.DESCRIPTION);
                if (iItemPropertyDescriptor != null) {
                    iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string2);
                }
            }
        } else if (modifyEvent.getSource() == this.execClassText) {
            String string3 = this.execClassText.getText();
            if (!string3.equals(this.currentSelection.getExecutableClass())) {
                if (string3.length() == 0 && this.currentSelection.getExecutableClass() == null) {
                    return;
                }
                IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ContextTypeItemProvider.EXEC_CLASS);
                if (iItemPropertyDescriptor != null) {
                    iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string3);
                }
            }
        } else if (modifyEvent.getSource() == this.uniqueIDText) {
            String string4 = this.uniqueIDText.getText();
            if (!string4.equals(this.currentSelection.getUniqueID())) {
                if (string4.length() == 0 && this.currentSelection.getUniqueID() == null) {
                    return;
                }
                IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ContextTypeItemProvider.UNIQUE_ID);
                if (iItemPropertyDescriptor != null) {
                    iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string4);
                }
            }
        } else if (modifyEvent.getSource() == this.nameText) {
            String string5 = this.nameText.getText();
            if (!string5.equals(this.currentSelection.getName())) {
                if (string5.length() == 0 && this.currentSelection.getName() == null) {
                    return;
                }
                IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ContextTypeItemProvider.NAME);
                if (iItemPropertyDescriptor != null) {
                    iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string5);
                }
            }
        } else if (modifyEvent.getSource() == this.logLevelText) {
            String string6 = this.logLevelText.getText();
            if (!string6.equals(this.currentSelection.getLoggingLevel())) {
                if (string6.length() == 0 && this.currentSelection.getLoggingLevel() == null) {
                    return;
                }
                IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ContextTypeItemProvider.LOG_LEVEL);
                if (iItemPropertyDescriptor != null) {
                    iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string6);
                }
            }
        } else if (modifyEvent.getSource() == this.impDateText) {
            String string7 = this.impDateText.getText();
            if (!string7.equals(this.currentSelection.getImplementationCreationDate())) {
                if (string7.length() == 0 && this.currentSelection.getImplementationCreationDate() == null) {
                    return;
                }
                IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ContextTypeItemProvider.IMPL_DATE);
                if (iItemPropertyDescriptor != null) {
                    iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string7);
                }
            }
        } else if (modifyEvent.getSource() == this.impVDescrText) {
            String string8 = this.impVDescrText.getText();
            if (!string8.equals(this.currentSelection.getImplementationVersionDescription())) {
                if (string8.length() == 0 && this.currentSelection.getImplementationVersionDescription() == null) {
                    return;
                }
                IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ContextTypeItemProvider.IMPL_DESCR);
                if (iItemPropertyDescriptor != null) {
                    iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string8);
                }
            }
        } else if (modifyEvent.getSource() == this.impVersionText) {
            String string9 = this.impVersionText.getText();
            if (!string9.equals(this.currentSelection.getImplementationVersion())) {
                if (string9.length() == 0 && this.currentSelection.getImplementationVersion() == null) {
                    return;
                }
                IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ContextTypeItemProvider.IMPL_VERSION);
                if (iItemPropertyDescriptor != null) {
                    iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string9);
                }
            }
        } else if (modifyEvent.getSource() == this.roleDateText) {
            String string10 = this.roleDateText.getText();
            if (!string10.equals(this.currentSelection.getRoleCreationDate())) {
                if (string10.length() == 0 && this.currentSelection.getRoleCreationDate() == null) {
                    return;
                }
                IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ContextTypeItemProvider.ROLE_DATE);
                if (iItemPropertyDescriptor != null) {
                    iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string10);
                }
            }
        } else if (modifyEvent.getSource() == this.roleVDescrText) {
            String string11 = this.roleVDescrText.getText();
            if (!string11.equals(this.currentSelection.getRoleVersionDescription())) {
                if (string11.length() == 0 && this.currentSelection.getRoleVersionDescription() == null) {
                    return;
                }
                IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ContextTypeItemProvider.ROLE_DESC);
                if (iItemPropertyDescriptor != null) {
                    iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string11);
                }
            }
        } else if (modifyEvent.getSource() == this.roleVersionText && !(string = this.roleVersionText.getText()).equals(this.currentSelection.getRoleVersion())) {
            if (string.length() == 0 && this.currentSelection.getRoleVersion() == null) {
                return;
            }
            IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ContextTypeItemProvider.ROLE_VERSION);
            if (iItemPropertyDescriptor != null) {
                iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string);
            }
        }
    }

    public void dispose() {
        this.itemFactory = null;
        this.itemProvider = null;
    }

    public void notifyChanged(Notification notification) {
        Object object = notification.getNotifier();
        if (object == null || object != this.currentSelection) {
            return;
        }
        this.display((EObject)this.currentSelection);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.getSource() == this.roleCombo) {
            int n = this.roleCombo.getSelectionIndex();
            if (n != this.currentSelection.getRole().getValue()) {
                IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ContextTypeItemProvider.NAME);
                this.currentSelection.setRole(RoleNames.get((int)n));
                String string = this.currentSelection.getName();
                if (iItemPropertyDescriptor != null) {
                    iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string);
                }
            }
        } else if (selectionEvent.getSource() == this.browseRef) {
            Object object;
            ResourceSelectionDialog resourceSelectionDialog = new ResourceSelectionDialog(Display.getCurrent().getActiveShell(), this.editingDomain);
            resourceSelectionDialog.open();
            if (resourceSelectionDialog.getReturnCode() == 0 && (object = resourceSelectionDialog.getSelection()) != null) {
                if (object instanceof SensorConfigType) {
                    this.uniqueIDText.setText(((SensorConfigType)object).getUniqueID());
                } else if (object instanceof Extractor) {
                    this.uniqueIDText.setText(((Extractor)object).getUniqueID());
                } else if (object instanceof OutputterConfigType) {
                    this.uniqueIDText.setText(((OutputterConfigType)object).getUniqueID());
                } else if (object instanceof ContextInstanceType) {
                    this.uniqueIDText.setText(((ContextInstanceType)object).getUniqueID());
                } else if (object instanceof ProcessUnitType) {
                    this.uniqueIDText.setText(((ProcessUnitType)object).getUniqueID());
                } else if (object instanceof ParserConfigType) {
                    this.uniqueIDText.setText(((ParserConfigType)object).getUniqueID());
                } else if (object instanceof FormatterType) {
                    this.uniqueIDText.setText(((FormatterType)object).getUniqueID());
                } else {
                    this.uniqueIDText.setText("");
                }
            }
        }
    }
}

