/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.LoggingAgentOutputterType;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.outputter.LoggingAgentOutputterTypeItemProvider;
import org.eclipse.hyades.logging.adapter.ui.internal.outputter.OutputterItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.util.GridUtil;
import org.eclipse.hyades.logging.adapter.ui.internal.util.IDetails;
import org.eclipse.hyades.logging.adapter.ui.internal.util.RuleBuilderWidgetFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class LoggingOutputterSection
extends Composite
implements IDetails,
ModifyListener,
INotifyChangedListener {
    protected Text agentName;
    protected Text logTime;
    protected boolean isDisplaying;
    protected LoggingAgentOutputterType currentSelection;
    protected LoggingAgentOutputterTypeItemProvider itemProvider;
    protected OutputterItemProviderAdapterFactory itemFactory = new OutputterItemProviderAdapterFactory();

    public LoggingOutputterSection(RuleBuilderWidgetFactory ruleBuilderWidgetFactory, Composite composite, int n) {
        super(composite, n);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 5;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(GridUtil.createFill());
        Label label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_LOG_AGENT_ANAME"), 0);
        this.agentName = ruleBuilderWidgetFactory.createText(this, "", 2);
        this.agentName.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_LOG_AGENT_WAIT"), 0);
        this.logTime = ruleBuilderWidgetFactory.createText(this, "", 0);
        this.logTime.setLayoutData((Object)new GridData(768));
        this.agentName.addModifyListener((ModifyListener)this);
        this.logTime.addModifyListener((ModifyListener)this);
        this.itemProvider = (LoggingAgentOutputterTypeItemProvider)this.itemFactory.createLoggingAgentOutputterTypeAdapter();
        this.itemProvider.addListener(this);
    }

    public void display(EObject eObject) {
        if (eObject != null) {
            AcadGuiModelManager.setCurrentModel((ContextInstanceType)((LoggingAgentOutputterType)eObject).eContainer().eContainer());
        }
        if (this.currentSelection == eObject) {
            return;
        }
        if (this.agentName.isFocusControl() || this.logTime.isFocusControl()) {
            return;
        }
        this.currentSelection = (LoggingAgentOutputterType)eObject;
        this.isDisplaying = true;
        this.agentName.setText(this.currentSelection.getAgentName() == null ? "" : this.currentSelection.getAgentName());
        this.logTime.setText(this.currentSelection.getWaitUntilLoggingTime() == null ? "" : this.currentSelection.getWaitUntilLoggingTime());
        this.isDisplaying = false;
    }

    public boolean updateCurrentSelection(EObject eObject) {
        this.currentSelection = (LoggingAgentOutputterType)eObject;
        this.currentSelection.setAgentName(this.agentName.getText());
        this.currentSelection.setWaitUntilLoggingTime(this.logTime.getText());
        return false;
    }

    public void setFocusToText() {
        this.agentName.setFocus();
        this.agentName.selectAll();
    }

    public void modifyText(ModifyEvent modifyEvent) {
        String string;
        if (this.isDisplaying || this.currentSelection == null) {
            return;
        }
        if (modifyEvent.getSource() == this.agentName) {
            String string2 = this.agentName.getText();
            if (!string2.equals(this.currentSelection.getAgentName())) {
                if (string2.length() == 0 && this.currentSelection.getAgentName() == null) {
                    return;
                }
                IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, LoggingAgentOutputterTypeItemProvider.AGENT_NAME);
                if (iItemPropertyDescriptor != null) {
                    iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string2);
                }
            }
        } else if (modifyEvent.getSource() == this.logTime && !(string = this.logTime.getText()).equals(this.currentSelection.getWaitUntilLoggingTime())) {
            if (string.length() == 0 && this.currentSelection.getWaitUntilLoggingTime() == null) {
                return;
            }
            IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, LoggingAgentOutputterTypeItemProvider.LOG_TIME);
            if (iItemPropertyDescriptor != null) {
                iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string);
            }
        }
    }

    public void dispose() {
        this.itemFactory = null;
        this.itemProvider = null;
    }

    public void notifyChanged(Notification notification) {
        Object object = notification.getNotifier();
        if (object == null || object != this.currentSelection) {
            return;
        }
        this.display((EObject)this.currentSelection);
    }
}

