/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.ProcessUnitType;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.unit.ProcessUnitTypeItemProvider;
import org.eclipse.hyades.logging.adapter.ui.internal.unit.UnitItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.util.GridUtil;
import org.eclipse.hyades.logging.adapter.ui.internal.util.IDetails;
import org.eclipse.hyades.logging.adapter.ui.internal.util.RuleBuilderWidgetFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ProcessUnitSection
extends Composite
implements IDetails,
ModifyListener,
INotifyChangedListener {
    protected Label uniqueId;
    protected Text descriptionText;
    protected boolean isDisplaying;
    protected ProcessUnitType currentSelection;
    protected ProcessUnitTypeItemProvider itemProvider;
    protected UnitItemProviderAdapterFactory itemFactory = new UnitItemProviderAdapterFactory();

    public ProcessUnitSection(RuleBuilderWidgetFactory ruleBuilderWidgetFactory, Composite composite, int n) {
        super(composite, n);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 5;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(GridUtil.createFill());
        Label label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_PU_DESCR"), 0);
        this.descriptionText = ruleBuilderWidgetFactory.createText(this, "", 0);
        this.descriptionText.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_PU_ID"), 0);
        this.uniqueId = ruleBuilderWidgetFactory.createLabel(this, "", 0);
        this.uniqueId.setLayoutData((Object)new GridData(768));
        this.descriptionText.addModifyListener((ModifyListener)this);
        this.itemProvider = (ProcessUnitTypeItemProvider)this.itemFactory.createProcessUnitTypeAdapter();
        this.itemProvider.addListener(this);
    }

    public void display(EObject eObject) {
        if (eObject != null) {
            AcadGuiModelManager.setCurrentModel((ContextInstanceType)((ProcessUnitType)eObject).eContainer());
        }
        if (this.currentSelection == eObject) {
            return;
        }
        if (this.uniqueId.isFocusControl() || this.descriptionText.isFocusControl()) {
            return;
        }
        this.currentSelection = (ProcessUnitType)eObject;
        this.isDisplaying = true;
        this.uniqueId.setText(this.currentSelection.getUniqueID() == null ? "" : this.currentSelection.getUniqueID());
        this.descriptionText.setText(this.currentSelection.getDescription() == null ? "" : this.currentSelection.getDescription());
        this.isDisplaying = false;
    }

    public boolean updateCurrentSelection(EObject eObject) {
        this.currentSelection = (ProcessUnitType)eObject;
        this.currentSelection.setUniqueID(this.uniqueId.getText());
        this.currentSelection.setDescription(this.descriptionText.getText());
        return false;
    }

    public void setFocusToText() {
        this.descriptionText.setFocus();
        this.descriptionText.selectAll();
    }

    public void modifyText(ModifyEvent modifyEvent) {
        String string;
        if (this.isDisplaying || this.currentSelection == null) {
            return;
        }
        if (modifyEvent.getSource() == this.descriptionText && !(string = this.descriptionText.getText()).equals(this.currentSelection.getDescription())) {
            if (string.length() == 0 && this.currentSelection.getDescription() == null) {
                return;
            }
            IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ProcessUnitTypeItemProvider.DESCRIPTION);
            if (iItemPropertyDescriptor != null) {
                iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string);
            }
        }
    }

    public void dispose() {
        this.itemFactory = null;
        this.itemProvider = null;
    }

    public void notifyChanged(Notification notification) {
        Object object = notification.getNotifier();
        if (object == null || object != this.currentSelection) {
            return;
        }
        this.display((EObject)this.currentSelection);
    }
}

