/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttributeType;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.parser.ParserItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.parser.RuleAttributeTypeItemProvider;
import org.eclipse.hyades.logging.adapter.ui.internal.util.GridUtil;
import org.eclipse.hyades.logging.adapter.ui.internal.util.IDetails;
import org.eclipse.hyades.logging.adapter.ui.internal.util.RuleBuilderWidgetFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RuleAttributeSection
extends Composite
implements IDetails,
SelectionListener,
INotifyChangedListener {
    protected Label nameText;
    protected Label uniqueId;
    protected Button usePreviuos;
    protected Label indexText;
    protected boolean isDisplaying;
    protected RuleAttributeType currentSelection;
    protected RuleAttributeTypeItemProvider itemProvider;
    protected ParserItemProviderAdapterFactory itemFactory = new ParserItemProviderAdapterFactory();

    public RuleAttributeSection(RuleBuilderWidgetFactory ruleBuilderWidgetFactory, Composite composite, int n) {
        super(composite, n);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 5;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(GridUtil.createFill());
        Label label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_ATTR_NAME"), 0);
        this.nameText = ruleBuilderWidgetFactory.createLabel(this, "");
        this.nameText.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_ATTR_ID"), 0);
        this.uniqueId = ruleBuilderWidgetFactory.createLabel(this, "unspecified");
        this.uniqueId.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, "", 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_ATTR_INDEX"), 0);
        this.indexText = ruleBuilderWidgetFactory.createLabel(this, "");
        this.indexText.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, "", 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.usePreviuos = ruleBuilderWidgetFactory.createButton(this, AcadEditorPlugin.getDefault().getString("STR_USE_PREV_ATTR"), 32);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.usePreviuos.setLayoutData((Object)gridData);
        this.itemProvider = (RuleAttributeTypeItemProvider)this.itemFactory.createRuleAttributeAdapter();
        this.itemProvider.addListener(this);
        this.usePreviuos.addSelectionListener((SelectionListener)this);
    }

    public void display(EObject eObject) {
        if (this.currentSelection == eObject) {
            return;
        }
        this.currentSelection = (RuleAttributeType)eObject;
        this.isDisplaying = true;
        this.nameText.setText(this.currentSelection.getName() == null ? "" : this.currentSelection.getName());
        this.uniqueId.setText(this.currentSelection.getId() == null ? "unspecified" : this.currentSelection.getId());
        this.indexText.setText(this.currentSelection.getIndex() == null ? "" : this.currentSelection.getIndex());
        this.usePreviuos.setSelection(this.currentSelection.isUsePreviousMatchSubstitutionAsDefault());
        this.isDisplaying = false;
    }

    public boolean updateCurrentSelection(EObject eObject) {
        this.currentSelection = (RuleAttributeType)eObject;
        this.currentSelection.setUsePreviousMatchSubstitutionAsDefault(this.usePreviuos.getSelection());
        return false;
    }

    public void setFocusToText() {
    }

    public void dispose() {
        this.itemFactory = null;
        this.itemProvider = null;
    }

    public void notifyChanged(Notification notification) {
        Object object = notification.getNotifier();
        if (object == null || object != this.currentSelection) {
            return;
        }
        this.display((EObject)this.currentSelection);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, RuleAttributeTypeItemProvider.NAME);
        this.currentSelection.setUsePreviousMatchSubstitutionAsDefault(this.usePreviuos.getSelection());
        String string = this.currentSelection.getName();
        if (iItemPropertyDescriptor != null) {
            iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string);
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }
}

