/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import java.io.File;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SingleFileSensorType;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.sensor.SensorItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.sensor.SingleFileSensorTypeItemProvider;
import org.eclipse.hyades.logging.adapter.ui.internal.util.GridUtil;
import org.eclipse.hyades.logging.adapter.ui.internal.util.IDetails;
import org.eclipse.hyades.logging.adapter.ui.internal.util.RuleBuilderWidgetFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SingleFileSensorSection
extends Composite
implements IDetails,
ModifyListener,
SelectionListener,
INotifyChangedListener {
    protected Text directoryText;
    protected Button browseDirectory;
    protected Text fileIdText;
    protected Button browseFile;
    protected Text pathConverterText;
    protected Text shellNameText;
    protected boolean isDisplaying;
    protected SingleFileSensorType currentSelection;
    protected SingleFileSensorTypeItemProvider itemProvider;
    protected SensorItemProviderAdapterFactory itemFactory = new SensorItemProviderAdapterFactory();

    public SingleFileSensorSection(RuleBuilderWidgetFactory ruleBuilderWidgetFactory, Composite composite, int n) {
        super(composite, n);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 5;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(GridUtil.createFill());
        Label label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_SINGLE_FILES_DIR"), 0);
        this.directoryText = ruleBuilderWidgetFactory.createText(this, "", 0);
        this.directoryText.setLayoutData((Object)new GridData(768));
        this.browseDirectory = ruleBuilderWidgetFactory.createButton(this, AcadEditorPlugin.getPlugin().getString("BROWSE"), 8);
        label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_SINGLE_FILES_FILE"), 0);
        this.fileIdText = ruleBuilderWidgetFactory.createText(this, "", 0);
        this.fileIdText.setLayoutData((Object)new GridData(768));
        this.browseFile = ruleBuilderWidgetFactory.createButton(this, AcadEditorPlugin.getPlugin().getString("BROWSE2"), 8);
        label = ruleBuilderWidgetFactory.createLabel(this, "", 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        Composite composite2 = ruleBuilderWidgetFactory.createComposite(this);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        composite2.setLayoutData((Object)gridData);
        label = ruleBuilderWidgetFactory.createLabel(composite2, AcadEditorPlugin.getPlugin().getString("STR_SINGLEFS_CONVERTER"), 0);
        this.pathConverterText = ruleBuilderWidgetFactory.createText(composite2, "", 0);
        this.pathConverterText.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(composite2, AcadEditorPlugin.getPlugin().getString("STR_SINGLEFS_SHELL"), 0);
        this.shellNameText = ruleBuilderWidgetFactory.createText(composite2, "", 0);
        this.shellNameText.setLayoutData((Object)new GridData(768));
        this.directoryText.addModifyListener((ModifyListener)this);
        this.fileIdText.addModifyListener((ModifyListener)this);
        this.pathConverterText.addModifyListener((ModifyListener)this);
        this.shellNameText.addModifyListener((ModifyListener)this);
        this.browseDirectory.addSelectionListener((SelectionListener)this);
        this.browseFile.addSelectionListener((SelectionListener)this);
        this.itemProvider = (SingleFileSensorTypeItemProvider)this.itemFactory.createSingleFileSensorTypeAdapter();
        this.itemProvider.addListener(this);
    }

    public void display(EObject eObject) {
        if (eObject != null) {
            AcadGuiModelManager.setCurrentModel((ContextInstanceType)((SingleFileSensorType)eObject).eContainer().eContainer());
        }
        if (this.currentSelection == eObject) {
            return;
        }
        if (this.directoryText.isFocusControl() || this.fileIdText.isFocusControl() || this.pathConverterText.isFocusControl()) {
            return;
        }
        this.currentSelection = (SingleFileSensorType)eObject;
        this.isDisplaying = true;
        this.directoryText.setText(this.currentSelection.getDirectory() == null ? "" : this.currentSelection.getDirectory());
        this.fileIdText.setText(this.currentSelection.getFileName() == null ? "" : this.currentSelection.getFileName());
        this.pathConverterText.setText(this.currentSelection.getConverter() == null ? "" : this.currentSelection.getConverter());
        this.shellNameText.setText(this.currentSelection.getShell() == null ? "" : this.currentSelection.getShell());
        this.isDisplaying = false;
    }

    public boolean updateCurrentSelection(EObject eObject) {
        this.currentSelection = (SingleFileSensorType)eObject;
        this.currentSelection.setDirectory(this.directoryText.getText());
        this.currentSelection.setFileName(this.fileIdText.getText());
        this.currentSelection.setConverter(this.pathConverterText.getText());
        this.currentSelection.setShell(this.shellNameText.getText());
        return false;
    }

    public void setFocusToText() {
        this.directoryText.setFocus();
        this.directoryText.selectAll();
    }

    public void modifyText(ModifyEvent modifyEvent) {
        String string;
        if (this.isDisplaying || this.currentSelection == null) {
            return;
        }
        if (modifyEvent.getSource() == this.directoryText) {
            String string2 = this.directoryText.getText();
            if (!string2.equals(this.currentSelection.getDirectory())) {
                if (string2.length() == 0 && this.currentSelection.getDirectory() == null) {
                    return;
                }
                IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, SingleFileSensorTypeItemProvider.DIRECTORY);
                if (iItemPropertyDescriptor != null) {
                    iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string2);
                }
            }
        } else if (modifyEvent.getSource() == this.fileIdText) {
            String string3 = this.fileIdText.getText();
            if (!string3.equals(this.currentSelection.getFileName())) {
                if (string3.length() == 0 && this.currentSelection.getFileName() == null) {
                    return;
                }
                IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, SingleFileSensorTypeItemProvider.FILE_NAME);
                if (iItemPropertyDescriptor != null) {
                    iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string3);
                }
            }
        } else if (modifyEvent.getSource() == this.pathConverterText) {
            String string4 = this.pathConverterText.getText();
            if (!string4.equals(this.currentSelection.getConverter())) {
                if (string4.length() == 0 && this.currentSelection.getConverter() == null) {
                    return;
                }
                IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, SingleFileSensorTypeItemProvider.CONVERTER);
                if (iItemPropertyDescriptor != null) {
                    iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string4);
                }
            }
        } else if (modifyEvent.getSource() == this.shellNameText && !(string = this.shellNameText.getText()).equals(this.currentSelection.getShell())) {
            if (string.length() == 0 && this.currentSelection.getShell() == null) {
                return;
            }
            IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, SingleFileSensorTypeItemProvider.SHELL);
            if (iItemPropertyDescriptor != null) {
                iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string);
            }
        }
    }

    public void dispose() {
        this.itemFactory = null;
        this.itemProvider = null;
    }

    public void notifyChanged(Notification notification) {
        Object object = notification.getNotifier();
        if (object == null || object != this.currentSelection) {
            return;
        }
        this.display((EObject)this.currentSelection);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.getSource() == this.browseDirectory) {
            String string;
            DirectoryDialog directoryDialog = new DirectoryDialog(Display.getCurrent().getActiveShell());
            directoryDialog.setMessage("Select a directory");
            String string2 = this.directoryText.getText();
            if (string2.length() > 0) {
                directoryDialog.setFilterPath(string2);
            }
            if ((string = directoryDialog.open()) != null) {
                this.directoryText.setText(string);
            }
        } else if (selectionEvent.getSource() == this.browseFile) {
            File file;
            String string;
            FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell());
            String string3 = this.directoryText.getText();
            if (string3.length() > 0 && new File(string3).exists()) {
                fileDialog.setFileName(string3.concat(File.separator).concat("*"));
            }
            if ((string = fileDialog.open()) != null && (file = new File(string)).exists()) {
                this.directoryText.setText(file.getParent());
                this.fileIdText.setText(file.getName());
            }
        }
    }
}

