/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import java.io.File;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.StaticParserSensorType;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.sensor.SensorItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.sensor.StaticParserSensorTypeItemProvider;
import org.eclipse.hyades.logging.adapter.ui.internal.util.GridUtil;
import org.eclipse.hyades.logging.adapter.ui.internal.util.IDetails;
import org.eclipse.hyades.logging.adapter.ui.internal.util.RuleBuilderWidgetFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class StaticParserSection
extends Composite
implements IDetails,
ModifyListener,
SelectionListener,
INotifyChangedListener {
    protected Text directoryText;
    protected Button browseDirectory;
    protected Text fileIdText;
    protected Button browseFile;
    protected Text classNameText;
    protected boolean isDisplaying;
    protected StaticParserSensorType currentSelection;
    protected StaticParserSensorTypeItemProvider itemProvider;
    protected SensorItemProviderAdapterFactory itemFactory = new SensorItemProviderAdapterFactory();

    public StaticParserSection(RuleBuilderWidgetFactory ruleBuilderWidgetFactory, Composite composite, int n) {
        super(composite, n);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 5;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(GridUtil.createFill());
        Label label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_STATICPS_DIR"), 0);
        this.directoryText = ruleBuilderWidgetFactory.createText(this, "", 0);
        this.directoryText.setLayoutData((Object)new GridData(768));
        this.browseDirectory = ruleBuilderWidgetFactory.createButton(this, AcadEditorPlugin.getPlugin().getString("BROWSE"), 8);
        label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_STATICPS_FILE"), 0);
        this.fileIdText = ruleBuilderWidgetFactory.createText(this, "", 0);
        this.fileIdText.setLayoutData((Object)new GridData(768));
        this.browseFile = ruleBuilderWidgetFactory.createButton(this, AcadEditorPlugin.getPlugin().getString("BROWSE2"), 8);
        label = ruleBuilderWidgetFactory.createLabel(this, "", 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        Composite composite2 = ruleBuilderWidgetFactory.createComposite(this);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        composite2.setLayoutData((Object)gridData);
        label = ruleBuilderWidgetFactory.createLabel(composite2, "", 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label = ruleBuilderWidgetFactory.createLabel(composite2, AcadEditorPlugin.getPlugin().getString("STR_STATICPS_PARSER"), 0);
        this.classNameText = ruleBuilderWidgetFactory.createText(composite2, "", 0);
        this.classNameText.setLayoutData((Object)new GridData(768));
        this.directoryText.addModifyListener((ModifyListener)this);
        this.classNameText.addModifyListener((ModifyListener)this);
        this.fileIdText.addModifyListener((ModifyListener)this);
        this.browseDirectory.addSelectionListener((SelectionListener)this);
        this.browseFile.addSelectionListener((SelectionListener)this);
        this.itemProvider = (StaticParserSensorTypeItemProvider)this.itemFactory.createStaticParserSensorTypeAdapter();
        this.itemProvider.addListener(this);
    }

    public void display(EObject eObject) {
        if (eObject != null) {
            AcadGuiModelManager.setCurrentModel((ContextInstanceType)((StaticParserSensorType)eObject).eContainer().eContainer());
        }
        if (this.currentSelection == eObject) {
            return;
        }
        if (this.directoryText.isFocusControl() || this.fileIdText.isFocusControl() || this.classNameText.isFocusControl()) {
            return;
        }
        this.currentSelection = (StaticParserSensorType)eObject;
        this.isDisplaying = true;
        this.directoryText.setText(this.currentSelection.getDirectory() == null ? "" : this.currentSelection.getDirectory());
        this.fileIdText.setText(this.currentSelection.getFileName() == null ? "" : this.currentSelection.getFileName());
        this.classNameText.setText(this.currentSelection.getParserClassName() == null ? "" : this.currentSelection.getParserClassName());
        this.isDisplaying = false;
    }

    public boolean updateCurrentSelection(EObject eObject) {
        this.currentSelection = (StaticParserSensorType)eObject;
        this.currentSelection.setDirectory(this.directoryText.getText());
        this.currentSelection.setFileName(this.fileIdText.getText());
        this.currentSelection.setParserClassName(this.classNameText.getText());
        return false;
    }

    public void setFocusToText() {
        this.directoryText.setFocus();
        this.directoryText.selectAll();
    }

    public void modifyText(ModifyEvent modifyEvent) {
        IItemPropertyDescriptor iItemPropertyDescriptor;
        String string;
        if (this.isDisplaying || this.currentSelection == null) {
            return;
        }
        if (modifyEvent.getSource() == this.directoryText) {
            string = this.directoryText.getText();
            if (!string.equals(this.currentSelection.getDirectory())) {
                if (string.length() == 0 && this.currentSelection.getDirectory() == null) {
                    return;
                }
                iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, StaticParserSensorTypeItemProvider.DIRECTORY);
                if (iItemPropertyDescriptor != null) {
                    iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string);
                }
            }
        } else if (modifyEvent.getSource() == this.fileIdText && !(string = this.fileIdText.getText()).equals(this.currentSelection.getFileName())) {
            if (string.length() == 0 && this.currentSelection.getFileName() == null) {
                return;
            }
            iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, StaticParserSensorTypeItemProvider.FILE_NAME);
            if (iItemPropertyDescriptor != null) {
                iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string);
            }
        }
        if (modifyEvent.getSource() == this.classNameText && !(string = this.classNameText.getText()).equals(this.currentSelection.getParserClassName())) {
            if (string.length() == 0 && this.currentSelection.getParserClassName() == null) {
                return;
            }
            iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, StaticParserSensorTypeItemProvider.CLASS_NAME);
            if (iItemPropertyDescriptor != null) {
                iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string);
            }
        }
    }

    public void dispose() {
        this.itemFactory = null;
        this.itemProvider = null;
    }

    public void notifyChanged(Notification notification) {
        Object object = notification.getNotifier();
        if (object == null || object != this.currentSelection) {
            return;
        }
        this.display((EObject)this.currentSelection);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.getSource() == this.browseDirectory) {
            String string;
            DirectoryDialog directoryDialog = new DirectoryDialog(Display.getCurrent().getActiveShell());
            directoryDialog.setMessage("Select a directory");
            String string2 = this.directoryText.getText();
            if (string2.length() > 0) {
                directoryDialog.setFilterPath(string2);
            }
            if ((string = directoryDialog.open()) != null) {
                this.directoryText.setText(string);
            }
        } else if (selectionEvent.getSource() == this.browseFile) {
            File file;
            String string;
            FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell());
            String string3 = this.directoryText.getText();
            if (string3.length() > 0 && new File(string3).exists()) {
                fileDialog.setFileName(string3.concat(File.separator).concat("*"));
            }
            if ((string = fileDialog.open()) != null && (file = new File(string)).exists()) {
                this.directoryText.setText(file.getParent());
                this.fileIdText.setText(file.getName());
            }
        }
    }
}

