/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.ui.internal.model;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.hyades.sd.ui.SDPluginImages;
import org.eclipse.hyades.sd.ui.internal.model.ColumnNode;
import org.eclipse.hyades.sd.ui.internal.model.ColumnPassage;
import org.eclipse.hyades.sd.ui.internal.model.GraphNode;
import org.eclipse.hyades.sd.ui.internal.model.NodeConnection;
import org.eclipse.hyades.sd.ui.internal.model.NodeContainer;
import org.eclipse.hyades.sd.ui.internal.model.NodeLink;
import org.eclipse.hyades.sd.ui.internal.util.LogCDrawUtils;
import org.eclipse.hyades.sd.ui.internal.views.SDViewerUI;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ColumnFigure
extends ColumnNode
implements NodeContainer,
PaintListener,
MouseMoveListener,
MouseListener,
MouseTrackListener,
Listener {
    private int width;
    private int tempWidth;
    private int height;
    private int number;
    private Rectangle parentBounds;
    private Point originalLocation;
    private SDViewerUI sdViewerUI;
    private Image headerImage = null;
    private boolean firstTime = true;
    private boolean selected = false;
    private Canvas canvas = null;
    private Composite parentComposite;
    private boolean collapsed = false;
    public GraphNode lastReadNode = null;
    public GraphNode[] internalNodes = new GraphNode[3];
    public int nextNewInternalNode = 0;

    public int init(Composite composite, String string, int n, int n2, Canvas canvas) {
        this.parentComposite = composite;
        this.sdViewerUI = (SDViewerUI)composite.getParent();
        String string2 = System.getProperty("os.name");
        int n3 = (string2 = string2.toLowerCase()).indexOf("linux");
        this.width = n3 < 0 ? Math.max(LogCDrawUtils.getMinColumnWidthExpanded(), (int)((double)string.length() * 5.3)) : Math.max(LogCDrawUtils.getMinColumnWidthExpanded(), (int)((double)string.length() * 6.6));
        this.setXOffset(n);
        this.number = n2;
        this.canvas = canvas;
        this.originalLocation = new Point(n, 0);
        this.parentBounds = this.sdViewerUI.getParent().getClientArea();
        LogCDrawUtils.setBottomMax(this.parentBounds.height / LogCDrawUtils.getTimeUnit());
        this.height = this.parentBounds.height;
        this.setHeaderImage();
        this.addListeners();
        return this.width;
    }

    private void setHeaderImage() {
        switch (this.getType()) {
            case 0: {
                break;
            }
            case 9: {
                this.headerImage = SDPluginImages.getImage("monitor_obj.gif");
                break;
            }
            case 1: {
                this.headerImage = SDPluginImages.getImage("monitor_obj.gif");
                break;
            }
            case 2: {
                this.headerImage = SDPluginImages.getImage("node_obj.gif");
                break;
            }
            case 4: {
                this.headerImage = SDPluginImages.getImage("process_obj.gif");
                break;
            }
            case 3: {
                this.headerImage = SDPluginImages.getImage("agent_run_obj.gif");
                break;
            }
            case 5: {
                this.headerImage = SDPluginImages.getImage("thread_obj.gif");
                break;
            }
            case 6: {
                this.headerImage = SDPluginImages.getImage("classobject_obj.gif");
                break;
            }
            case 7: {
                this.headerImage = SDPluginImages.getImage("class.gif");
                break;
            }
            case 8: {
                this.headerImage = SDPluginImages.getImage("method.gif");
                break;
            }
            case 11: {
                this.headerImage = SDPluginImages.getImage("log_obj.gif");
                break;
            }
        }
    }

    private void addListeners() {
        this.canvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                ColumnFigure.this.widgetDisposed(disposeEvent);
            }
        });
        this.canvas.addPaintListener((PaintListener)this);
        this.canvas.addMouseTrackListener((MouseTrackListener)this);
    }

    public void paintControl(PaintEvent paintEvent) {
        int n;
        Object object;
        Rectangle rectangle = this.canvas.getClientArea();
        if (this.originalLocation.x + this.width <= rectangle.x || this.originalLocation.x >= rectangle.x + rectangle.width) {
            return;
        }
        int n2 = LogCDrawUtils.getNodeWidth();
        int n3 = LogCDrawUtils.getBoxSpace();
        int n4 = LogCDrawUtils.getBoxHeight();
        int n5 = LogCDrawUtils.getSideSpace();
        int n6 = LogCDrawUtils.getUpperSpace();
        int n7 = LogCDrawUtils.getStartPosition();
        int n8 = LogCDrawUtils.getTimeUnit();
        int n9 = LogCDrawUtils.getBottomMax();
        int n10 = this.sdViewerUI.getSize().y;
        GC gC = paintEvent.gc;
        int n11 = 0;
        if (this.selected) {
            gC.setForeground(LogCDrawUtils.getForegroundSelectedColor());
        } else {
            gC.setForeground(LogCDrawUtils.getForegroundColor());
        }
        if (n6 + n4 - n7 > 0) {
            gC.drawRectangle(this.getXOffset() + n5, n6, this.width - 2 * n5, n4);
            n11 = this.getType() == 2 ? n5 + (this.width - this.getShortName().length() * gC.getCharWidth('M')) / 2 : 2 * n5;
            if (this.headerImage != null) {
                gC.drawImage(this.headerImage, this.getXOffset() + n5 + 1, n6 + 1);
                gC.drawString(this.getShortName(), this.getXOffset() + n11, n6 + n4 / 2);
            } else {
                gC.drawString(this.getShortName(), this.getXOffset() + n11, n6 + n4 / 4);
            }
            if (this.secondaryName != null) {
                gC.drawString(this.secondaryName, this.getXOffset() + 2 * n5 + 16, n6 + 1);
            }
        }
        gC.setLineStyle(3);
        gC.drawLine(this.getXOffset() + this.width / 2, n6 + n4, this.getXOffset() + this.width / 2, this.height);
        gC.setLineStyle(1);
        if (this.selected) {
            gC.setForeground(LogCDrawUtils.getForegroundColor());
        }
        int n12 = n9 * n8;
        int n13 = 0;
        while (n13 < this.getInternalNodeCount()) {
            ColumnNode columnNode = (ColumnNode)this.internalNodes[n13];
            int n14 = (columnNode.getStartPosition() - n7) * n8 + n6 + n4;
            int n15 = (columnNode.getStopPosition() - n7) * n8 + n6 + n4;
            if (!(n14 < 0 && n15 < 0 || n14 > n10 && n15 > n10)) {
                columnNode.drawSelf(gC, this.width, n8, n3, n7, n10, n2, this.getXOffset(), this.sdViewerUI.getColumnPassagesMap());
            }
            if (this.graph.getType() == 21 || this.graph.getType() == 22) {
                NodeConnection[] nodeConnectionArray = columnNode.getTargetConnections();
                int n16 = 0;
                while (n16 < nodeConnectionArray.length) {
                    if (nodeConnectionArray[n16] != null && ((NodeLink)(object = (NodeLink)nodeConnectionArray[n16])).getSource().getStartIncrementValue() != ((NodeLink)object).getTarget().getStartIncrementValue() && ((NodeLink)object).getTarget().getContainer().getIndexInContainer() == this.getIndexInContainer()) {
                        ((NodeLink)object).drawSelf(gC, this.width, this, n8, n3, n7, n2, this.getXOffset(), this.sdViewerUI.getColumnPassagesMap());
                    }
                    ++n16;
                }
            }
            ++n13;
        }
        int n17 = 0;
        Iterator iterator = this.sdViewerUI.getColumnPassages();
        while (iterator.hasNext()) {
            object = (ColumnPassage)iterator.next();
            if (!((ColumnPassage)object).isOver(this.indexInContainer) || (n17 = (((ColumnPassage)object).getPassagePosition() - n7) * n8 + n6 + n4) < 0 || n17 > n10) continue;
            ((ColumnPassage)object).drawSelf(gC, this.width, n8, n3, n7, this.getXOffset());
        }
        int n18 = LogCDrawUtils.getSelectedWeightIndex();
        if (n18 != -1 && this.getColumnNodeAtPosition(n = n3 + n8 * (n18 - n7)) != null) {
            this.drawSelectedWeight(gC, n8, n);
        }
        if (this.firstTime) {
            this.canvas.addMouseMoveListener((MouseMoveListener)this);
            this.canvas.addMouseListener((MouseListener)this);
            this.firstTime = false;
        }
        Color color = paintEvent.gc.getBackground();
        paintEvent.gc.setForeground(Display.getDefault().getSystemColor(21));
        paintEvent.gc.setBackground(Display.getDefault().getSystemColor(22));
        paintEvent.gc.drawString(this.getShortName(), this.originalLocation.x, 0, false);
        paintEvent.gc.setBackground(color);
    }

    private void drawSelectedWeight(GC gC, int n, int n2) {
        Color color = gC.getBackground();
        int n3 = LogCDrawUtils.getNodeWidth();
        gC.setBackground(LogCDrawUtils.getSelectedWeightColor());
        gC.fillRectangle(this.getXOffset() + this.width / 2 - n3 / 2 + 1, n2 + 1, n3 - 1, n - 1);
        gC.setBackground(color);
    }

    public int drawSelf(GC gC, Point point, boolean bl, int n, int n2) {
        int n3 = this.width / n2;
        int n4 = this.originalLocation.x / n2;
        n4 += n3 / 2;
        if (bl) {
            gC.setLineStyle(3);
            gC.drawLine(n4, 0, n4, point.y + n);
            gC.setLineStyle(1);
        }
        return n4;
    }

    public void setName(String string) {
        super.setName(string);
    }

    public String getFullName() {
        return this.getName();
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getHeight() {
        return this.height;
    }

    public int getNumber() {
        return this.number;
    }

    public int getNodesNumber() {
        return this.getInternalNodeCount();
    }

    public ColumnNode getNode(int n) {
        return (ColumnNode)this.internalNodes[n];
    }

    void widgetDisposed(DisposeEvent disposeEvent) {
        this.disposeMe();
    }

    public void disposeMe() {
        if (this.canvas != null) {
            this.canvas.removeMouseListener((MouseListener)this);
            this.canvas.removePaintListener((PaintListener)this);
            this.canvas.removeMouseTrackListener((MouseTrackListener)this);
            this.canvas.removeMouseMoveListener((MouseMoveListener)this);
        }
    }

    public void mouseMove(MouseEvent mouseEvent) {
        if (mouseEvent.x < this.getXOffset() || mouseEvent.x > this.getXOffset() + this.width) {
            return;
        }
        this.sdViewerUI.setToolTip(mouseEvent.x, mouseEvent.y, this);
    }

    public void mouseEnter(MouseEvent mouseEvent) {
    }

    public void mouseExit(MouseEvent mouseEvent) {
        this.sdViewerUI.removeToolTip();
    }

    public void mouseHover(MouseEvent mouseEvent) {
        this.canvas.forceFocus();
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        this.sdViewerUI.fillContextMenu(iMenuManager);
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
    }

    public void mouseDown(MouseEvent mouseEvent) {
        if (mouseEvent.x < this.getXOffset() || mouseEvent.x > this.getXOffset() + this.width) {
            return;
        }
        Rectangle rectangle = this.canvas.getClientArea();
        if (this.originalLocation.x + this.width <= rectangle.x || this.originalLocation.x >= rectangle.x + rectangle.width) {
            return;
        }
        this.sdViewerUI.getGraphComposite().forceFocus();
        this.sdViewerUI.setIdEvent(mouseEvent);
        if (LogCDrawUtils.getBoxSpace() != 0 && mouseEvent.y <= LogCDrawUtils.getBoxSpace()) {
            this.sdViewerUI.setSelectedColumnFigure(this);
            return;
        }
        ColumnPassage columnPassage = this.getColumnPassageAtPosition(mouseEvent.y);
        if (columnPassage != null) {
            this.sdViewerUI.setSelectedNodeLink(this, (NodeLink)columnPassage.getNodeConnection());
            return;
        }
        ArrayList arrayList = this.getColumnNodesAtPosition(mouseEvent.y);
        int n = LogCDrawUtils.getNodeWidth();
        if (arrayList != null && arrayList.size() > 0) {
            int n2 = 0;
            while (n2 < arrayList.size()) {
                ColumnNode columnNode = (ColumnNode)arrayList.get(n2);
                if (columnNode != null) {
                    if (mouseEvent.x >= this.getXOffset() + (this.width - n) / 2 && mouseEvent.x <= this.getXOffset() + (this.width + n) / 2) {
                        this.sdViewerUI.setSelectedNode(columnNode, this);
                        return;
                    }
                    NodeLink nodeLink = this.getNodeLinkAtPosition(columnNode, mouseEvent.x, mouseEvent.y);
                    if (nodeLink != null) {
                        this.sdViewerUI.setSelectedNodeLink(this, nodeLink);
                        return;
                    }
                }
                ++n2;
            }
        }
        if (mouseEvent.x >= this.getXOffset() + this.width / 2 - 1 && mouseEvent.x <= this.getXOffset() + this.width / 2 + 1) {
            this.sdViewerUI.setSelectedColumnFigure(this);
            return;
        }
        this.sdViewerUI.setSelectedColumnFigure(null);
    }

    public void mouseUp(MouseEvent mouseEvent) {
    }

    public void handleEvent(Event event) {
        if (this.collapsed) {
            this.width = this.tempWidth;
            this.tempWidth = LogCDrawUtils.getMinColumnWidth();
        } else if (!this.collapsed) {
            this.tempWidth = this.width;
            this.width = LogCDrawUtils.getMinColumnWidth();
        }
        this.collapsed = !this.collapsed;
        this.sdViewerUI.adjustColumns(this.width - this.tempWidth, this.number);
    }

    public ArrayList getColumnNodesAtPosition(int n) {
        ArrayList<ColumnNode> arrayList = new ArrayList<ColumnNode>();
        int n2 = (n - LogCDrawUtils.getBoxSpace()) / LogCDrawUtils.getTimeUnit() + LogCDrawUtils.getStartPosition();
        int n3 = this.getInternalNodeCount() - 1;
        while (n3 >= 0) {
            ColumnNode columnNode = (ColumnNode)this.internalNodes[n3];
            if (n2 >= columnNode.getStartPosition() && n2 <= columnNode.getStopPosition()) {
                arrayList.add(columnNode);
            }
            --n3;
        }
        return arrayList;
    }

    public ColumnNode getColumnNodeAtPosition(int n) {
        int n2 = (n - LogCDrawUtils.getBoxSpace()) / LogCDrawUtils.getTimeUnit() + LogCDrawUtils.getStartPosition();
        int n3 = this.getInternalNodeCount() - 1;
        while (n3 >= 0) {
            ColumnNode columnNode = (ColumnNode)this.internalNodes[n3];
            if (n2 >= columnNode.getStartPosition() && n2 <= columnNode.getStopPosition()) {
                return columnNode;
            }
            --n3;
        }
        return null;
    }

    public NodeLink getNodeLinkAtPosition(ColumnNode columnNode, int n, int n2) {
        NodeLink nodeLink;
        int n3;
        if (n < this.getXOffset() || n > this.getXOffset() + this.width) {
            return null;
        }
        int n4 = LogCDrawUtils.getTimeUnit();
        int n5 = 0;
        while (n5 < columnNode.getSourceConnections().length) {
            if (columnNode.getSourceConnections()[n5] != null && n2 >= (n3 = (nodeLink = (NodeLink)columnNode.getSourceConnections()[n5]).isLogRecordConection() && (nodeLink.getTarget().getStartIncrement().getValue() <= nodeLink.getSource().getStartIncrement().getValue() || nodeLink.getTarget().getStartIncrement().getValue() >= nodeLink.getSource().getEndIncrement().getValue()) ? LogCDrawUtils.getBoxSpace() + n4 * (nodeLink.getSource().getStartIncrementValue() - LogCDrawUtils.getStartPosition()) : LogCDrawUtils.getBoxSpace() + n4 * (nodeLink.getStartIncrementValue() - LogCDrawUtils.getStartPosition())) - 1 && n2 <= n3 + 1 && (n > this.getXOffset() + this.width / 2 && nodeLink.getTarget().getContainer().getIndexInContainer() >= columnNode.getContainer().getIndexInContainer() && nodeLink.getSource().getContainer().getIndexInContainer() >= columnNode.getContainer().getIndexInContainer() || n < this.getXOffset() + this.width / 2 && nodeLink.getTarget().getContainer().getIndexInContainer() < columnNode.getContainer().getIndexInContainer() && nodeLink.getSource().getContainer().getIndexInContainer() <= columnNode.getContainer().getIndexInContainer())) {
                return nodeLink;
            }
            ++n5;
        }
        int n6 = 0;
        while (n6 < columnNode.getTargetConnections().length) {
            if (columnNode.getTargetConnections()[n6] != null) {
                nodeLink = (NodeLink)columnNode.getTargetConnections()[n6];
                n3 = LogCDrawUtils.getBoxSpace() + n4 * (nodeLink.getStartIncrementValue() - LogCDrawUtils.getStartPosition());
                if (n2 >= n3 - 1 && n2 <= n3 + 1 && (n > this.getXOffset() + this.width / 2 && nodeLink.getTarget().getContainer().getIndexInContainer() >= columnNode.getContainer().getIndexInContainer() && nodeLink.getSource().getContainer().getIndexInContainer() >= columnNode.getContainer().getIndexInContainer() || n < this.getXOffset() + this.width / 2 && nodeLink.getTarget().getContainer().getIndexInContainer() <= columnNode.getContainer().getIndexInContainer() && nodeLink.getSource().getContainer().getIndexInContainer() < columnNode.getContainer().getIndexInContainer())) {
                    return nodeLink;
                }
            }
            ++n6;
        }
        return null;
    }

    public ColumnPassage getColumnPassageAtPosition(int n) {
        int n2 = LogCDrawUtils.getTimeUnit();
        Iterator iterator = this.sdViewerUI.getColumnPassages();
        while (iterator.hasNext()) {
            ColumnPassage columnPassage = (ColumnPassage)iterator.next();
            int n3 = LogCDrawUtils.getBoxSpace() + n2 * (columnPassage.getPassagePosition() - LogCDrawUtils.getStartPosition());
            if (!columnPassage.isOver(this.indexInContainer) || n < n3 - 1 || n > n3 + 1) continue;
            return columnPassage;
        }
        return null;
    }

    public void adjustLocation(int n) {
        this.originalLocation.x += n;
    }

    public void setOriginalLocation(int n, int n2) {
        this.originalLocation.x = n;
        this.originalLocation.y = n2;
        this.setXOffset(n);
    }

    public Point getOriginalLocation() {
        return this.originalLocation;
    }

    public NodeContainer getNodeContainer() {
        return this;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public Canvas getMyCanvas() {
        return this.canvas;
    }

    public GraphNode[] getInternalNodes() {
        return this.internalNodes;
    }

    public void setInternalNodes(GraphNode[] graphNodeArray) {
        this.internalNodes = graphNodeArray;
    }

    public void addInternalNode(GraphNode graphNode) {
        try {
            this.internalNodes[this.nextNewInternalNode] = graphNode;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            GraphNode[] graphNodeArray = new GraphNode[2 * this.internalNodes.length];
            System.arraycopy(this.internalNodes, 0, graphNodeArray, 0, this.internalNodes.length);
            this.internalNodes = graphNodeArray;
            this.internalNodes[this.nextNewInternalNode] = graphNode;
        }
        graphNode.setIndexInContainer(this.nextNewInternalNode);
        ++this.nextNewInternalNode;
    }

    public int getInternalNodeCount() {
        return this.nextNewInternalNode;
    }
}

