/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.ui.internal.util;

import java.util.Vector;
import org.eclipse.hyades.sd.ui.SDPlugin;
import org.eclipse.hyades.sd.ui.internal.model.GraphNode;
import org.eclipse.hyades.sd.ui.internal.util.DrawAreaFindDialog;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredList;

public class SearchTab
implements PaintListener {
    private GraphNode[] containers;
    private int containerCount;
    private int type;
    private GraphNode selectedNode = null;
    private DrawAreaFindDialog dialog = null;
    private Text fPatternText = null;
    private FilteredList list = null;
    private boolean initialSelection = true;

    public SearchTab(GraphNode[] graphNodeArray, int n, int n2, DrawAreaFindDialog drawAreaFindDialog) {
        this.containers = graphNodeArray;
        this.containerCount = n;
        this.type = n2;
        this.dialog = drawAreaFindDialog;
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.addPaintListener((PaintListener)this);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 5;
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(SDPlugin.getString("STR_NAME"));
        this.fPatternText = new Text(composite2, 2048);
        this.fPatternText.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.list = new FilteredList(composite2, 2048, (ILabelProvider)new ElementsLabelProvider(), true, true, true);
        this.list.setLayoutData((Object)GridUtil.createFill());
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!SearchTab.this.initialSelection) {
                    SearchTab.this.updateSelectedNode();
                }
                SearchTab.this.initialSelection = false;
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                SearchTab.this.dialog.okPressed();
            }
        });
        this.fPatternText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                SearchTab.this.list.setFilter(((Text)modifyEvent.widget).getText());
                SearchTab.this.updateSelectedNode();
            }
        });
        this.loadList();
        return composite2;
    }

    private void updateSelectedNode() {
        Object[] objectArray = this.list.getSelection();
        this.dialog.setSelectedNode(objectArray == null || objectArray.length == 0 ? null : (GraphNode)objectArray[0]);
    }

    public void loadList() {
        Vector<GraphNode> vector = new Vector<GraphNode>();
        int n = 0;
        while (n < this.containerCount) {
            if (this.containers[n] != null && this.containers[n].getType() == this.type) {
                vector.add(this.containers[n]);
            }
            ++n;
        }
        this.list.setElements(vector.toArray());
    }

    public void paintControl(PaintEvent paintEvent) {
        this.updateSelectedNode();
        this.fPatternText.setFocus();
    }

    class ElementsLabelProvider
    extends LabelProvider {
        ElementsLabelProvider() {
        }

        public String getText(Object object) {
            String string = "";
            string = SearchTab.this.type == 6 ? ((GraphNode)object).getName() + ":" + ((GraphNode)object).getSecondaryName() : (SearchTab.this.type == 11 ? ((GraphNode)object).getName() + ":" + ((GraphNode)object).getShortName() : ((GraphNode)object).getName());
            return object == null ? "" : string;
        }
    }
}

