/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.extension;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.internal.extension.AssociationMapping;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class AssociationDescriptor
implements IAssociationDescriptor,
Serializable {
    private AssociationMapping associationMapping;
    private String id;
    private String name;
    private String extension;
    private String description;
    private Class extensionClass;
    private String imageKey;
    private Set types;
    private boolean isPluginDefault = false;
    private IConfigurationElement configurationElement;

    public AssociationDescriptor(AssociationMapping associationMapping) {
        this.associationMapping = associationMapping;
    }

    public void dispose() {
        if (this.types != null) {
            this.types.clear();
        }
        this.configurationElement = null;
        this.extensionClass = null;
    }

    protected ImageRegistry getImageRegistry() {
        return this.associationMapping.getImageRegistry();
    }

    public IAssociationMapping getAssociationMapping() {
        return this.associationMapping;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setImageDescriptor(ImageDescriptor imageDescriptor) {
        String string = imageDescriptor.toString();
        if (this.getImageRegistry() != null && this.getImageRegistry().getDescriptor(string) == null) {
            this.getImageRegistry().put(string, imageDescriptor);
            this.imageKey = string;
        }
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.imageKey == null || this.getImageRegistry() == null) {
            return null;
        }
        ImageDescriptor imageDescriptor = this.getImageRegistry().getDescriptor(this.imageKey);
        if (imageDescriptor == null && this.configurationElement != null && (imageDescriptor = UIUtil.getImageDescriptorFromPlugin(this.configurationElement.getDeclaringExtension().getDeclaringPluginDescriptor(), this.imageKey)) != null) {
            this.getImageRegistry().put(this.imageKey, imageDescriptor);
        }
        return imageDescriptor;
    }

    public Image getImage() {
        if (this.imageKey == null || this.getImageRegistry() == null) {
            return null;
        }
        Image image = this.getImageRegistry().get(this.imageKey);
        if (image == null && this.getImageDescriptor() != null) {
            image = this.getImageRegistry().get(this.imageKey);
        }
        return image;
    }

    public void setConfigurationElement(IConfigurationElement iConfigurationElement) {
        this.extensionClass = null;
        this.configurationElement = iConfigurationElement;
    }

    protected IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    public void setImplementationClass(Class clazz) {
        this.extensionClass = clazz;
    }

    public Class getImplementationClass() {
        if (this.extensionClass == null && this.configurationElement != null && this.getValue(this.configurationElement, "class") != null) {
            try {
                this.extensionClass = this.configurationElement.createExecutableExtension("class").getClass();
            }
            catch (Exception exception) {
                HyadesUIPlugin.logError(exception);
            }
        }
        return this.extensionClass;
    }

    public Object createImplementationClassInstance() {
        Class clazz = this.getImplementationClass();
        if (clazz != null) {
            try {
                return clazz.newInstance();
            }
            catch (Exception exception) {
                HyadesUIPlugin.logError(exception);
            }
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setExtension(String string) {
        this.extension = string;
    }

    public String getExtension() {
        return this.extension;
    }

    public boolean applyTo(String string) {
        if (this.applyToAllTypes()) {
            return true;
        }
        return this.types.contains(string);
    }

    public boolean applyToAllTypes() {
        return this.types == null;
    }

    public boolean addType(String string) {
        if (string == null) {
            return false;
        }
        if (this.types == null) {
            this.types = new HashSet();
        }
        if (this.types.add(string)) {
            if (!this.associationMapping.register(string, this)) {
                this.types.remove(string);
                return false;
            }
            if (this.types.size() == 1) {
                this.associationMapping.deregister(this);
            }
        }
        return true;
    }

    public boolean removeType(String string) {
        if (string == null) {
            return false;
        }
        if (this.types == null) {
            return false;
        }
        if (this.types.remove(string)) {
            if (this.types.isEmpty()) {
                this.types = null;
            }
            this.associationMapping.deregister(string, this);
            if (this.applyToAllTypes()) {
                this.associationMapping.register(this);
            }
        }
        return true;
    }

    public String[] types() {
        if (this.types == null) {
            return new String[0];
        }
        return this.types.toArray(new String[this.types.size()]);
    }

    public IAssociationDescriptor copy() {
        AssociationDescriptor associationDescriptor = this.createClone();
        this.setAttributesOf(associationDescriptor);
        return associationDescriptor;
    }

    protected AssociationDescriptor createClone() {
        return new AssociationDescriptor(null);
    }

    protected void setAttributesOf(AssociationDescriptor associationDescriptor) {
        associationDescriptor.name = this.name;
        associationDescriptor.description = this.description;
        associationDescriptor.id = this.id;
        associationDescriptor.extension = this.extension;
        associationDescriptor.configurationElement = this.configurationElement;
        associationDescriptor.extensionClass = this.extensionClass;
        associationDescriptor.imageKey = this.imageKey;
        associationDescriptor.types = this.types == null ? null : new HashSet(this.types);
    }

    protected void loadFromConfigurationElement(IConfigurationElement iConfigurationElement) {
        int n;
        Object[] objectArray;
        this.configurationElement = iConfigurationElement;
        this.id = this.getValue(iConfigurationElement, "id");
        this.name = this.getValue(iConfigurationElement, "name");
        this.extension = this.getValue(iConfigurationElement, "extension");
        this.description = this.getValue(iConfigurationElement, "description");
        this.imageKey = this.getValue(iConfigurationElement, "icon");
        String string = this.getValue(iConfigurationElement, "isDefault");
        this.isPluginDefault = string != null && string.equalsIgnoreCase("true");
        String string2 = this.getValue(iConfigurationElement, "type");
        if (string2 != null) {
            this.addType(string2);
        } else {
            objectArray = iConfigurationElement.getChildren("appliesTo");
            n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                this.addType(this.getValue(objectArray[n], "type"));
                ++n;
            }
        }
        if (this.applyToAllTypes()) {
            this.associationMapping.register(this);
            if (this.isPluginDefault) {
                this.associationMapping.setDefaultAssociationDescriptor(this);
            }
        } else if (this.isPluginDefault) {
            objectArray = this.types();
            n = 0;
            while (n < objectArray.length) {
                this.associationMapping.setDefaultAssociationDescriptor((String)objectArray[n], this);
                ++n;
            }
        }
    }

    private String getValue(IConfigurationElement iConfigurationElement, String string) {
        IConfigurationElement[] iConfigurationElementArray;
        String string2 = iConfigurationElement.getAttribute(string);
        if (string2 == null && (iConfigurationElementArray = iConfigurationElement.getChildren(string)).length == 1) {
            string2 = iConfigurationElementArray[0].getValue();
        }
        return string2;
    }

    public boolean isPluginDefault() {
        return this.isPluginDefault;
    }

    public void setPluginDefault(boolean bl) {
        this.isPluginDefault = bl;
    }
}

