/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.extension;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.internal.util.CoreUtil;
import org.eclipse.hyades.ui.util.IDisposable;

class AssociationDescriptorEntry
implements IDisposable {
    private String type;
    private Set typedAssociationDescriptors;
    private List commonAssociationDescriptors;
    private Set avoidedAssociationDescriptors;
    private IAssociationDescriptor defaultAssociationDescriptor;

    public AssociationDescriptorEntry(List list, String string) {
        this.type = string;
        this.commonAssociationDescriptors = list;
        this.typedAssociationDescriptors = new HashSet();
        this.avoidedAssociationDescriptors = new HashSet();
    }

    public void dispose() {
        this.commonAssociationDescriptors = null;
        this.defaultAssociationDescriptor = null;
        this.avoidedAssociationDescriptors.clear();
        CoreUtil.dispose(this.typedAssociationDescriptors);
    }

    public String getType() {
        return this.type;
    }

    public boolean addTypedAssociationDescriptor(IAssociationDescriptor iAssociationDescriptor) {
        if (iAssociationDescriptor == null) {
            return false;
        }
        this.avoidedAssociationDescriptors.remove(iAssociationDescriptor);
        return this.typedAssociationDescriptors.add(iAssociationDescriptor);
    }

    public boolean removeTypedAssociationDescriptor(IAssociationDescriptor iAssociationDescriptor) {
        if (iAssociationDescriptor == null) {
            return false;
        }
        this.avoidedAssociationDescriptors.remove(iAssociationDescriptor);
        this.typedAssociationDescriptors.remove(iAssociationDescriptor);
        if (this.defaultAssociationDescriptor == iAssociationDescriptor) {
            this.defaultAssociationDescriptor = null;
        }
        return true;
    }

    public void removeAllTypedAssociationDescriptor() {
        if (this.typedAssociationDescriptors.contains(this.defaultAssociationDescriptor)) {
            this.defaultAssociationDescriptor = null;
        }
        this.avoidedAssociationDescriptors.clear();
        this.typedAssociationDescriptors.clear();
    }

    protected Set getTypedAssociationDescriptor() {
        return Collections.unmodifiableSet(this.typedAssociationDescriptors);
    }

    public IAssociationDescriptor[] getAssociationDescriptors() {
        ArrayList<IAssociationDescriptor> arrayList = new ArrayList<IAssociationDescriptor>(this.typedAssociationDescriptors);
        arrayList.addAll(this.commonAssociationDescriptors);
        if (arrayList.isEmpty()) {
            return new IAssociationDescriptor[0];
        }
        ((AbstractCollection)arrayList).removeAll(this.avoidedAssociationDescriptors);
        IAssociationDescriptor iAssociationDescriptor = this.getDefault();
        if (iAssociationDescriptor != null) {
            ((AbstractCollection)arrayList).remove(iAssociationDescriptor);
            arrayList.add(0, iAssociationDescriptor);
        }
        return arrayList.toArray(new IAssociationDescriptor[arrayList.size()]);
    }

    public void setDefault(IAssociationDescriptor iAssociationDescriptor) {
        if (iAssociationDescriptor.applyTo(this.type) && !this.avoidedAssociationDescriptors.contains(iAssociationDescriptor)) {
            this.defaultAssociationDescriptor = iAssociationDescriptor;
        }
    }

    public IAssociationDescriptor getDefault() {
        if (this.defaultAssociationDescriptor == null || !this.defaultAssociationDescriptor.applyTo(this.type) || this.avoidedAssociationDescriptors.contains(this.defaultAssociationDescriptor)) {
            Object object;
            this.defaultAssociationDescriptor = null;
            Iterator iterator = this.typedAssociationDescriptors.iterator();
            while (iterator.hasNext()) {
                object = (IAssociationDescriptor)iterator.next();
                if (this.avoidedAssociationDescriptors.contains(object)) continue;
                this.defaultAssociationDescriptor = object;
                return object;
            }
            object = this.commonAssociationDescriptors.iterator();
            while (object.hasNext()) {
                IAssociationDescriptor iAssociationDescriptor = (IAssociationDescriptor)object.next();
                if (this.avoidedAssociationDescriptors.contains(iAssociationDescriptor)) continue;
                this.defaultAssociationDescriptor = iAssociationDescriptor;
                return iAssociationDescriptor;
            }
        }
        return this.defaultAssociationDescriptor;
    }

    public boolean addToAvoidedSet(IAssociationDescriptor iAssociationDescriptor) {
        if (iAssociationDescriptor == null || !iAssociationDescriptor.applyTo(this.type)) {
            return false;
        }
        if (this.avoidedAssociationDescriptors.add(iAssociationDescriptor)) {
            if (this.defaultAssociationDescriptor == iAssociationDescriptor) {
                this.defaultAssociationDescriptor = null;
            }
            return true;
        }
        return false;
    }

    public boolean removeFromAvoidedSet(IAssociationDescriptor iAssociationDescriptor) {
        if (iAssociationDescriptor == null || !iAssociationDescriptor.applyTo(this.type)) {
            return false;
        }
        return this.avoidedAssociationDescriptors.remove(iAssociationDescriptor);
    }

    public void removeAllFromAvoidedSet() {
        this.avoidedAssociationDescriptors.clear();
    }

    public Set avoidedAssociationDescriptors() {
        return Collections.unmodifiableSet(this.avoidedAssociationDescriptors);
    }
}

