/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchResultCollector;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenJavaSource {
    private static final String JAVA_PERSPECTIVE_ID = "org.eclipse.jdt.ui.JavaPerspective";

    public static boolean openSource(String string, int n, IJavaSearchScope iJavaSearchScope, boolean bl) {
        boolean bl2 = false;
        if (iJavaSearchScope == null) {
            iJavaSearchScope = SearchEngine.createWorkspaceScope();
        }
        if (string == null) {
            string = "";
        }
        if (string != "") {
            SearchEngine searchEngine = new SearchEngine();
            int n2 = string.indexOf("(");
            n2 = n2 != -1 ? string.substring(0, n2).lastIndexOf("$") : string.lastIndexOf("$");
            String string2 = null;
            if (n2 != -1) {
                int n3;
                if (n == 1) {
                    n3 = string.lastIndexOf(".");
                    if (n3 != -1) {
                        string2 = string.substring(0, n3);
                    }
                } else if (n == 3) {
                    n3 = string.indexOf("(");
                    if (n3 != -1) {
                        string2 = string.substring(0, n3);
                    }
                } else {
                    string2 = string;
                }
                string = string.substring(n2 + 1);
            }
            OpenSourceJavaSearchResultCollector openSourceJavaSearchResultCollector = new OpenSourceJavaSearchResultCollector(string2);
            try {
                searchEngine.search(ResourcesPlugin.getWorkspace(), string, n, 0, iJavaSearchScope, (IJavaSearchResultCollector)openSourceJavaSearchResultCollector);
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            if (openSourceJavaSearchResultCollector.getFile() != null) {
                bl2 = OpenJavaSource.openWbSource(openSourceJavaSearchResultCollector.getFile(), openSourceJavaSearchResultCollector.getStart(), openSourceJavaSearchResultCollector.getEnd(), bl);
            }
        }
        return bl2;
    }

    private static boolean openWbSource(IFile iFile, int n, int n2, boolean bl) {
        IWorkbenchPage iWorkbenchPage;
        IEditorPart iEditorPart = null;
        if (bl) {
            iWorkbenchPage = OpenJavaSource.getJavaActivePage();
            if (iWorkbenchPage == null) {
                return false;
            }
            try {
                iEditorPart = iWorkbenchPage.openEditor(iFile);
            }
            catch (PartInitException partInitException) {
                HyadesUIPlugin.logError(partInitException);
            }
        } else {
            iEditorPart = UIUtil.openEditor(iFile, null, false);
        }
        try {
            IDocument iDocument;
            int n3;
            if (iEditorPart != null && iEditorPart instanceof ITextEditor && n2 - 1 < (n3 = (iDocument = (iWorkbenchPage = (ITextEditor)iEditorPart).getDocumentProvider().getDocument((Object)iEditorPart.getEditorInput())).getLength()) && n < n3) {
                iWorkbenchPage.setHighlightRange(n, n2 - n, true);
                return true;
            }
        }
        catch (Exception exception) {
            HyadesUIPlugin.logError(exception);
        }
        return false;
    }

    private static IWorkbenchPage getJavaActivePage() {
        IWorkbenchPage iWorkbenchPage = UIUtil.getActiveWorkbenchPage();
        if (iWorkbenchPage == null || !iWorkbenchPage.getPerspective().getId().equals(JAVA_PERSPECTIVE_ID)) {
            IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            iWorkbenchPage = null;
            try {
                IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindow.getPages();
                int n = 0;
                while (n < iWorkbenchPageArray.length) {
                    if (iWorkbenchPageArray[n].getPerspective().getId().equals(JAVA_PERSPECTIVE_ID)) {
                        iWorkbenchPage = iWorkbenchPageArray[n];
                        iWorkbenchWindow.setActivePage(iWorkbenchPage);
                        break;
                    }
                    ++n;
                }
                if (iWorkbenchPage == null) {
                    IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                    IWorkbench iWorkbench = iWorkbenchWindow.getWorkbench();
                    if (iWorkbench != null && iWorkspaceRoot != null) {
                        iWorkbenchPage = iWorkbench.showPerspective(JAVA_PERSPECTIVE_ID, iWorkbenchWindow, (IAdaptable)iWorkspaceRoot);
                    }
                }
            }
            catch (Exception exception) {
                HyadesUIPlugin.logError(exception);
            }
        }
        return iWorkbenchPage;
    }

    private static class OpenSourceJavaSearchResultCollector
    implements IJavaSearchResultCollector {
        private IResource _resource;
        private int _start;
        private int _end;
        private String _className;

        public OpenSourceJavaSearchResultCollector(String string) {
            this._className = string;
        }

        public void aboutToStart() {
            this._resource = null;
            this._start = -1;
            this._end = -1;
        }

        public void accept(IResource iResource, int n, int n2, IJavaElement iJavaElement, int n3) {
            boolean bl = false;
            if (this._className != null) {
                if (iJavaElement instanceof IType && this._className.compareTo(((IType)iJavaElement).getFullyQualifiedName()) == 0) {
                    bl = true;
                } else if (iJavaElement instanceof IMethod && this._className.compareTo(((IMethod)iJavaElement).getDeclaringType().getFullyQualifiedName()) == 0) {
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (bl) {
                this._resource = iResource;
                this._start = n;
                this._end = n2;
                try {
                    ISourceReference iSourceReference;
                    ISourceRange iSourceRange;
                    if (iJavaElement != null && iJavaElement instanceof ISourceReference && (iSourceRange = (iSourceReference = (ISourceReference)iJavaElement).getSourceRange()) != null) {
                        this._start = iSourceRange.getOffset();
                        this._end = this._start + iSourceRange.getLength();
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
        }

        public void done() {
        }

        public IProgressMonitor getProgressMonitor() {
            return null;
        }

        public IFile getFile() {
            if (this._resource != null && this._resource.getType() == 1) {
                return (IFile)this._resource;
            }
            return null;
        }

        public int getStart() {
            return this._start;
        }

        public int getEnd() {
            return this._end;
        }
    }
}

