/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.hyades.trace.views.internal.StdDrawStrategy;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.util.internal.BufferedCanvas;
import org.eclipse.hyades.trace.views.util.internal.SpectrumColorMap;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;

public class JCanvas
implements SelectionListener,
KeyListener {
    protected final float MAG_STEP = 2.0f;
    protected static final int ARROW_FACTOR = 4;
    protected static final int MIN_FONT_SIZE = 5;
    protected static final int MAX_FONT_SIZE = 72;
    protected static final float GROWTH_FACTOR = 1.25f;
    protected StdDrawStrategy _objDS;
    protected float _left;
    protected float _top;
    protected float _prefWidth;
    protected float _prefHeight;
    protected float _xscale = 1.0f;
    protected float _yscale = 1.0f;
    protected float _xscaleMax = 64.0f;
    protected float _yscaleMax = 64.0f;
    protected Point _origin = new Point(0, 0);
    protected Rectangle _prevSize = new Rectangle(0, 0, 0, 0);
    private Cursor _zoomInCursor;
    private Cursor _zoomOutCursor;
    private Cursor _defaultCursor;
    private boolean _zoomIn = false;
    private boolean _zoomOut = false;
    protected boolean _controlDown = false;
    protected BufferedCanvas fCanvas;
    protected int fCanvasStyle;
    public static final int fScrollBarWidth = 12;
    protected int fHSel = 0;
    protected int fVSel = 0;
    protected int fHeight;

    public JCanvas(Composite composite, int n) {
        this(composite, n, 0);
    }

    public JCanvas(Composite composite, int n, int n2) {
        this.fCanvasStyle = n;
        this.fHeight = n2;
        ImageDescriptor imageDescriptor = TracePluginImages.DESC_IMG_ZOOMIN_SOURCE;
        ImageDescriptor imageDescriptor2 = TracePluginImages.DESC_IMG_ZOOMOUT_SOURCE;
        ImageDescriptor imageDescriptor3 = TracePluginImages.DESC_IMG_ZOOMMASK;
        this._zoomInCursor = new Cursor((Device)Display.getCurrent(), imageDescriptor.getImageData(), imageDescriptor3.getImageData(), 0, 0);
        this._zoomOutCursor = new Cursor((Device)Display.getCurrent(), imageDescriptor2.getImageData(), imageDescriptor3.getImageData(), 0, 0);
        this.createControl(composite);
        this._defaultCursor = new Cursor((Device)Display.getCurrent(), 0);
    }

    public boolean alignVertical(JCanvas jCanvas) {
        if (this._top != jCanvas._top || this._origin.y != jCanvas._origin.y || this._prefHeight != jCanvas._prefHeight || this._yscale != jCanvas._yscale) {
            this._top = jCanvas._top;
            this._origin.y = jCanvas._origin.y;
            this._prefHeight = jCanvas._prefHeight;
            this.yscale(jCanvas.yscale());
            return true;
        }
        return false;
    }

    public float bottom() {
        return this._top + this.height();
    }

    public Canvas canvas() {
        return this.fCanvas;
    }

    protected final Control createControl(Composite composite) {
        this.fCanvas = new BufferedCanvas(composite, this.fCanvasStyle){

            public void doPaint(GC gC) {
                JCanvas.this.paint(gC);
            }
        };
        this.fCanvas.setBackground(SpectrumColorMap.getBackgroundColor());
        ScrollBar scrollBar = this.fCanvas.getHorizontalBar();
        ScrollBar scrollBar2 = this.fCanvas.getVerticalBar();
        if (scrollBar != null) {
            scrollBar.addSelectionListener((SelectionListener)this);
        }
        if (scrollBar2 != null) {
            scrollBar2.addSelectionListener((SelectionListener)this);
        }
        this.fCanvas.addKeyListener(this);
        return this.fCanvas;
    }

    public int denormX(float f) {
        return Math.round((f - this._left) * this._xscale - (float)this._origin.x);
    }

    public int denormY(float f) {
        return Math.round((f - this._top) * this._yscale - (float)this._origin.y);
    }

    protected void denormZoom(float f, float f2, float f3, float f4) {
        float f5 = Math.min(this._xscaleMax / this.xscale(), f);
        float f6 = Math.min(this._yscaleMax / this.yscale(), f2);
        if (f5 != 1.0f || f6 != 1.0f) {
            this.xscale(this.xscale() * f5);
            this.yscale(this.yscale() * f6);
            this.zoomJCanvasScroller(f5, f6, f3, f4);
        }
        this.updateScrollbars();
    }

    public void drawArrow(GC gC, float f, float f2, float f3, float f4, Color color) {
        int n;
        int n2;
        int n3 = this.denormX(f);
        int n4 = this.denormY(f2);
        int n5 = this.denormX(f3);
        int n6 = n5 - n3;
        int n7 = (int)Math.sqrt(n6 * n6 + (n2 = (n = this.denormY(f4)) - n4) * n2);
        if (n7 > 1) {
            n6 = Math.round((float)(n6 * 4) * this._xscale / (float)n7);
            n2 = Math.round((float)(n2 * 4) * this._yscale / (float)n7);
        }
        if (n6 != 0 || n2 != 0) {
            gC.setForeground(color);
            gC.setBackground(color);
            gC.drawLine(n5, n, n5 - n6 - n2 / 2, n + n6 / 2 - n2);
            gC.drawLine(n5, n, n5 - n6 + n2 / 2, n - n6 / 2 - n2);
        }
        gC.setForeground(color);
        gC.setBackground(color);
        gC.drawLine(n3, n4, n5, n);
    }

    public void drawDiamond(GC gC, float f, float f2, float f3, float f4, Color color, boolean bl) {
        int n = this.denormX(f);
        int n2 = this.denormY(f2);
        float f5 = this._xscale;
        float f6 = this._yscale;
        int n3 = Math.round(f5 * f3);
        int n4 = Math.round(f6 * f4);
        if (n3 < 1) {
            n3 = 1;
        }
        if (n4 < 1) {
            n4 = 1;
        }
        int[] nArray = new int[]{n + n3 / 2, n2, n + n3, n2 + n4 / 2, n + n3 / 2, n2 + n4, n, n2 + n4 / 2};
        gC.setForeground(color);
        gC.setBackground(color);
        if (bl) {
            gC.fillPolygon(nArray);
        } else {
            gC.drawPolygon(nArray);
        }
        this._objDS.setHeight(Math.max(this._objDS.getHeight(), (float)(n2 + n4)));
        this._objDS.setWidth(Math.max(this._objDS.getWidth(), (float)(n + n3)));
    }

    public void drawLine(GC gC, float f, float f2, float f3, float f4, Color color) {
        gC.setForeground(color);
        gC.setBackground(color);
        int n = this.denormX(f);
        int n2 = this.denormY(f2);
        int n3 = this.denormX(f3);
        int n4 = this.denormY(f4);
        gC.drawLine(n, n2, n3, n4);
    }

    public void drawLoop(GC gC, float f, float f2, float f3, float f4, Color color) {
        int n = this.denormX(f);
        int n2 = this.denormY(f2);
        int n3 = Math.round(this._xscale * f3);
        int n4 = Math.round(this._yscale * f4);
        int n5 = Math.round(4.0f * this._xscale);
        int n6 = Math.round(4.0f * this._yscale);
        gC.setForeground(color);
        gC.setBackground(color);
        gC.drawOval(n - n3 / 2, n2 - n4, n3, n4);
    }

    public void drawRect(GC gC, float f, float f2, float f3, float f4, Color color) {
        int n = this.denormX(f);
        int n2 = this.denormY(f2);
        int n3 = Math.round(this._xscale * f3);
        int n4 = Math.round(this._yscale * f4);
        if (n3 < 1 || n4 < 1) {
            n3 = 1;
            n4 = 1;
            return;
        }
        gC.setForeground(color);
        gC.setBackground(color);
        gC.drawRectangle(n, n2, n3, n4);
        this._objDS.setHeight(Math.max(this._objDS.getHeight(), (float)(n2 + n4)));
        this._objDS.setWidth(Math.max(this._objDS.getWidth(), (float)(n + n3)));
    }

    public void drawRectXor(float f, float f2, float f3, float f4) {
        int n = this.denormX(f);
        int n2 = this.denormY(f2);
        int n3 = Math.round(this._xscale * f3);
        int n4 = Math.round(this._yscale * f4);
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        GC gC = new GC((Drawable)this.fCanvas);
        gC.setXORMode(true);
        gC.setForeground(display.getSystemColor(1));
        gC.setBackground(display.getSystemColor(2));
        if (n3 >= 1 && n4 >= 1) {
            gC.drawRectangle(n, n2, n3, n4);
        }
        gC.dispose();
    }

    public void drawRectXor(GC gC, float f, float f2, float f3, float f4) {
        int n = this.denormX(f);
        int n2 = this.denormY(f2);
        int n3 = Math.round(this._xscale * f3);
        int n4 = Math.round(this._yscale * f4);
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        gC.setXORMode(true);
        gC.setForeground(display.getSystemColor(1));
        gC.setBackground(display.getSystemColor(2));
        if (n3 >= 1 && n4 >= 1) {
            gC.drawRectangle(n, n2, n3, n4);
        }
    }

    public void drawSquare(GC gC, float f, float f2, float f3, Color color) {
        int n = this.denormX(f);
        int n2 = this.denormY(f2);
        int n3 = Math.round(this._xscale * f3);
        if (n3 < 1) {
            return;
        }
        gC.setForeground(color);
        gC.setBackground(color);
        gC.drawRectangle(n, n2, n3, n3);
    }

    public void drawString(GC gC, String string, float f, float f2, Color color) {
        int n = this.denormX(f);
        int n2 = this.denormY(f2);
        gC.setForeground(color);
        gC.drawString(string, n, n2 - 10, true);
    }

    public void drawString(GC gC, String string, float f, float f2, Color color, Color color2) {
        int n = this.denormX(f);
        int n2 = this.denormY(f2);
        gC.setForeground(color);
        gC.setBackground(color2);
        gC.drawString(string, n, n2 - 10);
    }

    protected boolean extendedTo(float f, float f2) {
        boolean bl = false;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (f < this.left()) {
            f3 = (this.left() - f) * 1.25f;
            this._prefWidth += f3;
            this.left(f);
            bl = true;
        } else if (f > this.left() + this.width()) {
            this._prefWidth = (f - this.left()) * 1.25f;
            bl = true;
        }
        if (f2 < this.top()) {
            f4 = (this.top() - f2) * 1.25f;
            this._prefHeight += f4;
            this.top(f2);
            bl = true;
        } else if (f2 > this.top() + this.height()) {
            this._prefHeight = (f2 - this.top()) * 1.25f;
            bl = true;
        }
        if (bl) {
            int n = Math.round(f3 * this._xscale);
            int n2 = Math.round(f4 * this._yscale);
            this._origin.x += n;
            this._origin.y += n2;
        }
        return bl;
    }

    protected float fdenormX(float f) {
        return (f - this._left) * this._xscale - (float)this._origin.x;
    }

    protected float fdenormY(float f) {
        return (f - this._top) * this._yscale - (float)this._origin.y;
    }

    public void fill3DDiamond(GC gC, float f, float f2, float f3, float f4, Color color) {
        int n = this.denormX(f);
        int n2 = this.denormY(f2);
        float f5 = this._xscale;
        float f6 = this._yscale;
        int n3 = Math.round(f5 * f3);
        int n4 = Math.round(f6 * f4);
        if (n3 < 1) {
            n3 = 1;
        }
        if (n4 < 1) {
            n4 = 1;
        }
        int[] nArray = new int[]{n + n3 / 2, n + n3, n + n3 / 2, n};
        int[] nArray2 = new int[]{n2, n2 + n4 / 2, n2 + n4, n2 + n4 / 2};
        int[] nArray3 = new int[]{n + n3 / 2, n2, n + n3, n2 + n4 / 2, n + n3 / 2, n2 + n4, n, n2 + n4 / 2};
        gC.setForeground(color);
        gC.setBackground(color);
        gC.fillPolygon(nArray3);
        Color color2 = new Color(null, 0, color.getGreen(), color.getBlue());
        gC.setForeground(color2);
        gC.setBackground(color2);
        gC.drawLine(n + n3 / 2, n2, n + n3, n2 + n4 / 2);
        gC.drawLine(n + n3, n2 + n4 / 2, n + n3 / 2, n2 + n4);
        gC.drawLine(n + n3 + 1, n2 + n4 / 2, n + n3 / 2, n2 + n4 + 1);
        Color color3 = new Color(null, color.getRed(), color.getGreen(), 0);
        gC.setForeground(color3);
        gC.setBackground(color3);
        gC.drawLine(n + n3 / 2, n2 + n4, n, n2 + n4 / 2);
        gC.drawLine(n, n2 + n4 / 2, n + n3 / 2, n2);
        gC.drawLine(n - 1, n2 + n4 / 2, n + n3 / 2, n2 - 1);
        this._objDS.setHeight(Math.max(this._objDS.getHeight(), (float)(n2 + n4)));
        this._objDS.setWidth(Math.max(this._objDS.getWidth(), (float)(n + n3)));
    }

    public void fill3DRect(GC gC, float f, float f2, float f3, float f4, Color color) {
        int n = this.denormX(f);
        int n2 = this.denormY(f2);
        int n3 = Math.round(this._xscale * f3);
        int n4 = Math.round(this._yscale * f4);
        if (n3 < 1) {
            n3 = 1;
        }
        if (n4 < 1) {
            n4 = 1;
        }
        gC.setForeground(color);
        gC.setBackground(color);
        gC.fillRoundRectangle(n, n2, n3, n4, 1, 1);
        gC.fillRoundRectangle(n + 1, n2 + 1, n3 - 2, n4 - 2, 1, 1);
        this._objDS.setHeight(Math.max(this._objDS.getHeight(), (float)(n2 + n4)));
        this._objDS.setWidth(Math.max(this._objDS.getWidth(), (float)(n + n3)));
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        if (this._objDS != null) {
            this._objDS.fillContextMenu(iMenuManager);
        }
    }

    public void fillOval(GC gC, float f, float f2, float f3, float f4, Color color) {
        int n = this.denormX(f);
        int n2 = this.denormY(f2);
        int n3 = Math.round(this._xscale * f3);
        int n4 = Math.round(this._yscale * f4);
        gC.setForeground(color);
        gC.setBackground(color);
        gC.fillOval(n, n2, n3, n4);
    }

    public void fillRect(GC gC, float f, float f2, float f3, float f4, Color color) {
        int n = this.denormX(f);
        int n2 = this.denormY(f2);
        int n3 = Math.round(this._xscale * f3);
        int n4 = Math.round(this._yscale * f4);
        if (n3 < 1) {
            n3 = 1;
        }
        if (n4 < 1) {
            n4 = 1;
        }
        gC.setForeground(color);
        gC.setBackground(color);
        gC.fillRectangle(n, n2, n3, n4);
        this._objDS.setHeight(Math.max(this._objDS.getHeight(), (float)(n2 + n4)));
        this._objDS.setWidth(Math.max(this._objDS.getWidth(), (float)(n + n3)));
    }

    public void fillSquare(GC gC, float f, float f2, float f3, Color color) {
        int n = this.denormX(f);
        int n2 = this.denormY(f2);
        int n3 = Math.round(this._xscale * f3);
        if (n3 < 1) {
            n3 = 1;
        }
        gC.setBackground(color);
        gC.fillRectangle(n, n2, n3, n3);
    }

    public Control getControl() {
        return this.fCanvas;
    }

    public Point getOrigin() {
        return this._origin;
    }

    protected Point getPreferredSize() {
        int n = Math.round(this._prefWidth * this.xscale());
        int n2 = Math.round(this._prefHeight * this.yscale());
        return new Point(n, n2);
    }

    public int getScrollX() {
        return this.fHSel;
    }

    public Rectangle getSize() {
        Rectangle rectangle = this.fCanvas.getClientArea();
        return rectangle;
    }

    protected Rectangle getVisible() {
        Rectangle rectangle = this.fCanvas.getClientArea();
        rectangle.height -= this.fHeight;
        return rectangle;
    }

    public float height() {
        return this._prefHeight;
    }

    public void home() {
        if (this.xscale() == 1.0f && this.yscale() == 1.0f) {
            this.scrollTo(0, 0);
        } else {
            this.xscale(1.0f);
            this.yscale(1.0f);
            this._origin.x = 0;
            this._origin.y = 0;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.keyCode == 262144) {
            this._controlDown = true;
        } else if (keyEvent.keyCode == 0x1000005) {
            this.pageUp();
        } else if (keyEvent.keyCode == 0x1000006) {
            this.pageDown();
        } else if (keyEvent.keyCode == 0x1000001) {
            this.page(0.0f, -0.1f);
        } else if (keyEvent.keyCode == 0x1000002) {
            this.page(0.0f, 0.1f);
        } else if (keyEvent.keyCode == 0x1000003) {
            if (this._controlDown) {
                this.page(-0.9f, 0.0f);
            } else {
                this.page(-0.1f, 0.0f);
            }
        } else if (keyEvent.keyCode == 0x1000004) {
            if (this._controlDown) {
                this.page(0.9f, 0.0f);
            } else {
                this.page(0.1f, 0.0f);
            }
        } else if (keyEvent.keyCode == 0x1000007) {
            this.zoomToFill(1.0f, 1000.0f);
            this.redraw();
        } else if (keyEvent.keyCode == 0x1000009 || keyEvent.character == '=' || keyEvent.character == '+') {
            this.zoomIn();
            this.redraw();
        } else if (keyEvent.character == '_' || keyEvent.character == '-') {
            this.zoomOut();
            this.redraw();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.keyCode == 262144) {
            this._controlDown = false;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public float left() {
        return this._left;
    }

    public void left(float f) {
        this._left = f;
    }

    public float normX(int n) {
        return (float)(n + this._origin.x) / this._xscale + this._left;
    }

    public float normY(int n) {
        return (float)(n + this._origin.y) / this._yscale + this._top;
    }

    protected void page(float f, float f2) {
        this.page(f, f2, true);
    }

    protected void page(float f, float f2, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        if (f != 0.0f) {
            n4 = this.getVisible().width;
            n3 = this.getPreferredSize().x;
            n2 = this._origin.x;
            n = n3 - n4 - n2;
            if (f > 0.0f && n <= 0) {
                this._origin.x = this.getPreferredSize().x - this.getVisible().width;
                if (bl) {
                    this.updateScrollbars();
                }
                return;
            }
            if (f < 0.0f && n2 <= 0) {
                this._origin.x = 0;
                if (bl) {
                    this.updateScrollbars();
                }
                return;
            }
        }
        if (f2 != 0.0f) {
            n4 = this.getVisible().height;
            n3 = this.getPreferredSize().y;
            n2 = this._origin.y;
            n = n3 - n4 - n2;
            if (f2 < 0.0f && n2 <= 0) {
                this._origin.y = 0;
                if (bl) {
                    this.updateScrollbars();
                }
                return;
            }
            if (f2 > 0.0f && n <= 0) {
                return;
            }
        }
        Rectangle rectangle = this.getVisible();
        this.scrollBy(Math.round((float)rectangle.width * f), Math.round((float)rectangle.height * f2), bl);
    }

    public void pageDown() {
        this.page(0.0f, 0.8f);
    }

    public void pageUp() {
        this.page(0.0f, -0.8f);
    }

    protected void paint(GC gC) {
        if (this._objDS == null) {
            return;
        }
        FontData fontData = SpectrumColorMap.getFontData();
        Font font = new Font((Device)Display.getDefault(), fontData);
        gC.setFont(font);
        this._objDS.setDirty();
        if (this._objDS.isDirtyAndReset()) {
            this._objDS.bgRedraw(gC);
            if (this.sizeChanged()) {
                this.updateScrollbars();
            }
            this._prevSize = this.getVisible();
        }
        font.dispose();
    }

    public void redraw() {
        Display display = Display.getCurrent();
        if (display == null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    JCanvas.this.fCanvas.redraw();
                }
            });
        } else {
            this.fCanvas.redraw();
        }
    }

    public float right() {
        return this._left + this.width();
    }

    public void scrollBy(int n, int n2) {
        this.scrollBy(n, n, true);
    }

    public void scrollBy(int n, int n2, boolean bl) {
        this.scrollTo(this._origin.x + n, this._origin.y + n2, bl);
    }

    public void scrollTo(int n, int n2) {
        this.scrollTo(n, n2, true);
    }

    public void scrollTo(int n, int n2, boolean bl) {
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        Point point = new Point(n, n2);
        if (point.x != this._origin.x || point.y != this._origin.y) {
            this._origin = point;
            this.redraw();
            if (bl) {
                this.updateScrollbars(point.x, point.y);
            }
        }
    }

    public void setArea(float f, float f2) {
        this._prefWidth = f;
        this._prefHeight = f2;
    }

    public void setDrawStrategy(StdDrawStrategy stdDrawStrategy) {
        this._objDS = stdDrawStrategy;
        if (this.fCanvas == null || this._objDS == null) {
            return;
        }
        this.fCanvas.addMouseListener(this._objDS);
        this.fCanvas.addMouseMoveListener(this._objDS);
    }

    public void setMenuListener(IMenuListener iMenuListener) {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(iMenuListener);
        Menu menu = menuManager.createContextMenu((Control)this.fCanvas);
        this.fCanvas.setMenu(menu);
    }

    public void setOrigin(Point point) {
        this._origin = point;
    }

    public void setZoomLimits(float f, float f2) {
        this._xscaleMax = f;
        this._yscaleMax = f2;
    }

    protected boolean sizeChanged() {
        Rectangle rectangle = this.getVisible();
        return rectangle.width != this._prevSize.width || rectangle.height != this._prevSize.height;
    }

    public float top() {
        return this._top;
    }

    public void top(float f) {
        this._top = f;
    }

    public void updateScrollbars() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (this._objDS == null) {
            return;
        }
        ScrollBar scrollBar = this.fCanvas.getHorizontalBar();
        ScrollBar scrollBar2 = this.fCanvas.getVerticalBar();
        if (scrollBar != null) {
            n6 = this.getVisible().width;
            n5 = this.getPreferredSize().x;
            n4 = this._origin.x;
            n3 = n5 - n6 - n4;
            scrollBar.setMinimum(0);
            scrollBar.setMaximum(n5 - n6);
            if (n5 <= n6) {
                scrollBar.setVisible(false);
            } else {
                scrollBar.setVisible(true);
                n2 = Math.round((float)n6 * 0.1f);
                if (n2 == 0) {
                    return;
                }
                n = scrollBar.getMaximum() / n2 + 2;
                scrollBar.setMaximum(n * n2);
                scrollBar.setThumb(scrollBar.getMaximum() / n);
                scrollBar.setSelection(n4);
                scrollBar.setPageIncrement(n2);
                scrollBar.setIncrement(n2);
                this.fHSel = scrollBar.getSelection();
            }
        }
        if (scrollBar2 != null) {
            n6 = this.getVisible().height;
            n5 = this.getPreferredSize().y;
            n4 = this._origin.y;
            n3 = n5 - n6 - n4;
            scrollBar2.setMinimum(0);
            scrollBar2.setMaximum(n5 - n6);
            if (n5 <= n6) {
                scrollBar2.setVisible(false);
            } else {
                scrollBar2.setVisible(true);
                n2 = Math.round((float)n6 * 0.1f);
                if (n2 == 0) {
                    return;
                }
                n = scrollBar2.getMaximum() / n2 + 2;
                scrollBar2.setMaximum(n * n2);
                scrollBar2.setThumb(scrollBar2.getMaximum() / n);
                scrollBar2.setSelection(n4);
                scrollBar2.setPageIncrement(n2);
                scrollBar2.setIncrement(n2);
                this.fVSel = scrollBar2.getSelection();
            }
        }
    }

    protected void updateScrollbars(int n, int n2) {
        if (this._objDS == null) {
            return;
        }
        ScrollBar scrollBar = this.fCanvas.getHorizontalBar();
        ScrollBar scrollBar2 = this.fCanvas.getVerticalBar();
        if (scrollBar != null) {
            scrollBar.setSelection(n);
            this.fHSel = scrollBar.getSelection();
        }
        if (scrollBar2 != null) {
            scrollBar2.setSelection(n2);
            this.fVSel = scrollBar2.getSelection();
        }
    }

    public boolean visible(float f, float f2, float f3, float f4) {
        int n = this.denormX(f);
        int n2 = this.denormY(f2);
        int n3 = Math.round(this.xscale() * f3);
        int n4 = Math.round(this.yscale() * f4);
        Rectangle rectangle = this.getVisible();
        return n <= rectangle.width && n + n3 >= 0 && n2 <= rectangle.height && n2 + n4 >= 0;
    }

    public float visibleBottom() {
        return this.normY(this.getVisible().height);
    }

    public float visibleHeight() {
        return (float)this.getVisible().height / this.yscale();
    }

    public float visibleLeft() {
        return this.normX(0);
    }

    public float visibleRight() {
        return this.normX(this.getVisible().width);
    }

    public float visibleTop() {
        return this.normY(0);
    }

    public float visibleWidth() {
        return (float)this.getVisible().width / this.xscale();
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.fCanvas.getHorizontalBar()) {
            ScrollBar scrollBar = (ScrollBar)selectionEvent.widget;
            int n = scrollBar.getSelection();
            if (n != 0 && n >= this.fHSel && this.fHSel >= 0) {
                int n2 = n - this.fHSel;
                if (n2 > 0 && scrollBar.getPageIncrement() > 0) {
                    float f = (float)n2 * 0.1f / (float)scrollBar.getPageIncrement();
                    this.page(f, 0.0f, false);
                }
            } else {
                int n3 = this.fHSel - n;
                if (n3 > 0 && scrollBar.getPageIncrement() > 0) {
                    float f = (float)n3 * 0.1f / (float)scrollBar.getPageIncrement();
                    this.page(-f, 0.0f, false);
                }
            }
            this.fHSel = n;
        } else if (selectionEvent.widget == this.fCanvas.getVerticalBar()) {
            ScrollBar scrollBar = (ScrollBar)selectionEvent.widget;
            int n = scrollBar.getSelection();
            if (n != 0 && n >= this.fVSel && this.fVSel >= 0) {
                int n4 = n - this.fVSel;
                if (n4 > 0 && scrollBar.getPageIncrement() > 0) {
                    float f = (float)n4 * 0.1f / (float)scrollBar.getPageIncrement();
                    this.page(0.0f, f, false);
                }
            } else {
                int n5 = this.fVSel - n;
                if (n5 > 0 && scrollBar.getPageIncrement() > 0) {
                    float f = (float)n5 * 0.1f / (float)scrollBar.getPageIncrement();
                    this.page(0.0f, -f, false);
                }
            }
            this.fVSel = n;
        }
    }

    public float width() {
        return this._prefWidth;
    }

    public float xscale() {
        return this._xscale;
    }

    protected void xscale(float f) {
        this._xscale = Math.min(f, this._xscaleMax);
    }

    public float yscale() {
        return this._yscale;
    }

    protected void yscale(float f) {
        this._yscale = Math.min(f, this._yscaleMax);
    }

    public void zoom(float f, float f2) {
        if (this._zoomIn) {
            this.denormZoom(1.5f, 1.5f, f, f2);
        }
        if (this._zoomOut) {
            this.denormZoom(0.5f, 0.5f, f, f2);
        }
        this.redraw();
    }

    public void zoom(float f, float f2, float f3, float f4) {
        this.denormZoom(f, f2, this.fdenormX(f3), this.fdenormY(f4));
    }

    public void zoomIn() {
        if (this._zoomIn) {
            this.fCanvas.setCursor(this._zoomInCursor);
        } else {
            this.fCanvas.setCursor(this._defaultCursor);
        }
    }

    protected void zoomJCanvasScroller(float f, float f2, float f3, float f4) {
        this._origin.x = Math.round(((float)this._origin.x + f3) * f - f3);
        this._origin.y = Math.round(((float)this._origin.y + f4) * f2 - f4);
    }

    public void zoomOut() {
        if (this._zoomOut) {
            this.fCanvas.setCursor(this._zoomOutCursor);
        } else {
            this.fCanvas.setCursor(this._defaultCursor);
        }
    }

    public void setDefautCursor() {
        this.fCanvas.setCursor(this._defaultCursor);
    }

    public void zoomRect(float f, float f2, float f3, float f4) {
        Rectangle rectangle = this.getVisible();
        float f5 = f3 * this.xscale();
        float f6 = f4 * this.yscale();
        float f7 = (float)rectangle.width / f5;
        float f8 = (float)rectangle.height / f6;
        float f9 = this.fdenormX(f + f3 / 2.0f);
        float f10 = this.fdenormY(f2 + f4 / 2.0f);
        float f11 = f9 - (float)rectangle.width / 2.0f;
        float f12 = f10 - (float)rectangle.height / 2.0f;
        this.denormZoom(f7, f8, f9 += f11 / f7, f10 += f12 / f8);
    }

    public void zoomToFill(float f, float f2) {
        float f3;
        if (this._objDS == null || this.fCanvas == null) {
            return;
        }
        float f4 = this.getVisible().width;
        float f5 = this.getVisible().height;
        if (f4 <= 0.0f) {
            f4 = 500.0f;
        }
        if (f5 <= 0.0f) {
            f5 = 250.0f;
        }
        f3 = (f3 = this._objDS.width()) == 0.0f ? 1.0f : f3;
        float f6 = this._objDS.height();
        float f7 = f6 = f6 == 0.0f ? 1.0f : f6;
        if (f3 > 1.0f && f4 / f3 < f) {
            this.xscale(f4 / f3);
        } else {
            this.xscale(f);
        }
        if (f6 > 1.0f && f5 / f6 < f2) {
            this.yscale(f5 / f6);
        } else {
            this.yscale(f2);
        }
        this._origin.x = 0;
        this._origin.y = 0;
        this.updateScrollbars();
    }

    public void zoomToFit() {
        this.zoomToFill(1.0f, 1.0f);
    }

    public void dispose() {
        if (this._zoomInCursor != null && !this._zoomInCursor.isDisposed()) {
            this._zoomInCursor.dispose();
        }
        if (this._zoomOutCursor != null && !this._zoomOutCursor.isDisposed()) {
            this._zoomOutCursor.dispose();
        }
        if (this._defaultCursor != null && !this._defaultCursor.isDisposed()) {
            this._defaultCursor.dispose();
        }
        this._objDS = null;
        this._prevSize = null;
        this._origin = null;
        this.fCanvas = null;
        this._zoomInCursor = null;
        this._zoomOutCursor = null;
        this._defaultCursor = null;
    }

    public void isZoomIn(boolean bl) {
        this._zoomIn = bl;
        if (bl) {
            this._zoomOut = false;
        }
    }

    public void isZoomOut(boolean bl) {
        this._zoomOut = bl;
        if (bl) {
            this._zoomIn = false;
        }
    }

    public boolean isZoom() {
        return this._zoomIn || this._zoomOut;
    }
}

