/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.adapter.internal.PatternPage;
import org.eclipse.hyades.trace.views.internal.JCanvas;
import org.eclipse.hyades.trace.views.internal.PatternDrawStrategy;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.GraphColorDialog;
import org.eclipse.hyades.trace.views.util.internal.ITimeChangedListener;
import org.eclipse.hyades.trace.views.util.internal.OpenSource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class Pattern
implements ControlListener,
ITimeChangedListener,
ISelectionProvider {
    protected final float MAG_STEP = 2.0f;
    protected Label _status;
    protected JCanvas _canvas;
    protected PatternDrawStrategy _curDS;
    protected PatternDrawStrategy _patDS;
    protected boolean _initialized = false;
    protected PatternPage _page;
    protected Composite viewContainer;
    protected ViewForm dataPane;
    protected Composite viewComp;
    protected Action _updateAction;
    protected Action _openColorDialog;
    protected Separator fSeparator;

    public Pattern(Composite composite, PatternPage patternPage) {
        this._page = patternPage;
        this.createControl(composite);
        this._updateAction = new UpdateAction(UIPlugin.getResourceString((String)"REFRESH_VIEWS"));
        this._openColorDialog = new OpenColorDialog(TraceUIPlugin.getString("OPEN_COLOR_DLG"));
        this.fSeparator = new Separator();
        TraceUIPlugin.getDefault().addTimeChangedEventListener(this);
    }

    public PatternPage getPage() {
        return this._page;
    }

    public void close() {
        this.viewContainer.dispose();
        this._page.dispose();
    }

    public void controlMoved(ControlEvent controlEvent) {
    }

    public void controlResized(ControlEvent controlEvent) {
        this.resizeContent();
    }

    public void createControl(Composite composite) {
        this.viewContainer = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.viewContainer.setLayout((Layout)gridLayout);
        this.viewContainer.setLayoutData((Object)GridUtil.createFill());
        this.viewComp = new Composite(this.viewContainer, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.viewComp.setLayout((Layout)gridLayout);
        this.viewComp.setLayoutData((Object)GridUtil.createFill());
        this.dataPane = new ViewForm(this.viewComp, 0);
        this.dataPane.setLayoutData((Object)GridUtil.createFill());
        this._canvas = new JCanvas((Composite)this.dataPane, 768, 10);
        this.dataPane.setContent((Control)this._canvas.canvas());
        this.viewContainer.addControlListener((ControlListener)this);
        this._status = new Label(this.viewContainer, 2048);
        this._status.setLayoutData((Object)GridUtil.createHorizontalFill());
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)(TraceUIPlugin.getPluginId() + ".exef0008"));
    }

    public void dispose() {
        TraceUIPlugin.getDefault().removeTimeChangedEventListener(this);
        if (this._patDS != null) {
            this._patDS.shutdown();
        }
        this._page = null;
        this._patDS = null;
        this._curDS = null;
        if (this._canvas != null) {
            this._canvas.dispose();
        }
        this._canvas = null;
        if (this.dataPane != null) {
            this.dataPane.dispose();
        }
        this.dataPane = null;
        if (this.viewComp != null) {
            this.viewComp.dispose();
        }
        this.viewComp = null;
        if (this.viewContainer != null) {
            this.viewContainer.dispose();
        }
        this.viewContainer = null;
        this._updateAction = null;
        this._openColorDialog = null;
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this._updateAction);
        iMenuManager.add((IAction)this._openColorDialog);
        iMenuManager.add((IContributionItem)this.fSeparator);
        this._canvas.fillContextMenu(iMenuManager);
    }

    public Control getControl() {
        return this.viewContainer;
    }

    public void initialize() {
        if (this._initialized) {
            return;
        }
        this._initialized = true;
        this.initStrategies();
        this.setDrawStrategy(this._patDS);
        this.updateTitle();
    }

    private void initStrategies() {
        this._patDS = new PatternDrawStrategy(this);
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        this.fillContextMenu(iMenuManager);
    }

    public void openSource() {
        OpenSource.openSource(UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject()).getFirstElement());
    }

    public void resizeContent() {
        Rectangle rectangle = this.viewComp.getClientArea();
        this.dataPane.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private void setDrawStrategy(PatternDrawStrategy patternDrawStrategy) {
        if (this._curDS != null) {
            this._curDS.jcanvas(null);
        }
        this._curDS = patternDrawStrategy;
        this._curDS.jcanvas(this._canvas);
        this._canvas.setDrawStrategy(this._curDS);
        this._canvas.zoomToFit();
    }

    public void update() {
        this._canvas.zoomToFill(1.0f, 1000.0f);
        this._canvas.redraw();
    }

    protected void updateStatus(String string) {
        if (string.equals(this._status.getText())) {
            return;
        }
        this._status.setText(string);
    }

    protected void updateTitle() {
        this.dataPane.setToolTipText(this._curDS.title());
    }

    public void updateUI() {
        this._canvas.zoomToFill(1.0f, 1000.0f);
        this._canvas.redraw();
    }

    public void zoomIn(boolean bl) {
        this.initialize();
        this._canvas.isZoomIn(bl);
        this._canvas.zoomIn();
    }

    public void zoomOut(boolean bl) {
        this.initialize();
        this._canvas.isZoomOut(bl);
        this._canvas.zoomOut();
    }

    public void updateButtons() {
    }

    public void handleTimeChangedEvent() {
        Action action = this._page.baseTime();
        Action action2 = this._page.rawTime();
        int n = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");
        if (action != null) {
            action.setChecked(n == 0);
        }
        if (action2 != null) {
            action2.setChecked(n == 1);
        }
        if (this._patDS != null) {
            this._patDS.setDrawMode(n);
        }
    }

    public void refresh() {
        if (this._patDS != null && this._canvas != null && !this._canvas.canvas().isDisposed() && this._canvas.canvas().isVisible()) {
            this._patDS.redraw();
        }
    }

    public void selectionChanged() {
        if (this._canvas != null && !this._canvas.canvas().isDisposed() && this._canvas.canvas().isVisible() && !this._canvas.canvas().isFocusControl()) {
            this._canvas.redraw();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
    }

    public ISelection getSelection() {
        if (this._page == null) {
            return new StructuredSelection();
        }
        Object object = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject()).getFirstElement();
        if (object != null) {
            return new StructuredSelection(object);
        }
        return new StructuredSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
    }

    public void setSelection(ISelection iSelection) {
    }

    public JCanvas getCanvas() {
        return this._canvas;
    }

    public boolean isEmpty() {
        return this._patDS._visibleThreads.size() <= 0 && this._curDS._visibleThreads.size() <= 0;
    }

    class OpenColorDialog
    extends Action {
        public OpenColorDialog(String string) {
            super(string);
            TracePluginImages.setImageDescriptors((IAction)this, "tool16", "opengraphcolor_co.gif");
        }

        public void run() {
            GraphColorDialog graphColorDialog = new GraphColorDialog(Pattern.this.viewContainer.getShell(), TraceUIPlugin.getString("STR_GRAPH_COLOR_DLG"), null);
            graphColorDialog.open();
        }
    }

    class UpdateAction
    extends Action {
        public UpdateAction(String string) {
            super(string);
            PDPluginImages.setImageDescriptors((IAction)this, (String)"lcl16", (String)"updateviews_co.gif");
        }

        public void run() {
            ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
            profileEvent.setSource((Object)Pattern.this._page.getMOFObject());
            profileEvent.setType(32);
            UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
        }
    }
}

