/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.util.AbstractCollection;
import java.util.ArrayList;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.views.internal.GraphDrawStrategy;
import org.eclipse.hyades.trace.views.internal.JCanvas;
import org.eclipse.hyades.trace.views.internal.SinglePattern;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.PerftraceUtil;
import org.eclipse.hyades.trace.views.util.internal.SpectrumColorMap;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;

public class SinglePatternDrawStrategy
extends GraphDrawStrategy
implements KeyListener {
    public static final String ZOOM_IN = "+";
    public static final String ZOOM_OUT = "-";
    protected final float MAG_STEP = 2.0f;
    private final int PREF_TREE_WIDTH = 1000;
    private String tmpString;
    private SinglePattern _parent;
    private int _drawMode = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");
    private int _indexOfInvocation = 0;
    private TRCFullMethodInvocation _viewroot;
    private int _treewidth;
    private long _maxtime = 0L;
    private float timescale = 1.0f;
    private boolean _hidedetails = true;
    protected static final int NRLABELS = 10;
    protected static final int MAXINV = 256;
    private TRCMethodInvocation[] _drawArray = new TRCMethodInvocation[256];
    private float[] _x = new float[256];
    private float[] _y = new float[256];
    private float[] _w = new float[256];
    private float[] _h = new float[256];
    private float _canvasVisibleBottom;
    private float _canvasVisibleTop;
    private float _canvasVisibleLeft;
    private float _canvasVisibleRight;
    private ArrayList _calleeList = new ArrayList();

    public SinglePatternDrawStrategy(SinglePattern singlePattern) {
        this._parent = singlePattern;
        this.setNonPropZoom(true);
    }

    public void bgRedraw(GC gC) {
        try {
            JCanvas jCanvas = this.jcanvas();
            if (jCanvas == null || this._viewroot == null) {
                return;
            }
            Display display = Display.getCurrent();
            if (display == null) {
                display = Display.getDefault();
            }
            this._canvasVisibleBottom = jCanvas.visibleBottom();
            this._canvasVisibleTop = jCanvas.visibleTop();
            this._canvasVisibleLeft = jCanvas.visibleLeft();
            this._canvasVisibleRight = jCanvas.visibleRight();
            this._hidedetails = true;
            this.initDrawArray();
            this.drawTree(gC, (TRCMethodInvocation)this._viewroot, 0, this.cellWidth(), this.titleMargin() - (int)((float)TString.getTime((double)this._viewroot.getEntryTime()) * this.timescale));
            this.flushDrawArray(gC);
            this._hidedetails = false;
            this.initDrawArray();
            this.drawTree(gC, (TRCMethodInvocation)this._viewroot, 0, this.cellWidth(), this.titleMargin() - (int)((float)TString.getTime((double)this._viewroot.getEntryTime()) * this.timescale));
            this.flushDrawArray(gC);
            this.drawTimeMarks(gC, 0, 0);
        }
        catch (StackOverflowError stackOverflowError) {
            // empty catch block
        }
    }

    protected int cellHeight() {
        return 20;
    }

    protected int cellWidth() {
        return 20;
    }

    public int current() {
        return this._indexOfInvocation + 1;
    }

    protected void drawInvocation(GC gC, TRCMethodInvocation tRCMethodInvocation, float f, float f2, float f3, float f4, boolean bl) {
        JCanvas jCanvas = this.jcanvas();
        if (jCanvas == null) {
            return;
        }
        float f5 = jCanvas.yscale();
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        String string = tRCMethodInvocation.getMethod().getName();
        Color color = display.getSystemColor(2);
        if ((tRCMethodInvocation.getMethod().getModifier() & 0x80) != 0) {
            color = display.getSystemColor(3);
        }
        TRCTraceObject tRCTraceObject = tRCMethodInvocation.getOwningObject();
        String string2 = PerftraceUtil.getClass(tRCMethodInvocation).getName();
        Color color2 = SpectrumColorMap.color(string2);
        double d = jCanvas.xscale();
        if (bl && d > 0.5 && !this._hidedetails) {
            int n = (int)((double)f3 * d / 5.0);
            if (string.length() > n) {
                string = string.substring(0, n);
            }
            float f6 = (float)gC.getFontMetrics().getHeight() / f5;
            jCanvas.drawString(gC, string, f, f2 + f6, color);
        }
        if (d * (double)f3 > 20.0) {
            jCanvas.drawLine(gC, f, f2, f + 3.0f * f3 / 4.0f, f2, color);
            jCanvas.fillRect(gC, f + 3.0f * f3 / 4.0f, f2, f3 / 4.0f, f4, color2);
        } else {
            jCanvas.fillRect(gC, f + f3 / 4.0f, f2, f3 * 3.0f / 4.0f, f4, color2);
        }
    }

    protected void drawNextPattern() {
        if (this._viewroot != null && this._viewroot.getMethod().getInvocations().size() > 0) {
            this._viewroot = (TRCFullMethodInvocation)this._viewroot.getMethod().getInvocations().get(this._indexOfInvocation++);
        } else {
            this._viewroot = null;
            this._indexOfInvocation = 0;
        }
        this.setTitle();
        this._parent.updateButtons();
        this.jcanvas().zoomToFill(1.0f, 1000.0f);
        this.jcanvas().redraw();
    }

    protected void setTitle() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this._viewroot == null) {
            this.tmpString = "";
        } else {
            TRCMethod tRCMethod = this._viewroot.getMethod();
            if (tRCMethod != null) {
                this.tmpString = TraceUIPlugin.getString("METHOD_A");
                this.tmpString = TString.change((String)this.tmpString, (String)"%1", (String)(tRCMethod.getDefiningClass().getName() + "." + tRCMethod.getName() + tRCMethod.getSignature()));
            }
            stringBuffer.append(this.tmpString).append(" : ").append(this._indexOfInvocation + 1).append("/").append(tRCMethod.getInvocations().size());
        }
        this._parent.updateTitle(stringBuffer.toString());
    }

    protected void drawPattern(int n) {
        this._viewroot = (TRCFullMethodInvocation)this._viewroot.getMethod().getInvocations().get(n);
        this._indexOfInvocation = n;
        this.setTitle();
        this._parent.updateButtons();
        this.jcanvas().zoomToFill(1.0f, 1000.0f);
        this.jcanvas().redraw();
    }

    protected void drawPreviousPattern() {
        this._viewroot = (TRCFullMethodInvocation)this._viewroot.getMethod().getInvocations().get(--this._indexOfInvocation);
        this.setTitle();
        this._parent.updateButtons();
        this.jcanvas().zoomToFill(1.0f, 1000.0f);
        this.jcanvas().redraw();
    }

    protected void drawTimeMarks(GC gC, int n, int n2) {
        JCanvas jCanvas = this.jcanvas();
        if (this.isDirty() || jCanvas == null) {
            return;
        }
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        float f = 50.0f / jCanvas.xscale();
        float f2 = jCanvas.visibleRight();
        long l = (long)((jCanvas.visibleTop() - (float)this.titleMargin()) / this.timescale);
        long l2 = (long)(jCanvas.visibleHeight() / this.timescale);
        long l3 = l2 / 10L;
        float f3 = f2 - f;
        float f4 = (float)gC.getFontMetrics().getHeight() / jCanvas.yscale();
        if (l3 > 1L) {
            long l4 = (long)Math.pow(10.0, (int)(Math.log(l3) / Math.log(10.0)) + 1) / 2L;
            long l5 = l4 * (l / l4 + 1L);
            int n3 = 0;
            while (n3 < 20) {
                long l6 = l5 + (long)n3 * l4;
                float f5 = (float)l6 * this.timescale + (float)this.titleMargin();
                jCanvas.drawString(gC, PerftraceUtil.formatTimeValue((double)l6 / 1000000.0), (float)n + f3, (float)n2 + f5, display.getSystemColor(2), display.getSystemColor(15));
                ++n3;
            }
        }
        jCanvas.drawString(gC, TraceUIPlugin.getString("STR_GRAPH_UNIT"), (float)n + f3 - 20.0f, jCanvas.visibleTop() + f4, display.getSystemColor(2), display.getSystemColor(15));
    }

    protected void drawTree(GC gC, TRCMethodInvocation tRCMethodInvocation, int n, float f, float f2) {
        ITraceSelection iTraceSelection;
        JCanvas jCanvas = this.jcanvas();
        if (tRCMethodInvocation == null || !(tRCMethodInvocation instanceof TRCFullMethodInvocation) || jCanvas == null || this.isDirty()) {
            return;
        }
        TRCFullMethodInvocation tRCFullMethodInvocation = (TRCFullMethodInvocation)tRCMethodInvocation;
        long l = PerftraceUtil.getTime(tRCFullMethodInvocation.getEntryTime());
        long l2 = PerftraceUtil.getTime(tRCFullMethodInvocation.getExitTime());
        if (l2 < 0L) {
            l2 = this.maxTime();
        }
        if (f2 + (float)l * this.timescale > this._canvasVisibleBottom || f2 + (float)l2 * this.timescale < this._canvasVisibleTop) {
            return;
        }
        float f3 = (float)(l2 - l) * this.timescale;
        if (this._hidedetails && jCanvas.yscale() * f3 < 10.0f) {
            return;
        }
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if ((iTraceSelection = UIPlugin.getDefault().getSelectionModel(this._parent.getPage().getMOFObject())).contains((Object)tRCFullMethodInvocation) || iTraceSelection.contains((Object)tRCFullMethodInvocation.getMethod())) {
            float f4 = (float)gC.getFontMetrics().getHeight() / jCanvas.yscale();
            jCanvas.fill3DRect(gC, f + (float)(4 * n * this.cellWidth()), f2 + (float)l * this.timescale, this.treeWidth() - (4 * n + 2) * this.cellWidth(), Math.max(f3, f4), SpectrumColorMap.getSelectionColor());
        } else if (iTraceSelection.contains((Object)tRCFullMethodInvocation.getOwningObject())) {
            jCanvas.fill3DRect(gC, f + (float)((4 * n + 3) * this.cellWidth()) - 5.0f, f2 + (float)l * this.timescale, (float)(this.treeWidth() - (4 * n + 5) * this.cellWidth()) + 5.0f, f3, SpectrumColorMap.getSelectionColor());
        }
        if (f + (float)((n + 1) * this.cellWidth() * 4) < this._canvasVisibleRight) {
            Object[] objectArray = tRCFullMethodInvocation.getInvokes().toArray();
            int n2 = 0;
            while (n2 < objectArray.length) {
                TRCFullMethodInvocation tRCFullMethodInvocation2 = (TRCFullMethodInvocation)objectArray[n2];
                if ((float)PerftraceUtil.getTime(tRCFullMethodInvocation2.getEntryTime()) * this.timescale * f2 > this._canvasVisibleBottom) break;
                long l3 = PerftraceUtil.getTime(tRCFullMethodInvocation2.getExitTime());
                if (l3 < 0L) {
                    l3 = this.maxTime();
                }
                if (!((float)l3 * this.timescale + f2 < this._canvasVisibleTop)) {
                    this.drawTree(gC, (TRCMethodInvocation)tRCFullMethodInvocation2, n + 1, f, f2);
                }
                ++n2;
            }
        }
        if (n < 256) {
            this.push(gC, n, (TRCMethodInvocation)tRCFullMethodInvocation, f + (float)(n * this.cellWidth() * 4), f2 + (float)l * this.timescale, this.cellWidth() * 4, f3);
        } else {
            this.drawInvocation(gC, (TRCMethodInvocation)tRCFullMethodInvocation, f + (float)(n * this.cellWidth() * 4), f2 + (float)l * this.timescale, this.cellWidth() * 4, f3, true);
        }
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        super.fillContextMenu(iMenuManager);
    }

    protected void flushDrawArray(GC gC) {
        int n = 0;
        while (n < 256) {
            if (this._drawArray[n] != null) {
                this.drawInvocation(gC, this._drawArray[n], this._x[n], this._y[n], this._w[n], this._h[n], true);
            }
            ++n;
        }
    }

    public boolean hasCaller() {
        return this._viewroot != null && this._viewroot.getInvokedBy() != null;
    }

    public boolean hasCallee() {
        return this._calleeList.size() > 0;
    }

    public boolean hasLessElements() {
        return this._indexOfInvocation > 0;
    }

    public boolean hasMoreElements() {
        return this._viewroot != null && this._indexOfInvocation < this._viewroot.getMethod().getInvocations().size() - 1;
    }

    public float height() {
        if (this._viewroot != null) {
            return (float)(this.maxTime() - PerftraceUtil.getTime(this._viewroot.getEntryTime())) * this.timescale + (float)this.titleMargin() + (float)this.cellWidth();
        }
        return this.titleMargin() + this.cellWidth();
    }

    protected void initDrawArray() {
        int n = 0;
        while (n < 256) {
            this._drawArray[n] = null;
            this._h[n] = 0.0f;
            this._w[n] = 0.0f;
            this._y[n] = 0.0f;
            this._x[n] = 0.0f;
            ++n;
        }
    }

    public boolean isSearchable() {
        return UIPlugin.getDefault().getSelectionModel(this._parent.getPage().getMOFObject()).size() > 0;
    }

    public void keyPressed(KeyEvent keyEvent) {
        JCanvas jCanvas = this.jcanvas();
        if (jCanvas == null) {
            return;
        }
        if (keyEvent.keyCode == 262144) {
            this._controlDown = true;
        } else if (keyEvent.keyCode == 0x1000007) {
            jCanvas.zoomToFill(1.0f, 1000.0f);
        } else {
            float f = jCanvas.normX(jCanvas.getSize().width / 2);
            float f2 = jCanvas.normY(jCanvas.getSize().height / 2);
            if (keyEvent.character == ',' || keyEvent.character == '<') {
                jCanvas.zoom(1.0f, 0.5f, f, f2);
            } else if (keyEvent.character == '.' || keyEvent.character == '>') {
                jCanvas.zoom(1.0f, 2.0f, f, f2);
            }
        }
    }

    protected int maxDepth() {
        if (this._viewroot != null) {
            return this._viewroot.getStackDepth();
        }
        return 0;
    }

    protected long maxTime() {
        long l = 0L;
        if (this._viewroot != null && (l = PerftraceUtil.getTime(this._viewroot.getExitTime())) == 0L) {
            l = PerftraceUtil.getTime(this._viewroot.getOwningObject().getProcess().getLastEventTime());
        }
        return l;
    }

    public void mouseDown(MouseEvent mouseEvent) {
        if (mouseEvent.button == 3) {
            return;
        }
        super.mouseDown(mouseEvent);
    }

    public void mouseUp(MouseEvent mouseEvent) {
        if (mouseEvent.button == 3) {
            return;
        }
        super.mouseUp(mouseEvent);
    }

    public void moved(float f, float f2) {
        if (this._viewroot == null) {
            return;
        }
        TRCFullMethodInvocation tRCFullMethodInvocation = this.subtreeContains(this._viewroot, f - (float)this.cellWidth(), f2 + (float)((int)((float)PerftraceUtil.getTime(this._viewroot.getEntryTime()) * this.timescale)), 0);
        if (tRCFullMethodInvocation != null) {
            TRCTraceObject tRCTraceObject = tRCFullMethodInvocation.getOwningObject();
            String string = tRCFullMethodInvocation.getMethod().getDefiningClass().getName();
            String string2 = tRCFullMethodInvocation.getMethod().getName();
            String string3 = PerftraceUtil.getClass((TRCMethodInvocation)tRCFullMethodInvocation).getName();
            double d = tRCFullMethodInvocation.getExitTime();
            if (d == 0.0) {
                d = tRCTraceObject.getProcess().getLastEventTime();
            }
            String string4 = TraceUIPlugin.getString("A_ON_B_AT_C_TIME");
            if (this._drawMode == 1) {
                string4 = TraceUIPlugin.getString("A_ON_B_AT_RAW_TIME");
            }
            string4 = TString.change((String)string4, (String)"%1", (String)(string + "." + string2));
            string4 = TString.change((String)string4, (String)"%2", (String)(string3 + "." + tRCTraceObject.getId()));
            string4 = TString.change((String)string4, (String)"%3", (String)TString.formatTimeValue((double)tRCFullMethodInvocation.getEntryTime()));
            double d2 = d - tRCFullMethodInvocation.getEntryTime();
            double d3 = d2 - tRCFullMethodInvocation.getOverhead();
            string4 = TString.change((String)string4, (String)"%4", (String)TString.formatTimeValue((double)(this._drawMode == 1 ? d2 : d3)));
            this.status(string4);
        } else {
            long l = (long)((f2 - (float)this.titleMargin()) / this.timescale);
            String string = TraceUIPlugin.getString("TIME_X");
            string = TString.change((String)string, (String)"%1", (String)TString.formatTimeValue((double)((double)l / 1000000.0)));
            this.status(string);
        }
    }

    protected void push(GC gC, int n, TRCMethodInvocation tRCMethodInvocation, float f, float f2, float f3, float f4) {
        JCanvas jCanvas = this.jcanvas();
        if (n >= 256 || jCanvas == null) {
            return;
        }
        if (this._drawArray[n] != null) {
            float f5 = jCanvas.yscale();
            float f6 = (f2 - this._y[n]) * f5;
            float f7 = (f2 + f4 - this._y[n]) * f5;
            if ((double)f7 < 1.0) {
                return;
            }
            this.drawInvocation(gC, this._drawArray[n], this._x[n], this._y[n], this._w[n], this._h[n], (double)f6 > 8.0);
        }
        this._drawArray[n] = tRCMethodInvocation;
        this._x[n] = f;
        this._y[n] = f2;
        this._w[n] = f3;
        this._h[n] = f4;
    }

    public void redraw() {
        this.setDirty();
    }

    public void selected(float f, float f2, boolean bl, boolean bl2, boolean bl3) {
        if (this._viewroot == null) {
            return;
        }
        TRCFullMethodInvocation tRCFullMethodInvocation = this.subtreeContains(this._viewroot, f - (float)this.cellWidth(), f2 + (float)((int)((float)TString.getTime((double)this._viewroot.getEntryTime()) * this.timescale)), 0);
        ITraceSelection iTraceSelection = UIPlugin.getDefault().getSelectionModel(this._parent.getPage().getMOFObject());
        iTraceSelection.add((Object)tRCFullMethodInvocation);
        ViewSelectionChangedEvent viewSelectionChangedEvent = UIPlugin.getDefault().getViewSelectionChangedEvent();
        viewSelectionChangedEvent.setSource((Object)this._parent.getPage().getMOFObject());
        UIPlugin.getDefault().notifyViewSelectionChangedListener(viewSelectionChangedEvent);
    }

    public void showCallee() {
        if (!this.hasCallee()) {
            return;
        }
        this._viewroot = (TRCFullMethodInvocation)this._calleeList.get(this._calleeList.size() - 1);
        ((AbstractCollection)this._calleeList).remove(this._viewroot);
        this._indexOfInvocation = 0;
        this.setTitle();
        this._parent.updateButtons();
        this.jcanvas().zoomToFill(1.0f, 1000.0f);
        this.jcanvas().redraw();
    }

    public void showCaller() {
        if (!this.hasCaller()) {
            return;
        }
        this._calleeList.add(this._viewroot);
        this._viewroot = (TRCFullMethodInvocation)this._viewroot.getInvokedBy();
        this._indexOfInvocation = 0;
        this.setTitle();
        this._parent.updateButtons();
        this.jcanvas().zoomToFill(1.0f, 1000.0f);
        this.jcanvas().redraw();
    }

    public void shutdown() {
        this._viewroot = null;
        if (this._calleeList != null) {
            this._calleeList.clear();
        }
        this._drawArray = null;
        this._parent = null;
    }

    protected void status(String string) {
        this._parent.updateStatus(string);
    }

    protected TRCFullMethodInvocation subtreeContains(TRCFullMethodInvocation tRCFullMethodInvocation, float f, float f2, int n) {
        if (tRCFullMethodInvocation == null) {
            return null;
        }
        int n2 = (int)(f / (float)this.cellWidth() / 4.0f);
        if (n == n2) {
            return tRCFullMethodInvocation;
        }
        if (n > n2) {
            return null;
        }
        double d = tRCFullMethodInvocation.getOwningObject().getProcess().getLastEventTime();
        Object[] objectArray = tRCFullMethodInvocation.getInvokes().toArray();
        int n3 = 0;
        while (n3 < objectArray.length) {
            TRCFullMethodInvocation tRCFullMethodInvocation2 = (TRCFullMethodInvocation)objectArray[n3];
            double d2 = tRCFullMethodInvocation2.getExitTime();
            if (d2 == 0.0) {
                d2 = d;
            }
            if (f2 < (float)TString.getTime((double)tRCFullMethodInvocation2.getEntryTime()) * this.timescale + (float)this.titleMargin()) {
                return null;
            }
            if (d2 == 0.0 || (float)TString.getTime((double)d2) * this.timescale + (float)this.titleMargin() >= f2) {
                return this.subtreeContains(tRCFullMethodInvocation2, f, f2, n + 1);
            }
            ++n3;
        }
        return null;
    }

    protected int titleMargin() {
        return 0;
    }

    protected int treeWidth() {
        return this.cellWidth() * 4 * (10 + this.maxDepth() / 10 * 10);
    }

    public float width() {
        return this.cellWidth() * 4 * (10 + this.maxDepth() / 10 * 10);
    }

    public void setDrawMode(int n) {
        this._drawMode = n;
    }

    protected void searchPattern() {
        this._calleeList.clear();
        Object object = UIPlugin.getDefault().getSelectionModel(this._parent.getPage().getMOFObject()).getFirstElement();
        if (object == null) {
            this._indexOfInvocation = 0;
            this._viewroot = null;
            return;
        }
        if (object instanceof TRCMethodInvocation) {
            this._viewroot = (TRCFullMethodInvocation)object;
            this._indexOfInvocation = 0;
        } else if (object instanceof TRCMethod) {
            if (((TRCMethod)object).getInvocations().size() == 0) {
                this._indexOfInvocation = 0;
                this._viewroot = null;
                return;
            }
            this._viewroot = (TRCFullMethodInvocation)((TRCMethod)object).getInvocations().get(0);
            this._indexOfInvocation = 0;
        }
        this.setTitle();
        this._parent.updateButtons();
        this.resetArea();
    }
}

