/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.editors;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.internal.sdb.SDBMatchPattern;
import org.eclipse.hyades.models.internal.sdb.SDBSymptom;
import org.eclipse.hyades.models.internal.sdb.impl.SDBFactoryImpl;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.editors.IDetails;
import org.eclipse.hyades.sdb.internal.editors.SymptomDBEditor;
import org.eclipse.hyades.sdb.internal.help.ContextIds;
import org.eclipse.hyades.sdb.internal.util.GridUtil;
import org.eclipse.hyades.sdb.internal.util.RASWidgetFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.help.WorkbenchHelp;

public class SymptomDetails
extends Composite
implements IDetails,
Listener {
    Text txtSymptom;
    Text lstMatch;
    private SDBFactoryImpl objFactory = null;
    private SymptomDBEditor editor;
    private SDBSymptom currentSel = null;
    private boolean isDisplaying = false;

    public SymptomDetails(RASWidgetFactory rASWidgetFactory, Composite composite, int n) {
        super(composite, n);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(GridUtil.createFill());
        Label label = rASWidgetFactory.createLabel(this, SDbPlugin.getResourceString("STR_SYMPTOM_LABEL"), 0);
        this.txtSymptom = rASWidgetFactory.createText(this, "", 0);
        this.txtSymptom.setLayoutData((Object)GridUtil.createHorizontalFill());
        rASWidgetFactory.createCompositeSeparator(this);
        Label label2 = rASWidgetFactory.createLabel(this, SDbPlugin.getResourceString("STR_MATCH_SYMPTOM_LABEL"), 0);
        GridData gridData = new GridData(768);
        label2.setLayoutData((Object)gridData);
        this.lstMatch = rASWidgetFactory.createText(this, "", 770);
        GridData gridData2 = new GridData(1808);
        gridData2.heightHint = 45;
        gridData2.verticalSpan = 3;
        this.lstMatch.setLayoutData((Object)gridData2);
        WorkbenchHelp.setHelp((Control)this.txtSymptom, (String)ContextIds.SYMDB_EDITOR_SYMPTOM);
        WorkbenchHelp.setHelp((Control)this.lstMatch, (String)ContextIds.SYMDB_EDITOR_SYMPTOM_DESCRIPTION);
        this.txtSymptom.addListener(24, (Listener)this);
        this.lstMatch.addListener(24, (Listener)this);
    }

    public void init(SymptomDBEditor symptomDBEditor) {
        this.editor = symptomDBEditor;
        this.objFactory = SDbPlugin.getDefault().getSDBFactory();
    }

    public void display(EObject eObject) {
        this.isDisplaying = true;
        this.currentSel = (SDBSymptom)eObject;
        this.txtSymptom.setText(this.currentSel.getDescription());
        this.lstMatch.setText(this.getMatchPattern());
        this.isDisplaying = false;
    }

    public void setFocusToTextBox() {
        this.txtSymptom.setFocus();
        this.txtSymptom.setSelection(0, this.txtSymptom.getText().length());
    }

    public void handleEvent(Event event) {
        Widget widget = event.widget;
        if (widget == this.txtSymptom || widget == this.lstMatch) {
            boolean bl = false;
            if (widget == this.txtSymptom && !this.isDisplaying) {
                bl = this.editor.validateState((Widget)this.txtSymptom, this, this.currentSel.getDescription());
            }
            if (widget == this.lstMatch && !this.isDisplaying) {
                bl = this.editor.validateState((Widget)this.lstMatch, this, this.getMatchPattern());
            }
            if (this.currentSel != null && !this.isDisplaying && bl) {
                this.editor.updateUIDirtyStatus(true);
                this.editor.updateModelDirtyStatus(true);
            }
        }
    }

    private String getMatchPattern() {
        String string = "";
        EList eList = this.currentSel.getPatterns();
        String string2 = System.getProperties().getProperty("line.separator");
        int n = eList.size();
        int n2 = 0;
        while (n2 < n) {
            string = string + ((SDBMatchPattern)eList.get(n2)).getValue() + (n2 == n - 1 ? "" : string2);
            ++n2;
        }
        return string;
    }

    private ArrayList getPatternLines() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.lstMatch.getText();
        String string2 = System.getProperties().getProperty("line.separator");
        int n = 0;
        int n2 = 0;
        while (n <= string.length()) {
            n2 = string.indexOf(string2, n);
            if (n2 <= -1) {
                arrayList.add(string.substring(n));
                break;
            }
            arrayList.add(string.substring(n, n2));
            n = n2 + string2.length();
        }
        return arrayList;
    }

    public boolean updateCurrentSelection(EObject eObject) {
        this.currentSel = (SDBSymptom)eObject;
        this.currentSel.setDescription(this.txtSymptom.getText());
        EList eList = this.currentSel.getPatterns();
        int n = eList.size();
        ArrayList arrayList = this.getPatternLines();
        int n2 = arrayList.size();
        if (n2 == 1 && ((String)arrayList.get(0)).equals("")) {
            this.currentSel.getPatterns().clear();
            return true;
        }
        if (n > n2) {
            int n3 = 0;
            while (n3 < n2) {
                ((SDBMatchPattern)eList.get(n3)).setValue((String)arrayList.get(n3));
                ++n3;
            }
            ArrayList arrayList2 = new ArrayList();
            int n4 = n2;
            while (n4 < n) {
                arrayList2.add(eList.get(n4));
                ++n4;
            }
            this.currentSel.getPatterns().removeAll(arrayList2);
        } else {
            int n5 = 0;
            while (n5 < n) {
                ((SDBMatchPattern)eList.get(n5)).setValue((String)arrayList.get(n5));
                ++n5;
            }
            if (n < n2) {
                int n6 = n;
                while (n6 < n2) {
                    SDBMatchPattern sDBMatchPattern = this.objFactory.createSDBMatchPattern();
                    sDBMatchPattern.setValue((String)arrayList.get(n6));
                    this.currentSel.getPatterns().add(sDBMatchPattern);
                    ++n6;
                }
            }
        }
        return true;
    }
}

