/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events;

import java.util.Date;
import org.eclipse.hyades.logging.events.AssociatedEventImpl;
import org.eclipse.hyades.logging.events.CbeFormatter;
import org.eclipse.hyades.logging.events.CommonBaseEventAnyElementImpl;
import org.eclipse.hyades.logging.events.ComponentIdentificationImpl;
import org.eclipse.hyades.logging.events.ContextDataElementImpl;
import org.eclipse.hyades.logging.events.ExtendedDataElementImpl;
import org.eclipse.hyades.logging.events.IAssociatedEvent;
import org.eclipse.hyades.logging.events.IAssociationEngine;
import org.eclipse.hyades.logging.events.ICommonBaseEvent;
import org.eclipse.hyades.logging.events.ICommonBaseEventAnyElement;
import org.eclipse.hyades.logging.events.IComponentIdentification;
import org.eclipse.hyades.logging.events.IContextDataElement;
import org.eclipse.hyades.logging.events.IExtendedDataElement;
import org.eclipse.hyades.logging.events.IMsgCatalogToken;
import org.eclipse.hyades.logging.events.IMsgDataElement;
import org.eclipse.hyades.logging.events.ISituation;
import org.eclipse.hyades.logging.events.ISituationType;
import org.eclipse.hyades.logging.events.MsgCatalogTokenImpl;
import org.eclipse.hyades.logging.events.MsgDataElementImpl;
import org.eclipse.hyades.logging.events.SituationImpl;
import org.eclipse.hyades.logging.events.exceptions.InvalidXMLAnyElementException;
import org.eclipse.hyades.logging.events.exceptions.MissingValueException;
import org.eclipse.hyades.logging.events.exceptions.ValueTooLongException;

public final class EventItemsFactory {
    public static IComponentIdentification createIComponentIdentification(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) throws MissingValueException, ValueTooLongException {
        EventItemsFactory.assertRequiredAttributeSpecified("componentIdType", string);
        EventItemsFactory.assertRequiredAttributeSpecified("component", string2);
        EventItemsFactory.assertRequiredAttributeSpecified("subComponent", string3);
        EventItemsFactory.assertRequiredAttributeSpecified("locationType", string4);
        EventItemsFactory.assertRequiredAttributeSpecified("location", string5);
        EventItemsFactory.assertStringValueNotLongerThan("componentIdType", string, 32);
        EventItemsFactory.assertStringValueNotLongerThan("component", string2, 255);
        EventItemsFactory.assertStringValueNotLongerThan("subComponent", string3, 255);
        EventItemsFactory.assertStringValueNotLongerThan("locationType", string4, 32);
        EventItemsFactory.assertStringValueNotLongerThan("location", string5, 255);
        EventItemsFactory.assertStringValueNotLongerThan("application", string6, 255);
        EventItemsFactory.assertStringValueNotLongerThan("executionEnv", string7, 255);
        EventItemsFactory.assertStringValueNotLongerThan("instanceId", string8, 128);
        EventItemsFactory.assertStringValueNotLongerThan("processId", string9, 64);
        EventItemsFactory.assertStringValueNotLongerThan("threadId", string10, 64);
        ComponentIdentificationImpl componentIdentificationImpl = new ComponentIdentificationImpl();
        componentIdentificationImpl.setComponentIdType(string);
        componentIdentificationImpl.setComponent(string2);
        componentIdentificationImpl.setSubComponent(string3);
        componentIdentificationImpl.setLocationType(string4);
        componentIdentificationImpl.setLocation(string5);
        if (EventItemsFactory.isOptionalAttributeSpecified(string7)) {
            componentIdentificationImpl.setExecutionEnvironment(string7);
        }
        if (EventItemsFactory.isOptionalAttributeSpecified(string8)) {
            componentIdentificationImpl.setInstanceId(string8);
        }
        if (EventItemsFactory.isOptionalAttributeSpecified(string9)) {
            componentIdentificationImpl.setProcessId(string9);
        }
        if (EventItemsFactory.isOptionalAttributeSpecified(string10)) {
            componentIdentificationImpl.setThreadId(string10);
        }
        return componentIdentificationImpl;
    }

    public static IComponentIdentification createIComponentIdentification(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11) throws MissingValueException, ValueTooLongException {
        EventItemsFactory.assertRequiredAttributeSpecified("componentIdType", string);
        EventItemsFactory.assertRequiredAttributeSpecified("component", string2);
        EventItemsFactory.assertRequiredAttributeSpecified("subComponent", string3);
        EventItemsFactory.assertRequiredAttributeSpecified("locationType", string4);
        EventItemsFactory.assertRequiredAttributeSpecified("location", string5);
        EventItemsFactory.assertRequiredAttributeSpecified("componentType", string11);
        EventItemsFactory.assertStringValueNotLongerThan("componentIdType", string, 32);
        EventItemsFactory.assertStringValueNotLongerThan("component", string2, 255);
        EventItemsFactory.assertStringValueNotLongerThan("subComponent", string3, 255);
        EventItemsFactory.assertStringValueNotLongerThan("locationType", string4, 32);
        EventItemsFactory.assertStringValueNotLongerThan("location", string5, 255);
        EventItemsFactory.assertStringValueNotLongerThan("application", string6, 255);
        EventItemsFactory.assertStringValueNotLongerThan("executionEnv", string7, 255);
        EventItemsFactory.assertStringValueNotLongerThan("instanceId", string8, 128);
        EventItemsFactory.assertStringValueNotLongerThan("processId", string9, 64);
        EventItemsFactory.assertStringValueNotLongerThan("threadId", string10, 64);
        EventItemsFactory.assertStringValueNotLongerThan("componentType", string11, 512);
        ComponentIdentificationImpl componentIdentificationImpl = new ComponentIdentificationImpl();
        componentIdentificationImpl.setComponentIdType(string);
        componentIdentificationImpl.setComponent(string2);
        componentIdentificationImpl.setComponentType(string11);
        componentIdentificationImpl.setSubComponent(string3);
        componentIdentificationImpl.setLocationType(string4);
        componentIdentificationImpl.setLocation(string5);
        if (EventItemsFactory.isOptionalAttributeSpecified(string7)) {
            componentIdentificationImpl.setExecutionEnvironment(string7);
        }
        if (EventItemsFactory.isOptionalAttributeSpecified(string8)) {
            componentIdentificationImpl.setInstanceId(string8);
        }
        if (EventItemsFactory.isOptionalAttributeSpecified(string9)) {
            componentIdentificationImpl.setProcessId(string9);
        }
        if (EventItemsFactory.isOptionalAttributeSpecified(string10)) {
            componentIdentificationImpl.setThreadId(string10);
        }
        return componentIdentificationImpl;
    }

    public static IContextDataElement createIContextDataElementById(String string, String string2, String string3) throws MissingValueException {
        EventItemsFactory.assertRequiredAttributeSpecified("name", string);
        EventItemsFactory.assertRequiredAttributeSpecified("type", string2);
        EventItemsFactory.assertRequiredAttributeSpecified("id", string3);
        ContextDataElementImpl contextDataElementImpl = new ContextDataElementImpl();
        contextDataElementImpl.setName(string);
        contextDataElementImpl.setType(string2);
        contextDataElementImpl.setContextId(string3);
        return contextDataElementImpl;
    }

    public static IContextDataElement createIContextDataElementByValue(String string, String string2, String string3) throws MissingValueException {
        EventItemsFactory.assertRequiredAttributeSpecified("name", string);
        EventItemsFactory.assertRequiredAttributeSpecified("type", string2);
        EventItemsFactory.assertRequiredAttributeSpecified("value", string3);
        ContextDataElementImpl contextDataElementImpl = new ContextDataElementImpl();
        contextDataElementImpl.setName(string);
        contextDataElementImpl.setType(string2);
        contextDataElementImpl.setContextValue(string3);
        return contextDataElementImpl;
    }

    public static ICommonBaseEventAnyElement createICommonBaseEventAnyElement(String string, String string2) throws MissingValueException, InvalidXMLAnyElementException {
        EventItemsFactory.assertRequiredAttributeSpecified("anyElement", string);
        EventItemsFactory.assertRequiredAttributeSpecified("nameSpace", string2);
        CommonBaseEventAnyElementImpl commonBaseEventAnyElementImpl = new CommonBaseEventAnyElementImpl();
        commonBaseEventAnyElementImpl.setXmlAnyElement(string);
        return commonBaseEventAnyElementImpl;
    }

    public static IAssociatedEvent createIAssociatedEvent(String string, ICommonBaseEvent[] iCommonBaseEventArray) throws MissingValueException {
        if (string == null) {
            throw new MissingValueException("associationEngine");
        }
        if (iCommonBaseEventArray == null) {
            throw new MissingValueException("resolvedEvents");
        }
        AssociatedEventImpl associatedEventImpl = new AssociatedEventImpl();
        int n = 0;
        while (n < iCommonBaseEventArray.length) {
            if (iCommonBaseEventArray[n] != null) {
                associatedEventImpl.addResolvedEvent(iCommonBaseEventArray[n].getGlobalInstanceId());
            }
            ++n;
        }
        associatedEventImpl.setAssociationEngine(string);
        return associatedEventImpl;
    }

    public static IAssociatedEvent createIAssociatedEvent(String string, ICommonBaseEvent[] iCommonBaseEventArray, IAssociationEngine iAssociationEngine) throws MissingValueException {
        if (string == null) {
            throw new MissingValueException("associationEngine");
        }
        if (iCommonBaseEventArray == null) {
            throw new MissingValueException("resolvedEvents");
        }
        if (iAssociationEngine == null) {
            throw new MissingValueException("associationEngineInfo");
        }
        AssociatedEventImpl associatedEventImpl = new AssociatedEventImpl();
        int n = 0;
        while (n < iCommonBaseEventArray.length) {
            if (iCommonBaseEventArray[n] != null) {
                associatedEventImpl.addResolvedEvent(iCommonBaseEventArray[n].getGlobalInstanceId());
            }
            ++n;
        }
        associatedEventImpl.setAssociationEngine(string);
        associatedEventImpl.setAssociationEngineInfo(iAssociationEngine);
        return associatedEventImpl;
    }

    public static IAssociatedEvent createIAssociatedEvent(ICommonBaseEvent[] iCommonBaseEventArray, IAssociationEngine iAssociationEngine) throws MissingValueException {
        if (iCommonBaseEventArray == null) {
            throw new MissingValueException("resolvedEvents");
        }
        if (iAssociationEngine == null) {
            throw new MissingValueException("associationEngineInfo");
        }
        AssociatedEventImpl associatedEventImpl = new AssociatedEventImpl();
        int n = 0;
        while (n < iCommonBaseEventArray.length) {
            if (iCommonBaseEventArray[n] != null) {
                associatedEventImpl.addResolvedEvent(iCommonBaseEventArray[n].getGlobalInstanceId());
            }
            ++n;
        }
        associatedEventImpl.setAssociationEngineInfo(iAssociationEngine);
        return associatedEventImpl;
    }

    public static IMsgDataElement createIMsgDataElement(String string, String string2, String string3, String string4, String string5, String string6, String[] stringArray) throws MissingValueException, ValueTooLongException {
        IMsgCatalogToken[] iMsgCatalogTokenArray = null;
        if (stringArray != null) {
            iMsgCatalogTokenArray = new IMsgCatalogToken[stringArray.length];
            MsgCatalogTokenImpl msgCatalogTokenImpl = null;
            int n = 0;
            while (n < stringArray.length) {
                msgCatalogTokenImpl = new MsgCatalogTokenImpl();
                msgCatalogTokenImpl.setValue(stringArray[n]);
                iMsgCatalogTokenArray[n] = msgCatalogTokenImpl;
                ++n;
            }
        }
        return EventItemsFactory.createIMsgDataElement(string, string2, string3, string4, string5, string6, iMsgCatalogTokenArray);
    }

    public static IMsgDataElement createIMsgDataElement(String string, String string2, String string3, String string4, String string5, String string6, IMsgCatalogToken[] iMsgCatalogTokenArray) throws MissingValueException, ValueTooLongException {
        EventItemsFactory.assertRequiredAttributeSpecified("msgIdType", string);
        EventItemsFactory.assertRequiredAttributeSpecified("msgId", string2);
        EventItemsFactory.assertAttributesSpecifiedTogether("msgCatalog", string4, "msgCatalogType", string5);
        EventItemsFactory.assertAttributesSpecifiedTogether("msgCatalog", string4, "msgCatalogId", string6);
        EventItemsFactory.assertStringValueNotLongerThan("msgIdType", string, 32);
        EventItemsFactory.assertStringValueNotLongerThan("msgId", string2, 255);
        EventItemsFactory.assertStringValueNotLongerThan("msgLocale", string3, 5);
        EventItemsFactory.assertStringValueNotLongerThan("msgCatalog", string4, 128);
        MsgDataElementImpl msgDataElementImpl = new MsgDataElementImpl();
        msgDataElementImpl.setMsgIdType(string);
        msgDataElementImpl.setMsgId(string2);
        if (EventItemsFactory.isOptionalAttributeSpecified(string3)) {
            msgDataElementImpl.setMsgLocale(string3);
        }
        if (EventItemsFactory.isOptionalAttributeSpecified(string4)) {
            msgDataElementImpl.setMsgCatalog(string4);
            msgDataElementImpl.setMsgCatalogType(string5);
            msgDataElementImpl.setMsgCatalogId(string6);
        }
        if (iMsgCatalogTokenArray != null) {
            msgDataElementImpl.setMsgCatalogTokens(iMsgCatalogTokenArray);
        }
        return msgDataElementImpl;
    }

    public static IExtendedDataElement createIExtendedDataElement(String string, boolean bl, IExtendedDataElement[] iExtendedDataElementArray) throws MissingValueException {
        IExtendedDataElement iExtendedDataElement = EventItemsFactory.getEmptyIExtendedDataElement(string, 7, iExtendedDataElementArray);
        String[] stringArray = new String[]{new Boolean(bl).toString()};
        iExtendedDataElement.setValues(stringArray);
        return iExtendedDataElement;
    }

    public static IExtendedDataElement createIExtendedDataElement(String string, byte by, IExtendedDataElement[] iExtendedDataElementArray) throws MissingValueException {
        IExtendedDataElement iExtendedDataElement = EventItemsFactory.getEmptyIExtendedDataElement(string, 0, iExtendedDataElementArray);
        String[] stringArray = new String[]{Byte.toString(by)};
        iExtendedDataElement.setValues(stringArray);
        return iExtendedDataElement;
    }

    public static IExtendedDataElement createIExtendedDataElement(String string, short s, IExtendedDataElement[] iExtendedDataElementArray) throws MissingValueException {
        IExtendedDataElement iExtendedDataElement = EventItemsFactory.getEmptyIExtendedDataElement(string, 1, iExtendedDataElementArray);
        String[] stringArray = new String[]{Short.toString(s)};
        iExtendedDataElement.setValues(stringArray);
        return iExtendedDataElement;
    }

    public static IExtendedDataElement createIExtendedDataElement(String string, int n, IExtendedDataElement[] iExtendedDataElementArray) throws MissingValueException {
        IExtendedDataElement iExtendedDataElement = EventItemsFactory.getEmptyIExtendedDataElement(string, 2, iExtendedDataElementArray);
        String[] stringArray = new String[]{Integer.toString(n)};
        iExtendedDataElement.setValues(stringArray);
        return iExtendedDataElement;
    }

    public static IExtendedDataElement createIExtendedDataElement(String string, long l, IExtendedDataElement[] iExtendedDataElementArray) throws MissingValueException {
        IExtendedDataElement iExtendedDataElement = EventItemsFactory.getEmptyIExtendedDataElement(string, 3, iExtendedDataElementArray);
        String[] stringArray = new String[]{Long.toString(l)};
        iExtendedDataElement.setValues(stringArray);
        return iExtendedDataElement;
    }

    public static IExtendedDataElement createIExtendedDataElement(String string, float f, IExtendedDataElement[] iExtendedDataElementArray) throws MissingValueException {
        IExtendedDataElement iExtendedDataElement = EventItemsFactory.getEmptyIExtendedDataElement(string, 4, iExtendedDataElementArray);
        String[] stringArray = new String[]{Float.toString(f)};
        iExtendedDataElement.setValues(stringArray);
        return iExtendedDataElement;
    }

    public static IExtendedDataElement createIExtendedDataElement(String string, double d, IExtendedDataElement[] iExtendedDataElementArray) throws MissingValueException {
        IExtendedDataElement iExtendedDataElement = EventItemsFactory.getEmptyIExtendedDataElement(string, 5, iExtendedDataElementArray);
        String[] stringArray = new String[]{Double.toString(d)};
        iExtendedDataElement.setValues(stringArray);
        return iExtendedDataElement;
    }

    public static IExtendedDataElement createIExtendedDataElement(String string, String string2, IExtendedDataElement[] iExtendedDataElementArray) throws MissingValueException {
        EventItemsFactory.assertRequiredAttributeSpecified("stringValue", string2);
        IExtendedDataElement iExtendedDataElement = EventItemsFactory.getEmptyIExtendedDataElement(string, 6, iExtendedDataElementArray);
        String[] stringArray = new String[]{string2};
        iExtendedDataElement.setValues(stringArray);
        return iExtendedDataElement;
    }

    public static IExtendedDataElement createIExtendedDataElement(String string, Date date, IExtendedDataElement[] iExtendedDataElementArray) throws MissingValueException {
        if (date == null) {
            throw new MissingValueException("dateTimeValue");
        }
        IExtendedDataElement iExtendedDataElement = EventItemsFactory.getEmptyIExtendedDataElement(string, 8, iExtendedDataElementArray);
        String string2 = CbeFormatter.convertDateToXmlSchemaDateTime(date.getTime());
        String[] stringArray = new String[]{string2};
        iExtendedDataElement.setValues(stringArray);
        return iExtendedDataElement;
    }

    public static IExtendedDataElement createIExtendedDataElement(String string, boolean[] blArray, IExtendedDataElement[] iExtendedDataElementArray) throws MissingValueException {
        if (blArray == null) {
            throw new MissingValueException("boolValues");
        }
        IExtendedDataElement iExtendedDataElement = EventItemsFactory.getEmptyIExtendedDataElement(string, 16, iExtendedDataElementArray);
        int n = blArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = new Boolean(blArray[n2]).toString();
            ++n2;
        }
        iExtendedDataElement.setValues(stringArray);
        return iExtendedDataElement;
    }

    public static IExtendedDataElement createIExtendedDataElement(String string, boolean bl, byte[] byArray, IExtendedDataElement[] iExtendedDataElementArray) throws MissingValueException {
        if (byArray == null) {
            throw new MissingValueException("byteValues");
        }
        if (bl) {
            IExtendedDataElement iExtendedDataElement = EventItemsFactory.getEmptyIExtendedDataElement(string, 28, iExtendedDataElementArray);
            iExtendedDataElement.setHexValue(byArray);
            return iExtendedDataElement;
        }
        IExtendedDataElement iExtendedDataElement = EventItemsFactory.getEmptyIExtendedDataElement(string, 9, iExtendedDataElementArray);
        int n = byArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = Byte.toString(byArray[n2]);
            ++n2;
        }
        iExtendedDataElement.setValues(stringArray);
        return iExtendedDataElement;
    }

    public static IExtendedDataElement createIExtendedDataElement(String string, byte[] byArray, IExtendedDataElement[] iExtendedDataElementArray) throws MissingValueException {
        if (byArray == null) {
            throw new MissingValueException("byteValues");
        }
        IExtendedDataElement iExtendedDataElement = EventItemsFactory.getEmptyIExtendedDataElement(string, 9, iExtendedDataElementArray);
        int n = byArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = Byte.toString(byArray[n2]);
            ++n2;
        }
        iExtendedDataElement.setValues(stringArray);
        return iExtendedDataElement;
    }

    public static IExtendedDataElement createIExtendedDataElement(String string, char[] cArray, IExtendedDataElement[] iExtendedDataElementArray) throws MissingValueException {
        if (cArray == null) {
            throw new MissingValueException("charValues");
        }
        IExtendedDataElement iExtendedDataElement = EventItemsFactory.getEmptyIExtendedDataElement(string, 28, iExtendedDataElementArray);
        iExtendedDataElement.setHexValues(cArray);
        return iExtendedDataElement;
    }

    public static IExtendedDataElement createIExtendedDataElement(String string, short[] sArray, IExtendedDataElement[] iExtendedDataElementArray) throws MissingValueException {
        if (sArray == null) {
            throw new MissingValueException("shortValues");
        }
        IExtendedDataElement iExtendedDataElement = EventItemsFactory.getEmptyIExtendedDataElement(string, 10, iExtendedDataElementArray);
        int n = sArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = Short.toString(sArray[n2]);
            ++n2;
        }
        iExtendedDataElement.setValues(stringArray);
        return iExtendedDataElement;
    }

    public static IExtendedDataElement createIExtendedDataElement(String string, int[] nArray, IExtendedDataElement[] iExtendedDataElementArray) throws MissingValueException {
        if (nArray == null) {
            throw new MissingValueException("intValues");
        }
        IExtendedDataElement iExtendedDataElement = EventItemsFactory.getEmptyIExtendedDataElement(string, 11, iExtendedDataElementArray);
        int n = nArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = Integer.toString(nArray[n2]);
            ++n2;
        }
        iExtendedDataElement.setValues(stringArray);
        return iExtendedDataElement;
    }

    public static IExtendedDataElement createIExtendedDataElement(String string, long[] lArray, IExtendedDataElement[] iExtendedDataElementArray) throws MissingValueException {
        if (lArray == null) {
            throw new MissingValueException("longValues");
        }
        IExtendedDataElement iExtendedDataElement = EventItemsFactory.getEmptyIExtendedDataElement(string, 12, iExtendedDataElementArray);
        int n = lArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = Long.toString(lArray[n2]);
            ++n2;
        }
        iExtendedDataElement.setValues(stringArray);
        return iExtendedDataElement;
    }

    public static IExtendedDataElement createIExtendedDataElement(String string, float[] fArray, IExtendedDataElement[] iExtendedDataElementArray) throws MissingValueException {
        if (fArray == null) {
            throw new MissingValueException("floatValues");
        }
        IExtendedDataElement iExtendedDataElement = EventItemsFactory.getEmptyIExtendedDataElement(string, 13, iExtendedDataElementArray);
        int n = fArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = Float.toString(fArray[n2]);
            ++n2;
        }
        iExtendedDataElement.setValues(stringArray);
        return iExtendedDataElement;
    }

    public static IExtendedDataElement createIExtendedDataElement(String string, double[] dArray, IExtendedDataElement[] iExtendedDataElementArray) throws MissingValueException {
        if (dArray == null) {
            throw new MissingValueException("doubleValues");
        }
        IExtendedDataElement iExtendedDataElement = EventItemsFactory.getEmptyIExtendedDataElement(string, 14, iExtendedDataElementArray);
        int n = dArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = Double.toString(dArray[n2]);
            ++n2;
        }
        iExtendedDataElement.setValues(stringArray);
        return iExtendedDataElement;
    }

    public static IExtendedDataElement createIExtendedDataElement(String string, String[] stringArray, IExtendedDataElement[] iExtendedDataElementArray) throws MissingValueException {
        if (stringArray == null) {
            throw new MissingValueException("stringValues");
        }
        IExtendedDataElement iExtendedDataElement = EventItemsFactory.getEmptyIExtendedDataElement(string, 15, iExtendedDataElementArray);
        iExtendedDataElement.setValues(stringArray);
        return iExtendedDataElement;
    }

    public static IExtendedDataElement createIExtendedDataElement(String string, Date[] dateArray, IExtendedDataElement[] iExtendedDataElementArray) throws MissingValueException {
        if (dateArray == null) {
            throw new MissingValueException("dateTimeValues");
        }
        IExtendedDataElement iExtendedDataElement = EventItemsFactory.getEmptyIExtendedDataElement(string, 17, iExtendedDataElementArray);
        int n = dateArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            if (dateArray[n2] == null) {
                throw new MissingValueException("dateTimeValues[" + n2 + "]");
            }
            stringArray[n2] = CbeFormatter.convertDateToXmlSchemaDateTime(dateArray[n2].getTime());
            ++n2;
        }
        iExtendedDataElement.setValues(stringArray);
        return iExtendedDataElement;
    }

    public static ISituation createISituation(String string, ISituationType iSituationType) throws MissingValueException, ValueTooLongException {
        EventItemsFactory.assertRequiredAttributeSpecified("categoryName", string);
        EventItemsFactory.assertRequiredAttributeSpecified("situationType", iSituationType);
        EventItemsFactory.assertStringValueNotLongerThan("categoryName", string, 64);
        SituationImpl situationImpl = new SituationImpl();
        situationImpl.setCategoryName(string);
        situationImpl.setSituationType(iSituationType);
        return situationImpl;
    }

    private static IExtendedDataElement getEmptyIExtendedDataElement(String string, int n, IExtendedDataElement[] iExtendedDataElementArray) throws MissingValueException {
        EventItemsFactory.assertRequiredAttributeSpecified("name", string);
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(n);
        if (iExtendedDataElementArray != null) {
            int n2 = 0;
            while (n2 < iExtendedDataElementArray.length) {
                if (iExtendedDataElementArray[n2] != null) {
                    extendedDataElementImpl.addChildDataElement(iExtendedDataElementArray[n2]);
                }
                ++n2;
            }
        }
        return extendedDataElementImpl;
    }

    private static boolean isOptionalAttributeSpecified(String string) {
        return string != null && string.length() > 0;
    }

    private static void assertRequiredAttributeSpecified(String string, String string2) throws MissingValueException {
        if (string2 == null || string2.length() == 0) {
            throw new MissingValueException(string);
        }
    }

    private static void assertRequiredAttributeSpecified(String string, Object object) throws MissingValueException {
        if (object == null) {
            throw new MissingValueException(string);
        }
    }

    private static void assertAttributesSpecifiedTogether(String string, String string2, String string3, String string4) throws MissingValueException {
        boolean bl;
        boolean bl2 = string2 != null && string2.length() > 0;
        boolean bl3 = bl = string4 != null && string4.length() > 0;
        if (!bl2 && bl) {
            throw new MissingValueException(string);
        }
        if (bl2 && !bl) {
            throw new MissingValueException(string3);
        }
    }

    private static void assertStringValueNotLongerThan(String string, String string2, int n) throws ValueTooLongException {
        if (string2 != null && string2.length() > n) {
            throw new ValueTooLongException(string, n);
        }
    }
}

