/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.editor.internal.ControlTableEditorListener;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDModifiableVariableRepresentation;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomControlBar;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class ControlTableEditor
extends Composite
implements DisposeListener {
    public static final int VAL_CONTROL = 0;
    public static final int VAL_NAME = 1;
    public static final int VAL_DESC = 2;
    public static final int VAL_IMAGE = 3;
    public static final int VAL_SLIDER = 4;
    public static final int VAL_MODIFY = 5;
    private int style;
    private TableViewer tableViewer = null;
    private Vector datas = new Vector();
    private boolean editable = true;
    private Vector listeners = new Vector();
    private ComboBoxCellEditor comboBoxSliderCellEditor;
    private Integer[] sliderChoices = new Integer[]{new Integer(1)};
    private String[] sliderChoicesString = new String[]{"1"};
    ArrayList disposables = new ArrayList();

    public void addListener(ControlTableEditorListener controlTableEditorListener) {
        this.listeners.add(controlTableEditorListener);
    }

    public void notifyListeners(ZoomControlBar zoomControlBar) {
        int n = 0;
        while (n < this.listeners.size()) {
            ControlTableEditorListener controlTableEditorListener = (ControlTableEditorListener)this.listeners.elementAt(n);
            controlTableEditorListener.barEdited(zoomControlBar);
            ++n;
        }
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        this.dispose();
    }

    public ControlTableEditor(Composite composite, int n, Object[][] objectArray) {
        super(composite, n);
        composite.addDisposeListener((DisposeListener)this);
        this.style = n;
        int n2 = 0;
        while (n2 < this.datas.size()) {
            try {
                BarElement barElement = (BarElement)this.datas.get(n2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n2;
        }
        this.datas = new Vector();
        int n3 = 0;
        while (n3 < objectArray.length) {
            this.datas.add(new BarElement((ZoomControlBar)objectArray[n3][0], (String)objectArray[n3][1], (String)objectArray[n3][2], (Image)objectArray[n3][3], (Integer)objectArray[n3][4], (SDModifiableVariableRepresentation)objectArray[n3][5]));
            ++n3;
        }
        this.instantiate();
    }

    public void ensureControlsValid() {
        int n = 0;
        while (n < this.datas.size()) {
            BarElement barElement = (BarElement)this.datas.get(n);
            if (barElement.slider >= this.sliderChoices.length) {
                barElement.slider = new Integer(0);
            }
            ++n;
        }
        if (this.tableViewer != null) {
            this.tableViewer.refresh(true);
        }
    }

    public void setSliderChoices(Integer[] integerArray, String[] stringArray) {
        this.sliderChoices = integerArray;
        this.sliderChoicesString = stringArray;
        this.comboBoxSliderCellEditor.setItems(stringArray);
        this.ensureControlsValid();
        this.redraw();
    }

    public void setValues(Object[][] objectArray) {
        int n = 0;
        while (n < this.datas.size()) {
            try {
                BarElement barElement = (BarElement)this.datas.get(n);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n;
        }
        this.datas.clear();
        int n2 = 0;
        while (n2 < objectArray.length) {
            this.datas.add(new BarElement((ZoomControlBar)objectArray[n2][0], (String)objectArray[n2][1], (String)objectArray[n2][2], (Image)objectArray[n2][3], (Integer)objectArray[n2][4], (SDModifiableVariableRepresentation)objectArray[n2][5]));
            ++n2;
        }
        System.err.println("GRAPH THINGY - SET VALUES");
        try {
            this.tableViewer.setInput((Object)this.datas);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public Object[][] getValues() {
        Object[][] objectArray = new Object[this.datas.size()][6];
        int n = 0;
        while (n < this.datas.size()) {
            objectArray[n][0] = ((BarElement)this.datas.get((int)n)).bar;
            objectArray[n][1] = ((BarElement)this.datas.get((int)n)).name;
            objectArray[n][2] = ((BarElement)this.datas.get((int)n)).description;
            objectArray[n][3] = ((BarElement)this.datas.get((int)n)).image;
            objectArray[n][4] = ((BarElement)this.datas.get((int)n)).slider;
            objectArray[n][5] = ((BarElement)this.datas.get((int)n)).rep;
            ++n;
        }
        return objectArray;
    }

    public void dispose() {
        super.dispose();
        this.disposables.addAll(this.datas);
        EditorPlugin.DBG.info(((Object)((Object)this)).getClass() + ":disposed");
        int n = 0;
        while (n < this.disposables.size()) {
            try {
                Object e = this.disposables.get(n);
                if (e != null) {
                    if (e instanceof Widget) {
                        ((Widget)e).dispose();
                    } else if (e instanceof Color) {
                        ((Color)e).dispose();
                    } else if (e instanceof Image) {
                        ((Image)e).dispose();
                    } else {
                        try {
                            EditorPlugin.disposeObject(e);
                        }
                        catch (Throwable throwable) {
                            EditorPlugin.DBG.info("Class not found when disposing of " + e.getClass() + "/" + e + " (" + throwable + ")");
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            ++n;
        }
    }

    public void instantiate() {
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        Table table = new Table((Composite)this, 98304);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)gridData);
        this.disposables.add(table);
        TableColumn tableColumn = null;
        tableColumn = new TableColumn(table, 16384);
        tableColumn.setText(EditorPlugin.getString("TABLE_COLUMN_NAME"));
        this.disposables.add(tableColumn);
        tableColumn = new TableColumn(table, 16384);
        tableColumn.setText(EditorPlugin.getString("TABLE_COLUMN_DESCRIPTION"));
        this.disposables.add(tableColumn);
        tableColumn = new TableColumn(table, 0x1000000);
        tableColumn.setText(EditorPlugin.getString("TABLE_COLUMN_IMAGE"));
        this.disposables.add(tableColumn);
        tableColumn = new TableColumn(table, 0x1000000);
        tableColumn.setText(EditorPlugin.getString("TABLE_COLUMN_SLIDER"));
        this.disposables.add(tableColumn);
        this.comboBoxSliderCellEditor = new ComboBoxCellEditor((Composite)table, this.sliderChoicesString);
        CellEditor[] cellEditorArray = new CellEditor[]{new TextCellEditor((Composite)table), new TextCellEditor((Composite)table), new TextCellEditor((Composite)table), this.comboBoxSliderCellEditor};
        int n = 0;
        while (n < cellEditorArray.length) {
            this.disposables.add(cellEditorArray[n]);
            ++n;
        }
        ICellEditorListener iCellEditorListener = new ICellEditorListener(){

            public void applyEditorValue() {
                ControlTableEditor.this.tableViewer.getTable().setFocus();
            }

            public void cancelEditor() {
                ControlTableEditor.this.tableViewer.getTable().setFocus();
            }

            public void editorValueChanged(boolean bl, boolean bl2) {
            }
        };
        int n2 = 0;
        while (n2 < cellEditorArray.length) {
            cellEditorArray[n2].addListener(iCellEditorListener);
            ++n2;
        }
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(32, 50, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(28, 50, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(16, 30, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(16, 30, true));
        table.setLayout((Layout)tableLayout);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setColumnProperties(new String[]{"name", "description", "image", "slider"});
        this.tableViewer.setContentProvider((IContentProvider)new BarContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new BarLabelProvider());
        this.tableViewer.setCellEditors(cellEditorArray);
        this.tableViewer.setCellModifier((ICellModifier)new BarCellModifier());
    }

    public class BarCellModifier
    implements ICellModifier {
        public boolean canModify(Object object, String string) {
            new Throwable("").printStackTrace();
            BarElement barElement = (BarElement)object;
            if ("name".equals(string)) {
                return false;
            }
            if ("description".equals(string)) {
                return false;
            }
            return !"image".equals(string);
        }

        public Object getValue(Object object, String string) {
            BarElement barElement = (BarElement)object;
            if ("name".equals(string)) {
                return barElement.name;
            }
            if ("description".equals(string)) {
                return barElement.description;
            }
            if ("image".equals(string)) {
                return barElement.image;
            }
            if ("slider".equals(string)) {
                return barElement.slider;
            }
            return null;
        }

        public void modify(Object object, String string, Object object2) {
            Item item = (Item)object;
            BarElement barElement = (BarElement)item.getData();
            boolean bl = false;
            if (!"name".equals(string) && !"description".equals(string) && !"image".equals(string) && "slider".equals(string)) {
                int n;
                Control control = ControlTableEditor.this.comboBoxSliderCellEditor.getControl();
                if (control instanceof CCombo) {
                    object2 = new Integer(((CCombo)control).getSelectionIndex());
                }
                if ((n = ((Integer)object2).intValue()) > -1 && !ControlTableEditor.this.sliderChoices[n].equals(barElement.slider)) {
                    bl = true;
                    barElement.slider = ControlTableEditor.this.sliderChoices[n];
                }
            }
            if (bl) {
                ControlTableEditor.this.notifyListeners(barElement.bar);
                ControlTableEditor.this.tableViewer.refresh((Object)barElement);
            }
        }
    }

    public static class BarContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object object) {
            return ((Vector)object).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    public class BarLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object object, int n) {
            if (n == 2) {
                BarElement barElement = (BarElement)object;
                return barElement.image;
            }
            return null;
        }

        public String getColumnText(Object object, int n) {
            String string = "";
            BarElement barElement = (BarElement)object;
            switch (n) {
                case 0: {
                    string = barElement.name;
                    break;
                }
                case 1: {
                    string = barElement.description;
                    break;
                }
                case 2: {
                    if (barElement.image != null) break;
                    string = "none";
                    break;
                }
                case 3: {
                    int n2 = barElement.slider;
                    string = ControlTableEditor.this.sliderChoicesString[n2];
                }
            }
            return string;
        }
    }

    public class BarElement {
        public ZoomControlBar bar;
        public String name;
        public String description;
        public Integer slider;
        public Image image;
        public SDModifiableVariableRepresentation rep;

        public BarElement(ZoomControlBar zoomControlBar, String string, String string2, Image image, Integer n, SDModifiableVariableRepresentation sDModifiableVariableRepresentation) {
            this.bar = zoomControlBar;
            this.name = string;
            this.description = string2;
            this.image = image;
            this.slider = n;
            this.rep = sDModifiableVariableRepresentation;
        }

        public void update() {
        }
    }
}

