/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class AttributeWizardPage
extends WizardPage
implements Listener {
    public static final int EVENT_BEFORE_ACTIVATION = 3;
    private Text itemNameText;
    private Text itemDescriptionText;
    private String itemName;
    private String itemDescription;
    private Collection activationListeners = new ArrayList();
    private boolean firstActivation = true;

    public AttributeWizardPage(String string) {
        super(string);
    }

    public void dispose() {
        this.activationListeners.clear();
        super.dispose();
    }

    public void addActivationListener(Listener listener) {
        this.activationListeners.add(listener);
    }

    public void removeActivationListener(Listener listener) {
        this.activationListeners.remove(listener);
    }

    public void removeAllActivationListeners() {
        this.activationListeners.clear();
    }

    protected void invokeActivationListeners(int n) {
        Iterator iterator = this.activationListeners.iterator();
        while (iterator.hasNext()) {
            Event event = new Event();
            event.data = this;
            event.type = n;
            Listener listener = (Listener)iterator.next();
            listener.handleEvent(event);
        }
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)GridDataUtil.createFill());
        Label label = new Label(composite2, 0);
        label.setText(HyadesUIPlugin.getString("LBL_NAME"));
        this.itemNameText = new Text(composite2, 2048);
        this.itemNameText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        if (this.itemName != null) {
            this.itemNameText.setText(this.itemName);
            this.itemNameText.selectAll();
        }
        this.addControl(composite2);
        label = new Label(composite2, 0);
        label.setText(HyadesUIPlugin.getString("LBL_DESC"));
        this.itemDescriptionText = new Text(composite2, 2050);
        this.itemDescriptionText.setLayoutData((Object)GridDataUtil.createFill());
        if (this.itemDescription != null) {
            this.itemDescriptionText.setText(this.itemDescription);
        }
        this.setControl((Control)composite2);
        WorkbenchHelp.setHelp((Control)composite2, (String)(HyadesUIPlugin.getID() + ".awip0001"));
        WorkbenchHelp.setHelp((Control)this.itemNameText, (String)(HyadesUIPlugin.getID() + ".awip0002"));
        WorkbenchHelp.setHelp((Control)this.itemDescriptionText, (String)(HyadesUIPlugin.getID() + ".awip0003"));
    }

    protected void addControl(Composite composite) {
    }

    public void handleEvent(Event event) {
        if (event.type == 24) {
            if (event.widget == this.itemNameText) {
                this.itemName = this.itemNameText.getText();
                this.setPageComplete(this.validatePage());
            } else if (event.widget == this.itemDescriptionText) {
                this.itemDescription = this.itemDescriptionText.getText();
            }
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.invokeActivationListeners(3);
        }
        super.setVisible(bl);
        if (bl && this.firstActivation) {
            this.itemNameText.setFocus();
            this.firstActivation = false;
            this.itemNameText.setFocus();
            this.itemNameText.addListener(24, (Listener)this);
            this.setPageComplete(this.validatePage());
            this.setErrorMessage(null);
        }
    }

    protected boolean validatePage() {
        this.setErrorMessage(null);
        if (this.firstActivation) {
            return true;
        }
        if (this.itemNameText.getText() == null || this.itemNameText.getText().trim().length() == 0) {
            this.setErrorMessage(HyadesUIPlugin.getString("_ERROR_MIS_NAME"));
            return false;
        }
        return true;
    }

    public void setItemName(String string) {
        if (this.itemNameText == null || this.itemNameText.isDisposed()) {
            this.itemName = string;
        } else {
            this.itemNameText.setText(string);
            this.itemNameText.selectAll();
        }
    }

    public String getItemName() {
        if (this.itemNameText == null || this.itemNameText.isDisposed()) {
            return this.itemName;
        }
        return this.itemNameText.getText();
    }

    public void setItemDescription(String string) {
        if (this.itemDescriptionText == null || this.itemDescriptionText.isDisposed()) {
            this.itemDescription = string;
        } else {
            this.itemDescriptionText.setText(string);
        }
    }

    public String getItemDescription() {
        if (this.itemDescriptionText == null || this.itemDescriptionText.isDisposed()) {
            return this.itemDescription;
        }
        return this.itemDescriptionText.getText();
    }
}

