/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.actions.AbstractListenerActionDelegate;
import org.eclipse.hyades.trace.ui.internal.util.AttachInfoDialog;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.WarningDialog;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class NewSnapshotActionDelegate
extends AbstractListenerActionDelegate {
    public void doAction(Object object) throws Exception {
        if (object == null || !(object instanceof TRCAgentProxy)) {
            return;
        }
        INavigator iNavigator = (INavigator)this.getView();
        if (iNavigator == null) {
            MessageDialog.openInformation((Shell)UIPlugin.getActiveWorkbenchShell(), (String)"title", (String)"Action not available in current context");
            return;
        }
        this.run((TRCAgentProxy)object, iNavigator);
    }

    public void run(TRCAgentProxy tRCAgentProxy, INavigator iNavigator) {
        Object object;
        if (tRCAgentProxy.isActive() && tRCAgentProxy.isAttached() && UIPlugin.getDefault().getPreferenceStore().getBoolean("new_snapshot_tips") && (object = new WarningDialog(UIPlugin.getDefault().getViewer().getShell(), UIPlugin.getResourceString("NEW_SNAPSHOT_TIP_TITLE"), UIPlugin.getResourceString("NEW_SNAPSHOT_WARNING_MESSAGE"), UIPlugin.getResourceString("NEW_SNAPSHOT_WARNING_TEXT"), "new_snapshot_tips")).open() == 1) {
            return;
        }
        if (UIPlugin.getDefault().getPreferenceStore().getBoolean("profile_tips")) {
            object = new AttachInfoDialog(UIPlugin.getDefault().getViewer().getShell(), UIPlugin.getResourceString("PROFILING_TIP_TITLE"));
            object.open();
        }
        try {
            Agent agent;
            PDCoreUtil.detachAgent(tRCAgentProxy);
            object = UIPlugin.getDefault().getProfileEvent();
            ((ProfileEvent)object).setSource(tRCAgentProxy);
            ((ProfileEvent)object).setType(8);
            UIPlugin.getDefault().notifyProfileEventListener((ProfileEvent)object);
            TRCProcessProxy tRCProcessProxy = tRCAgentProxy.getProcessProxy();
            String string = tRCProcessProxy.getNode().getName();
            Node node = PDCoreUtil.profileConnect(string, String.valueOf(tRCProcessProxy.getNode().getPort()));
            if (node == null) {
                return;
            }
            Object object2 = LoadersUtils.locateAgentInstance((TRCAgentProxy)tRCAgentProxy);
            if (object2 != null && object2 instanceof Agent && (agent = (Agent)object2).isActive()) {
                if (tRCAgentProxy.isActive()) {
                    PDCoreUtil.detachAgent(tRCAgentProxy);
                    tRCAgentProxy.setActive(false);
                }
                TRCAgentProxy tRCAgentProxy2 = tRCAgentProxy;
                tRCAgentProxy = PDCoreUtil.createUniqueAgent(tRCProcessProxy, agent);
                PDCoreUtil.copyAgentProperties(tRCAgentProxy2, tRCAgentProxy);
                PDCoreUtil.doAttach(agent, tRCAgentProxy);
                PDCoreUtil.activate(tRCAgentProxy);
            }
            object = UIPlugin.getDefault().getProfileEvent();
            ((ProfileEvent)object).setSource(tRCAgentProxy);
            ((ProfileEvent)object).setType(4);
            UIPlugin.getDefault().notifyProfileEventListener((ProfileEvent)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected boolean isEnabledFor(Object object) {
        return object != null && object instanceof TRCAgentProxy && ((TRCAgentProxy)object).isActive() && ((TRCAgentProxy)object).isAttached();
    }

    protected boolean enableForMultiSelection() {
        return false;
    }

    public void dispose() {
        super.dispose();
    }
}

