/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.AttachTraceAction;
import org.eclipse.hyades.trace.ui.internal.launcher.LaunchTraceAction;
import org.eclipse.hyades.trace.ui.internal.launcher.RelaunchTraceAction;
import org.eclipse.hyades.trace.ui.internal.launcher.ToolBarAction;
import org.eclipse.hyades.trace.ui.internal.launcher.TraceAction;
import org.eclipse.hyades.trace.ui.internal.util.TraceArguments;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;

public class TraceDropDownAction
implements IWorkbenchWindowPulldownDelegate {
    private TraceAction _traceAction;
    private Vector pullDownButtonActionMap;

    public TraceDropDownAction() {
        this.getToolBarButtonActionsExtentionPoint();
        this._traceAction = new TraceAction();
    }

    private void createMenuForAction(Menu menu, Action action) {
        ActionContributionItem actionContributionItem = new ActionContributionItem((IAction)action);
        actionContributionItem.fill(menu, -1);
    }

    public void dispose() {
        if (this._traceAction != null) {
            this._traceAction.dispose();
            this._traceAction = null;
        }
    }

    protected void getToolBarButtonActionsExtentionPoint() {
        IPluginRegistry iPluginRegistry = Platform.getPluginRegistry();
        IConfigurationElement[] iConfigurationElementArray = iPluginRegistry.getConfigurationElementsFor("com.ibm.etools.pd.core", "toolBarButtonActions");
        this.pullDownButtonActionMap = new Vector();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            String string = iConfigurationElement.getAttribute("id");
            String string2 = iConfigurationElement.getAttribute("class");
            try {
                Object object = iConfigurationElement.createExecutableExtension("class");
                if (object instanceof ToolBarAction) {
                    this.pullDownButtonActionMap.add(object);
                } else {
                    System.err.println("pullDownButtonAction " + string2 + " should inherit com.ibm.etools.pd.core.launcher.DropDownAction class ! ");
                }
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            ++n;
        }
    }

    public Menu getMenu(Control control) {
        Menu menu = new Menu(control);
        ArrayList arrayList = UIPlugin.getDefault().getTraceManager().getTraces();
        int n = 0;
        while (n < arrayList.size()) {
            TraceArguments traceArguments = (TraceArguments)arrayList.get(n);
            RelaunchTraceAction relaunchTraceAction = new RelaunchTraceAction(traceArguments);
            this.createMenuForAction(menu, relaunchTraceAction);
            ++n;
        }
        if (arrayList.size() > 0) {
            new MenuItem(menu, 2);
        }
        this.createMenuForAction(menu, new LaunchTraceAction());
        this.createMenuForAction(menu, new AttachTraceAction());
        if (this.pullDownButtonActionMap != null && this.pullDownButtonActionMap.size() > 0) {
            int n2 = 0;
            while (n2 < this.pullDownButtonActionMap.size()) {
                this.createMenuForAction(menu, (ToolBarAction)((Object)this.pullDownButtonActionMap.get(n2)));
                ++n2;
            }
        }
        return menu;
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
    }

    public void run(IAction iAction) {
        this._traceAction.run();
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }
}

