/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.CList;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TraceLogUI
implements SelectionListener,
ModifyListener {
    private CList _list;
    private Button _delete;
    private Button _addAgent;
    private Label _newAgentLabel;
    private Text _newAgent;

    protected void addAgent() {
        String string = this._newAgent.getText().trim();
        this.addAgent(string);
    }

    public void addAgent(String string) {
        this._list.add(string);
        this._list.getList().setSelection(this._list.getList().indexOf(string));
        this._newAgent.setText("");
        this._newAgent.setFocus();
        this._addAgent.setEnabled(false);
        this._delete.setEnabled(true);
    }

    public Composite createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)GridUtil.createFill());
        this._list = new CList(composite2, "");
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 3;
        composite3.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = 120;
        composite3.setLayoutData((Object)gridData);
        this._delete = new Button(composite3, 8);
        this._delete.setText(UIPlugin.getResourceString("REMOVE_AGENT"));
        this._delete.setLayoutData((Object)GridUtil.createHorizontalFill());
        Composite composite4 = new Composite(composite3, 0);
        composite4.setLayout((Layout)gridLayout);
        composite4.setLayoutData((Object)GridUtil.createFill());
        Composite composite5 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 3;
        composite5.setLayout((Layout)gridLayout);
        composite5.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._newAgentLabel = new Label(composite5, 0);
        this._newAgentLabel.setText(UIPlugin.getResourceString("ADD_AGENT"));
        this._newAgent = new Text(composite5, 2048);
        this._newAgent.setLayoutData((Object)GridUtil.createHorizontalFill());
        Composite composite6 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 1;
        composite6.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.widthHint = 120;
        composite6.setLayoutData((Object)gridData);
        this._addAgent = new Button(composite6, 8);
        this._addAgent.setText(UIPlugin.getResourceString("ADD_AGENT_BUTTON"));
        this._addAgent.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._addAgent.setEnabled(false);
        this._delete.setEnabled(false);
        this._delete.addSelectionListener((SelectionListener)this);
        this._addAgent.addSelectionListener((SelectionListener)this);
        this._newAgent.addModifyListener((ModifyListener)this);
        this._newAgent.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 4) {
                    TraceLogUI.this.addAgent();
                    traverseEvent.doit = false;
                }
            }
        });
        this._list.getList().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TraceLogUI.this._delete.setEnabled(TraceLogUI.this._list.getSelectedIndices().length > 0);
            }
        });
        this._newAgent.setFocus();
        return composite2;
    }

    public String[] getAgents() {
        return this._list.getList().getItems();
    }

    public void modifyText(ModifyEvent modifyEvent) {
        if (modifyEvent.widget == this._newAgent) {
            this._addAgent.setEnabled(!this._newAgent.getText().trim().equals(""));
        }
    }

    protected void removeAgent() {
        int n = this._list.getSelectedIndex();
        this._list.remove(n);
        if (this._list.getItemCount() > 0) {
            if (n == 0) {
                this._list.setSelectedIndex(0);
            }
            if (n < this._list.getItemCount()) {
                this._list.setSelectedIndex(n);
            } else if (n - 1 < this._list.getItemCount()) {
                this._list.setSelectedIndex(n - 1);
            } else {
                this._list.setSelectedIndex(0);
            }
        } else {
            this._delete.setEnabled(false);
        }
        this._newAgent.setFocus();
        this._newAgent.selectAll();
    }

    public void reset() {
        this._list.getList().removeAll();
        this._delete.setEnabled(false);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this._addAgent) {
            this.addAgent();
        } else if (selectionEvent.widget == this._delete) {
            this.removeAgent();
        }
    }
}

