/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.loaders.util.InvalidXMLException;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.internal.ui.PDProjectViewer;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceLocationUI;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.wizard.ImportTraceRange;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.ui.help.WorkbenchHelp;

public class ImportTracePage1
extends WizardDataTransferPage
implements Listener,
ModifyListener,
SelectionListener,
IRunnableWithProgress {
    protected Button sourceBrowseButton;
    protected ImportTraceRange _option;
    protected String fError;
    protected String fInputLog = "";
    protected TRCMonitor fMonitor;
    protected Text sourceNameField;
    protected TraceLocationUI _location;
    protected double fStartPercentage;
    protected double fStopPercentage;
    private Button _showExecFlow;
    private Button _showExecStatistic;
    private Button _showHeapStatistic;
    private Composite _detailsGroup;
    private Label _description;
    private Shell shell;
    private long logLength;
    private int collectionMode = 0;

    public ImportTracePage1(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        super("xmlTraceFileImportPage1");
        this.setTitle(UIPlugin.getResourceString("IMPORT_XML_TRACE_PTITLE"));
        this.setDescription(UIPlugin.getResourceString("IMPORT_XML_TRACE_PDESC"));
        this.setImageDescriptor(PDPluginImages.getImageDescriptor("launch_wiz.gif"));
        this.shell = iWorkbench.getActiveWorkbenchWindow().getShell();
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(272));
        composite2.setSize(composite2.computeSize(-1, -1));
        this.createSourceGroup(composite2);
        this.createSpacer(composite2);
        this.createBoldLabel(composite2, UIPlugin.getResourceString("STR_IMPORT_XML_PSOURCEQ"));
        this._location = new TraceLocationUI();
        this._location.createControl(composite2);
        this._location.getLocationLabel().setText(UIPlugin.getResourceString("STR_IMPORT_FOLDER"));
        this.createSpacer(composite2);
        this._option = new ImportTraceRange((WizardPage)this);
        this._option.createControl(composite2);
        this.addStatisticOption(composite2);
        this.createSpacer(composite2);
        this._option.getWholeFileBtn().addSelectionListener((SelectionListener)this);
        this._option.getInRangeBtn().addSelectionListener((SelectionListener)this);
        this.restoreWidgetValues();
        this.updateWidgetEnablements();
        this.setPageComplete(this.determinePageCompletion());
        this.setControl((Control)composite2);
        PDProjectExplorer pDProjectExplorer = null;
        PDProjectViewer pDProjectViewer = null;
        IWorkbenchPage iWorkbenchPage = UIPlugin.getActiveWorkbenchWindow().getActivePage();
        if (iWorkbenchPage != null && iWorkbenchPage.getPerspective().getId().equals("org.eclipse.hyades.trace.internal.ui.tracePerspective")) {
            pDProjectExplorer = UIPlugin.getDefault().getViewer();
        }
        IProject iProject = null;
        TRCMonitor tRCMonitor = null;
        if (pDProjectExplorer != null) {
            pDProjectViewer = (PDProjectViewer)pDProjectExplorer.getViewer();
        }
        if (pDProjectViewer != null) {
            iProject = pDProjectViewer.getSelectionProject();
            tRCMonitor = pDProjectViewer.getSelectionMonitor();
        }
        this._location.getLocation().addModifyListener((ModifyListener)this);
        this._location.getMonitor().addModifyListener((ModifyListener)this);
        this.sourceNameField.addModifyListener((ModifyListener)this);
        if (iProject != null) {
            this._location.setLocation(iProject.getName());
        }
        if (tRCMonitor != null) {
            this._location.setMonitor(tRCMonitor.getName());
        }
    }

    public boolean finish() {
        File file = new File(this.sourceNameField.getText().trim());
        if (!file.exists()) {
            this.fError = UIPlugin.getResourceString("STR_ERROR_XML_NOTFOUND");
            this.fError = HyadesUtil.change(this.fError, "%1", this.fInputLog);
            String string = UIPlugin.getResourceString("STR_ERROR_LOAD_XML");
            Status status = new Status(2, "org.eclipse.core.resources", 566, this.fError, null);
            ErrorDialog.openError((Shell)this.getShell(), (String)UIPlugin.getResourceString("TRACE_MSG"), (String)string, (IStatus)status);
            return false;
        }
        if (!file.canRead()) {
            this.fError = UIPlugin.getResourceString("STR_ERROR_XML_READFILE");
            this.fError = HyadesUtil.change(this.fError, "%1", this.fInputLog);
            String string = UIPlugin.getResourceString("STR_ERROR_LOAD_XML");
            Status status = new Status(2, "org.eclipse.core.resources", 566, this.fError, null);
            ErrorDialog.openError((Shell)this.getShell(), (String)UIPlugin.getResourceString("TRACE_MSG"), (String)string, (IStatus)status);
            return false;
        }
        this.fError = null;
        if (this._option.getInRangeSelection()) {
            this.fStartPercentage = this._option.getStartRange();
            this.fStopPercentage = this._option.getStopRange();
        } else {
            this.fStartPercentage = 0.0;
            this.fStopPercentage = 100.0;
        }
        return this.loadXMLTrace();
    }

    public void handleEvent(Event event) {
        if (event.widget == this.sourceBrowseButton) {
            this.handleSourceBrowseButtonPressed();
        }
    }

    public void modifyText(ModifyEvent modifyEvent) {
        this.setPageComplete(this.determinePageCompletion());
    }

    public void run(IProgressMonitor iProgressMonitor) {
        Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            public void run() {
                if (ImportTracePage1.this._showHeapStatistic.getSelection()) {
                    ImportTracePage1.this.collectionMode = 0;
                } else if (ImportTracePage1.this._showExecStatistic.getSelection()) {
                    ImportTracePage1.this.collectionMode = 3;
                } else if (ImportTracePage1.this._showExecFlow.getSelection()) {
                    ImportTracePage1.this.collectionMode = 2;
                }
            }
        });
        try {
            File file = new File(this.fInputLog);
            if (!PDCoreUtil.isZipFile(this.fInputLog)) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                this.logLength = file.length();
                XMLLoader xMLLoader = new XMLLoader(this.fMonitor);
                xMLLoader.setCollectionMode(this.collectionMode);
                this.importFile(iProgressMonitor, xMLLoader, file, bufferedInputStream);
            } else {
                ZipFile zipFile = new ZipFile(file);
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                boolean bl = false;
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration.nextElement();
                    this.logLength = zipEntry.getSize();
                    XMLLoader xMLLoader = new XMLLoader(this.fMonitor);
                    xMLLoader.setCollectionMode(this.collectionMode);
                    this.importFile(iProgressMonitor, xMLLoader, file, zipFile.getInputStream(zipEntry));
                }
            }
        }
        catch (IOException iOException) {
            this.fError = UIPlugin.getResourceString("STR_IMPORT_IOEXCEPTION_ERROR_");
            this.fError = HyadesUtil.change(this.fError, "%1", iOException.getMessage());
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this._showExecStatistic) {
            this._description.setText(UIPlugin.getResourceString("STR_ANALYZE_EXE_TIME"));
        } else if (selectionEvent.widget == this._showHeapStatistic) {
            this._description.setText(UIPlugin.getResourceString("STR_ANALYZE_HEAP"));
        } else if (selectionEvent.widget == this._showExecFlow) {
            this._description.setText(UIPlugin.getResourceString("Show Execution flow graphical details."));
        } else {
            this.setPageComplete(this.determinePageCompletion());
        }
    }

    protected boolean allowNewContainerName() {
        return true;
    }

    protected Button createButton(Composite composite, int n, String string, boolean bl) {
        ++((GridLayout)composite.getLayout()).numColumns;
        Button button = new Button(composite, 8);
        GridData gridData = new GridData(256);
        gridData.heightHint = this.convertVerticalDLUsToPixels(14);
        gridData.widthHint = this.convertHorizontalDLUsToPixels(63);
        button.setLayoutData((Object)gridData);
        button.setData((Object)new Integer(n));
        button.setText(string);
        if (bl) {
            Shell shell = composite.getShell();
            if (shell != null) {
                shell.setDefaultButton(button);
            }
            button.setFocus();
        }
        button.setFont(composite.getFont());
        return button;
    }

    protected void createSourceGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        new Label(composite2, 0).setText(UIPlugin.getResourceString("STR_IMPORT_XML_SOURCE"));
        this.sourceNameField = new Text(composite2, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.sourceNameField.setLayoutData((Object)gridData);
        this.sourceBrowseButton = new Button(composite2, 8);
        this.sourceBrowseButton.setText(UIPlugin.getResourceString("BROWSE"));
        this.sourceBrowseButton.addListener(13, (Listener)this);
        this.sourceBrowseButton.setLayoutData((Object)new GridData(256));
        this.sourceNameField.setFocus();
        WorkbenchHelp.setHelp((Control)composite, (String)(UIPlugin.getPluginId() + ".xmli0000"));
    }

    protected boolean determinePageCompletion() {
        boolean bl;
        boolean bl2 = bl = this.validateSourceGroup() && this.validateDestinationGroup() && this.validateOptionsGroup();
        if (bl) {
            this.setErrorMessage(null);
        }
        return bl;
    }

    protected void handleSourceBrowseButtonPressed() {
        String string = this.sourceNameField.getText();
        FileDialog fileDialog = new FileDialog(this.sourceNameField.getShell());
        fileDialog.setFilterPath(string);
        fileDialog.setFilterExtensions(new String[]{"*.trcxml", "*.*"});
        fileDialog.open();
        String string2 = fileDialog.getFileName();
        if (string2 != null && !string2.equals("")) {
            this.sourceNameField.setText(fileDialog.getFilterPath() + File.separator + string2);
        }
    }

    protected void updateWidgetEnablements() {
        boolean bl = this.determinePageCompletion();
        this.setPageComplete(bl);
        if (bl) {
            this.setMessage(null);
        }
        super.updateWidgetEnablements();
    }

    protected boolean validateOptionsGroup() {
        return !this._location.getLocation().getText().trim().equals("") && !this._location.getMonitor().getText().trim().equals("") && (this._option.getWholeFileSelection() || this._option.getInRangeSelection() && this._option.checkRegionValue() == null);
    }

    protected boolean validateSourceGroup() {
        return !this.sourceNameField.getText().trim().equals("");
    }

    private void addStatisticOption(Composite composite) {
        Group group = new Group(composite, 0);
        GridData gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 2;
        group.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        group.setLayout((Layout)gridLayout);
        this._showHeapStatistic = new Button((Composite)group, 16);
        this._showHeapStatistic.setText(UIPlugin.getResourceString("HEAP_STAT"));
        this._showExecStatistic = new Button((Composite)group, 16);
        this._showExecStatistic.setText(UIPlugin.getResourceString("EXEC_STAT"));
        this._showExecFlow = new Button((Composite)group, 16);
        this._showExecFlow.setText(UIPlugin.getResourceString("FULL_DATA"));
        this._description = new Label(composite, 64);
        gridData = new GridData();
        gridData.horizontalIndent = 20;
        gridData.widthHint = 375;
        this._description.setLayoutData((Object)gridData);
        this._description.setLayoutData((Object)gridData);
        this._description.setText(UIPlugin.getResourceString("STR_ANALYZE_HEAP"));
        this._showHeapStatistic.setSelection(true);
        this._showHeapStatistic.addSelectionListener((SelectionListener)this);
        this._showExecStatistic.addSelectionListener((SelectionListener)this);
        this._showExecFlow.addSelectionListener((SelectionListener)this);
    }

    private String createModel(TRCMonitor tRCMonitor, String string) {
        this.fMonitor = tRCMonitor;
        this.fInputLog = string;
        try {
            this.getWizard().getContainer().run(true, true, (IRunnableWithProgress)this);
        }
        catch (InterruptedException interruptedException) {
            return "";
        }
        catch (InvocationTargetException invocationTargetException) {
            return invocationTargetException.getTargetException().getMessage();
        }
        return this.fError;
    }

    private void handleOutOfMemoryError() {
        String string = UIPlugin.getResourceString("IMPORT_OUT_OF_MEMORY_ERROR_");
        if (this.shell != null) {
            final Status status = new Status(2, "org.eclipse.core.resources", 566, string, null);
            this.shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ErrorDialog.openError((Shell)ImportTracePage1.this.shell, (String)UIPlugin.getResourceString("TRACE_MSG"), (String)UIPlugin.getResourceString("OUT_OF_MEMORY_ERROR_TITLE"), (IStatus)status);
                }
            });
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void importFile(IProgressMonitor var1_1, XMLLoader var2_2, File var3_3, InputStream var4_4) throws OutOfMemoryError {
        block35: {
            block32: {
                block34: {
                    block29: {
                        block30: {
                            block31: {
                                try {
                                    var5_5 = false;
                                    var6_6 = 1;
                                    var7_7 = 1;
                                    try {
                                        var8_8 = false;
                                        var10_13 = var9_11 = 65536;
                                        var11_14 = new byte[var10_13];
                                        var12_15 = new byte[var10_13];
                                        var13_16 = 0L;
                                        var15_17 = 0;
                                        var16_18 = this.logLength / 100L;
                                        var16_18 *= this.fStartPercentage;
                                        var18_19 = this.logLength;
                                        if (this.fStopPercentage != 100.0) {
                                            var18_19 /= 100.0;
                                            var18_19 *= this.fStopPercentage;
                                        }
                                        var1_1.beginTask(this.fInputLog, (int)(var18_19 - var16_18));
                                        var20_20 = 0;
                                        var21_21 = 0;
                                        block15: while (true) {
                                            if (var15_17 <= -1) {
                                                if (var7_7 == var6_6) break;
                                                var4_4.close();
                                                this.fError = UIPlugin.getResourceString("STR_EOF_REACHED_ERROR_");
                                                this.fError = HyadesUtil.change(this.fError, "%1", this.fInputLog);
                                                this.fError = HyadesUtil.change(this.fError, "%2", String.valueOf(var7_7));
                                                break block29;
                                            }
                                            if (var1_1.isCanceled()) {
                                                var4_4.close();
                                                var5_5 = true;
                                                throw new OperationCanceledException();
                                            }
                                            var21_21 = 0;
                                            var15_17 = var4_4.read(var11_14);
                                            while (true) {
                                                if (var21_21 >= var15_17) {
                                                    this.fError = null;
                                                    continue block15;
                                                }
                                                var12_15[var20_20++] = var11_14[var21_21];
                                                if (var20_20 == var10_13) {
                                                    var22_22 = var12_15;
                                                    var12_15 = new byte[var10_13 += var9_11];
                                                    System.arraycopy(var22_22, 0, var12_15, 0, var20_20);
                                                    continue;
                                                }
                                                if (var11_14[var21_21++] != 10) continue;
                                                ++var6_6;
                                                if (var12_15[1] != 63) {
                                                    try {
                                                        var13_16 += (long)var20_20;
                                                        if ((double)var13_16 > var18_19 && var18_19 != (double)var3_3.length()) {
                                                            var22_23 = new String("</TRACE>").getBytes();
                                                            var2_2.loadEvent(var22_23, 8, true);
                                                            var1_1.done();
                                                            var4_4.close();
                                                            var25_26 = null;
                                                            if (var4_4 == null) break block30;
                                                            break block31;
                                                        }
                                                        var22_24 = this.loadLine(var6_6, var13_16, var16_18, var18_19);
                                                        var2_2.loadEvent(var12_15, var20_20, var22_24);
                                                    }
                                                    catch (InvalidXMLException var22_25) {
                                                        var1_1.worked(var20_20);
                                                        var4_4.close();
                                                        var13_16 -= (long)var20_20;
                                                        continue;
                                                    }
                                                    catch (OutOfMemoryError var23_34) {
                                                        var4_4.close();
                                                        this.handleOutOfMemoryError();
                                                        throw var23_34;
                                                    }
                                                }
                                                var7_7 = var6_6;
                                                var1_1.worked(var20_20);
                                                var20_20 = 0;
                                            }
                                            break;
                                        }
                                    }
                                    catch (IOException var8_9) {
                                        this.fError = UIPlugin.getResourceString("STR_IMPORT_IOEXCEPTION_ERROR_");
                                        this.fError = HyadesUtil.change(this.fError, "%1", var8_9.getMessage());
                                    }
                                    catch (Exception var9_12) {
                                        this.fError = var5_5 != false ? "" : UIPlugin.getResourceString("STR_IMPORT_EXCEPTION_ERROR_");
                                        this.fError = HyadesUtil.change(this.fError, "%1", this.fInputLog);
                                        this.fError = HyadesUtil.change(this.fError, "%2", String.valueOf(var7_7));
                                        this.fError = HyadesUtil.change(this.fError, "%3", var9_12.getMessage());
                                    }
                                    if (var4_4 != null) {
                                        try {
                                            var4_4.close();
                                        }
                                        catch (IOException var8_10) {
                                            // empty catch block
                                        }
                                    }
                                    var1_1.done();
                                    break block32;
                                }
                                catch (Throwable var24_35) {
                                    var25_29 = null;
                                    if (var4_4 != null) {
                                        var2_2.cleanUp();
                                        try {
                                            var4_4.close();
                                        }
                                        catch (IOException var26_33) {
                                            // empty catch block
                                        }
                                    }
                                    var1_1.done();
                                    throw var24_35;
                                }
                            }
                            var2_2.cleanUp();
                            ** try [egrp 4[TRYBLOCK] [6 : 620->628)] { 
lbl111:
                            // 1 sources

                            var4_4.close();
                            break block30;
lbl113:
                            // 1 sources

                            catch (IOException var26_30) {
                                // empty catch block
                            }
                        }
                        var1_1.done();
                        return;
                    }
                    var25_27 = null;
                    if (var4_4 != null) {
                        var2_2.cleanUp();
                        ** try [egrp 4[TRYBLOCK] [6 : 620->628)] { 
lbl123:
                        // 1 sources

                        var4_4.close();
                        break block34;
lbl125:
                        // 1 sources

                        catch (IOException var26_31) {
                            // empty catch block
                        }
                    }
                }
                var1_1.done();
                return;
            }
            var25_28 = null;
            if (var4_4 != null) {
                var2_2.cleanUp();
                ** try [egrp 4[TRYBLOCK] [6 : 620->628)] { 
lbl135:
                // 1 sources

                var4_4.close();
                break block35;
lbl137:
                // 1 sources

                catch (IOException var26_32) {
                    // empty catch block
                }
            }
        }
        var1_1.done();
    }

    private boolean loadLine(int n, double d, double d2, double d3) {
        if (n <= 7) {
            return true;
        }
        return d >= d2 && d <= d3;
    }

    private boolean loadXMLTrace() {
        IWorkbenchPage iWorkbenchPage = UIPlugin.getActivePage();
        if (iWorkbenchPage == null) {
            return false;
        }
        IContainer iContainer = PDCoreUtil.createContainer((IPath)new Path(this._location.getLocation().getText().trim()));
        if (iContainer == null) {
            return false;
        }
        TRCMonitor tRCMonitor = PDCoreUtil.createMonitor(iContainer, this._location.getMonitor().getText().trim());
        this.fError = this.createModel(tRCMonitor, this.sourceNameField.getText().trim());
        ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
        profileEvent.setSource(null);
        profileEvent.setType(128);
        UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
        if (this.fError != null) {
            if (!this.fError.equals("")) {
                String string = UIPlugin.getResourceString("STR_ERROR_LOAD_XML");
                Status status = new Status(2, "org.eclipse.core.resources", 566, this.fError, null);
                ErrorDialog.openError((Shell)this.getShell(), (String)UIPlugin.getResourceString("TRACE_MSG"), (String)string, (IStatus)status);
            }
            return false;
        }
        return true;
    }

    static final class FileInfo {
        InputStream inputStream;
        long fileLength;

        FileInfo() {
        }
    }
}

