/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceNodeUI;
import org.eclipse.hyades.trace.ui.internal.wizard.RelaunchWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class RelaunchNodeWizardPage
extends WizardPage
implements ModifyListener {
    protected TraceNodeUI _nodeUI;

    public RelaunchNodeWizardPage(String string) {
        super(string);
        this.setTitle(UIPlugin.getResourceString("NODE_PROPERTIES_TITLE"));
        this.setDescription(UIPlugin.getResourceString("RELAUNCH_NODE_PROPERTIES_DESC"));
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 5;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 500;
        composite2.setLayoutData((Object)gridData);
        this._nodeUI = new TraceNodeUI(false);
        this._nodeUI.createControl(composite2);
        this._nodeUI.setShowDelta(false);
        this._nodeUI.getPortNumberUI().addModifyListener((ModifyListener)this);
        this.setControl((Control)composite2);
        this._nodeUI.setEnabled(false);
        this.populateData();
        this.setPageComplete(true);
        WorkbenchHelp.setHelp((Control)composite, (String)(UIPlugin.getPluginId() + ".rnwp0000"));
    }

    public TraceNodeUI getNodeUI() {
        return this._nodeUI;
    }

    public boolean finish() {
        return true;
    }

    public void modifyText(ModifyEvent modifyEvent) {
        this.setPageComplete(true);
        String string = this._nodeUI.getPortNumberUI().getText().trim();
        if (modifyEvent.widget == this._nodeUI.getPortNumberUI()) {
            try {
                int n = Integer.parseInt(string);
                if (n < 0) {
                    this.setErrorMessage(UIPlugin.getResourceString("RAC_INVALID_PORT"));
                    this.setPageComplete(false);
                    return;
                }
                this.setErrorMessage(null);
                this.setPageComplete(true);
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(UIPlugin.getResourceString("RAC_INVALID_PORT"));
                this.setPageComplete(false);
            }
        }
    }

    protected void populateData() {
        TRCNode tRCNode = ((RelaunchWizard)this.getWizard()).getNode();
        if (tRCNode == null) {
            return;
        }
        this._nodeUI.getNodeNameUI().setText(tRCNode.getName());
        this._nodeUI.getPortNumberUI().setText(String.valueOf(tRCNode.getPort()));
        if (tRCNode.getIpAddress() != null) {
            this._nodeUI.getAddressUI().setText(tRCNode.getIpAddress());
        }
    }
}

