/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.preferences;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.analysis.engine.AnalysisEnginePlugin;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.LogUIPluginImages;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.sdb.internal.wizard.ImportSymptomDBWizard;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.help.WorkbenchHelp;

public class SymptomDBUI
implements SelectionListener {
    private Composite result;
    private Table _list;
    private Button _moveUp;
    private Button _moveDown;
    private Button _selAll;
    private Button _unselAll;
    private Button _restoreDefaults;
    private ArrayList _data = new ArrayList();
    private Item _oldSelection;
    private Button _add;
    private static final int _restoreDefaultsButtonId = 1025;
    private static final int SIZING_WIZARD_WIDTH = 500;

    public Composite createControl(Composite composite) {
        this.result = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.result.setLayout((Layout)gridLayout);
        GridData gridData = GridUtil.createFill();
        gridData.heightHint = 320;
        gridData.widthHint = 400;
        this.result.setLayoutData((Object)gridData);
        Label label = new Label(this.result, 0);
        gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 3;
        gridData.heightHint = 10;
        label.setLayoutData((Object)gridData);
        Label label2 = new Label(this.result, 0);
        label2.setText(LogUIPlugin.getResourceString("STR_SYMPTOM_DB_DLG_TEXT"));
        Composite composite2 = new Composite(this.result, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        gridData = GridUtil.createFill();
        gridData.heightHint = 250;
        gridData.horizontalSpan = 3;
        composite2.setLayoutData((Object)gridData);
        this._list = new Table(composite2, 2336);
        gridData = GridUtil.createFill();
        this._list.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        gridData = new GridData();
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        composite3.setLayoutData((Object)gridData);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 1;
        composite3.setLayout((Layout)gridLayout2);
        this._moveUp = new Button(composite3, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this._moveUp.setLayoutData((Object)gridData);
        this._moveUp.setText(LogUIPlugin.getResourceString("STR_COL_DLG_UP"));
        this._moveDown = new Button(composite3, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this._moveDown.setLayoutData((Object)gridData);
        this._moveDown.setText(LogUIPlugin.getResourceString("STR_COL_DLG_DOWN"));
        this._selAll = new Button(composite3, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this._selAll.setLayoutData((Object)gridData);
        this._selAll.setText(LogUIPlugin.getResourceString("STR_COL_DLG_SEL_ALL"));
        this._unselAll = new Button(composite3, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this._unselAll.setLayoutData((Object)gridData);
        this._unselAll.setText(LogUIPlugin.getResourceString("STR_COL_DLG_USEL_ALL"));
        label = new Label(composite3, 0);
        this._add = new Button(composite3, 0);
        gridData = GridUtil.createHorizontalFill();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 2;
        this._add.setLayoutData((Object)gridData);
        this._add.setText(LogUIPlugin.getResourceString("STR_ADD_DB"));
        this._list.addSelectionListener((SelectionListener)this);
        this._moveUp.addSelectionListener((SelectionListener)this);
        this._moveDown.addSelectionListener((SelectionListener)this);
        this._selAll.addSelectionListener((SelectionListener)this);
        this._unselAll.addSelectionListener((SelectionListener)this);
        this._add.addSelectionListener((SelectionListener)this);
        this._moveUp.setEnabled(false);
        this._moveDown.setEnabled(false);
        this._selAll.setEnabled(false);
        this._unselAll.setEnabled(false);
        WorkbenchHelp.setHelp((Control)this._list, (String)ContextIds.SYMDB_PREF_DATABASE);
        return this.result;
    }

    public ArrayList getData() {
        return this._data;
    }

    protected void moveDown(int n) {
        TableItem tableItem = this._list.getItem(n);
        ColumnData columnData = (ColumnData)tableItem.getData();
        TableItem tableItem2 = new TableItem(this._list, 32, n + 2);
        tableItem2.setImage(LogUIPluginImages.getImage("symptomdb_obj.gif"));
        tableItem2.setChecked(tableItem.getChecked());
        tableItem2.setText(tableItem.getText());
        tableItem2.setData((Object)columnData);
        tableItem2.setGrayed(tableItem.getGrayed());
        this._list.remove(n);
        this._list.select(n + 1);
    }

    protected void moveUp(int n) {
        TableItem tableItem;
        TableItem tableItem2 = this._list.getItem(n);
        ColumnData columnData = (ColumnData)tableItem2.getData();
        if (n > 0) {
            tableItem = this._list.getItem(n - 1);
            ColumnData columnData2 = (ColumnData)tableItem.getData();
        }
        tableItem = new TableItem(this._list, 32, n - 1);
        tableItem.setChecked(tableItem2.getChecked());
        tableItem.setText(tableItem2.getText());
        tableItem.setImage(LogUIPluginImages.getImage("symptomdb_obj.gif"));
        tableItem.setData((Object)columnData);
        tableItem.setGrayed(tableItem2.getGrayed());
        this._list.remove(n + 1);
        this._list.select(n - 1);
    }

    private void populateList() {
        int n = 0;
        while (n < this._data.size()) {
            ColumnData columnData = (ColumnData)this._data.get(n);
            TableItem tableItem = new TableItem(this._list, 0);
            tableItem.setText(columnData.name());
            tableItem.setImage(LogUIPluginImages.getImage("symptomdb_obj.gif"));
            tableItem.setChecked(columnData.visible());
            tableItem.setData((Object)columnData);
            ++n;
        }
        if (this._list.getItemCount() > 0) {
            this._selAll.setEnabled(true);
            this._unselAll.setEnabled(true);
            this._list.select(0);
            if (this._list.getItemCount() > 1) {
                this._moveDown.setEnabled(true);
            }
        }
        int n2 = this._list.getSelectionIndex();
    }

    public void addDBPath(String string) {
        IResource iResource;
        IResource iResource2;
        Object object;
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        while (this._list.getItemCount() > 0) {
            this._list.getItem(0).dispose();
        }
        this._data.clear();
        if (string == null || string.equals("")) {
            return;
        }
        int n = string.indexOf(";");
        while (n != -1) {
            String string2 = string.substring(0, n);
            int n2 = string2.indexOf(",");
            if (n2 != -1) {
                object = string2.substring(0, n2);
                iResource2 = new Path((String)object);
                iResource = iWorkspace.getRoot().findMember((IPath)iResource2);
                if (iResource != null && iResource.exists()) {
                    this.addColumn((String)object, string2.substring(n2 + 1).equals("1"));
                }
            }
            string = string.substring(n + 1);
            n = string.indexOf(";");
        }
        int n3 = string.indexOf(",");
        if (n3 != -1) {
            String string3 = string.substring(0, n3);
            object = new Path(string3);
            iResource2 = iWorkspace.getRoot().findMember((IPath)object);
            iResource = null;
            if (iResource2 != null && iResource2.exists()) {
                this.addColumn(string3, string.substring(n3 + 1).equals("1"));
            }
        }
        this.populateList();
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.widgetSelected(selectionEvent);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        int n;
        if (selectionEvent.widget == this._moveUp) {
            n = this._list.getSelectionIndex();
            if (n > 0) {
                this.moveUp(n);
            }
        } else if (selectionEvent.widget == this._moveDown) {
            n = this._list.getSelectionIndex();
            if (n != -1 && n < this._list.getItemCount() - 1) {
                this.moveDown(n);
            }
        } else {
            if (selectionEvent.widget == this._selAll) {
                int n2 = 0;
                while (n2 < this._list.getItemCount()) {
                    TableItem tableItem = this._list.getItem(n2);
                    tableItem.setChecked(true);
                    ++n2;
                }
                return;
            }
            if (selectionEvent.widget == this._unselAll) {
                int n3 = 0;
                while (n3 < this._list.getItemCount()) {
                    TableItem tableItem = this._list.getItem(n3);
                    tableItem.setChecked(false);
                    ++n3;
                }
                return;
            }
            if (selectionEvent.widget == this._add) {
                this.launchImportWizard();
            }
        }
        n = this._list.getSelectionIndex();
        ColumnData columnData = null;
        ColumnData columnData2 = null;
        if (n > 0) {
            columnData2 = (ColumnData)this._list.getItem(n - 1).getData();
        }
        if (n != -1) {
            columnData = (ColumnData)this._list.getItem(n).getData();
        }
        this._moveUp.setEnabled(columnData != null && columnData2 != null);
        this._moveDown.setEnabled(columnData != null && n < this._list.getItemCount() - 1);
        this._selAll.setEnabled(this._list.getItemCount() > 0);
        this._unselAll.setEnabled(this._list.getItemCount() > 0);
    }

    public void storeValues(IPreferenceStore iPreferenceStore) {
        String string = "";
        int n = 0;
        while (n < this._list.getItemCount()) {
            TableItem tableItem = this._list.getItem(n);
            String string2 = tableItem.getChecked() ? "1" : "0";
            string = string + ";" + tableItem.getText() + "," + string2;
            ++n;
        }
        if (string.startsWith(";") && string.length() > 1) {
            string = string.substring(1);
        }
        iPreferenceStore.setValue("symptom_db_path", string);
    }

    private void launchImportWizard() {
        ImportSymptomDBWizard importSymptomDBWizard = new ImportSymptomDBWizard();
        WizardDialog wizardDialog = new WizardDialog(this.result.getShell(), (IWizard)importSymptomDBWizard);
        wizardDialog.create();
        wizardDialog.getShell().setSize(500, wizardDialog.getShell().getSize().y);
        if (wizardDialog.open() == 0) {
            this.addDBPath(AnalysisEnginePlugin.getPlugin().getPreferenceStore().getString("symptom_db_path"));
        }
    }

    private void addColumn(String string, boolean bl) {
        ColumnData columnData = null;
        columnData = this.getColumn(string);
        if (columnData == null) {
            columnData = new ColumnData(string, bl);
            this._data.add(columnData);
        } else {
            columnData.visible(bl);
        }
    }

    private ColumnData getColumn(String string) {
        int n = 0;
        while (n < this._data.size()) {
            ColumnData columnData = (ColumnData)this._data.get(n);
            if (columnData.name().equals(string)) {
                return columnData;
            }
            ++n;
        }
        return null;
    }

    class ColumnData {
        private String _name;
        private boolean _visible = false;

        public ColumnData(String string, boolean bl) {
            this._name = string;
            this._visible = bl;
        }

        public String name() {
            return this._name;
        }

        public void name(String string) {
            this._name = string;
        }

        public boolean visible() {
            return this._visible;
        }

        public void visible(boolean bl) {
            this._visible = bl;
        }
    }
}

