/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import java.util.List;
import java.util.Locale;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.CBEAdvFilterUI;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.log.ui.internal.util.FeatureNode;
import org.eclipse.hyades.log.ui.internal.util.LogRecordSearch;
import org.eclipse.hyades.log.ui.internal.util.TerminalNode;
import org.eclipse.hyades.log.ui.internal.views.LogContentProvider;
import org.eclipse.hyades.log.ui.internal.views.LogPage;
import org.eclipse.hyades.log.ui.internal.views.LogViewerUI;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.help.WorkbenchHelp;

public class SearchRecordDialog
extends Dialog
implements SelectionListener {
    private CBEAdvFilterUI _filters;
    private Button btnFind;
    private Button btnCancel;
    private Button btnUp;
    private Button btnDown;
    private Label lblMessage;
    private LogRecordSearch logRecordSearch = null;
    private Tree tree;
    private List cbeList;
    private LogPage page;
    private String _title;
    private Object lastMatch = null;

    public SearchRecordDialog(Shell shell, String string, Image image, LogPage logPage) {
        super(shell);
        this._title = string;
        Window.setDefaultImage((Image)image);
        this.page = logPage;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this._title);
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = GridUtil.createFill();
        gridData.widthHint = 500;
        composite2.setLayoutData((Object)gridData);
        this._filters = new CBEAdvFilterUI();
        this._filters.createControl(composite2, LogUIPlugin.getResourceString("STR_SEARCH_CONTENT_LABEL"));
        this.initializeFilters();
        Label label = new Label(composite2, 258);
        gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 0;
        composite3.setLayout((Layout)gridLayout);
        gridData = GridUtil.createFill();
        composite3.setLayoutData((Object)gridData);
        this.createOptionsGroup(composite3);
        this.createButtonsGroup(composite3);
        this.createFooter(composite2);
        this.initializeButtons();
        this.btnFind.addSelectionListener((SelectionListener)this);
        this.btnCancel.addSelectionListener((SelectionListener)this);
        this._filters.getAddBtn().addSelectionListener((SelectionListener)this);
        this._filters.getRemoveBtn().addSelectionListener((SelectionListener)this);
        WorkbenchHelp.setHelp((Control)composite2, (String)ContextIds.ACTLOG_VIEW_DIALOG_SEARCH);
        return composite2;
    }

    private void initializeFilters() {
        IPreferenceStore iPreferenceStore = LogUIPlugin.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getString("pd_src_filter_options");
        this._filters.initializeFilters(string);
    }

    private void initializeButtons() {
        if (LogUIPlugin.getDefault().getPreferenceStore().getString("pd_src_direction_options").equals("1")) {
            this.btnDown.setSelection(true);
        } else {
            this.btnUp.setSelection(true);
        }
        this.btnFind.setEnabled(this._filters.getFilterList().getFilters().size() > 0);
    }

    private void createOptionsGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)GridUtil.createHorizontalFill());
        Group group = new Group(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setText(LogUIPlugin.getResourceString("STR_DIRECTION_LABEL"));
        group.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 1;
        gridData.widthHint = 300;
        group.setLayoutData((Object)gridData);
        this.btnUp = new Button((Composite)group, 16);
        this.btnUp.setText(LogUIPlugin.getResourceString("STR_DIR_UP_LABEL"));
        this.btnDown = new Button((Composite)group, 16);
        this.btnDown.setText(LogUIPlugin.getResourceString("STR_DIR_DOWN_LABEL"));
    }

    private void createButtonsGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        GridData gridData = GridUtil.createHorizontalFill();
        gridData.horizontalAlignment = 3;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        this.btnFind = new Button(composite2, 8);
        this.btnFind.setText(LogUIPlugin.getResourceString("STR_FINDNEXT_LABEL"));
        gridData = new GridData();
        gridData.widthHint = Locale.getDefault().toString().equals("en_US") ? 75 : 100;
        this.btnFind.setLayoutData((Object)gridData);
        this.btnCancel = new Button(composite2, 8);
        this.btnCancel.setText(LogUIPlugin.getResourceString("STR_CANCEL_LABEL"));
        gridData = new GridData();
        gridData.widthHint = Locale.getDefault().toString().equals("en_US") ? 75 : 100;
        this.btnCancel.setLayoutData((Object)gridData);
        Shell shell = composite.getShell();
        if (shell != null) {
            shell.setDefaultButton(this.btnFind);
        }
    }

    private void createFooter(Composite composite) {
        this.lblMessage = new Label(composite, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.lblMessage.setLayoutData((Object)gridData);
    }

    private void setSelection(Object object) {
        if (object == null) {
            this.lblMessage.setText(LogUIPlugin.getResourceString("STR_STRING_NOT_FOUND"));
            return;
        }
        EObject eObject = this.page.getTraceViewer().getObjectToView(HyadesUtil.getMofObject());
        if (object != null && object instanceof EObject) {
            this.page.getTraceViewer().setRecordSelection((EObject)object, eObject);
        }
        this.lastMatch = object;
        this.page.getView().getViewer().reveal(this.lastMatch);
    }

    private Object getCBENode(Object object) {
        if (object instanceof CBECommonBaseEvent) {
            return object;
        }
        if (object instanceof EObject) {
            return this.getCBENode(((EObject)object).eContainer());
        }
        return null;
    }

    private Object getStartNode() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.page.getView().getViewer().getSelection();
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof CBECommonBaseEvent) {
            return object;
        }
        if (object instanceof EObject) {
            return this.getCBENode(object);
        }
        if (object instanceof FeatureNode) {
            return this.getCBENode(((FeatureNode)object).getElement());
        }
        if (object instanceof TerminalNode) {
            return this.getCBENode(((TerminalNode)object).getTreeParent());
        }
        return null;
    }

    public LogRecordSearch getRecordSearchEngine() {
        Object object;
        LogViewerUI logViewerUI;
        if (this.logRecordSearch == null) {
            this.logRecordSearch = new LogRecordSearch();
        }
        if ((logViewerUI = this.page.getView()) != null && logViewerUI.getViewer() != null) {
            object = (LogContentProvider)logViewerUI.getViewer().getContentProvider();
            this.cbeList = ((LogContentProvider)object).getCachedElements();
        }
        object = this.getStartNode();
        this.logRecordSearch.initialize(this.cbeList, object);
        return this.logRecordSearch;
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.btnCancel) {
            this._filters.storeValues(LogUIPlugin.getDefault().getPreferenceStore(), "pd_src_filter_options");
            LogUIPlugin.getDefault().getPreferenceStore().setValue("pd_src_direction_options", this.btnDown.getSelection() ? "1" : "-1");
            this.close();
        }
        if (selectionEvent.widget == this.btnFind) {
            this.lblMessage.setText("");
            Object object = this.getRecordSearchEngine().search(this._filters.getFilterList().getFilters(), this.btnDown.getSelection() ? 1 : -1, this.lastMatch);
            this.setSelection(object);
        }
        if (selectionEvent.widget == this._filters.getAddBtn() || selectionEvent.widget == this._filters.getRemoveBtn()) {
            this.btnFind.setEnabled(this._filters.getFilterList().getSize() > 0);
        }
    }
}

