/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.views;

import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.RecordTableElement;
import org.eclipse.hyades.models.cbe.CBEDefaultEvent;
import org.eclipse.hyades.models.internal.sdb.SDBDirective;
import org.eclipse.hyades.models.internal.sdb.SDBMatchPattern;
import org.eclipse.hyades.models.internal.sdb.SDBSolution;
import org.eclipse.hyades.models.internal.sdb.SDBSymptom;
import org.eclipse.hyades.trace.ui.internal.util.HyperlinkText;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.PageBook;

public class LogAnalysisPageBook
extends PageBook
implements ISelectionChangedListener {
    private CTabFolder tabFolder;
    private CTabItem detailsTabItem;
    private CTabItem analysisTabItem;
    private HyperlinkText detailsTabText;
    private HyperlinkText analysisTabText;
    private String resultString = "";
    private String detailsString = "";
    private final String LINESEPARATOR = System.getProperty("line.separator");
    private final String DELIMITER = "--------------------------------------------------------------------";

    public LogAnalysisPageBook(Composite composite, int n) {
        super(composite, n);
        this.populateUI();
    }

    public void populateUI() {
        this.tabFolder = new CTabFolder((Composite)this, 128);
        this.detailsTabText = new HyperlinkText((Composite)this.tabFolder, 842);
        this.detailsTabItem = new CTabItem(this.tabFolder, 0);
        this.detailsTabItem.setText(LogUIPlugin.getResourceString("STR_SYMPTOM_TAB"));
        this.detailsTabItem.setControl((Control)this.detailsTabText);
        this.analysisTabText = new HyperlinkText((Composite)this.tabFolder, 842);
        this.analysisTabItem = new CTabItem(this.tabFolder, 0);
        this.analysisTabItem.setText(LogUIPlugin.getResourceString("STR_ANALYSIS_TAB"));
        this.analysisTabItem.setControl((Control)this.analysisTabText);
        this.tabFolder.setSelection(this.detailsTabItem);
        this.showPage((Control)this.tabFolder);
    }

    public void setInputNull() {
        this.analysisTabText.setText("");
        this.analysisTabItem.setControl((Control)this.analysisTabText);
        this.detailsTabText.setText("");
        this.detailsTabItem.setControl((Control)this.detailsTabText);
        this.tabFolder.setSelection(this.detailsTabItem);
        this.showPage((Control)this.tabFolder);
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        Object object = null;
        ISelection iSelection = selectionChangedEvent.getSelection();
        if (!(iSelection instanceof IStructuredSelection)) {
            return;
        }
        object = ((IStructuredSelection)iSelection).getFirstElement();
        if (object != null) {
            if (object instanceof CBEDefaultEvent) {
                EList eList = ((CBEDefaultEvent)object).getSymptoms();
                this.resultString = eList.isEmpty() ? (((CBEDefaultEvent)object).isAnalyzed() ? LogUIPlugin.getResourceString("STR_NO_MATCH") : "") : this.formatDirectivesList(eList);
            } else if (object instanceof RecordTableElement) {
                this.detailsString = this.replaceNewLineChars(((RecordTableElement)object).getValue());
                this.detailsTabItem.setText(LogUIPlugin.getResourceString("STR_SYMPTOM_TAB") + " " + ((RecordTableElement)object).getName());
            } else if (object instanceof EObject) {
                this.resultString = "";
            } else if (object instanceof Object[]) {
                this.detailsString = "";
                this.detailsTabItem.setText(LogUIPlugin.getResourceString("STR_SYMPTOM_TAB"));
                this.resultString = "";
            }
        }
        this.analysisTabItem.setControl((Control)this.analysisTabText);
        this.analysisTabText.setText(this.resultString);
        this.detailsTabText.setText(this.detailsString);
        this.detailsTabItem.setControl((Control)this.detailsTabText);
        this.showPage((Control)this.tabFolder);
    }

    private String formatDirectivesList(EList eList) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < eList.size()) {
            stringBuffer.append(this.LINESEPARATOR);
            stringBuffer.append("--------------------------------------------------------------------");
            stringBuffer.append(this.LINESEPARATOR);
            SDBSymptom sDBSymptom = (SDBSymptom)eList.get(n);
            stringBuffer.append(sDBSymptom.getDescription()).append(this.LINESEPARATOR);
            EList eList2 = sDBSymptom.getPatterns();
            int n2 = 0;
            while (n2 < eList2.size()) {
                stringBuffer.append(((SDBMatchPattern)eList2.get(n2)).getValue()).append(this.LINESEPARATOR);
                ++n2;
            }
            eList2 = sDBSymptom.getSolutions();
            int n3 = 0;
            while (n3 < eList2.size()) {
                SDBSolution sDBSolution = (SDBSolution)eList2.get(n3);
                stringBuffer.append(((SDBSolution)eList2.get(n3)).getDescription()).append(this.LINESEPARATOR);
                EList eList3 = sDBSolution.getDirectives();
                int n4 = 0;
                while (n4 < eList3.size()) {
                    stringBuffer.append(((SDBDirective)eList3.get(n4)).getDescription()).append(this.LINESEPARATOR);
                    ++n4;
                }
                ++n3;
            }
            ++n;
        }
        return stringBuffer.toString().trim();
    }

    private String replaceNewLineChars(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n\f");
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken().trim());
            stringBuffer.append(this.LINESEPARATOR);
        }
        return stringBuffer.toString();
    }

    public void dispose() {
        if (this.analysisTabText != null) {
            this.analysisTabText.dispose();
        }
        if (this.detailsTabText != null) {
            this.detailsTabText.dispose();
        }
    }
}

