/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import java.util.Vector;
import org.eclipse.hyades.logging.adapter.ui.internal.util.ResultQueueEntry;

public class ResultQueue {
    private Vector entries = new Vector();
    private Vector partialResults = new Vector();
    private boolean valid = true;
    private int lockCount = 0;
    private int maxSize = 10;

    public void insertExtractorResult(Object object) {
        ResultQueueEntry resultQueueEntry = new ResultQueueEntry();
        resultQueueEntry.extractorOutput = object;
        this.partialResults.add(resultQueueEntry);
        this.insert(resultQueueEntry);
    }

    public void insertFormatterResult(Object object) {
        ResultQueueEntry resultQueueEntry = (ResultQueueEntry)this.partialResults.remove(0);
        resultQueueEntry.formatterOutput = object;
    }

    public Object get(int n) {
        ResultQueue resultQueue = this;
        synchronized (resultQueue) {
            ResultQueue resultQueue2;
            ++this.lockCount;
            while (n >= this.entries.size() && this.valid) {
                try {
                    resultQueue2 = this;
                    synchronized (resultQueue2) {
                        this.wait(10L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            --this.lockCount;
            resultQueue2 = this.entries.get(n);
            return resultQueue2;
        }
    }

    public Object getFirstEntry() {
        if (this.entries.size() > 0) {
            return this.entries.firstElement();
        }
        return "";
    }

    public Object getLastEntry() {
        if (this.entries.size() > 0) {
            return this.entries.lastElement();
        }
        return "";
    }

    private void insert(Object object) {
        ResultQueue resultQueue = this;
        synchronized (resultQueue) {
            ++this.lockCount;
            while (this.isFull() && this.valid) {
                ResultQueue resultQueue2 = this;
                synchronized (resultQueue2) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (!this.isFull() && this.valid) {
                this.entries.add(object);
            }
            --this.lockCount;
        }
    }

    public Object remove() {
        boolean bl = this.isFull();
        Object e = this.entries.remove(0);
        if (bl) {
            ResultQueue resultQueue = this;
            synchronized (resultQueue) {
                this.notifyAll();
            }
        }
        return e;
    }

    public void flush() {
        ResultQueue resultQueue = this;
        synchronized (resultQueue) {
            this.partialResults.removeAllElements();
            this.entries.removeAllElements();
            this.valid = false;
            while (this.lockCount-- > 0) {
                this.notifyAll();
            }
        }
    }

    public boolean isFull() {
        return this.entries.size() >= this.maxSize;
    }

    public void setMaxSize(int n) {
        this.maxSize = n;
    }

    public int getSize() {
        return this.entries.size();
    }

    public int getMaxSize() {
        return this.maxSize;
    }
}

