/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.views;

import java.io.File;
import org.eclipse.hyades.logging.adapter.MessageString;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SingleFileSensorType;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPluginImages;
import org.eclipse.hyades.logging.adapter.ui.ContextIds;
import org.eclipse.hyades.logging.adapter.ui.internal.actions.ActionHandlerListener;
import org.eclipse.hyades.logging.adapter.ui.internal.util.ResultQueueEntry;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModel;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.hyades.logging.adapter.ui.internal.views.ContentView;
import org.eclipse.hyades.logging.adapter.ui.internal.views.ResultView;
import org.eclipse.hyades.logging.events.CbeFormatter;
import org.eclipse.hyades.logging.events.ICommonBaseEvent;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.ViewPart;

public class LogView
extends ViewPart {
    private final String LOG_TITLE = AcadEditorPlugin.getPlugin().getString("TEMPLATE_LOG");
    TextViewer eventsViewer;
    Action createRuleAction;
    Action guessRuleAction;
    Action selectAllAction;
    Action nextEventAction;
    Action previousEventAction;
    Action firstEventAction;
    Action lastEventAction;
    Action refreshAction;
    Action showLog;

    public void init(IViewSite iViewSite) throws PartInitException {
        super.init(iViewSite);
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        this.init(iViewSite);
        this.enableEditActions();
    }

    public void createPartControl(Composite composite) {
        SashForm sashForm = new SashForm(composite, 256);
        sashForm.setLayout((Layout)new FillLayout());
        this.eventsViewer = new TextViewer((Composite)sashForm, 2882);
        this.eventsViewer.setEditable(false);
        this.createActions();
        this.createToolbar();
        this.createContextMenu();
        this.set_Title();
        WorkbenchHelp.setHelp((Control)composite, (String)ContextIds.ACAD_EDITOR_LOGVIEW);
    }

    public void setFocus() {
        if (this.eventsViewer != null && this.eventsViewer.getControl().isDisposed()) {
            this.eventsViewer.getControl().setFocus();
        }
    }

    public void createActions() {
        this.showLog = new Action(AcadEditorPlugin.getPlugin().getString("STR_SHOW_LOG_ACTION")){

            public void run() {
                LogView.this.showLog();
            }
        };
        this.showLog.setToolTipText(AcadEditorPlugin.getPlugin().getString("STR_SHOW_LOG_ACTION"));
        AcadEditorPluginImages.setImageDescriptors((IAction)this.showLog, "lcl16", "show_log_exec.gif");
        this.nextEventAction = new Action(AcadEditorPlugin.getPlugin().getString("STR_SHOW_NEXTE_ACTION")){

            public void run() {
                LogView.this.showNextEvent();
            }
        };
        this.nextEventAction.setToolTipText(AcadEditorPlugin.getPlugin().getString("STR_SHOW_NEXTE_ACTION"));
        AcadEditorPluginImages.setImageDescriptors((IAction)this.nextEventAction, "lcl16", "next_event_exec.gif");
        this.previousEventAction = new Action(AcadEditorPlugin.getPlugin().getString("STR_SHOW_PREVE_ACTION")){

            public void run() {
                LogView.this.showPreviousEvent();
            }
        };
        this.previousEventAction.setToolTipText(AcadEditorPlugin.getPlugin().getString("STR_SHOW_PREVE_ACTION"));
        AcadEditorPluginImages.setImageDescriptors((IAction)this.previousEventAction, "lcl16", "previous_event_exec.gif");
        this.firstEventAction = new Action(AcadEditorPlugin.getPlugin().getString("STR_SHOW_FIRSTE_ACTION")){

            public void run() {
                LogView.this.showFirstEvent();
            }
        };
        this.firstEventAction.setToolTipText(AcadEditorPlugin.getPlugin().getString("STR_SHOW_FIRSTE_ACTION"));
        AcadEditorPluginImages.setImageDescriptors((IAction)this.firstEventAction, "lcl16", "first_event_exec.gif");
        this.lastEventAction = new Action(AcadEditorPlugin.getPlugin().getString("STR_SHOW_LASTE_ACTION")){

            public void run() {
                LogView.this.showLastEvent();
            }
        };
        this.lastEventAction.setToolTipText(AcadEditorPlugin.getPlugin().getString("STR_SHOW_LASTE_ACTION"));
        AcadEditorPluginImages.setImageDescriptors((IAction)this.lastEventAction, "lcl16", "last_event_exec.gif");
        this.refreshAction = new Action(AcadEditorPlugin.getPlugin().getString("STR_RERUN_ACTION")){

            public void run() {
                LogView.this.refreshData();
            }
        };
        this.refreshAction.setToolTipText(AcadEditorPlugin.getPlugin().getString("STR_RERUN_ACTION"));
        AcadEditorPluginImages.setImageDescriptors((IAction)this.refreshAction, "lcl16", "reapply_exec.gif");
        this.createRuleAction = new Action(AcadEditorPlugin.getPlugin().getString("ADD_HASH_ACTION")){

            public void run() {
                LogView.this.createRule();
            }
        };
        this.createRuleAction.setToolTipText(AcadEditorPlugin.getPlugin().getString("ADD_HASH_ACTION"));
        AcadEditorPluginImages.setImageDescriptors((IAction)this.createRuleAction, "lcl16", "create_rule_exec.gif");
        this.guessRuleAction = new Action(AcadEditorPlugin.getPlugin().getString("GUESS_RULE_ACTION")){

            public void run() {
                LogView.this.guessRule();
            }
        };
        this.guessRuleAction.setToolTipText(AcadEditorPlugin.getPlugin().getString("GUESS_RULE_ACTION"));
        AcadEditorPluginImages.setImageDescriptors((IAction)this.guessRuleAction, "lcl16", "guess_rule_exec.gif");
        this.eventsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                LogView.this.updateActionEnablement();
            }
        });
    }

    private void createToolbar() {
        IToolBarManager iToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        iToolBarManager.add((IAction)this.refreshAction);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.firstEventAction);
        iToolBarManager.add((IAction)this.previousEventAction);
        iToolBarManager.add((IAction)this.nextEventAction);
        iToolBarManager.add((IAction)this.lastEventAction);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.showLog);
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                LogView.this.fillContextMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.eventsViewer.getControl());
        this.eventsViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.eventsViewer);
    }

    private void hookGlobalActions() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        iActionBars.setGlobalActionHandler("selectAll", (IAction)this.selectAllAction);
        iActionBars.setGlobalActionHandler("delete", (IAction)this.guessRuleAction);
        this.eventsViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == '\u007f' && keyEvent.stateMask == 0 && LogView.this.guessRuleAction.isEnabled()) {
                    LogView.this.guessRuleAction.run();
                }
            }
        });
    }

    private void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.createRuleAction);
        iMenuManager.add((IContributionItem)new GroupMarker("additions"));
        iMenuManager.add((IAction)this.guessRuleAction);
    }

    private void updateActionEnablement() {
        TextSelection textSelection = (TextSelection)this.eventsViewer.getSelection();
        this.createRuleAction.setEnabled(!textSelection.isEmpty());
        this.guessRuleAction.setEnabled(!textSelection.isEmpty());
    }

    private void showNextEvent() {
        ViewPart viewPart;
        if (AcadGuiModelManager.getCurrentModel() == null) {
            return;
        }
        ResultQueueEntry resultQueueEntry = AcadGuiModelManager.getCurrentModel().getNextEvent();
        String string = ((MessageString)resultQueueEntry.extractorOutput).getValue();
        this.eventsViewer.setDocument((IDocument)new Document(string));
        if (resultQueueEntry.formatterOutput != null && (viewPart = ResultView.getResultView(true)) != null) {
            String string2 = CbeFormatter.toCanonicalXMLString((ICommonBaseEvent)((ICommonBaseEvent)resultQueueEntry.formatterOutput), (boolean)true);
            viewPart.setResult(string2);
        }
        this.set_Title();
        this.enableActions();
        viewPart = ContentView.getContentView(false);
        if (viewPart != null) {
            viewPart.showLog();
        }
    }

    private void showPreviousEvent() {
        ResultView resultView;
        if (AcadGuiModelManager.getCurrentModel() == null) {
            return;
        }
        ResultQueueEntry resultQueueEntry = AcadGuiModelManager.getCurrentModel().getPreviousEvent();
        String string = ((MessageString)resultQueueEntry.extractorOutput).getValue();
        this.eventsViewer.setDocument((IDocument)new Document(string));
        if (resultQueueEntry.formatterOutput != null && (resultView = ResultView.getResultView(true)) != null) {
            String string2 = CbeFormatter.toCanonicalXMLString((ICommonBaseEvent)((ICommonBaseEvent)resultQueueEntry.formatterOutput), (boolean)true);
            resultView.setResult(string2);
        }
        this.set_Title();
        this.enableActions();
    }

    protected void refreshData() {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                AcadGuiModel acadGuiModel = AcadGuiModelManager.getCurrentModel();
                if (acadGuiModel != null) {
                    acadGuiModel.loadTemplateFile();
                }
            }
        });
    }

    public void set_Title() {
        ResultView resultView;
        AcadGuiModel acadGuiModel = AcadGuiModelManager.getCurrentModel();
        StringBuffer stringBuffer = new StringBuffer(this.LOG_TITLE).append(" ");
        if (acadGuiModel != null) {
            long l = acadGuiModel.getCurrentCount();
            l = l >= 0L ? ++l : 0L;
            if (acadGuiModel.getContextInstance() == null || acadGuiModel.getContextInstance().eContainer() == null) {
                stringBuffer.append(AcadEditorPlugin.getPlugin().getString("STR_NO_EXTRACTOR"));
            } else {
                SensorConfigType sensorConfigType = AcadGuiModelManager.getLogForConfiguration(acadGuiModel);
                if (sensorConfigType != null) {
                    SensorType sensorType = sensorConfigType.getType();
                    switch (sensorType.getValue()) {
                        case 0: {
                            stringBuffer.append(AcadEditorPlugin.getPlugin().getString("STR_NO_SENSOR"));
                            break;
                        }
                        case 1: {
                            SingleFileSensorType singleFileSensorType = sensorConfigType.getSingleFileSensor();
                            if (singleFileSensorType == null) {
                                stringBuffer.append(AcadEditorPlugin.getPlugin().getString("STR_NO_SENSOR"));
                                break;
                            }
                            stringBuffer.append(singleFileSensorType.getDirectory()).append(File.separator).append(singleFileSensorType.getFileName());
                        }
                    }
                    String string = AcadEditorPlugin.getPlugin().getString("STR_LOG_TITLE", new Object[]{String.valueOf(l), String.valueOf(acadGuiModel.getEventCount())});
                    stringBuffer.append(" ").append(string);
                } else {
                    stringBuffer.append(AcadEditorPlugin.getPlugin().getString("STR_NO_SENSOR"));
                }
            }
        }
        super.setTitle(stringBuffer.toString());
        ContentView contentView = ContentView.getContentView(false);
        if (contentView != null) {
            contentView.set_Title();
        }
        if ((resultView = ResultView.getResultView(false)) != null) {
            resultView.set_Title();
        }
    }

    public void showFirstEvent() {
        ResultView resultView;
        if (AcadGuiModelManager.getCurrentModel() == null) {
            return;
        }
        ResultQueueEntry resultQueueEntry = AcadGuiModelManager.getCurrentModel().getFirstEvent();
        String string = ((MessageString)resultQueueEntry.extractorOutput).getValue();
        this.eventsViewer.setDocument((IDocument)new Document(string));
        if (resultQueueEntry.formatterOutput != null && (resultView = ResultView.getResultView(true)) != null) {
            String string2 = CbeFormatter.toCanonicalXMLString((ICommonBaseEvent)((ICommonBaseEvent)resultQueueEntry.formatterOutput), (boolean)true);
            resultView.setResult(string2);
        }
        this.set_Title();
        this.enableActions();
    }

    private void showLastEvent() {
        ResultView resultView;
        if (AcadGuiModelManager.getCurrentModel() == null) {
            return;
        }
        ResultQueueEntry resultQueueEntry = AcadGuiModelManager.getCurrentModel().getLastEvent();
        String string = ((MessageString)resultQueueEntry.extractorOutput).getValue();
        this.eventsViewer.setDocument((IDocument)new Document(string));
        if (resultQueueEntry.formatterOutput != null && (resultView = ResultView.getResultView(true)) != null) {
            String string2 = CbeFormatter.toCanonicalXMLString((ICommonBaseEvent)((ICommonBaseEvent)resultQueueEntry.formatterOutput), (boolean)true);
            resultView.setResult(string2);
        }
        this.set_Title();
        this.enableActions();
    }

    private void createRule() {
        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Generic Adaptor Message", (String)"Not implemented");
    }

    private void guessRule() {
        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Generic Adaptor Message", (String)"Not implemented");
    }

    public void dispose() {
        super.dispose();
    }

    public void setContent(String string) {
        if (this.eventsViewer != null) {
            this.eventsViewer.setDocument((IDocument)new Document(string));
        }
    }

    public String getText() {
        return ((StyledText)this.eventsViewer.getControl()).getText();
    }

    public static final LogView getLogView(boolean bl) {
        try {
            IWorkbenchPage iWorkbenchPage = AcadEditorPlugin.getDefault().getActivePage();
            if (iWorkbenchPage == null) {
                return null;
            }
            IViewPart iViewPart = iWorkbenchPage.findView("org.eclipse.hyades.logging.adapter.ui.views.logview");
            if (iViewPart != null) {
                if (bl) {
                    iWorkbenchPage.showView("org.eclipse.hyades.logging.adapter.ui.views.logview");
                }
                return (LogView)iViewPart;
            }
            if (bl) {
                iWorkbenchPage.showView("org.eclipse.hyades.logging.adapter.ui.views.logview");
                return (LogView)iViewPart;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return null;
    }

    public void reset() {
        ContentView contentView;
        this.setContent("");
        ResultView resultView = ResultView.getResultView(false);
        if (resultView != null) {
            resultView.reset();
        }
        if ((contentView = ContentView.getContentView(false)) != null) {
            contentView.reset();
        }
    }

    public Action getCreateRuleAction() {
        return this.createRuleAction;
    }

    public void enableActions() {
        AcadGuiModel acadGuiModel = AcadGuiModelManager.getCurrentModel();
        if (acadGuiModel == null || acadGuiModel.getContextInstance() == null) {
            this.previousEventAction.setEnabled(false);
            this.nextEventAction.setEnabled(false);
            this.firstEventAction.setEnabled(false);
            this.lastEventAction.setEnabled(false);
            this.createRuleAction.setEnabled(false);
            this.showLog.setEnabled(false);
            return;
        }
        this.firstEventAction.setEnabled(acadGuiModel.getEventCount() > 0L);
        this.lastEventAction.setEnabled(acadGuiModel.getEventCount() > 0L);
        this.createRuleAction.setEnabled(true);
        this.showLog.setEnabled(true);
        this.previousEventAction.setEnabled(acadGuiModel.hasPrevious());
        this.nextEventAction.setEnabled(acadGuiModel.hasNext());
    }

    protected void enableEditActions() {
        ActionHandlerListener.DEFAULT.connectPart((IWorkbenchPart)this);
    }

    protected void showLog() {
        ContentView contentView = ContentView.getContentView(true);
        if (contentView != null) {
            contentView.showLog();
        }
    }
}

