/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.ui.internal.model;

import java.util.Map;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.sd.ui.internal.model.Graph;
import org.eclipse.hyades.sd.ui.internal.model.GraphNode;
import org.eclipse.hyades.sd.ui.internal.model.Increment;
import org.eclipse.hyades.sd.ui.internal.model.NodeConnection;
import org.eclipse.hyades.sd.ui.internal.model.NodeContainer;
import org.eclipse.hyades.sd.ui.internal.model.NodeLink;
import org.eclipse.hyades.sd.ui.internal.util.LogCDrawUtils;
import org.eclipse.swt.graphics.GC;

public class ColumnNode
implements GraphNode {
    private int nodePosition = 0;
    private int startPosition = 0;
    private int stopPosition = 0;
    private int beginPosition;
    private int endPosition;
    private int xOffset = 0;
    private boolean selected = false;
    private boolean positionSet = false;
    public String name = null;
    public int type = 0;
    public double startTime = 0.0;
    public double endTime = 0.0;
    public Increment startIncrement = null;
    public Increment endIncrement = null;
    public int nextNewSourceConnection = 0;
    public int nextNewTargetConnection = 0;
    public int indexInContainer = 0;
    public String shortName = null;
    public String secondaryName = null;
    public Object userArea = null;
    public Graph graph = null;
    public NodeContainer container = null;
    public NodeConnection lastReadTargetConnection = null;
    public NodeConnection[] targetConnections = new NodeConnection[3];
    public NodeConnection[] sourceConnections = new NodeConnection[3];

    public GraphNode getGraphNode() {
        return this;
    }

    public void init() {
        this.startPosition = this.getStartIncrementValue();
        this.stopPosition = this.getEndIncrementValue();
    }

    public void setPosition(int n) {
        this.positionSet = true;
        this.nodePosition = n;
    }

    public int getPosition() {
        return this.nodePosition;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public int getStopPosition() {
        return this.stopPosition;
    }

    public int getPositionRange() {
        return this.endPosition - this.beginPosition;
    }

    public int getBeginPosition() {
        return this.beginPosition;
    }

    public int getEndPosition() {
        return this.endPosition;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public boolean isPositionSet() {
        return this.positionSet;
    }

    public void disposeMe() {
    }

    public void drawSelf(GC gC, int n, int n2, int n3, int n4, int n5, int n6, int n7, Map map) {
        int n8;
        Object object;
        short s;
        if (this.selected) {
            gC.setForeground(LogCDrawUtils.getForegroundSelectedColor());
        } else {
            gC.setForeground(LogCDrawUtils.getForegroundColor());
        }
        this.beginPosition = (this.startPosition - n4) * n2 + n3;
        this.endPosition = (this.stopPosition - n4) * n2 + n3;
        if (this.userArea != null && this.userArea instanceof CBECommonBaseEvent && (s = ((CBECommonBaseEvent)this.userArea).getSeverity()) >= 0 && s <= 70) {
            if (s >= 50) {
                gC.setBackground(LogCDrawUtils.getRedEventFillColor());
                gC.setForeground(LogCDrawUtils.getRedEventStrokeColor());
            } else if (s >= 30 && s < 50) {
                gC.setBackground(LogCDrawUtils.getYellowEventFillColor());
                gC.setForeground(LogCDrawUtils.getYellowEventStrokeColor());
            } else if (s < 30) {
                gC.setBackground(LogCDrawUtils.getBlueEventFillColor());
                gC.setForeground(LogCDrawUtils.getBlueEventStrokeColor());
            }
        }
        int[] nArray = new int[]{n7 + n / 2 - 5, this.beginPosition, n7 + n / 2 + 5, this.beginPosition, n7 + n / 2 + 5, this.endPosition, n7 + n / 2 - 5, this.endPosition};
        gC.fillPolygon(nArray);
        gC.drawPolygon(nArray);
        if (this.userArea != null && this.userArea instanceof CBECommonBaseEvent && this.selected) {
            gC.setForeground(LogCDrawUtils.getLogHighLightColor());
            object = new int[]{n7 + n / 2 - 6, this.beginPosition - 1, n7 + n / 2 + 6, this.beginPosition - 1, n7 + n / 2 + 6, this.endPosition + 1, n7 + n / 2 - 6, this.endPosition + 1};
            gC.drawPolygon((int[])object);
        }
        gC.setBackground(LogCDrawUtils.getBackgroundColor());
        int n9 = 0;
        while (n9 < this.sourceConnections.length) {
            if (this.sourceConnections[n9] != null) {
                object = (NodeLink)this.sourceConnections[n9];
                n8 = (((NodeLink)object).getStartIncrementValue() - n4) * n2 + n3;
                if (n8 >= 0 && n8 <= n5) {
                    ((NodeLink)object).drawSelf(gC, n, this, n2, n3, n4, n6, n7, map);
                }
                if (n8 > n5 && (n8 = (((NodeLink)object).getSource().getStartIncrementValue() - n4) * n2 + n3) >= 0 && n8 <= n5) {
                    ((NodeLink)object).drawSelf(gC, n, this, n2, n3, n4, n6, n7, map);
                }
            }
            ++n9;
        }
        int n10 = 0;
        while (n10 < this.targetConnections.length) {
            if (this.targetConnections[n10] != null && (n8 = (((NodeLink)(object = (NodeLink)this.targetConnections[n10])).getStartIncrementValue() - n4) * n2 + n3) >= 0 && n8 <= n5) {
                ((NodeLink)object).drawSelf(gC, n, this, n2, n3, n4, n6, n7, map);
            }
            ++n10;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String string) {
        this.shortName = string;
    }

    public String getSecondaryName() {
        return this.secondaryName;
    }

    public void setSecondaryName(String string) {
        this.secondaryName = string;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public Graph getGraph() {
        if (this.graph == null) {
            this.graph = this.getContainer().getGraph();
        }
        return this.graph;
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    public NodeContainer getContainer() {
        return this.container;
    }

    public void setContainer(NodeContainer nodeContainer) {
        this.container = nodeContainer;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public void setStartTime(double d) {
        this.startTime = d;
        this.startIncrement = this.getGraph().addIncrementAppendDup(d);
    }

    public Increment getStartIncrement() {
        return this.startIncrement;
    }

    public void setStartIncrement(Increment increment) {
        this.startTime = increment.getTime();
        this.startIncrement = increment;
    }

    public double getEndTime() {
        return this.endTime;
    }

    public void setEndTime(double d) {
        this.endTime = d;
        this.endIncrement = this.getGraph().addIncrementAppendDup(d);
    }

    public Increment getEndIncrement() {
        return this.endIncrement;
    }

    public void setEndIncrement(Increment increment) {
        this.endTime = increment.getTime();
        this.endIncrement = increment;
    }

    public int getStartIncrementValue() {
        if (this.startIncrement != null) {
            return this.startIncrement.getValue();
        }
        return 0;
    }

    public int getEndIncrementValue() {
        if (this.endIncrement != null) {
            return this.endIncrement.getValue();
        }
        return 0;
    }

    public void addSourceConnection(NodeConnection nodeConnection) {
        try {
            this.sourceConnections[this.nextNewSourceConnection] = nodeConnection;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            NodeConnection[] nodeConnectionArray = new NodeConnection[2 * this.sourceConnections.length];
            System.arraycopy(this.sourceConnections, 0, nodeConnectionArray, 0, this.sourceConnections.length);
            this.sourceConnections = nodeConnectionArray;
            this.sourceConnections[this.nextNewSourceConnection] = nodeConnection;
        }
        if (nodeConnection.getEndIncrement().getValue() < this.getStartIncrement().getValue()) {
            this.graph.moveIncrementAndAdjust(this.getStartIncrement(), nodeConnection.getStartIncrement().getValue());
        }
        if (nodeConnection.getEndIncrement().getValue() > this.getEndIncrement().getValue()) {
            this.graph.moveIncrementAndAdjust(nodeConnection.getEndIncrement(), this.getEndIncrement().getValue());
        }
        ++this.nextNewSourceConnection;
    }

    public void addTargetConnection(NodeConnection nodeConnection) {
        try {
            this.targetConnections[this.nextNewTargetConnection] = nodeConnection;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            NodeConnection[] nodeConnectionArray = new NodeConnection[2 * this.targetConnections.length];
            System.arraycopy(this.targetConnections, 0, nodeConnectionArray, 0, this.targetConnections.length);
            this.targetConnections = nodeConnectionArray;
            this.targetConnections[this.nextNewTargetConnection] = nodeConnection;
        }
        if (nodeConnection.getStartIncrement().getValue() < this.getStartIncrement().getValue()) {
            this.graph.moveIncrementAndAdjust(this.getStartIncrement(), nodeConnection.getStartIncrement().getValue());
        }
        if (nodeConnection.getStartIncrement().getValue() > this.getEndIncrement().getValue()) {
            this.graph.moveIncrementAndAdjust(nodeConnection.getEndIncrement(), this.getEndIncrement().getValue());
        }
        ++this.nextNewTargetConnection;
    }

    public NodeConnection[] getSourceConnections() {
        return this.sourceConnections;
    }

    public void setSourceConnections(NodeConnection[] nodeConnectionArray) {
        this.sourceConnections = nodeConnectionArray;
    }

    public NodeConnection[] getTargetConnections() {
        return this.targetConnections;
    }

    public void setTargetConnections(NodeConnection[] nodeConnectionArray) {
        this.targetConnections = nodeConnectionArray;
    }

    public int getSourceConnectionCount() {
        return this.nextNewSourceConnection;
    }

    public int getTargetConnectionCount() {
        return this.nextNewTargetConnection;
    }

    public NodeConnection getLastReadTargetConnection() {
        return this.lastReadTargetConnection;
    }

    public void setLastReadTargetConnection(NodeConnection nodeConnection) {
        this.lastReadTargetConnection = nodeConnection;
    }

    public void setUserArea(Object object) {
        this.userArea = object;
    }

    public Object getUserArea() {
        return this.userArea;
    }

    public int getIndexInContainer() {
        return this.indexInContainer;
    }

    public void setIndexInContainer(int n) {
        this.indexInContainer = n;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public void setXOffset(int n) {
        this.xOffset = n;
    }
}

