/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.ui.internal.model;

import org.eclipse.hyades.sd.ui.internal.model.NodeConnection;
import org.eclipse.hyades.sd.ui.internal.util.LogCDrawUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public class ColumnPassage {
    int type;
    boolean logRecordConection;
    NodeConnection nodeConnection;
    int passagePosition;

    public ColumnPassage(int n, NodeConnection nodeConnection, boolean bl) {
        this.type = n;
        this.nodeConnection = nodeConnection;
        this.logRecordConection = bl;
        this.passagePosition = this.nodeConnection.getStartIncrementValue();
    }

    public void drawSelf(GC gC, int n, int n2, int n3, int n4, int n5) {
        Color color = gC.getForeground();
        if (this.nodeConnection.isSelected()) {
            if (!this.logRecordConection) {
                gC.setForeground(LogCDrawUtils.getForegroundSelectedColor());
            } else {
                gC.setForeground(LogCDrawUtils.getLogHighLightColor());
            }
        } else if (!this.logRecordConection) {
            gC.setForeground(LogCDrawUtils.getConnectionColor());
        } else {
            gC.setForeground(LogCDrawUtils.getLogConnectionColor());
        }
        int n6 = n3 + n2 * (this.passagePosition - n4);
        switch (this.type) {
            case 22: {
                gC.drawLine(n5, n6, n5 + n, n6);
                break;
            }
            case 23: {
                gC.drawLine(n5 + n, n6, n5, n6);
                break;
            }
            case 24: {
                gC.setLineStyle(3);
                gC.drawLine(n5, n6, n5 + n, n6);
                gC.setLineStyle(1);
                break;
            }
            case 25: {
                gC.setLineStyle(3);
                gC.drawLine(n5 + n, n6, n5, n6);
                gC.setLineStyle(1);
                break;
            }
            default: {
                System.out.println("WRONG INDEX FOR PASSAGE!!!!!");
            }
        }
        gC.setForeground(color);
        color.dispose();
    }

    public int getPassagePosition() {
        return this.passagePosition;
    }

    public void setPassagePosition(int n) {
        this.passagePosition = n;
    }

    public NodeConnection getNodeConnection() {
        return this.nodeConnection;
    }

    public void setSelected(boolean bl) {
        this.nodeConnection.setSelected(bl);
    }

    public boolean isOver(int n) {
        return n > Math.min(this.nodeConnection.getSource().getContainer().getIndexInContainer(), this.nodeConnection.getTarget().getContainer().getIndexInContainer()) && n < Math.max(this.nodeConnection.getSource().getContainer().getIndexInContainer(), this.nodeConnection.getTarget().getContainer().getIndexInContainer());
    }
}

