/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.ui.internal.util;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.hyades.sd.ui.SDPlugin;
import org.eclipse.hyades.sd.ui.internal.model.ColumnFigure;
import org.eclipse.hyades.sd.ui.internal.model.ColumnNode;
import org.eclipse.hyades.sd.ui.internal.model.GraphNode;
import org.eclipse.hyades.sd.ui.internal.model.NodeLink;
import org.eclipse.hyades.sd.ui.internal.util.LogCDrawUtils;
import org.eclipse.hyades.sd.ui.internal.views.SDViewerUI;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.help.WorkbenchHelp;

public class DrawAreaOverview
extends MouseAdapter
implements SelectionListener,
PaintListener,
MouseMoveListener {
    Composite graphComposite;
    Button overviewButton;
    Canvas overviewCanvas = null;
    SelectorFigure selectorFigure = null;
    SDViewerUI sdViewerUI;
    GC gc;
    boolean expanded = false;
    Point parentSize;
    int overviewResizeRatio = 1;
    int canvasSizeX;
    int canvasSizeY;
    boolean mouseDown = false;
    boolean firstTime = true;
    int mouseDownX = 0;
    int mouseDownY = 0;
    int mouseOffsetX = 0;
    int mouseOffsetY = 0;
    Point overviewButtonPreferredSize;
    int headerSize;
    boolean drawLifeLines = true;
    int[] columnPositions = null;
    int boxSpace;
    int boxHeight;

    public DrawAreaOverview(Composite composite, Point point) {
        this.graphComposite = composite;
        this.parentSize = point;
        this.sdViewerUI = (SDViewerUI)composite.getParent();
        this.overviewButton = new Button(composite, 8);
        this.overviewButton.setText(SDPlugin.getString("STR_OVERVIEW"));
        this.overviewButton.setCapture(false);
        this.overviewButtonPreferredSize = this.overviewButton.computeSize(-1, -1, true);
        this.overviewButton.setSize(this.overviewButtonPreferredSize.x, this.overviewButtonPreferredSize.y);
        this.headerSize = this.overviewButtonPreferredSize.y;
        this.setButtonLocation();
        this.overviewButton.addSelectionListener((SelectionListener)this);
        this.overviewButton.moveAbove(null);
        this.boxSpace = LogCDrawUtils.getInitBoxSpace();
        this.boxHeight = LogCDrawUtils.getInitBoxSpace();
        WorkbenchHelp.setHelp((Control)this.overviewButton, (String)(SDPlugin.getPluginId() + ".ovbn0000"));
        WorkbenchHelp.setHelp((Control)composite, (String)(SDPlugin.getPluginId() + ".ovar0000"));
    }

    private void setButtonLocation() {
        if (System.getProperty("os.name").startsWith("Windows")) {
            this.overviewButton.setLocation(this.parentSize.x - this.overviewButtonPreferredSize.x - 13, this.parentSize.y - this.overviewButtonPreferredSize.y);
        } else {
            this.overviewButton.setLocation(this.parentSize.x - this.overviewButtonPreferredSize.x - 24, this.parentSize.y - this.overviewButtonPreferredSize.y - 9);
        }
    }

    public void paintControl(PaintEvent paintEvent) {
        if (this.expanded) {
            this.drawOverview(paintEvent);
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (this.parentSize.x == 0 || this.parentSize.y == 0) {
            return;
        }
        if (this.expanded) {
            this.closeUI();
        } else {
            try {
                this.setCanvasSize(this.sdViewerUI.getEndOfTime() * LogCDrawUtils.getTimeUnit() + LogCDrawUtils.getInitBoxSpace());
            }
            catch (ArithmeticException arithmeticException) {
                return;
            }
            this.openUI();
        }
        this.expanded = !this.expanded;
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void close() {
        if (this.expanded) {
            this.closeUI();
            this.expanded = !this.expanded;
        }
    }

    private void openUI() {
        if (this.overviewCanvas == null) {
            this.overviewCanvas = new Canvas(this.graphComposite, 2048);
            this.overviewCanvas.setBackground(LogCDrawUtils.getBackgroundColor());
            this.overviewCanvas.addPaintListener((PaintListener)this);
            this.overviewCanvas.addMouseMoveListener((MouseMoveListener)this);
            this.overviewCanvas.addMouseListener((MouseListener)this);
            this.selectorFigure = new SelectorFigure();
            this.gc = new GC((Drawable)this.overviewCanvas);
            this.overviewCanvas.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    if (DrawAreaOverview.this.selectorFigure != null) {
                        DrawAreaOverview.this.selectorFigure.dispose();
                    }
                    DrawAreaOverview.this.selectorFigure = null;
                    if (DrawAreaOverview.this.gc != null) {
                        DrawAreaOverview.this.gc.dispose();
                    }
                    DrawAreaOverview.this.gc = null;
                }
            });
        }
        this.overviewCanvas.setSize(this.canvasSizeX, this.canvasSizeY);
        this.overviewCanvas.setLocation(this.parentSize.x - this.overviewCanvas.getSize().x, this.parentSize.y - this.overviewCanvas.getSize().y);
        int n = LogCDrawUtils.getOverviewRatio();
        Point point = this.overviewCanvas.getLocation();
        this.selectorFigure.moveFigure(this.graphComposite.getHorizontalBar().getSelection() / n, this.graphComposite.getVerticalBar().getSelection() * LogCDrawUtils.getTimeUnit() / n);
        this.overviewButton.setLocation(this.overviewButton.getLocation().x, point.y - this.overviewButton.getSize().y);
        this.overviewCanvas.moveAbove(null);
    }

    private void closeUI() {
        this.overviewCanvas.setVisible(false);
        if (this.overviewCanvas != null) {
            this.overviewCanvas.dispose();
        }
        this.overviewCanvas = null;
        if (this.selectorFigure != null) {
            this.selectorFigure.dispose();
        }
        this.selectorFigure = null;
        if (this.gc != null) {
            this.gc.dispose();
        }
        this.gc = null;
        this.sdViewerUI.redraw();
        this.setButtonLocation();
    }

    public void adjustParentSize(int n, int n2) {
        this.parentSize.x = n;
        this.parentSize.y = n2;
        this.setButtonLocation();
    }

    public void setCanvasSize(int n) {
        float f = n;
        float f2 = 0.0f;
        GraphNode[] graphNodeArray = this.sdViewerUI.getColumnFigures();
        int n2 = 0;
        while (n2 < this.sdViewerUI.getGraph().getTopNodeCount()) {
            ColumnFigure columnFigure = (ColumnFigure)graphNodeArray[n2];
            f2 += (float)columnFigure.getWidth();
            ++n2;
        }
        float f3 = this.parentSize.x;
        float f4 = this.parentSize.y - this.headerSize - this.overviewButtonPreferredSize.y;
        float f5 = Math.max(f2 / f3, f / f4);
        this.overviewResizeRatio = new Float(f5).intValue();
        ++this.overviewResizeRatio;
        if (this.overviewResizeRatio < 1) {
            this.overviewResizeRatio = 1;
        }
        LogCDrawUtils.setOverviewRatio(this.overviewResizeRatio);
        this.canvasSizeY = new Float(f / (float)this.overviewResizeRatio).intValue();
        this.canvasSizeX = new Float(f2 / (float)this.overviewResizeRatio).intValue();
        this.drawLifeLines = this.canvasSizeX / this.sdViewerUI.getGraph().getTopNodeCount() >= 3;
    }

    private void drawOverview(PaintEvent paintEvent) {
        ColumnFigure columnFigure;
        this.gc.fillRectangle(0, 0, this.overviewCanvas.getSize().x, this.overviewCanvas.getSize().y);
        int n = this.sdViewerUI.getGraph().getTopNodeCount();
        this.columnPositions = new int[n];
        GraphNode[] graphNodeArray = this.sdViewerUI.getColumnFigures();
        int n2 = 0;
        while (n2 < n) {
            columnFigure = (ColumnFigure)graphNodeArray[n2];
            this.columnPositions[n2] = columnFigure.drawSelf(this.gc, new Point(this.canvasSizeX / n, this.canvasSizeY), this.drawLifeLines, this.boxHeight, this.overviewResizeRatio);
            ++n2;
        }
        int n3 = LogCDrawUtils.getTimeUnit();
        Color color = this.gc.getForeground();
        this.gc.setForeground(LogCDrawUtils.getLogConnectionColor());
        int n4 = 0;
        while (n4 < n) {
            columnFigure = (ColumnFigure)graphNodeArray[n4];
            int n5 = 0;
            while (n5 < columnFigure.getInternalNodeCount()) {
                ColumnNode columnNode = (ColumnNode)columnFigure.getInternalNodes()[n5];
                int n6 = 0;
                while (n6 < columnNode.getSourceConnections().length) {
                    if (columnNode.getSourceConnections()[n6] != null) {
                        NodeLink nodeLink = (NodeLink)columnNode.getSourceConnections()[n6];
                        int n7 = (this.boxSpace + n3 * nodeLink.getStartIncrementValue()) / this.overviewResizeRatio;
                        this.gc.drawLine(this.columnPositions[nodeLink.getSource().getContainer().getIndexInContainer()], n7, this.columnPositions[nodeLink.getTarget().getContainer().getIndexInContainer()], n7);
                    }
                    ++n6;
                }
                ++n5;
            }
            ++n4;
        }
        this.gc.setForeground(color);
        color.dispose();
        this.selectorFigure.paintFigure((Graphics)new SWTGraphics(this.gc));
        if (this.firstTime) {
            this.mouseDownX = this.selectorFigure.getTargetBounds().width / 2;
            this.mouseDownY = this.selectorFigure.getTargetBounds().height / 2;
            this.firstTime = false;
        }
    }

    public void redraw() {
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
        if (!this.selectorFigure.positionContained(mouseEvent.x, mouseEvent.y)) {
            this.mouseDown = true;
            this.moveShadowDC(mouseEvent.x, mouseEvent.y);
            this.mouseDown = false;
        }
    }

    public void mouseDown(MouseEvent mouseEvent) {
        if (this.selectorFigure.positionContained(mouseEvent.x, mouseEvent.y)) {
            this.mouseDown = true;
            this.mouseDownX = mouseEvent.x;
            this.mouseDownY = mouseEvent.y;
            this.mouseOffsetX = mouseEvent.x - this.selectorFigure.getTargetBounds().x;
            this.mouseOffsetY = mouseEvent.y - this.selectorFigure.getTargetBounds().y;
        }
    }

    public void mouseUp(MouseEvent mouseEvent) {
        this.mouseDown = false;
    }

    public void mouseMove(MouseEvent mouseEvent) {
        this.moveShadow(mouseEvent.x, mouseEvent.y);
    }

    private void moveShadowDC(int n, int n2) {
        if (this.mouseDown) {
            Rectangle rectangle = this.selectorFigure.getTargetBounds();
            rectangle.x = n - rectangle.width / 2;
            if (rectangle.x < 0) {
                rectangle.x = 0;
            } else if (rectangle.getRight().x > this.canvasSizeX) {
                rectangle.x = this.canvasSizeX - rectangle.width;
            }
            this.mouseDownX = rectangle.x + rectangle.width / 2;
            rectangle.y = n2 - rectangle.height / 2;
            if (rectangle.y < 0) {
                rectangle.y = 0;
            } else if (rectangle.getBottom().y > this.canvasSizeY) {
                rectangle.y = this.canvasSizeY - rectangle.height;
            }
            this.mouseDownY = rectangle.y + rectangle.height / 2;
            this.overviewCanvas.redraw();
            this.selectorFigure.paintFigure((Graphics)new SWTGraphics(this.gc));
            this.sdViewerUI.setScrollbars(rectangle.getLeft().x * this.overviewResizeRatio, (rectangle.getTop().y * this.overviewResizeRatio + LogCDrawUtils.getInitBoxSpace()) / LogCDrawUtils.getTimeUnit());
            this.mouseDown = false;
        }
    }

    private void moveShadow(int n, int n2) {
        if (this.mouseDown) {
            int n3 = n - this.mouseDownX;
            int n4 = n2 - this.mouseDownY;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            Rectangle rectangle = this.selectorFigure.getTargetBounds();
            if (n3 == 0 && n4 == 0) {
                return;
            }
            if (n3 > 0) {
                n5 = rectangle.getLeft().x;
                n6 = n5 + rectangle.width + n3;
            } else if (n3 < 0) {
                n6 = rectangle.getRight().x;
                n5 = n6 - rectangle.width + n3;
            } else if (n3 == 0) {
                n5 = rectangle.getLeft().x - 1;
                n6 = rectangle.getRight().x + 1;
            }
            if (n4 > 0) {
                n7 = rectangle.getTop().y;
                n8 = n7 + rectangle.height + n4;
            } else if (n4 < 0) {
                n8 = rectangle.getBottom().y;
                n7 = n8 - rectangle.height + n4;
            } else if (n4 == 0) {
                n7 = rectangle.getTop().y - 1;
                n8 = rectangle.getBottom().y + 1;
            }
            this.selectorFigure.moveFigure(n3 + n - rectangle.x - this.mouseOffsetX, n4 + n2 - rectangle.y - this.mouseOffsetY);
            this.selectorFigure.paintFigure((Graphics)new SWTGraphics(this.gc));
            n6 = Math.max(n6, 0);
            n8 = Math.max(n8, 0);
            n5 = Math.max(n5, 0);
            n7 = Math.max(n7, 0);
            this.overviewCanvas.redraw(n5, n7, n6 - n5, n8 - n7, false);
            this.sdViewerUI.setScrollbars(rectangle.x * this.overviewResizeRatio, rectangle.y * this.overviewResizeRatio / LogCDrawUtils.getTimeUnit());
            this.mouseDownX = n;
            this.mouseDownY = n2;
        }
    }

    public void positionShadow() {
        if (this.expanded) {
            int n = LogCDrawUtils.getOverviewRatio();
            this.selectorFigure.positionFigure(this.graphComposite.getHorizontalBar().getSelection() / n, this.graphComposite.getVerticalBar().getSelection() * LogCDrawUtils.getTimeUnit() / n);
            this.overviewCanvas.redraw();
        }
    }

    private class SelectorFigure {
        private Image image;
        private Rectangle iBounds = new Rectangle(0, 0, 1, 1);
        Rectangle targetBounds;
        int overviewRatio;

        public SelectorFigure() {
            Display display = Display.getDefault();
            PaletteData paletteData = new PaletteData(255, 65280, 0xFF0000);
            RGB rGB = new RGB(255, 20, 20);
            int n = paletteData.getPixel(rGB);
            ImageData imageData = new ImageData(1, 1, 24, paletteData);
            imageData.setPixel(0, 0, n);
            imageData.setAlpha(0, 0, 40);
            this.image = new Image((Device)display, imageData);
            this.overviewRatio = LogCDrawUtils.getOverviewRatio();
            this.targetBounds = new Rectangle(0, 0, DrawAreaOverview.this.parentSize.x / this.overviewRatio, DrawAreaOverview.this.parentSize.y / this.overviewRatio);
        }

        protected void dispose() {
            this.image.dispose();
        }

        public void moveFigure(int n, int n2) {
            this.targetBounds.performTranslate(n, n2);
            if (this.targetBounds.x < 0) {
                this.targetBounds.x = 0;
            }
            if (this.targetBounds.y < 0) {
                this.targetBounds.y = 0;
            }
            if (this.targetBounds.getRight().x > DrawAreaOverview.this.canvasSizeX) {
                this.targetBounds.x = DrawAreaOverview.this.canvasSizeX - this.targetBounds.width;
            }
            if (this.targetBounds.getBottom().y > DrawAreaOverview.this.canvasSizeY) {
                this.targetBounds.y = DrawAreaOverview.this.canvasSizeY - this.targetBounds.height;
            }
        }

        public void positionFigure(int n, int n2) {
            this.targetBounds.x = n;
            if (this.targetBounds.x < 0) {
                this.targetBounds.x = 0;
            }
            if (this.targetBounds.getRight().x > DrawAreaOverview.this.canvasSizeX) {
                this.targetBounds.x = DrawAreaOverview.this.canvasSizeX - this.targetBounds.width;
            }
            this.targetBounds.y = n2;
            if (this.targetBounds.y < 0) {
                this.targetBounds.y = 0;
            }
            if (this.targetBounds.getBottom().y > DrawAreaOverview.this.canvasSizeY) {
                this.targetBounds.y = DrawAreaOverview.this.canvasSizeY - this.targetBounds.height;
            }
        }

        public void paintFigure(Graphics graphics) {
            if (this.targetBounds.width < 1 || this.targetBounds.height < 1) {
                return;
            }
            graphics.drawImage(this.image, this.iBounds, this.targetBounds);
        }

        public boolean positionContained(int n, int n2) {
            return n >= this.targetBounds.x && n <= this.targetBounds.x + this.targetBounds.width && n2 >= this.targetBounds.y && n2 <= this.targetBounds.y + this.targetBounds.height;
        }

        public Rectangle getTargetBounds() {
            return this.targetBounds;
        }
    }
}

