/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.ui.internal.util;

import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.sd.ui.SDPlugin;
import org.eclipse.hyades.sd.ui.internal.views.SDViewerPage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class LogCDrawUtils {
    static int timeUnit = 6;
    static int nodeWidth = 10;
    static int boxHeight = 40;
    static int upperSpace = 30;
    static int initBoxSpace = 60;
    static int startPosition = 0;
    static int sideSpace = 5;
    static int minColumnWidth = 25;
    static int minColumnWidthExpanded = 65;
    static int bottomMax = 0;
    static int overviewRatio = 1;
    static int weightScaleWidth = 15;
    static int selectedWeightIndex = -1;
    static Color weightColor = null;
    public static int SD_VIEWER = 1;
    public static int TABLE_VIEWER = 2;
    static int viewerType = 1;
    static int currentGraphType = 16;
    static SDViewerPage currentPage = null;
    static Color redEventFillColor = new Color((Device)Display.getDefault(), 255, 0, 0);
    static Color redEventStrokeColor = new Color((Device)Display.getDefault(), 255, 0, 0);
    static Color yellowEventFillColor = new Color((Device)Display.getDefault(), 255, 237, 147);
    static Color yellowEventStrokeColor = new Color((Device)Display.getDefault(), 255, 191, 63);
    static Color blueEventFillColor = new Color((Device)Display.getDefault(), 150, 185, 220);
    static Color blueEventStrokeColor = new Color((Device)Display.getDefault(), 63, 127, 191);
    static Color logConnectionColor = new Color((Device)Display.getDefault(), 159, 159, 159);
    static Color logHighLightColor = new Color((Device)Display.getDefault(), 0, 0, 0);

    public static void setTimeUnit(int n) {
        timeUnit = n;
    }

    public static void increaseTimeUnit(int n) {
        timeUnit += n;
    }

    public static void decreaseTimeUnit(int n) {
        if ((timeUnit -= n) < 1) {
            timeUnit = 1;
        }
    }

    public static int getTimeUnit() {
        return timeUnit;
    }

    public static void setNodeWidth(int n) {
        nodeWidth = n;
    }

    public static int getNodeWidth() {
        return nodeWidth;
    }

    public static void setBoxHeight(int n) {
        boxHeight = n;
    }

    public static int getBoxHeight() {
        return boxHeight;
    }

    public static void setUpperSpace(int n) {
        upperSpace = n;
    }

    public static int getUpperSpace() {
        return upperSpace;
    }

    public static int getInitBoxSpace() {
        return initBoxSpace;
    }

    public static void setStartPosition(int n) {
        startPosition = n;
    }

    public static int getStartPosition() {
        return startPosition;
    }

    public static void adjustStartPosition(int n) {
        int n2 = n * timeUnit;
        if (n2 <= upperSpace) {
            upperSpace = 30 - n2;
            boxHeight = 40;
            startPosition = 0;
            return;
        }
        if (n2 <= boxHeight + upperSpace) {
            boxHeight = 40 - n2 + upperSpace;
            upperSpace = 0;
            startPosition = 0;
            return;
        }
        if (n2 > boxHeight + upperSpace) {
            upperSpace = 0;
            boxHeight = 0;
            startPosition = n;
            return;
        }
        upperSpace = 30;
        boxHeight = 40;
        startPosition = 0;
    }

    public static void setSideSpace(int n) {
        sideSpace = n;
    }

    public static int getSideSpace() {
        return sideSpace;
    }

    public static int getMinColumnWidth() {
        return minColumnWidth;
    }

    public static int getMinColumnWidthExpanded() {
        return minColumnWidthExpanded;
    }

    public static void setBottomMax(int n) {
        bottomMax = Math.max(n, bottomMax);
    }

    public static int getBottomMax() {
        return bottomMax;
    }

    public static Color getConnectionColor() {
        return Display.getDefault().getSystemColor(9);
    }

    public static Color getConnectionColorOverview() {
        return Display.getDefault().getSystemColor(2);
    }

    public static Color getBackgroundColor() {
        return Display.getDefault().getSystemColor(1);
    }

    public static Color getForegroundColor() {
        return Display.getDefault().getSystemColor(2);
    }

    public static Color getForegroundSelectedColor() {
        return Display.getDefault().getSystemColor(5);
    }

    public static Color getRedEventFillColor() {
        return redEventFillColor;
    }

    public static Color getRedEventStrokeColor() {
        return redEventStrokeColor;
    }

    public static Color getYellowEventFillColor() {
        return yellowEventFillColor;
    }

    public static Color getYellowEventStrokeColor() {
        return yellowEventStrokeColor;
    }

    public static Color getBlueEventFillColor() {
        return blueEventFillColor;
    }

    public static Color getBlueEventStrokeColor() {
        return blueEventStrokeColor;
    }

    public static Color getLogConnectionColor() {
        return logConnectionColor;
    }

    public static Color getLogHighLightColor() {
        return logHighLightColor;
    }

    public static void dispose() {
        redEventFillColor.dispose();
        redEventStrokeColor.dispose();
        yellowEventFillColor.dispose();
        yellowEventStrokeColor.dispose();
        blueEventFillColor.dispose();
        blueEventStrokeColor.dispose();
        logConnectionColor.dispose();
        logHighLightColor.dispose();
    }

    public static int getBoxSpace() {
        return upperSpace + boxHeight;
    }

    public static void setOverviewRatio(int n) {
        overviewRatio = n;
    }

    public static int getOverviewRatio() {
        return overviewRatio;
    }

    public static int getWeightScaleWidth() {
        return weightScaleWidth;
    }

    public static void setWeightSelection(int n, Color color) {
        if (weightColor != null) {
            weightColor.dispose();
            weightColor = null;
        }
        selectedWeightIndex = n;
        weightColor = color;
    }

    public static int getSelectedWeightIndex() {
        return selectedWeightIndex;
    }

    public static Color getSelectedWeightColor() {
        return weightColor;
    }

    public static void setViewerType(int n) {
        viewerType = n;
    }

    public static int getViewerType() {
        return viewerType;
    }

    public static void setCurrentGraphType(int n) {
        currentGraphType = n;
    }

    public static int getCurrentGraphType() {
        return currentGraphType;
    }

    public static void setCurrentPage(SDViewerPage sDViewerPage) {
        currentPage = sDViewerPage;
    }

    public static SDViewerPage getCurrentPage() {
        return currentPage;
    }

    public static void reset() {
        timeUnit = 6;
        nodeWidth = 10;
        boxHeight = 40;
        upperSpace = 30;
        initBoxSpace = 60;
        startPosition = 0;
        sideSpace = 5;
        minColumnWidth = 25;
        bottomMax = 0;
        overviewRatio = 1;
        weightScaleWidth = 15;
        selectedWeightIndex = -1;
        if (weightColor != null) {
            weightColor.dispose();
        }
        weightColor = null;
    }

    public static String getCorrelationName(IConfigurationElement iConfigurationElement) {
        String string;
        if (iConfigurationElement != null && (string = iConfigurationElement.getAttribute("name")) != null) {
            return string;
        }
        return SDPlugin.getString("STR_NO_COR_SELECTED");
    }

    public static EList getAgentProxies(TRCNode tRCNode) {
        BasicEList basicEList = new BasicEList();
        Iterator iterator = tRCNode.getProcessProxies().iterator();
        while (iterator.hasNext()) {
            TRCProcessProxy tRCProcessProxy = (TRCProcessProxy)iterator.next();
            EList eList = tRCProcessProxy.getAgentProxies();
            if (eList == null || eList.size() <= 0) continue;
            basicEList.addAll(eList);
        }
        return basicEList;
    }
}

