/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.log.ui.internal.LogUIPluginImages;
import org.eclipse.hyades.log.ui.internal.util.IRecordPaneViewerListener;
import org.eclipse.hyades.log.ui.internal.util.LogUIConstants;
import org.eclipse.hyades.log.ui.internal.util.RecordChangeEvent;
import org.eclipse.hyades.models.cbe.CBEPackage;
import org.eclipse.hyades.models.internal.sdb.impl.SDBFactoryImpl;
import org.eclipse.hyades.models.internal.sdb.impl.SDBPackageImpl;
import org.eclipse.hyades.models.internal.sdb.impl.SDBResourceSetImpl;
import org.eclipse.hyades.ui.internal.util.StringUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class LogUIPlugin
extends AbstractUIPlugin {
    private static LogUIPlugin inst;
    private static ResourceBundle aResourceBundle;
    private SDBFactoryImpl factory;
    private ResourceSet resourceSet;
    private ArrayList recordChangeListeners = null;
    static /* synthetic */ Class class$java$lang$String;

    public LogUIPlugin(IPluginDescriptor iPluginDescriptor) {
        super(iPluginDescriptor);
        if (inst == null) {
            inst = this;
        }
        aResourceBundle = this.getDescriptor().getResourceBundle();
    }

    public static LogUIPlugin getDefault() {
        return inst;
    }

    public static String getPluginId() {
        return LogUIPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public static ImageDescriptor getImageDescriptor(String string) {
        return LogUIPluginImages.getImageDescriptor(string);
    }

    public static ResourceBundle getResourceBundle() {
        return aResourceBundle;
    }

    public static String getResourceString(String string) {
        ResourceBundle resourceBundle = LogUIPlugin.getResourceBundle();
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    public static String getResourceString(String string, String[] stringArray) {
        String string2 = LogUIPlugin.getResourceString(string);
        int n = stringArray.length;
        while (n > 0) {
            string2 = StringUtil.replace((String)string2, (String)("%" + n), (String)stringArray[n - 1]);
            --n;
        }
        return string2;
    }

    public static Shell getActiveWorkbenchShell() {
        return LogUIPlugin.getActiveWorkbenchWindow().getShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return LogUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static void log(Throwable throwable) {
        String string = throwable.getMessage();
        LogUIPlugin.getDefault().getLog().log((IStatus)new Status(4, LogUIPlugin.getPluginId(), 4, string == null ? "" : string, throwable));
    }

    public void shutdown() throws CoreException {
        LogUIPluginImages.shutdown();
        super.shutdown();
    }

    public void startup() throws CoreException {
        SDBPackageImpl.init();
        this.factory = new SDBFactoryImpl();
        this.resourceSet = SDBResourceSetImpl.getInstance();
        super.startup();
    }

    public SDBFactoryImpl getSymptomDBFactory() {
        if (this.factory == null) {
            this.factory = new SDBFactoryImpl();
        }
        return this.factory;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    protected void initializeDefaultPreferences(IPreferenceStore iPreferenceStore) {
        try {
            ArrayList arrayList = new ArrayList(40);
            ArrayList arrayList2 = new ArrayList(70);
            this.createSortAndFilterList(arrayList, arrayList2, (EClassifier)CBEPackage.eINSTANCE.getCBECommonBaseEvent());
            ((AbstractCollection)arrayList).remove("timeZone");
            StringBuffer stringBuffer = new StringBuffer();
            this.generatePreferenceString(stringBuffer, arrayList, new String[]{"creationTime", "sequenceNumber"});
            iPreferenceStore.setDefault("pd_sort_log_options", stringBuffer.toString().trim());
            ((AbstractCollection)arrayList2).remove("timeZone");
            StringBuffer stringBuffer2 = new StringBuffer();
            this.generatePreferenceString(stringBuffer2, arrayList2, null);
            iPreferenceStore.setDefault("pd_filter_options", stringBuffer2.toString().trim());
            iPreferenceStore.setDefault("pd_adv_filter_options", "");
            iPreferenceStore.setDefault("pd_src_filter_options", "");
            iPreferenceStore.setDefault("pd_src_direction_options", "1");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        iPreferenceStore.setDefault("LogAnalyzer.DateFormat", LogUIConstants.LOG_ANALYZER_FORMAT_DATE_DEFAULT);
        iPreferenceStore.setDefault("LogAnalyzer.TimeFormat", LogUIConstants.LOG_ANALYZER_FORMAT_TIME_DEFAULT);
    }

    private void generatePreferenceString(StringBuffer stringBuffer, ArrayList arrayList, String[] stringArray) {
        String string = "";
        if (stringArray == null) {
            string = ":1 ";
        } else {
            string = ":1 ";
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(stringArray[n2]);
                stringBuffer.append(string);
                ((AbstractCollection)arrayList).remove(stringArray[n2]);
                ++n2;
            }
            string = ":0 ";
        }
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            stringBuffer.append(string2);
            stringBuffer.append(string);
        }
    }

    private void createSortAndFilterList(List list, List list2, EClassifier eClassifier) {
        ArrayList arrayList = new ArrayList(30);
        EList eList = CBEPackage.eINSTANCE.getEClassifiers();
        int n = eList.size();
        int n2 = 0;
        while (n2 < n) {
            EClassifier eClassifier2 = (EClassifier)eList.get(n2);
            this.getEObjectAttributes((EClass)eClassifier2, arrayList);
            int n3 = arrayList.size();
            boolean bl = ((EClass)eClassifier2).getEAllSuperTypes().contains(eClassifier) || eClassifier2 == eClassifier;
            int n4 = 0;
            while (n4 < n3) {
                String string = (String)arrayList.get(n4);
                if (bl && !list.contains(string)) {
                    list.add(string);
                }
                if (!list2.contains(string)) {
                    list2.add(string);
                }
                ++n4;
            }
            arrayList.clear();
            ++n2;
        }
    }

    private void getEObjectAttributes(EClass eClass, List list) {
        EList eList = eClass.getEAttributes();
        boolean bl = false;
        int n = 0;
        while (n < eList.size()) {
            EAttribute eAttribute = (EAttribute)eList.get(n);
            boolean bl2 = eAttribute.isMany() && eAttribute.getEType().getInstanceClass() != (class$java$lang$String == null ? LogUIPlugin.class$("java.lang.String") : class$java$lang$String) && !eAttribute.getEType().getInstanceClassName().equals("byte") && !eAttribute.getEType().getInstanceClassName().equals("short") ? true : (bl = false);
            if (!bl) {
                list.add(eAttribute.getName());
            }
            ++n;
        }
    }

    public void addRecordPaneViewerListener(IRecordPaneViewerListener iRecordPaneViewerListener) {
        if (this.recordChangeListeners == null) {
            this.recordChangeListeners = new ArrayList();
        }
        if (!this.recordChangeListeners.contains(iRecordPaneViewerListener)) {
            this.recordChangeListeners.add(iRecordPaneViewerListener);
        }
    }

    public void removeRecordPaneViewerListener(IRecordPaneViewerListener iRecordPaneViewerListener) {
        if (this.recordChangeListeners != null) {
            ((AbstractCollection)this.recordChangeListeners).remove(iRecordPaneViewerListener);
        }
    }

    public void fireRecordChangeNotification(RecordChangeEvent recordChangeEvent) {
        if (this.recordChangeListeners != null) {
            int n = 0;
            while (n < this.recordChangeListeners.size()) {
                ((IRecordPaneViewerListener)this.recordChangeListeners.get(n)).handleRecordChangeEvent(recordChangeEvent);
                ++n;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        aResourceBundle = null;
    }
}

