/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.wizards.IImportWizardWidget;
import org.eclipse.hyades.log.ui.internal.wizards.ParserField;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ImportWizardRadioButton
implements IImportWizardWidget {
    protected Collection buttonList = new ArrayList();
    private ParserField _field = null;

    public ImportWizardRadioButton(ParserField parserField) {
        this._field = parserField;
    }

    public String getValue() {
        Iterator iterator = this.buttonList.iterator();
        while (iterator.hasNext()) {
            Button button = (Button)iterator.next();
            if (!button.getSelection()) continue;
            return button.getText();
        }
        return null;
    }

    public void setValue(String string) {
        Iterator iterator = this.buttonList.iterator();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = "";
        while (iterator.hasNext() && stringTokenizer.hasMoreTokens()) {
            Button button = (Button)iterator.next();
            string2 = stringTokenizer.nextToken();
            button.setSelection(string2.equals("true"));
        }
    }

    public void createControl(Composite composite, String string) {
        Label label = new Label(composite, 64);
        GridData gridData = new GridData();
        gridData.widthHint = 400;
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setText(this._field.getName());
        IPreferenceStore iPreferenceStore = LogUIPlugin.getDefault().getPreferenceStore();
        String string2 = iPreferenceStore.getString(string + this._field.getId());
        StringTokenizer stringTokenizer = new StringTokenizer(this._field.getDefaultValue(), ",");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            Button button = new Button(composite, 16);
            Point point = button.computeSize(-1, -1, true);
            gridData = new GridData();
            gridData.widthHint = 400;
            gridData.horizontalSpan = 2;
            button.setLayoutData((Object)gridData);
            button.setToolTipText(this._field.getTooltip());
            button.setText(string3);
            if (string2 != null && string2.trim().equals(string3)) {
                button.setSelection(true);
            } else if ((string2 == null || string2.trim().equals("")) && n == 0) {
                button.setSelection(true);
            } else {
                button.setSelection(false);
            }
            ++n;
            this.buttonList.add(button);
        }
    }

    public Collection getButtonList() {
        return this.buttonList;
    }

    public void setButtonList(Collection collection) {
        this.buttonList = collection;
    }

    public boolean isValid() {
        return true;
    }

    public ParserField getField() {
        return this._field;
    }
}

