/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.navigator.LogNavigator;
import org.eclipse.hyades.log.ui.internal.wizards.CorrelationSelectionWizardPage;
import org.eclipse.hyades.log.ui.internal.wizards.LogSelectionWizardPage;
import org.eclipse.hyades.logc.extensions.ILogRecordCorrelationEngine;
import org.eclipse.hyades.logc.extensions.ILogRecordFilter;
import org.eclipse.hyades.logs.correlators.RecordList;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.CorrelationEngine;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;

public class NewCorrelationWizard
extends Wizard
implements INewWizard {
    private LogSelectionWizardPage selPage;
    private CorrelationSelectionWizardPage corrPage;
    private IStructuredSelection sel;
    private IWorkbench workbench;

    public boolean performFinish() {
        IPreferenceStore iPreferenceStore;
        final CorrelationContainerProxy correlationContainerProxy = this.createCorrelationContainer();
        if (correlationContainerProxy != null) {
            try {
                IViewPart iViewPart;
                iPreferenceStore = this.workbench.getActiveWorkbenchWindow().getActivePage();
                if (iPreferenceStore != null && !iPreferenceStore.getPerspective().getId().equals("org.eclipse.hyades.trace.internal.ui.tracePerspective") && (iViewPart = ResourcesPlugin.getWorkspace().getRoot()) != null) {
                    iPreferenceStore = this.workbench.showPerspective("org.eclipse.hyades.trace.internal.ui.tracePerspective", this.workbench.getActiveWorkbenchWindow(), (IAdaptable)iViewPart);
                }
                if (iPreferenceStore != null && (iViewPart = iPreferenceStore.showView("org.eclipse.hyades.log.ui.internal.navigator.LogNavigator")) != null) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            ((LogNavigator)iViewPart).selectReveal((ISelection)new StructuredSelection((Object)correlationContainerProxy));
                        }
                    });
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        iPreferenceStore = LogUIPlugin.getDefault().getPreferenceStore();
        iPreferenceStore.setValue("corr_nr", iPreferenceStore.getInt("corr_nr") + 1);
        return true;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.sel = iStructuredSelection;
        this.workbench = iWorkbench;
    }

    public void addPages() {
        this.setWindowTitle(LogUIPlugin.getResourceString("STR_NEW_CORR_WIZARD_TITLE"));
        super.addPages();
        this.selPage = new LogSelectionWizardPage(LogUIPlugin.getResourceString("STR_NEW_CORR_WIZARD_TITLE"), this.sel);
        this.addPage((IWizardPage)this.selPage);
        this.corrPage = new CorrelationSelectionWizardPage(LogUIPlugin.getResourceString("STR_NEW_CORR_WIZARD_TITLE"), this.getCorrelationExtensions());
        this.addPage((IWizardPage)this.corrPage);
    }

    private IExtension[] getCorrelationExtensions() {
        IPluginRegistry iPluginRegistry = Platform.getPluginRegistry();
        IExtensionPoint iExtensionPoint = iPluginRegistry.getExtensionPoint("org.eclipse.hyades.logc.logInteractionView");
        IExtension[] iExtensionArray = null;
        if (iExtensionPoint != null) {
            iExtensionArray = iExtensionPoint.getExtensions();
        }
        return iExtensionArray;
    }

    private CorrelationContainerProxy createCorrelationContainer() {
        BasicEList basicEList = new BasicEList();
        String string = null;
        CorrelationContainerProxy correlationContainerProxy = null;
        ILogRecordCorrelationEngine iLogRecordCorrelationEngine = null;
        IConfigurationElement iConfigurationElement = this.corrPage.getCorrelation();
        List list = this.selPage.getLogFiles();
        IConfigurationElement[] iConfigurationElementArray = this.addNodes(iConfigurationElement, basicEList, list);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            if (iConfigurationElementArray[n].getName().equals("LogRecordCorrelationEngine")) {
                try {
                    iLogRecordCorrelationEngine = (ILogRecordCorrelationEngine)iConfigurationElementArray[n].createExecutableExtension("class");
                    string = iConfigurationElement.getAttribute("name");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n;
        }
        if (iLogRecordCorrelationEngine != null && list.size() > 0) {
            correlationContainerProxy = LoadersUtils.getCorrelationContainerProxy((TRCAgentProxy)((TRCAgentProxy)list.get(0)), string, (String)this.selPage.getName());
            correlationContainerProxy.setName(this.selPage.getName());
            CorrelationEngine correlationEngine = HierarchyFactory.eINSTANCE.createCorrelationEngine();
            correlationEngine.setId(string);
            correlationEngine.setType(iConfigurationElement.getAttribute("log_types"));
            correlationEngine.setName(iConfigurationElement.getAttribute("name"));
            correlationContainerProxy.setCorrelationEngine(correlationEngine);
            int n2 = 1;
            while (n2 < list.size()) {
                if (list.get(n2) != null) {
                    correlationContainerProxy.getCorrelatedAgents().add(list.get(n2));
                }
                ++n2;
            }
            iLogRecordCorrelationEngine.correlate(correlationContainerProxy, (EList)basicEList);
        }
        return correlationContainerProxy;
    }

    private IConfigurationElement[] addNodes(IConfigurationElement iConfigurationElement, BasicEList basicEList, List list) {
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren();
        ILogRecordFilter iLogRecordFilter = null;
        boolean bl = true;
        int n = 0;
        while (n < list.size()) {
            if (list.get(n) != null) {
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    if (iConfigurationElementArray[n2].getName().equals("LogRecordFilter") && ((TRCAgentProxy)list.get(n)).getName().equals(iConfigurationElementArray[n2].getAttribute("log_type"))) {
                        try {
                            iLogRecordFilter = (ILogRecordFilter)iConfigurationElementArray[n2].createExecutableExtension("class");
                            basicEList.add((Object)this.loadLog((TRCAgentProxy)list.get(n), iLogRecordFilter));
                            bl = false;
                        }
                        catch (Exception exception) {
                            basicEList.add((Object)this.loadLog((TRCAgentProxy)list.get(n), null));
                            bl = false;
                        }
                    } else if (((TRCAgentProxy)list.get(n)).getName().equals(iConfigurationElementArray[n2].getAttribute("log_type"))) {
                        basicEList.add((Object)this.loadLog((TRCAgentProxy)list.get(n), null));
                        bl = false;
                    }
                    ++n2;
                }
                if (bl) {
                    basicEList.add((Object)this.loadLog((TRCAgentProxy)list.get(n), null));
                }
            }
            bl = true;
            ++n;
        }
        return iConfigurationElementArray;
    }

    private RecordList loadLog(TRCAgentProxy tRCAgentProxy, ILogRecordFilter iLogRecordFilter) {
        RecordList recordList = null;
        recordList = iLogRecordFilter != null ? new RecordList(this.cbeEventFilter(iLogRecordFilter.filter(tRCAgentProxy.getAgent().getDefaultEvents())), tRCAgentProxy.getName()) : new RecordList(this.cbeEventFilter(tRCAgentProxy.getAgent().getDefaultEvents()), tRCAgentProxy.getName());
        return recordList;
    }

    private EList cbeEventFilter(EList eList) {
        BasicEList basicEList = new BasicEList();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof CBECommonBaseEvent)) continue;
            basicEList.add(e);
        }
        return basicEList;
    }
}

