/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import org.eclipse.hyades.loaders.util.HyadesConfigurationElement;
import org.eclipse.hyades.loaders.util.IHyadesPluginClassDescriptor;
import org.eclipse.hyades.loaders.util.RegistryReader;
import org.eclipse.hyades.loaders.util.XMLFragmentHandler;
import org.eclipse.hyades.loaders.util.XMLFragmentHandlerExtensions;

class XMLFragmentHandlerRegistryReader
extends RegistryReader {
    static final String TAG_HANDLER = "handler";
    static final String ATT_CLASS = "class";

    public XMLFragmentHandlerRegistryReader() {
        super("fragment_handler");
    }

    protected boolean readElement(HyadesConfigurationElement hyadesConfigurationElement) {
        if (hyadesConfigurationElement.getName().equals(TAG_HANDLER)) {
            if (hyadesConfigurationElement.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(hyadesConfigurationElement, ATT_CLASS);
            } else if (XMLFragmentHandlerExtensions.getInstance().size() > 0) {
                this.logError(hyadesConfigurationElement, "Another handler has been already registered. Only the first registered XML handler would be active.");
            } else {
                try {
                    IHyadesPluginClassDescriptor iHyadesPluginClassDescriptor = this.createPluginClassDescriptor(hyadesConfigurationElement, ATT_CLASS);
                    XMLFragmentHandlerExtensions.getInstance().put(TAG_HANDLER, (XMLFragmentHandler)iHyadesPluginClassDescriptor.createInstance());
                }
                catch (Exception exception) {
                    this.logError(hyadesConfigurationElement, exception.getLocalizedMessage());
                }
                return true;
            }
        }
        return false;
    }
}

