/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;

public class HierarchyURIConverterImpl
extends URIConverterImpl {
    protected static IWorkspaceRoot workspaceRoot = EcorePlugin.getWorkspaceRoot();
    protected URIMap uriMap;

    public Map getURIMap() {
        return this.getInternalURIMap();
    }

    public InputStream createInputStream(URI uRI) throws IOException {
        URI uRI2 = this.normalize(uRI);
        String string = uRI2.scheme();
        if ("file".equals(string)) {
            String string2 = uRI2.toFileString();
            return this.createFileInputStream(string2);
        }
        if ("platform".equals(string) && uRI2.segmentCount() > 1 && "resource".equals(uRI2.segment(0))) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 1;
            int n2 = uRI2.segmentCount();
            while (n < n2) {
                stringBuffer.append('/');
                stringBuffer.append(uRI2.segment(n));
                ++n;
            }
            return this.createPlatformResourceInputStream(stringBuffer.toString());
        }
        if (string == null) {
            String string3 = uRI2.toString();
            return this.createFileInputStream(string3);
        }
        return this.createURLInputStream(uRI2);
    }

    public OutputStream createOutputStream(URI uRI) throws IOException {
        URI uRI2 = this.normalize(uRI);
        String string = uRI2.scheme();
        if ("file".equals(string)) {
            String string2 = uRI2.toFileString();
            return this.createFileOutputStream(string2);
        }
        if ("platform".equals(string) && uRI2.segmentCount() > 1 && "resource".equals(uRI2.segment(0))) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 1;
            int n2 = uRI2.segmentCount();
            while (n < n2) {
                stringBuffer.append('/');
                stringBuffer.append(uRI2.segment(n));
                ++n;
            }
            return this.createPlatformResourceOutputStream(stringBuffer.toString());
        }
        if (string == null) {
            String string3 = uRI2.toString();
            return this.createFileOutputStream(string3);
        }
        return this.createURLOutputStream(uRI2);
    }

    public URI normalize(URI uRI) {
        String string = uRI.fragment();
        URI uRI2 = string == null ? this.getInternalURIMap().getURI(uRI) : this.getInternalURIMap().getURI(uRI.trimFragment()).appendFragment(string);
        String string2 = uRI2.scheme();
        if (string2 == null) {
            if (workspaceRoot != null) {
                if (uRI2.hasAbsolutePath()) {
                    uRI2 = URI.createPlatformResourceURI((String)uRI2.toString());
                }
            } else {
                uRI2 = URI.createURI((String)("file:" + uRI2));
            }
        }
        if (uRI2.equals((Object)uRI)) {
            return uRI;
        }
        return this.normalize(uRI2);
    }

    protected InputStream createFileInputStream(String string) throws IOException {
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        return fileInputStream;
    }

    protected OutputStream createFileOutputStream(String string) throws IOException {
        File file = new File(string);
        String string2 = file.getParent();
        if (string2 != null) {
            new File(string2).mkdirs();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        return fileOutputStream;
    }

    protected InputStream createPlatformResourceInputStream(String string) throws IOException {
        if (workspaceRoot != null) {
            return WorkbenchHelper.createPlatformResourceInputStream(string);
        }
        URI uRI = EcorePlugin.resolvePlatformResourcePath((String)string);
        if (uRI != null) {
            return this.createInputStream(uRI);
        }
        throw new IOException("The path '" + string + "' is unmapped");
    }

    protected OutputStream createPlatformResourceOutputStream(String string) throws IOException {
        if (workspaceRoot != null) {
            return WorkbenchHelper.createPlatformResourceOutputStream(string);
        }
        URI uRI = EcorePlugin.resolvePlatformResourcePath((String)string);
        if (uRI != null) {
            return this.createOutputStream(uRI);
        }
        throw new IOException("The path '" + string + "' is unmapped");
    }

    protected InputStream createURLInputStream(URI uRI) throws IOException {
        URL uRL = new URL(uRI.toString());
        URLConnection uRLConnection = uRL.openConnection();
        return uRLConnection.getInputStream();
    }

    protected OutputStream createURLOutputStream(URI uRI) throws IOException {
        URL uRL = new URL(uRI.toString());
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDoOutput(true);
        return uRLConnection.getOutputStream();
    }

    public static class WorkbenchHelper {
        public static InputStream createPlatformResourceInputStream(String string) throws IOException {
            IFile iFile = workspaceRoot.getFile((IPath)new Path(string));
            try {
                if (!iFile.isLocal(1) || !iFile.isSynchronized(1)) {
                    iFile.refreshLocal(1, null);
                }
                return iFile.getContents();
            }
            catch (CoreException coreException) {
                throw new Resource.IOWrappedException((Exception)((Object)coreException));
            }
        }

        public static OutputStream createPlatformResourceOutputStream(String string) throws IOException {
            IFile iFile = workspaceRoot.getFile((IPath)new Path(string));
            return new HierarchyPlatformResourceOutputStream(iFile, false, false, null);
        }
    }

    public static class HierarchyPlatformResourceOutputStream
    extends OutputStream {
        protected HierarchyPipedInputStream pipedInputStream;
        protected IFile file;
        protected IProgressMonitor progressMonitor;
        protected boolean firstCall = true;
        protected boolean force;
        protected boolean keepHistory;
        protected int SAVE_TRESHOLD = 262144;
        protected byte[] outBuf = new byte[this.SAVE_TRESHOLD];
        protected int outPos;

        public HierarchyPlatformResourceOutputStream(IFile iFile, boolean bl, boolean bl2, IProgressMonitor iProgressMonitor) throws IOException {
            this.file = iFile;
            this.force = bl;
            this.keepHistory = bl2;
            this.progressMonitor = iProgressMonitor;
            this.createContainer(iFile.getParent());
            this.pipedInputStream = new HierarchyPipedInputStream(this.outBuf, 0);
        }

        public void close() throws IOException {
            this.flush();
        }

        public void flush() throws IOException {
            if (this.outPos > 0) {
                this.writeToWorkspaceResource();
                this.outPos = 0;
            }
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            while (n2 > 0) {
                int n3 = this.min(this.SAVE_TRESHOLD - this.outPos, n2);
                System.arraycopy(byArray, n, this.outBuf, this.outPos, n3);
                this.outPos += n3;
                n += n3;
                n2 -= n3;
                if (this.outPos != this.SAVE_TRESHOLD) continue;
                this.flush();
            }
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        public void write(int n) throws IOException {
            this.outBuf[this.outPos++] = (byte)n;
            if (this.outPos == this.SAVE_TRESHOLD) {
                this.flush();
            }
        }

        protected void createContainer(IContainer iContainer) throws IOException {
            if (!iContainer.exists() && iContainer.getType() == 2) {
                this.createContainer(iContainer.getParent());
                try {
                    ((IFolder)iContainer).create(this.force, this.keepHistory, this.progressMonitor);
                }
                catch (CoreException coreException) {
                    throw new Resource.IOWrappedException((Exception)((Object)coreException));
                }
            }
        }

        protected int min(int n, int n2) {
            if (n < n2) {
                return n;
            }
            return n2;
        }

        private void writeToWorkspaceResource() throws IOException {
            this.pipedInputStream.setInBuf(this.outBuf, this.outPos);
            try {
                if (!this.file.exists()) {
                    this.file.create((InputStream)this.pipedInputStream, this.force, this.progressMonitor);
                    this.firstCall = false;
                } else {
                    if (!this.file.isLocal(1) || !this.file.isSynchronized(1)) {
                        this.file.refreshLocal(1, this.progressMonitor);
                    }
                    if (this.firstCall) {
                        this.file.setContents((InputStream)this.pipedInputStream, this.force, this.keepHistory, this.progressMonitor);
                        this.firstCall = false;
                    } else {
                        this.file.appendContents((InputStream)this.pipedInputStream, this.force, this.keepHistory, this.progressMonitor);
                    }
                }
            }
            catch (CoreException coreException) {
                throw new Resource.IOWrappedException((Exception)((Object)coreException));
            }
        }
    }

    public static class HierarchyPipedInputStream
    extends InputStream {
        private byte[] inBuf;
        private int inCount;
        private int inPos;
        private long inTotalLength;

        public HierarchyPipedInputStream(byte[] byArray, int n) {
            this.inBuf = byArray;
            this.inCount = n;
            this.inTotalLength = n;
            this.inPos = 0;
        }

        public void setInBuf(byte[] byArray, int n) {
            this.inBuf = byArray;
            this.inCount = n;
            this.inTotalLength = n;
            this.inPos = 0;
        }

        public int available() throws IOException {
            return this.inCount;
        }

        public boolean markSupported() {
            return false;
        }

        public int read() throws IOException {
            if (this.available() == 0) {
                return -1;
            }
            --this.inCount;
            return this.inBuf[this.inPos++];
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.available() == 0) {
                return -1;
            }
            int n3 = this.min(this.inCount, n2);
            System.arraycopy(this.inBuf, this.inPos, byArray, n, n3);
            this.inPos += n3;
            this.inCount -= n3;
            return n3;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public long skip(long l) throws IOException {
            if ((l += (long)this.inPos) < this.inTotalLength) {
                this.inPos = (int)l;
                return l;
            }
            return -1L;
        }

        protected int min(int n, int n2) {
            if (n < n2) {
                return n;
            }
            return n2;
        }
    }

    public static interface URIMap
    extends Map {
        public URI getURI(URI var1);
    }
}

